/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;

class CompoundBitVectorIntervalManager
implements CompoundIntervalManager {
    private final BitVectorInfo info;
    private final boolean allowSignedWrapAround;
    private final OverflowEventHandler overflowEventHandler;

    public CompoundBitVectorIntervalManager(BitVectorInfo pInfo, boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        Preconditions.checkNotNull((Object)pInfo);
        this.info = pInfo;
        this.allowSignedWrapAround = pAllowSignedWrapAround;
        this.overflowEventHandler = pOverflowEventHandler;
    }

    public int hashCode() {
        return Objects.hash(this.info, this.allowSignedWrapAround);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof CompoundBitVectorIntervalManager) {
            CompoundBitVectorIntervalManager other = (CompoundBitVectorIntervalManager)pOther;
            return this.allowSignedWrapAround == other.allowSignedWrapAround && this.info.equals(other.info);
        }
        return false;
    }

    @Override
    public CompoundInterval allPossibleValues() {
        return CompoundBitVectorInterval.of(this.info.getRange());
    }

    @Override
    public CompoundInterval bottom() {
        return CompoundBitVectorInterval.bottom(this.info);
    }

    @Override
    public CompoundInterval logicalFalse() {
        return CompoundBitVectorInterval.logicalFalse(this.info);
    }

    @Override
    public CompoundInterval logicalTrue() {
        return CompoundBitVectorInterval.logicalTrue(this.info);
    }

    @Override
    public CompoundInterval union(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.unionWith(operand2);
    }

    @Override
    public boolean contains(CompoundInterval pContainer, CompoundInterval pElement) {
        CompoundBitVectorIntervalManager.checkOperands(pContainer, pElement);
        CompoundBitVectorInterval container = (CompoundBitVectorInterval)pContainer;
        CompoundBitVectorInterval element = (CompoundBitVectorInterval)pElement;
        return container.contains(element);
    }

    @Override
    public CompoundInterval lessEqual(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.lessEqual(operand2);
    }

    @Override
    public CompoundInterval lessThan(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.lessThan(operand2);
    }

    @Override
    public CompoundInterval greaterEqual(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.greaterEqual(operand2);
    }

    @Override
    public CompoundInterval greaterThan(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.greaterThan(operand2);
    }

    @Override
    public CompoundInterval singleton(long pValue) {
        return CompoundBitVectorInterval.singleton(this.info, pValue);
    }

    @Override
    public CompoundInterval singleton(BigInteger pValue) {
        return CompoundBitVectorInterval.singleton(this.info, pValue);
    }

    @Override
    public CompoundInterval singleton(Number pValue) {
        if (pValue instanceof BigInteger) {
            return this.singleton((BigInteger)pValue);
        }
        if (pValue instanceof Long || pValue instanceof Integer || pValue instanceof Short || pValue instanceof Byte) {
            return this.singleton((Long)pValue);
        }
        throw new IllegalArgumentException("Unsupported number: " + pValue);
    }

    @Override
    public CompoundInterval castedSingleton(BigInteger pValue) {
        return CompoundBitVectorInterval.cast(this.info, pValue, pValue, this.allowSignedWrapAround, OverflowEventHandler.EMPTY);
    }

    @Override
    public CompoundInterval fromBoolean(boolean pValue) {
        return CompoundBitVectorInterval.fromBoolean(this.info, pValue);
    }

    @Override
    public CompoundInterval intersect(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.intersectWith(operand2);
    }

    @Override
    public CompoundInterval modulo(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.modulo(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval add(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.add(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval logicalEquals(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.logicalEquals(operand2);
    }

    @Override
    public CompoundInterval binaryAnd(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.binaryAnd(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval binaryOr(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.binaryOr(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval binaryXor(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.binaryXor(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval binaryNot(CompoundInterval pOperand) {
        CompoundBitVectorIntervalManager.checkOperand(pOperand);
        CompoundBitVectorInterval operand = (CompoundBitVectorInterval)pOperand;
        return operand.binaryNot(this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval divide(CompoundInterval pNumerator, CompoundInterval pDenominator) {
        CompoundBitVectorIntervalManager.checkOperands(pNumerator, pDenominator);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pNumerator;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pDenominator;
        return operand1.divide(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval multiply(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.multiply(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval shiftLeft(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.shiftLeft(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval shiftRight(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.shiftRight(operand2, this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public boolean doIntersect(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return operand1.intersectsWith(operand2);
    }

    @Override
    public CompoundInterval span(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperands(pOperand1, pOperand2);
        CompoundBitVectorInterval operand1 = (CompoundBitVectorInterval)pOperand1;
        CompoundBitVectorInterval operand2 = (CompoundBitVectorInterval)pOperand2;
        return CompoundBitVectorInterval.span(operand1, operand2);
    }

    @Override
    public CompoundInterval negate(CompoundInterval pToNegate) {
        CompoundBitVectorIntervalManager.checkOperand(pToNegate);
        return ((CompoundBitVectorInterval)pToNegate).negate(this.allowSignedWrapAround, this.overflowEventHandler);
    }

    @Override
    public CompoundInterval cast(TypeInfo pInfo, CompoundInterval pToCast) {
        Preconditions.checkArgument((boolean)(pInfo instanceof BitVectorInfo), (Object)"Unsupported target type: Not a compound bit vector interval.");
        if (pToCast instanceof CompoundBitVectorInterval) {
            return ((CompoundBitVectorInterval)pToCast).cast((BitVectorInfo)pInfo, this.allowSignedWrapAround, OverflowEventHandler.EMPTY);
        }
        return this.allPossibleValues();
    }

    private static void checkOperand(CompoundInterval pOperand) {
        Preconditions.checkArgument((boolean)(pOperand instanceof CompoundBitVectorInterval), (Object)"Operand is not a compound bit vector interval.");
    }

    private static void checkOperands(CompoundInterval pOperand1, CompoundInterval pOperand2) {
        CompoundBitVectorIntervalManager.checkOperand(pOperand1);
        CompoundBitVectorIntervalManager.checkOperand(pOperand2);
    }
}

