/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundFloatingPointIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.FloatingPointTypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;

public enum CompoundBitVectorIntervalManagerFactory implements CompoundIntervalManagerFactory
{
    ALLOW_SIGNED_WRAP_AROUND{

        @Override
        public boolean isSignedWrapAroundAllowed() {
            return true;
        }
    }
    ,
    FORBID_SIGNED_WRAP_AROUND{

        @Override
        public boolean isSignedWrapAroundAllowed() {
            return false;
        }
    };

    private final Collection<OverflowEventHandler> overflowEventHandlers = new CopyOnWriteArrayList<OverflowEventHandler>();

    private void handleAllOverflowHandlers() {
        for (OverflowEventHandler component : this.overflowEventHandlers) {
            component.signedOverflow();
        }
    }

    @Override
    public CompoundIntervalManager createCompoundIntervalManager(MachineModel pMachineModel, Type pType) {
        return this.createCompoundIntervalManager(BitVectorInfo.from(pMachineModel, pType));
    }

    @Override
    public CompoundIntervalManager createCompoundIntervalManager(TypeInfo pInfo) {
        return this.createCompoundIntervalManager(pInfo, true);
    }

    public CompoundIntervalManager createCompoundIntervalManager(TypeInfo pInfo, boolean pWithOverflowHandlers) {
        if (pInfo instanceof BitVectorInfo) {
            return new CompoundBitVectorIntervalManager((BitVectorInfo)pInfo, this.isSignedWrapAroundAllowed(), pWithOverflowHandlers ? this::handleAllOverflowHandlers : () -> {});
        }
        if (pInfo instanceof FloatingPointTypeInfo) {
            return new CompoundFloatingPointIntervalManager((FloatingPointTypeInfo)pInfo);
        }
        throw new AssertionError((Object)("Unsupported type: " + pInfo));
    }

    public abstract boolean isSignedWrapAroundAllowed();

    public void addOverflowEventHandler(OverflowEventHandler pOverflowEventHandler) {
        this.overflowEventHandlers.add(pOverflowEventHandler);
    }

    public void removeOverflowEventHandler(OverflowEventHandler pOverflowEventHandler) {
        this.overflowEventHandlers.remove(pOverflowEventHandler);
    }
}

