/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.math.IntMath;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntegralInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ICCOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.IICOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ISCOperator;

public class CompoundMathematicalInterval
implements CompoundIntegralInterval {
    private static final CompoundMathematicalInterval ZERO = new CompoundMathematicalInterval(SimpleInterval.singleton(BigInteger.ZERO));
    private static final CompoundMathematicalInterval ONE = new CompoundMathematicalInterval(SimpleInterval.singleton(BigInteger.ONE));
    private static final CompoundMathematicalInterval MINUS_ONE = new CompoundMathematicalInterval(SimpleInterval.singleton(BigInteger.valueOf(-1L)));
    private static final CompoundMathematicalInterval BOTTOM = new CompoundMathematicalInterval();
    private static final CompoundMathematicalInterval TOP = new CompoundMathematicalInterval(SimpleInterval.infinite());
    private static final CompoundMathematicalInterval FALSE = ZERO;
    private static final CompoundMathematicalInterval TRUE = CompoundMathematicalInterval.logicalFalse().invert();
    private final SimpleInterval[] intervals;

    private CompoundMathematicalInterval() {
        this.intervals = new SimpleInterval[0];
    }

    private CompoundMathematicalInterval(SimpleInterval pInterval) {
        this.intervals = new SimpleInterval[]{pInterval};
    }

    private CompoundMathematicalInterval(SimpleInterval[] pIntervals) {
        this.intervals = pIntervals;
    }

    private static CompoundMathematicalInterval getInternal(SimpleInterval pInterval) {
        CompoundMathematicalInterval cached = CompoundMathematicalInterval.getCached(pInterval);
        if (cached != null) {
            return cached;
        }
        return new CompoundMathematicalInterval(pInterval);
    }

    private static CompoundMathematicalInterval getCached(SimpleInterval pInterval) {
        if (pInterval.isSingleton()) {
            BigInteger value = pInterval.getLowerBound();
            if (value.equals(BigInteger.ONE)) {
                return ONE;
            }
            if (value.equals(BigInteger.ZERO)) {
                return ZERO;
            }
            if (value.equals(CompoundMathematicalInterval.MINUS_ONE.intervals[0].getLowerBound())) {
                return MINUS_ONE;
            }
        }
        return null;
    }

    private static CompoundMathematicalInterval getInternal(SimpleInterval[] pIntervals) {
        CompoundMathematicalInterval cached;
        if (pIntervals.length == 0) {
            return CompoundMathematicalInterval.bottom();
        }
        if (pIntervals.length == 1 && (cached = CompoundMathematicalInterval.getCached(pIntervals[0])) != null) {
            return cached;
        }
        return new CompoundMathematicalInterval(pIntervals);
    }

    public int getNumberOfIntervals() {
        return this.intervals.length;
    }

    @Override
    public List<SimpleInterval> getIntervals() {
        return Collections.unmodifiableList(Arrays.asList(this.intervals));
    }

    public List<CompoundMathematicalInterval> splitIntoIntervals() {
        return Lists.transform(Arrays.asList(this.intervals), CompoundMathematicalInterval::of);
    }

    public CompoundMathematicalInterval unionWith(CompoundMathematicalInterval pOther) {
        if (pOther == this || this.isTop() || pOther.isBottom()) {
            return this;
        }
        if (pOther.isTop() || this.isBottom()) {
            return pOther;
        }
        CompoundMathematicalInterval current = this;
        for (SimpleInterval interval : pOther.intervals) {
            current = current.unionWith(interval);
        }
        return current;
    }

    public CompoundMathematicalInterval unionWith(SimpleInterval pOther) {
        if (this.contains(pOther)) {
            return this;
        }
        if (this.isBottom() || pOther.isTop()) {
            return CompoundMathematicalInterval.getInternal(pOther);
        }
        ArrayList<SimpleInterval> resultIntervals = new ArrayList<SimpleInterval>();
        int start = 0;
        SimpleInterval lastInterval = null;
        if (pOther.hasLowerBound() && this.hasUpperBound()) {
            BigInteger pOtherLB = pOther.getLowerBound();
            SimpleInterval currentLocal = this.intervals[start];
            while (currentLocal != null && pOtherLB.compareTo(currentLocal.getUpperBound()) > 0) {
                resultIntervals.add(currentLocal);
                lastInterval = currentLocal;
                SimpleInterval simpleInterval = currentLocal = ++start < this.intervals.length ? this.intervals[start] : null;
                assert (currentLocal == null || currentLocal.hasUpperBound()) : this.toString();
            }
        }
        boolean inserted = false;
        for (int index = start; index < this.intervals.length; ++index) {
            SimpleInterval interval = this.intervals[index];
            boolean currentInserted = false;
            if (interval.touches(lastInterval)) {
                lastInterval = CompoundMathematicalInterval.union(interval, lastInterval);
                resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                currentInserted = true;
            }
            if (!inserted) {
                if (pOther.touches(lastInterval)) {
                    if ((lastInterval = CompoundMathematicalInterval.union(pOther, lastInterval)).touches(interval)) {
                        lastInterval = CompoundMathematicalInterval.union(lastInterval, interval);
                        currentInserted = true;
                    }
                    resultIntervals.set(resultIntervals.size() - 1, lastInterval);
                    inserted = true;
                } else if (pOther.touches(interval)) {
                    lastInterval = CompoundMathematicalInterval.union(pOther, interval);
                    resultIntervals.add(lastInterval);
                    inserted = true;
                    currentInserted = true;
                } else if (!pOther.hasLowerBound() || interval.hasLowerBound() && CompoundMathematicalInterval.less(pOther.getLowerBound(), interval.getLowerBound())) {
                    resultIntervals.add(pOther);
                    inserted = true;
                }
                if (currentInserted) continue;
                lastInterval = interval;
                resultIntervals.add(lastInterval);
                continue;
            }
            if (currentInserted) continue;
            lastInterval = interval;
            resultIntervals.add(lastInterval);
        }
        if (!inserted) {
            if (pOther.touches(lastInterval)) {
                resultIntervals.remove(resultIntervals.size() - 1);
                lastInterval = CompoundMathematicalInterval.union(pOther, lastInterval);
                resultIntervals.add(lastInterval);
            } else {
                resultIntervals.add(pOther);
            }
        }
        SimpleInterval[] resultArray = new SimpleInterval[resultIntervals.size()];
        return CompoundMathematicalInterval.getInternal(resultIntervals.toArray(resultArray));
    }

    public CompoundMathematicalInterval intersectWith(CompoundMathematicalInterval pOther) {
        if (this.isBottom() || pOther.isTop() || this == pOther) {
            return this;
        }
        if (this.isTop() || pOther.isBottom()) {
            return pOther;
        }
        if (pOther.contains(this)) {
            return this;
        }
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        for (SimpleInterval otherInterval : pOther.intervals) {
            result = result.unionWith(this.intersectWith(otherInterval));
        }
        return result;
    }

    public CompoundMathematicalInterval intersectWith(SimpleInterval pOther) {
        int intervalIndex;
        int intervalIndex2;
        if (this.isBottom() || pOther.isTop()) {
            return this;
        }
        if (this.contains(pOther)) {
            return CompoundMathematicalInterval.of(pOther);
        }
        if (this.intervals.length == 1 && pOther.contains(this.intervals[0])) {
            return this;
        }
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        int lbIndex = pOther.hasLowerBound() ? ((intervalIndex2 = this.intervalIndexOf(pOther.getLowerBound())) >= 0 ? intervalIndex2 : -intervalIndex2 - 1) : 0;
        int ubIndex = pOther.hasUpperBound() ? ((intervalIndex = this.intervalIndexOf(pOther.getUpperBound())) >= 0 ? intervalIndex : -intervalIndex - 1) : this.intervals.length - 1;
        for (int i = lbIndex; i <= ubIndex; ++i) {
            SimpleInterval interval = this.intervals[i];
            if (!interval.intersectsWith(pOther)) continue;
            result = result.unionWith(interval.intersectWith(pOther));
        }
        return result;
    }

    public boolean intersectsWith(CompoundMathematicalInterval pOther) {
        if (this.contains(pOther)) {
            return !pOther.isBottom();
        }
        if (pOther.contains(this)) {
            return !this.isBottom();
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean intersectsWith(SimpleInterval pOther) {
        if (this.contains(pOther)) {
            return true;
        }
        return !this.intersectWith(pOther).isBottom();
    }

    public boolean contains(CompoundMathematicalInterval pState) {
        if (this == pState || this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : pState.intervals) {
            if (this.contains(interval)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(SimpleInterval pInterval) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom() || pInterval.isTop()) {
            return false;
        }
        if (!pInterval.hasLowerBound() && this.hasLowerBound()) {
            return false;
        }
        if (!pInterval.hasUpperBound() && this.hasUpperBound()) {
            return false;
        }
        boolean hasLowerBound = pInterval.hasLowerBound();
        boolean hasUpperBound = pInterval.hasUpperBound();
        BigInteger lb = hasLowerBound ? pInterval.getLowerBound() : null;
        BigInteger ub = hasUpperBound ? pInterval.getUpperBound() : null;
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqUb;
            int index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
            SimpleInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqLb = !intervalAtIndex.hasLowerBound() || hasLowerBound && intervalAtIndex.getLowerBound().compareTo(lb) <= 0;
            boolean bl = ubIndexGeqUb = !intervalAtIndex.hasUpperBound() || hasUpperBound && intervalAtIndex.getUpperBound().compareTo(ub) >= 0;
            if (lbIndexLeqLb) {
                if (ubIndexGeqUb) {
                    return true;
                }
                leftInclusive = index + 1;
                continue;
            }
            rightExclusive = index;
        }
        return false;
    }

    private int intervalIndexOf(BigInteger value) {
        if (this.isBottom()) {
            return -1;
        }
        if (this.isTop()) {
            return 0;
        }
        int leftInclusive = 0;
        int rightExclusive = this.intervals.length;
        int index = rightExclusive / 2;
        while (leftInclusive < rightExclusive) {
            boolean ubIndexGeqValue;
            SimpleInterval intervalAtIndex = this.intervals[index];
            boolean lbIndexLeqValue = !intervalAtIndex.hasLowerBound() || intervalAtIndex.getLowerBound().compareTo(value) <= 0;
            boolean bl = ubIndexGeqValue = !intervalAtIndex.hasUpperBound() || intervalAtIndex.getUpperBound().compareTo(value) >= 0;
            if (lbIndexLeqValue) {
                if (ubIndexGeqValue) {
                    return index;
                }
                leftInclusive = index + 1;
            } else {
                rightExclusive = index;
            }
            index = IntMath.mean((int)leftInclusive, (int)rightExclusive);
        }
        return index == 0 ? -1 : -index;
    }

    @Override
    public boolean contains(BigInteger pValue) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return false;
        }
        return this.contains(SimpleInterval.singleton(pValue));
    }

    public boolean contains(long pValue) {
        if (this.isTop()) {
            return true;
        }
        if (this.isBottom()) {
            return false;
        }
        BigInteger value = BigInteger.valueOf(pValue);
        return this.intervalIndexOf(value) >= 0;
    }

    @Override
    public boolean isBottom() {
        return this.intervals.length == 0;
    }

    public boolean isTop() {
        return !this.isBottom() && this.intervals[0].isTop();
    }

    @Override
    public boolean containsAllPossibleValues() {
        return this.isTop();
    }

    public String toString() {
        if (this.isBottom()) {
            return Character.toString('\u22a5');
        }
        if (this.isTop()) {
            return Character.toString('\u22a4');
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        if (!this.isBottom()) {
            Iterator<SimpleInterval> intervalIterator = Arrays.asList(this.intervals).iterator();
            sb.append(intervalIterator.next());
            while (intervalIterator.hasNext()) {
                sb.append(", ");
                sb.append(intervalIterator.next());
            }
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean hasLowerBound() {
        if (this.isTop() || this.isBottom()) {
            return false;
        }
        return this.intervals[0].hasLowerBound();
    }

    @Override
    public boolean hasUpperBound() {
        if (this.isTop() || this.isBottom()) {
            return false;
        }
        return this.intervals[this.intervals.length - 1].hasUpperBound();
    }

    @Override
    public BigInteger getLowerBound() {
        return this.intervals[0].getLowerBound();
    }

    @Override
    public BigInteger getUpperBound() {
        return this.intervals[this.intervals.length - 1].getUpperBound();
    }

    @Override
    public boolean isSingleton() {
        return !this.isBottom() && this.intervals.length == 1 && this.intervals[0].isSingleton();
    }

    @Override
    public @Nullable BigInteger getValue() {
        if (this.isBottom()) {
            return null;
        }
        if (this.isTop()) {
            return BigInteger.ZERO;
        }
        for (SimpleInterval interval : this.intervals) {
            if (interval.hasLowerBound()) {
                return interval.getLowerBound();
            }
            if (!interval.hasUpperBound()) continue;
            return interval.getUpperBound();
        }
        return null;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther == null) {
            return false;
        }
        if (pOther instanceof CompoundMathematicalInterval) {
            return Arrays.equals(this.intervals, ((CompoundMathematicalInterval)pOther).intervals);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.intervals);
    }

    @Override
    public CompoundMathematicalInterval signum() {
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        if (this.containsNegative()) {
            result = result.unionWith(CompoundMathematicalInterval.singleton(-1L));
        }
        if (this.containsZero()) {
            result = result.unionWith(CompoundMathematicalInterval.singleton(0L));
        }
        if (this.containsPositive()) {
            result = result.unionWith(CompoundMathematicalInterval.singleton(1L));
        }
        return result;
    }

    @Override
    public CompoundMathematicalInterval span() {
        BigInteger lowerBound = null;
        BigInteger upperBound = null;
        if (this.hasLowerBound()) {
            lowerBound = this.getLowerBound();
        }
        if (this.hasUpperBound()) {
            upperBound = this.getUpperBound();
        }
        return CompoundMathematicalInterval.of(CompoundMathematicalInterval.createSimpleInterval(lowerBound, upperBound));
    }

    @Override
    public CompoundMathematicalInterval invert() {
        if (this.isTop()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isBottom()) {
            return CompoundMathematicalInterval.top();
        }
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        int index = 0;
        BigInteger currentLowerBound = null;
        if (!this.hasLowerBound()) {
            currentLowerBound = this.intervals[index++].getUpperBound().add(BigInteger.ONE);
        }
        while (index < this.intervals.length) {
            SimpleInterval current = this.intervals[index++];
            result = result.unionWith(CompoundMathematicalInterval.createSimpleInterval(currentLowerBound, current.getLowerBound().subtract(BigInteger.ONE)));
            if (current.hasUpperBound()) {
                currentLowerBound = current.getUpperBound().add(BigInteger.ONE);
                continue;
            }
            currentLowerBound = null;
        }
        if (currentLowerBound != null) {
            SimpleInterval[] resultIntervals = new SimpleInterval[result.intervals.length + 1];
            System.arraycopy(result.intervals, 0, resultIntervals, 0, result.intervals.length);
            resultIntervals[result.intervals.length] = CompoundMathematicalInterval.createSimpleInterval(currentLowerBound, null);
            result = CompoundMathematicalInterval.getInternal(resultIntervals);
        }
        return result;
    }

    public CompoundMathematicalInterval negate() {
        if (this.isTop() || this.isBottom()) {
            return this;
        }
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        for (SimpleInterval simpleInterval : this.intervals) {
            result = result.unionWith(simpleInterval.negate());
        }
        return result;
    }

    @Override
    public boolean containsPositive() {
        if (this.isBottom()) {
            return false;
        }
        if (this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : this.intervals) {
            if (!interval.containsPositive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsNegative() {
        if (this.isBottom()) {
            return false;
        }
        if (this.isTop()) {
            return true;
        }
        for (SimpleInterval interval : this.intervals) {
            if (!interval.containsNegative()) continue;
            return true;
        }
        return false;
    }

    public boolean containsZero() {
        return this.contains(0L);
    }

    @Override
    public CompoundMathematicalInterval extendToMinValue() {
        if (!this.hasLowerBound()) {
            return this;
        }
        SimpleInterval[] resultIntervals = new SimpleInterval[this.intervals.length];
        resultIntervals[0] = this.intervals[0].extendToNegativeInfinity();
        System.arraycopy(this.intervals, 1, resultIntervals, 1, this.intervals.length - 1);
        return CompoundMathematicalInterval.getInternal(resultIntervals);
    }

    @Override
    public CompoundMathematicalInterval extendToMaxValue() {
        if (!this.hasUpperBound()) {
            return this;
        }
        SimpleInterval[] resultIntervals = new SimpleInterval[this.intervals.length];
        int index = this.intervals.length - 1;
        System.arraycopy(this.intervals, 0, resultIntervals, 0, index);
        resultIntervals[index] = this.intervals[index].extendToPositiveInfinity();
        return CompoundMathematicalInterval.getInternal(resultIntervals);
    }

    public CompoundMathematicalInterval add(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.ADD, pValue);
    }

    public CompoundMathematicalInterval add(long pValue) {
        return this.add(BigInteger.valueOf(pValue));
    }

    public CompoundMathematicalInterval add(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.ADD, pInterval);
    }

    public CompoundMathematicalInterval add(CompoundMathematicalInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.ADD, pState);
    }

    public CompoundMathematicalInterval multiply(BigInteger pValue) {
        if (pValue.equals(BigInteger.ZERO)) {
            return CompoundMathematicalInterval.singleton(pValue);
        }
        if (pValue.equals(BigInteger.ONE)) {
            return this;
        }
        CompoundMathematicalInterval result = this.applyOperationToAllAndUnite(ISCOperator.MULTIPLY, pValue);
        if (result.isTop()) {
            SimpleInterval[] resultIntervals = new SimpleInterval[7];
            if (pValue.signum() >= 0) {
                for (int i = -3; i <= 3; ++i) {
                    resultIntervals[i + 3] = SimpleInterval.singleton(pValue.multiply(BigInteger.valueOf(i)));
                }
            } else {
                for (int i = -3; i <= 3; ++i) {
                    resultIntervals[3 - i] = SimpleInterval.singleton(pValue.multiply(BigInteger.valueOf(i)));
                }
            }
            resultIntervals[0] = resultIntervals[0].extendToNegativeInfinity();
            resultIntervals[6] = resultIntervals[6].extendToPositiveInfinity();
            result = CompoundMathematicalInterval.getInternal(resultIntervals);
        }
        return result;
    }

    public CompoundMathematicalInterval multiply(SimpleInterval pInterval) {
        if (pInterval.isSingleton()) {
            return this.multiply(pInterval.getLowerBound());
        }
        return this.applyOperationToAllAndUnite(IICOperator.MULTIPLY, pInterval);
    }

    public CompoundMathematicalInterval multiply(CompoundMathematicalInterval pState) {
        if (pState.intervals.length == 1) {
            return this.multiply(pState.intervals[0]);
        }
        return this.applyOperationToAllAndUnite(ICCOperator.MULTIPLY, pState);
    }

    public CompoundMathematicalInterval divide(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.DIVIDE, pValue);
    }

    public CompoundMathematicalInterval divide(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.DIVIDE, pInterval);
    }

    public CompoundMathematicalInterval divide(CompoundMathematicalInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.DIVIDE, pState);
    }

    public CompoundMathematicalInterval modulo(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.MODULO, pValue);
    }

    public CompoundMathematicalInterval modulo(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.MODULO, pInterval);
    }

    public CompoundMathematicalInterval modulo(CompoundMathematicalInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.MODULO, pState);
    }

    public CompoundMathematicalInterval shiftLeft(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.SHIFT_LEFT, pValue);
    }

    public CompoundMathematicalInterval shiftLeft(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.SHIFT_LEFT, pInterval);
    }

    public CompoundMathematicalInterval shiftLeft(CompoundMathematicalInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.SHIFT_LEFT, pState);
    }

    public CompoundMathematicalInterval shiftRight(BigInteger pValue) {
        return this.applyOperationToAllAndUnite(ISCOperator.SHIFT_RIGHT, pValue);
    }

    public CompoundMathematicalInterval shiftRight(SimpleInterval pInterval) {
        return this.applyOperationToAllAndUnite(IICOperator.SHIFT_RIGHT, pInterval);
    }

    public CompoundMathematicalInterval shiftRight(CompoundMathematicalInterval pState) {
        return this.applyOperationToAllAndUnite(ICCOperator.SHIFT_RIGHT, pState);
    }

    public CompoundMathematicalInterval logicalEquals(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isSingleton() && this.equals(pState)) {
            return CompoundMathematicalInterval.logicalTrue();
        }
        if (!this.intersectsWith(pState)) {
            return CompoundMathematicalInterval.logicalFalse();
        }
        return CompoundMathematicalInterval.top();
    }

    @Override
    public boolean isDefinitelyFalse() {
        return this.equals(CompoundMathematicalInterval.logicalFalse());
    }

    @Override
    public boolean isDefinitelyTrue() {
        return !this.isBottom() && !this.containsZero();
    }

    public CompoundMathematicalInterval greaterThan(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) > 0) {
            return TRUE;
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) <= 0) {
            return FALSE;
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval greaterEqual(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.hasLowerBound() && pState.hasUpperBound() && this.getLowerBound().compareTo(pState.getUpperBound()) >= 0) {
            return TRUE;
        }
        if (this.hasUpperBound() && pState.hasLowerBound() && this.getUpperBound().compareTo(pState.getLowerBound()) < 0) {
            return FALSE;
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval lessThan(CompoundMathematicalInterval pState) {
        return this.greaterEqual(pState).logicalNot();
    }

    public CompoundMathematicalInterval lessEqual(CompoundMathematicalInterval pState) {
        return this.greaterThan(pState).logicalNot();
    }

    public CompoundMathematicalInterval logicalAnd(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero() || pState.isSingleton() && pState.containsZero()) {
            return CompoundMathematicalInterval.logicalFalse();
        }
        if (!this.containsZero() && !pState.containsZero()) {
            return CompoundMathematicalInterval.logicalTrue();
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval logicalOr(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero() && pState.isSingleton() && pState.containsZero()) {
            return CompoundMathematicalInterval.logicalFalse();
        }
        if (!this.containsZero() || !pState.containsZero()) {
            return CompoundMathematicalInterval.logicalTrue();
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval logicalNot() {
        if (this.isBottom()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return TRUE;
        }
        if (!this.containsZero()) {
            return FALSE;
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval binaryAnd(CompoundMathematicalInterval pState) {
        CompoundMathematicalInterval result;
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return pState;
        }
        if (this.isSingleton() && this.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return pState.contains(1L) ? CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE)) : CompoundMathematicalInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().and(pState.getValue())));
            }
        } else {
            if (this.isSingleton()) {
                return pState.binaryAnd(this);
            }
            result = CompoundMathematicalInterval.top();
        }
        if (!result.isSingleton()) {
            CompoundMathematicalInterval absThis = this.absolute();
            CompoundMathematicalInterval absOther = pState.absolute();
            BigInteger smallestUpperBound = null;
            if (absThis.hasUpperBound()) {
                smallestUpperBound = absThis.getUpperBound();
            }
            if (absOther.hasUpperBound()) {
                BigInteger bigInteger = smallestUpperBound = smallestUpperBound == null ? absOther.getUpperBound() : smallestUpperBound.min(absOther.getUpperBound());
            }
            assert (smallestUpperBound == null || smallestUpperBound.signum() >= 0);
            CompoundMathematicalInterval range = smallestUpperBound == null ? CompoundMathematicalInterval.zero().extendToMaxValue() : CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, smallestUpperBound));
            if (this.containsNegative() && pState.containsNegative()) {
                range = range.unionWith(range.negate());
            }
            result = result.intersectWith(range);
        }
        return result;
    }

    public CompoundMathematicalInterval absolute() {
        if (!this.containsNegative()) {
            return this;
        }
        return this.intersectWith(CompoundMathematicalInterval.one().negate().extendToMinValue()).negate().unionWith(this.intersectWith(CompoundMathematicalInterval.zero().extendToMaxValue()));
    }

    public CompoundMathematicalInterval binaryXor(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isSingleton() && pState.isSingleton()) {
            return CompoundMathematicalInterval.singleton(this.getValue().xor(pState.getValue()));
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        CompoundMathematicalInterval zeroToOne = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        if (pState.isSingleton() && pState.contains(1L) && this.equals(zeroToOne)) {
            return this;
        }
        if (this.isSingleton() && this.contains(1L) && pState.equals(zeroToOne)) {
            return zeroToOne;
        }
        if (pState.isSingleton()) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundMathematicalInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().xor(pState.getValue())));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryXor(this);
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval binaryNot() {
        if (this.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        for (SimpleInterval interval : this.intervals) {
            if (!interval.isSingleton()) {
                if (!this.containsNegative()) {
                    return CompoundMathematicalInterval.singleton(0L).extendToMinValue();
                }
                if (!this.containsPositive()) {
                    return CompoundMathematicalInterval.singleton(0L).extendToMaxValue();
                }
                return CompoundMathematicalInterval.top();
            }
            result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().not()));
        }
        return result;
    }

    public CompoundMathematicalInterval binaryOr(CompoundMathematicalInterval pState) {
        if (this.isBottom() || pState.isBottom()) {
            return CompoundMathematicalInterval.bottom();
        }
        if (this.isSingleton() && this.containsZero()) {
            return pState;
        }
        if (pState.isSingleton() && pState.containsZero()) {
            return this;
        }
        if (pState.isSingleton()) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : this.intervals) {
                if (!interval.isSingleton()) {
                    return CompoundMathematicalInterval.top();
                }
                result = result.unionWith(SimpleInterval.singleton(interval.getLowerBound().or(pState.getValue())));
            }
            return result;
        }
        if (this.isSingleton()) {
            return pState.binaryOr(this);
        }
        return CompoundMathematicalInterval.top();
    }

    public CompoundMathematicalInterval logicalXor(CompoundMathematicalInterval pState) {
        return CompoundMathematicalInterval.logicalAnd(CompoundMathematicalInterval.logicalOr(this, pState), CompoundMathematicalInterval.logicalNot(CompoundMathematicalInterval.logicalAnd(this, pState)));
    }

    public static CompoundMathematicalInterval logicalAnd(CompoundMathematicalInterval p1, CompoundMathematicalInterval p2) {
        return p1.logicalAnd(p2);
    }

    public static CompoundMathematicalInterval logicalOr(CompoundMathematicalInterval p1, CompoundMathematicalInterval p2) {
        return p1.logicalOr(p2);
    }

    public static CompoundMathematicalInterval logicalXor(CompoundMathematicalInterval p1, CompoundMathematicalInterval p2) {
        return p1.logicalXor(p2);
    }

    public static CompoundMathematicalInterval logicalNot(CompoundMathematicalInterval pState) {
        return pState.logicalNot();
    }

    private <T> CompoundMathematicalInterval applyOperationToAllAndUnite(Operator<SimpleInterval, T, CompoundMathematicalInterval> pOperator, T pOperand) {
        CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
        for (SimpleInterval interval : this.intervals) {
            CompoundMathematicalInterval current = pOperator.apply(interval, pOperand);
            if (current == null || !(result = result.unionWith(current)).isTop()) continue;
            return result;
        }
        return result;
    }

    private static SimpleInterval union(SimpleInterval a, SimpleInterval b) {
        Preconditions.checkArgument((boolean)a.touches(b), (Object)"Cannot unite intervals that do not touch.");
        return CompoundMathematicalInterval.createSimpleInterval(CompoundMathematicalInterval.lowestBound(a, b), CompoundMathematicalInterval.highestBound(a, b));
    }

    private static @Nullable BigInteger lowestBound(SimpleInterval a, SimpleInterval b) {
        BigInteger bLowerBound;
        if (!a.hasLowerBound() || !b.hasLowerBound()) {
            return null;
        }
        BigInteger aLowerBound = a.getLowerBound();
        return CompoundMathematicalInterval.lessOrEqual(aLowerBound, bLowerBound = b.getLowerBound()) ? aLowerBound : bLowerBound;
    }

    private static BigInteger highestBound(SimpleInterval a, SimpleInterval b) {
        if (!a.hasUpperBound() || !b.hasUpperBound()) {
            return null;
        }
        BigInteger aUpperBound = a.getUpperBound();
        BigInteger bUpperBound = b.getUpperBound();
        return CompoundMathematicalInterval.lessOrEqual(bUpperBound, aUpperBound) ? aUpperBound : bUpperBound;
    }

    private static boolean less(BigInteger first, BigInteger second) {
        return first.compareTo(second) < 0;
    }

    private static boolean lessOrEqual(BigInteger first, BigInteger second) {
        return first.compareTo(second) <= 0;
    }

    public static CompoundMathematicalInterval of(@Nullable SimpleInterval interval) {
        if (interval == null) {
            return CompoundMathematicalInterval.bottom();
        }
        return CompoundMathematicalInterval.getInternal(interval);
    }

    public static CompoundMathematicalInterval singleton(BigInteger pValue) {
        Preconditions.checkNotNull((Object)pValue);
        return CompoundMathematicalInterval.of(SimpleInterval.singleton(pValue));
    }

    public static CompoundMathematicalInterval singleton(long pValue) {
        return CompoundMathematicalInterval.singleton(BigInteger.valueOf(pValue));
    }

    public static CompoundMathematicalInterval bottom() {
        return BOTTOM;
    }

    public static CompoundMathematicalInterval top() {
        return TOP;
    }

    public static CompoundMathematicalInterval logicalFalse() {
        return FALSE;
    }

    public static CompoundMathematicalInterval logicalTrue() {
        return TRUE;
    }

    public static CompoundMathematicalInterval zero() {
        return ZERO;
    }

    public static CompoundMathematicalInterval one() {
        return ONE;
    }

    public static CompoundMathematicalInterval minusOne() {
        return MINUS_ONE;
    }

    private static SimpleInterval createSimpleInterval(@Nullable BigInteger lowerBound, @Nullable BigInteger upperBound) {
        if (lowerBound == null) {
            if (upperBound == null) {
                return SimpleInterval.infinite();
            }
            return SimpleInterval.singleton(upperBound).extendToNegativeInfinity();
        }
        if (upperBound == null) {
            return SimpleInterval.singleton(lowerBound).extendToPositiveInfinity();
        }
        return SimpleInterval.of(lowerBound, upperBound);
    }

    public static CompoundMathematicalInterval span(CompoundMathematicalInterval pLeftValue, CompoundMathematicalInterval pRightValue) {
        return pLeftValue.span().unionWith(pRightValue.span()).span();
    }

    public static CompoundMathematicalInterval union(CompoundMathematicalInterval pLeftValue, CompoundMathematicalInterval pRightValue) {
        return pLeftValue.unionWith(pRightValue);
    }

    public static CompoundMathematicalInterval fromBoolean(boolean value) {
        return value ? CompoundMathematicalInterval.logicalTrue() : CompoundMathematicalInterval.logicalFalse();
    }
}

