/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.List;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundMathematicalInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

public class CompoundMathematicalIntervalTest {
    private final SimpleInterval oneToFiveInterval = SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(5L));
    private final SimpleInterval sixToTenInterval = SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.valueOf(10L));
    private final SimpleInterval oneToTenInterval = SimpleInterval.of(BigInteger.ONE, BigInteger.TEN);
    private final SimpleInterval negInfToZeroInterval = SimpleInterval.singleton(BigInteger.ZERO).extendToNegativeInfinity();
    private final SimpleInterval zeroToPosInfInterval = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();

    @Test
    public void testIsTop() {
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.oneToTenInterval).isTop()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.negInfToZeroInterval).isTop()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.zeroToPosInfInterval).isTop()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.bottom().isTop()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.top().isTop()).isTrue();
    }

    @Test
    public void testIsBottom() {
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.oneToTenInterval).isBottom()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.negInfToZeroInterval).isBottom()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.zeroToPosInfInterval).isBottom()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.top().isBottom()).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.bottom().isBottom()).isTrue();
    }

    @Test
    public void testUnionWith() {
        int i;
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.negInfToZeroInterval).unionWith(this.zeroToPosInfInterval).isTop()).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.negInfToZeroInterval).unionWith(CompoundMathematicalInterval.of(this.zeroToPosInfInterval)).isTop()).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.bottom().unionWith(CompoundMathematicalInterval.top()).isTop()).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(this.negInfToZeroInterval).unionWith(CompoundMathematicalInterval.of(this.oneToTenInterval)).isTop()).isFalse();
        Truth.assertThat((Object)CompoundMathematicalInterval.of(this.oneToTenInterval)).isEqualTo((Object)CompoundMathematicalInterval.of(this.oneToFiveInterval).unionWith(this.sixToTenInterval));
        Truth.assertThat((Object)CompoundMathematicalInterval.of(this.oneToTenInterval)).isEqualTo((Object)CompoundMathematicalInterval.of(this.oneToTenInterval).unionWith(this.sixToTenInterval));
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        Truth.assertThat(CompoundMathematicalInterval.of(zero.extendToNegativeInfinity()).unionWith(zero.extendToPositiveInfinity()).getIntervals()).hasSize(1);
        SimpleInterval zeroToThreeInterval = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(3L));
        CompoundMathematicalInterval zeroToThree = CompoundMathematicalInterval.of(zeroToThreeInterval);
        CompoundMathematicalInterval six = CompoundMathematicalInterval.singleton(6L);
        Truth.assertThat(zeroToThree.unionWith(six).getIntervals()).hasSize(2);
        Truth.assertThat((Object)six.unionWith(zeroToThree)).isEqualTo((Object)zeroToThree.unionWith(six));
        Truth.assertThat((Object)zeroToThree.unionWith(CompoundMathematicalInterval.singleton(0L))).isEqualTo((Object)zeroToThree);
        Truth.assertThat((Object)zeroToThree.unionWith(CompoundMathematicalInterval.singleton(1L))).isEqualTo((Object)zeroToThree);
        Truth.assertThat((Object)zeroToThree.unionWith(CompoundMathematicalInterval.singleton(2L))).isEqualTo((Object)zeroToThree);
        Truth.assertThat((Object)zeroToThree.unionWith(CompoundMathematicalInterval.singleton(3L))).isEqualTo((Object)zeroToThree);
        Truth.assertThat((Object)zeroToThree.unionWith(zeroToThree)).isEqualTo((Object)zeroToThree);
        CompoundMathematicalInterval steps = CompoundMathematicalInterval.bottom();
        for (i = -6; i <= 6; i += 2) {
            steps = steps.unionWith(CompoundMathematicalInterval.singleton(i));
        }
        steps = steps.extendToMinValue().extendToMaxValue();
        for (i = -6; i <= 6; i += 2) {
            Truth.assertThat((Boolean)steps.contains(i)).isTrue();
        }
        CompoundMathematicalInterval stepsNegInf = steps.unionWith(CompoundMathematicalInterval.singleton(BigInteger.valueOf(-4L)).extendToMinValue());
        for (int i2 = -6; i2 <= 6; i2 += 2) {
            Truth.assertThat((Boolean)stepsNegInf.contains(i2)).isTrue();
        }
        CompoundMathematicalInterval zeroOrTenToInf = CompoundMathematicalInterval.singleton(0L).unionWith(CompoundMathematicalInterval.singleton(10L).extendToMaxValue());
        CompoundMathematicalInterval negOne = CompoundMathematicalInterval.singleton(-1L);
        CompoundMathematicalInterval negOneOrZeroOrTenToInf = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-1L), BigInteger.ZERO)).unionWith(CompoundMathematicalInterval.singleton(10L).extendToMaxValue());
        Truth.assertThat((Object)zeroOrTenToInf.unionWith(negOne)).isEqualTo((Object)negOneOrZeroOrTenToInf);
        Truth.assertThat((Object)negOne.unionWith(CompoundMathematicalInterval.one()).unionWith(zero)).isEqualTo((Object)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-1L), BigInteger.valueOf(1L))));
        Truth.assertThat(negOne.unionWith(CompoundMathematicalInterval.one()).unionWith(zero).getIntervals()).hasSize(1);
    }

    @Test
    public void testIntersectWith() {
        Truth.assertThat((Object)CompoundMathematicalInterval.of(this.negInfToZeroInterval).intersectWith(this.zeroToPosInfInterval)).isEqualTo((Object)CompoundMathematicalInterval.of(SimpleInterval.singleton(BigInteger.ZERO)));
        Truth.assertThat((Object)CompoundMathematicalInterval.of(this.negInfToZeroInterval).intersectWith(CompoundMathematicalInterval.of(this.zeroToPosInfInterval))).isEqualTo((Object)CompoundMathematicalInterval.of(SimpleInterval.singleton(BigInteger.ZERO)));
        Truth.assertThat((Boolean)CompoundMathematicalInterval.bottom().intersectWith(CompoundMathematicalInterval.top()).isBottom()).isTrue();
        Truth.assertThat((Object)CompoundMathematicalInterval.top().intersectWith(CompoundMathematicalInterval.of(this.oneToTenInterval))).isEqualTo((Object)CompoundMathematicalInterval.of(this.oneToTenInterval));
        SimpleInterval oneToTwo = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        CompoundMathematicalInterval notTwo = CompoundMathematicalInterval.singleton(2L).invert();
        Truth.assertThat((Object)notTwo.intersectWith(CompoundMathematicalInterval.of(oneToTwo))).isEqualTo((Object)CompoundMathematicalInterval.singleton(1L));
    }

    @Test
    public void testInvert() {
        Truth.assertThat((Object)CompoundMathematicalInterval.top().invert()).isEqualTo((Object)CompoundMathematicalInterval.bottom());
        Truth.assertThat((Object)CompoundMathematicalInterval.bottom().invert()).isEqualTo((Object)CompoundMathematicalInterval.top());
        CompoundMathematicalInterval negInfToTen = CompoundMathematicalInterval.singleton(10L).extendToMinValue();
        CompoundMathematicalInterval elevenToInf = CompoundMathematicalInterval.singleton(11L).extendToMaxValue();
        Truth.assertThat((Object)negInfToTen.invert()).isEqualTo((Object)elevenToInf);
        Truth.assertThat((Object)elevenToInf.invert()).isEqualTo((Object)negInfToTen);
        Truth.assertThat((Object)negInfToTen.invert().invert()).isEqualTo((Object)negInfToTen);
        for (int i = -1; i < 2; ++i) {
            CompoundMathematicalInterval invertedState = CompoundMathematicalInterval.singleton(i).invert();
            Truth.assertThat((Boolean)invertedState.contains(i)).isFalse();
            Truth.assertThat((Boolean)invertedState.hasLowerBound()).isFalse();
            Truth.assertThat((Boolean)invertedState.hasUpperBound()).isFalse();
            Truth.assertThat((Boolean)invertedState.isTop()).isFalse();
            Truth.assertThat((Boolean)invertedState.isBottom()).isFalse();
            Truth.assertThat((Boolean)invertedState.contains(i - 1)).isTrue();
            Truth.assertThat((Boolean)invertedState.contains(i + 1)).isTrue();
        }
        Truth.assertThat((Object)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(5L))).unionWith(CompoundMathematicalInterval.singleton(7L).extendToMaxValue()).invert()).isEqualTo((Object)CompoundMathematicalInterval.singleton(0L).extendToMinValue().unionWith(CompoundMathematicalInterval.singleton(6L)));
    }

    @Test
    public void moduloTest() {
        SimpleInterval zeroToThreeInterval = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(3L));
        CompoundMathematicalInterval zeroToThree = CompoundMathematicalInterval.of(zeroToThreeInterval);
        CompoundMathematicalInterval six = CompoundMathematicalInterval.singleton(6L);
        SimpleInterval sixToTenSimpleInterval = SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.valueOf(10L));
        CompoundMathematicalInterval sixToTen = CompoundMathematicalInterval.of(sixToTenSimpleInterval);
        Truth.assertThat((Object)sixToTen.modulo(BigInteger.valueOf(7L))).isEqualTo((Object)zeroToThree.unionWith(six));
        Truth.assertThat((Object)sixToTen.negate().modulo(BigInteger.valueOf(7L))).isEqualTo((Object)zeroToThree.unionWith(six).negate());
        Truth.assertThat((Object)sixToTen.modulo(BigInteger.valueOf(7L).negate())).isEqualTo((Object)zeroToThree.unionWith(six));
        Truth.assertThat((Object)sixToTen.negate().modulo(BigInteger.valueOf(7L).negate())).isEqualTo((Object)zeroToThree.unionWith(six).negate());
    }

    @Test
    public void testNegate() {
        Truth.assertThat((Object)CompoundMathematicalInterval.one().negate()).isEqualTo((Object)CompoundMathematicalInterval.singleton(-1L));
        CompoundMathematicalInterval twoToFour = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L)));
        CompoundMathematicalInterval negTwoToNegOne = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L)));
        CompoundMathematicalInterval negFourToNegTwo = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L)));
        CompoundMathematicalInterval oneToTwo = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(2L)));
        Truth.assertThat((Object)negTwoToNegOne.unionWith(twoToFour).negate()).isEqualTo((Object)oneToTwo.unionWith(negFourToNegTwo));
    }

    @Test
    public void testIsSingleton() {
        CompoundMathematicalInterval negOne = CompoundMathematicalInterval.singleton(-1L);
        CompoundMathematicalInterval zero = CompoundMathematicalInterval.singleton(0L);
        CompoundMathematicalInterval ten = CompoundMathematicalInterval.singleton(10L);
        Truth.assertThat((Boolean)negOne.isSingleton()).isTrue();
        Truth.assertThat((Boolean)zero.isSingleton()).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.one().isSingleton()).isTrue();
        Truth.assertThat((Boolean)ten.isSingleton()).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.span(CompoundMathematicalInterval.one(), ten).isSingleton()).isFalse();
        Truth.assertThat((Boolean)zero.unionWith(ten).isSingleton()).isFalse();
        Truth.assertThat((Boolean)negOne.unionWith(CompoundMathematicalInterval.span(CompoundMathematicalInterval.one(), ten)).isSingleton()).isFalse();
    }

    @Test
    public void containsTest() {
        Truth.assertThat((Boolean)CompoundMathematicalInterval.singleton(-1L).contains(-1L)).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.singleton(0L).contains(0L)).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.one().contains(1L)).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.singleton(-1L).contains(CompoundMathematicalInterval.singleton(-1L))).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.singleton(0L).contains(CompoundMathematicalInterval.singleton(0L))).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.singleton(1L).contains(CompoundMathematicalInterval.singleton(1L))).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.TEN)))).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.TEN)).contains(CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)))).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(5L)).isTrue();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN)).contains(-1L)).isFalse();
        Truth.assertThat((Boolean)CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(4L))).unionWith(SimpleInterval.of(BigInteger.valueOf(6L), BigInteger.TEN)).contains(5L)).isFalse();
    }

    @Test
    public void binaryNotTest() {
        CompoundMathematicalInterval.singleton(1L).extendToMinValue().binaryNot();
    }

    @Test
    public void testMultiply() {
        CompoundMathematicalInterval topMultNeg2 = CompoundMathematicalInterval.top().multiply(BigInteger.valueOf(-2L));
        List<SimpleInterval> intervals = topMultNeg2.getIntervals();
        int i = 0;
        BigInteger lastUpperBound = null;
        for (SimpleInterval interval : intervals) {
            if (i == 0) {
                Truth.assertThat((Boolean)interval.hasLowerBound()).isFalse();
            } else {
                Truth.assertThat((Boolean)interval.hasLowerBound()).isTrue();
                Truth.assertThat((Boolean)(interval.getLowerBound().subtract(lastUpperBound).compareTo(BigInteger.ONE) > 0 ? 1 : 0)).isTrue();
            }
            if (i == intervals.size() - 1) {
                Truth.assertThat((Boolean)interval.hasUpperBound()).isFalse();
            }
            if (interval.hasUpperBound()) {
                lastUpperBound = interval.getUpperBound();
            }
            ++i;
        }
        Truth.assertThat((Object)topMultNeg2.unionWith(topMultNeg2)).isEqualTo((Object)topMultNeg2);
    }

    @Test
    public void testBinaryXor() {
        CompoundMathematicalInterval zeroToOne = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        CompoundMathematicalInterval one = CompoundMathematicalInterval.one();
        Truth.assertThat((Object)zeroToOne.binaryXor(one)).isEqualTo((Object)zeroToOne);
        Truth.assertThat((Object)one.binaryXor(zeroToOne)).isEqualTo((Object)zeroToOne);
    }

    @Test
    public void testBinaryAnd() {
        CompoundMathematicalInterval zeroToOne = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE));
        CompoundMathematicalInterval one = CompoundMathematicalInterval.one();
        Truth.assertThat((Object)CompoundMathematicalInterval.top().binaryAnd(one)).isEqualTo((Object)zeroToOne);
        Truth.assertThat((Object)one.binaryAnd(CompoundMathematicalInterval.top())).isEqualTo((Object)zeroToOne);
        CompoundMathematicalInterval.top().binaryAnd(CompoundMathematicalInterval.singleton(8L));
    }

    @Test
    public void testAbsolute() {
        Truth.assertThat((Boolean)CompoundMathematicalInterval.top().absolute().containsNegative()).isFalse();
        Truth.assertThat((Object)CompoundMathematicalInterval.one().negate().absolute()).isEqualTo((Object)CompoundMathematicalInterval.one());
        CompoundMathematicalInterval twoToFour = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L)));
        CompoundMathematicalInterval negTwoToNegOne = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L)));
        CompoundMathematicalInterval negFourToNegTwo = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L)));
        CompoundMathematicalInterval oneToTwo = CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(2L)));
        Truth.assertThat((Boolean)twoToFour.absolute().containsNegative()).isFalse();
        Truth.assertThat((Boolean)negFourToNegTwo.absolute().containsNegative()).isFalse();
        Truth.assertThat((Boolean)negFourToNegTwo.negate().absolute().containsNegative()).isFalse();
        Truth.assertThat((Boolean)oneToTwo.absolute().containsNegative()).isFalse();
        Truth.assertThat((Boolean)oneToTwo.negate().absolute().containsNegative()).isFalse();
        Truth.assertThat((Boolean)negTwoToNegOne.unionWith(twoToFour).negate().absolute().containsNegative()).isFalse();
    }
}

