/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AAssignment;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.MemoryLocationExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class EdgeAnalyzer {
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final MachineModel machineModel;

    public EdgeAnalyzer(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.machineModel = pMachineModel;
    }

    Map<MemoryLocation, CType> getInvolvedVariableTypes(CFAEdge pCfaEdge) {
        switch (pCfaEdge.getEdgeType()) {
            case AssumeEdge: {
                AssumeEdge assumeEdge = (AssumeEdge)pCfaEdge;
                AExpression expression = assumeEdge.getExpression();
                return this.getInvolvedVariableTypes(expression, pCfaEdge);
            }
            case DeclarationEdge: {
                ADeclarationEdge declarationEdge = (ADeclarationEdge)pCfaEdge;
                ADeclaration declaration = declarationEdge.getDeclaration();
                if (declaration instanceof CVariableDeclaration) {
                    CVariableDeclaration variableDeclaration = (CVariableDeclaration)declaration;
                    MemoryLocation declaredVariable = MemoryLocation.forDeclaration(variableDeclaration);
                    CType cType = variableDeclaration.getType();
                    CInitializer cInitializer = variableDeclaration.getInitializer();
                    if (cInitializer == null) {
                        return ImmutableMap.of((Object)declaredVariable, (Object)cType);
                    }
                    ImmutableMap<MemoryLocation, CType> initializerVariableTypes = this.getInvolvedVariableTypes(cInitializer, pCfaEdge);
                    if (initializerVariableTypes.containsKey(declaredVariable)) {
                        assert (((CType)initializerVariableTypes.get(declaredVariable)).equals(cType));
                        return initializerVariableTypes;
                    }
                    return ImmutableMap.builderWithExpectedSize((int)(initializerVariableTypes.size() + 1)).put((Object)declaredVariable, (Object)cType).putAll(initializerVariableTypes).buildOrThrow();
                }
                if (declaration instanceof AVariableDeclaration) {
                    throw new UnsupportedOperationException("Only C expressions are supported");
                }
                return ImmutableMap.of();
            }
            case FunctionCallEdge: {
                FunctionCallEdge functionCallEdge = (FunctionCallEdge)pCfaEdge;
                HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>();
                String callerFunctionName = pCfaEdge.getPredecessor().getFunctionName();
                for (AExpression aExpression : functionCallEdge.getArguments()) {
                    result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(aExpression, new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, callerFunctionName, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of())));
                }
                for (AParameterDeclaration aParameterDeclaration : functionCallEdge.getSuccessor().getFunctionParameters()) {
                    result.putAll(this.getInvolvedVariableTypes(aParameterDeclaration, pCfaEdge));
                }
                return result;
            }
            case ReturnStatementEdge: {
                AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)pCfaEdge;
                if (returnStatementEdge.getExpression().isPresent()) {
                    AExpression returnExpression = returnStatementEdge.getExpression().get();
                    HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>();
                    Optional<? extends AAssignment> returnAssignment = returnStatementEdge.asAssignment();
                    if (returnAssignment.isPresent()) {
                        result.putAll(this.getInvolvedVariableTypes(returnAssignment.get(), pCfaEdge));
                    } else {
                        Optional<? extends AVariableDeclaration> optional = returnStatementEdge.getSuccessor().getEntryNode().getReturnVariable();
                        if (optional.isPresent()) {
                            CIdExpression cIdExpression = new CIdExpression(returnStatementEdge.getFileLocation(), (CSimpleDeclaration)((Object)optional.get()));
                            result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes((AExpression)cIdExpression, pCfaEdge));
                        }
                    }
                    result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(returnExpression, pCfaEdge));
                    return result;
                }
                return ImmutableMap.of();
            }
            case StatementEdge: {
                AStatementEdge statementEdge = (AStatementEdge)pCfaEdge;
                AStatement statement = statementEdge.getStatement();
                if (statement instanceof AExpressionAssignmentStatement) {
                    return this.getInvolvedVariableTypes((AExpressionAssignmentStatement)statement, pCfaEdge);
                }
                if (statement instanceof AExpressionStatement) {
                    return this.getInvolvedVariableTypes(((AExpressionStatement)statement).getExpression(), pCfaEdge);
                }
                if (statement instanceof AFunctionCallAssignmentStatement) {
                    return this.getInvolvedVariableTypes((AFunctionCallAssignmentStatement)statement, pCfaEdge);
                }
                if (statement instanceof AFunctionCallStatement) {
                    AFunctionCallStatement functionCallStatement = (AFunctionCallStatement)statement;
                    HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>();
                    for (AExpression aExpression : functionCallStatement.getFunctionCallExpression().getParameterExpressions()) {
                        result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(aExpression, pCfaEdge));
                    }
                    return result;
                }
                return ImmutableMap.of();
            }
            case FunctionReturnEdge: {
                FunctionReturnEdge functionReturnEdge = (FunctionReturnEdge)pCfaEdge;
                AFunctionCall functionCall = functionReturnEdge.getSummaryEdge().getExpression();
                if (functionCall instanceof AFunctionCallAssignmentStatement) {
                    AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)functionCall;
                    AFunctionCallExpression functionCallExpression = functionCall.getFunctionCallExpression();
                    if (functionCallExpression != null) {
                        HashMap<MemoryLocation, CType> hashMap = new HashMap<MemoryLocation, CType>();
                        Optional<? extends AVariableDeclaration> optional = functionReturnEdge.getFunctionEntry().getReturnVariable();
                        if (optional.isPresent()) {
                            AExpression idExpression = new CIdExpression(functionReturnEdge.getFileLocation(), (CSimpleDeclaration)((Object)optional.get()));
                            idExpression = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(idExpression, functionCallAssignmentStatement.getLeftHandSide().getExpressionType());
                            hashMap.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(idExpression, new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, functionReturnEdge.getPredecessor().getFunctionName(), (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of())));
                        }
                        hashMap.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes((AExpression)functionCallAssignmentStatement.getLeftHandSide(), pCfaEdge));
                        return hashMap;
                    }
                }
                return ImmutableMap.of();
            }
        }
        return ImmutableMap.of();
    }

    private Map<MemoryLocation, CType> getInvolvedVariableTypes(AAssignment pAssignment, CFAEdge pCfaEdge) {
        if (pAssignment instanceof AExpressionAssignmentStatement) {
            AExpressionAssignmentStatement expressionAssignmentStatement = (AExpressionAssignmentStatement)pAssignment;
            HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes((AExpression)expressionAssignmentStatement.getLeftHandSide(), pCfaEdge));
            result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(expressionAssignmentStatement.getRightHandSide(), expressionAssignmentStatement.getLeftHandSide().getExpressionType()), pCfaEdge));
            return result;
        }
        if (pAssignment instanceof AFunctionCallAssignmentStatement) {
            AFunctionCallAssignmentStatement functionCallAssignmentStatement = (AFunctionCallAssignmentStatement)pAssignment;
            HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes((AExpression)functionCallAssignmentStatement.getLeftHandSide(), pCfaEdge));
            AFunctionCallExpression functionCallExpression = functionCallAssignmentStatement.getFunctionCallExpression();
            for (AExpression aExpression : functionCallExpression.getParameterExpressions()) {
                result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(aExpression, pCfaEdge));
            }
            return result;
        }
        return ImmutableMap.of();
    }

    private Map<? extends MemoryLocation, ? extends CType> getInvolvedVariableTypes(AParameterDeclaration pParameter, CFAEdge pCFAEdge) {
        if (pParameter.getType() instanceof CType) {
            return ImmutableMap.of((Object)new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pCFAEdge).getMemoryLocation(pParameter), (Object)((CType)pParameter.getType()));
        }
        return ImmutableMap.of();
    }

    private ImmutableMap<MemoryLocation, CType> getInvolvedVariableTypes(CInitializer pCInitializer, CFAEdge pCfaEdge) {
        if (pCInitializer instanceof CDesignatedInitializer) {
            return this.getInvolvedVariableTypes(((CDesignatedInitializer)pCInitializer).getRightHandSide(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerExpression) {
            return this.getInvolvedVariableTypes((AExpression)((CInitializerExpression)pCInitializer).getExpression(), pCfaEdge);
        }
        if (pCInitializer instanceof CInitializerList) {
            CInitializerList initializerList = (CInitializerList)pCInitializer;
            HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>();
            for (CInitializer initializer : initializerList.getInitializers()) {
                result.putAll((Map<MemoryLocation, CType>)this.getInvolvedVariableTypes(initializer, pCfaEdge));
            }
            return ImmutableMap.copyOf(result);
        }
        return ImmutableMap.of();
    }

    public ImmutableMap<MemoryLocation, CType> getInvolvedVariableTypes(AExpression pExpression, CFAEdge pCFAEdge) {
        return this.getInvolvedVariableTypes(pExpression, new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pCFAEdge, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of()));
    }

    public ImmutableMap<MemoryLocation, CType> getInvolvedVariableTypes(AExpression pExpression, MemoryLocationExtractor pVariableNameExtractor) {
        if (pExpression == null) {
            return ImmutableMap.of();
        }
        if (pExpression instanceof CExpression) {
            HashMap<MemoryLocation, CType> result = new HashMap<MemoryLocation, CType>();
            for (ALeftHandSide leftHandSide : ((CExpression)pExpression).accept(LHSVisitor.INSTANCE)) {
                try {
                    ExpressionToFormulaVisitor etfv = new ExpressionToFormulaVisitor(this.compoundIntervalManagerFactory, this.machineModel, pVariableNameExtractor);
                    NumeralFormula<CompoundInterval> formula = ((CExpression)((Object)leftHandSide)).accept(etfv);
                    for (MemoryLocation memoryLocation : (Set)formula.accept(COLLECT_VARS_VISITOR)) {
                        result.put(memoryLocation, (CType)leftHandSide.getExpressionType());
                    }
                }
                catch (UnrecognizedCodeException unrecognizedCodeException) {
                }
            }
            return ImmutableMap.copyOf(result);
        }
        throw new UnsupportedOperationException("Only C expressions are supported");
    }

    private static class LHSVisitor
    extends DefaultCExpressionVisitor<Iterable<ALeftHandSide>, NoException> {
        private static final LHSVisitor INSTANCE = new LHSVisitor();

        private LHSVisitor() {
        }

        @Override
        protected Iterable<ALeftHandSide> visitDefault(CExpression pExp) {
            return ImmutableSet.of();
        }

        @Override
        public Iterable<ALeftHandSide> visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            return Collections.singleton(pIastArraySubscriptExpression);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CFieldReference pIastFieldReference) {
            return Collections.singleton(pIastFieldReference);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CIdExpression pIastIdExpression) {
            return Collections.singleton(pIastIdExpression);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CPointerExpression pPointerExpression) {
            return Collections.singleton(pPointerExpression);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CComplexCastExpression pComplexCastExpression) {
            return pComplexCastExpression.getOperand().accept(this);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CBinaryExpression pIastBinaryExpression) {
            CExpression operand1 = pIastBinaryExpression.getOperand1();
            CExpression operand2 = pIastBinaryExpression.getOperand2();
            operand1 = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(operand1, pIastBinaryExpression.getCalculationType());
            operand2 = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(operand2, pIastBinaryExpression.getCalculationType());
            return Iterables.concat(operand1.accept(this), operand2.accept(this));
        }

        @Override
        public Iterable<ALeftHandSide> visit(CCastExpression pIastCastExpression) {
            return ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(pIastCastExpression.getOperand(), pIastCastExpression.getCastType()).accept(this);
        }

        @Override
        public Iterable<ALeftHandSide> visit(CUnaryExpression pIastUnaryExpression) {
            CExpression operand = pIastUnaryExpression.getOperand();
            if (pIastUnaryExpression.getOperator() != CUnaryExpression.UnaryOperator.AMPER) {
                operand = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(operand, pIastUnaryExpression.getExpressionType());
            }
            return operand.accept(this);
        }
    }
}

