/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.IntegerOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.DelegateAbstractDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeJoinOperator;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.conditions.ReachedSetAdjustingCPA;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStrategyFactories;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.EdgeAnalyzer;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsMergeOperator;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsTransferRelation;
import org.sosy_lab.cpachecker.cpa.invariants.MemoryLocationExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptAllVariableSelection;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.AcceptSpecifiedVariableSelection;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.StateToFormulaWriter;
import org.sosy_lab.cpachecker.util.automaton.CachingTargetLocationProvider;
import org.sosy_lab.cpachecker.util.automaton.TargetLocationProvider;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

public class InvariantsCPA
implements ConfigurableProgramAnalysis,
ReachedSetAdjustingCPA,
StatisticsProvider {
    private final InvariantsOptions options;
    private final Configuration config;
    private final LogManager logManager;
    private final TargetLocationProvider targetLocationProvider;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final MachineModel machineModel;
    private final Specification specification;
    private final WeakHashMap<CFANode, InvariantsPrecision> initialPrecisionMap = new WeakHashMap();
    private boolean relevantVariableLimitReached = false;
    private final Map<CFANode, BooleanFormula<CompoundInterval>> invariants = Collections.synchronizedMap(new HashMap());
    private final ConditionAdjuster conditionAdjuster;
    @GuardedBy(value="itself")
    private final Set<MemoryLocation> currentInterestingVariables = new LinkedHashSet<MemoryLocation>();
    private final MergeOperator mergeOperator;
    private final AbstractDomain abstractDomain;
    private final StateToFormulaWriter writer;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory = CompoundBitVectorIntervalManagerFactory.FORBID_SIGNED_WRAP_AROUND;
    private final EdgeAnalyzer edgeAnalyzer;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(InvariantsCPA.class).withOptions(InvariantsOptions.class);
    }

    public InvariantsCPA(Configuration pConfig, LogManager pLogManager, InvariantsOptions pOptions, ShutdownNotifier pShutdownNotifier, CFA pCfa, Specification pSpecification) throws InvalidConfigurationException {
        this.config = pConfig;
        this.logManager = pLogManager;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCfa;
        this.specification = (Specification)Preconditions.checkNotNull((Object)pSpecification);
        this.targetLocationProvider = new CachingTargetLocationProvider(this.shutdownNotifier, this.logManager, this.cfa);
        this.options = pOptions;
        this.conditionAdjuster = pOptions.conditionAdjusterFactory.createConditionAdjuster(this);
        this.machineModel = pCfa.getMachineModel();
        this.abstractDomain = DelegateAbstractDomain.getInstance();
        if (pOptions.merge.equalsIgnoreCase("precisiondependent")) {
            this.mergeOperator = new InvariantsMergeOperator();
        } else if (pOptions.merge.equalsIgnoreCase("sep")) {
            this.mergeOperator = MergeSepOperator.getInstance();
        } else {
            assert (pOptions.merge.equalsIgnoreCase("join"));
            this.mergeOperator = new MergeJoinOperator(this.abstractDomain);
        }
        this.writer = new StateToFormulaWriter(this.config, this.logManager, this.shutdownNotifier, this.cfa);
        this.edgeAnalyzer = new EdgeAnalyzer(this.compoundIntervalManagerFactory, this.machineModel);
    }

    @Override
    public MergeOperator getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.abstractDomain;
    }

    @Override
    public TransferRelation getTransferRelation() {
        return new InvariantsTransferRelation(this.compoundIntervalManagerFactory, this.machineModel, this.options.allowOverapproximationOfUnsupportedFeatures, this.options.usePointerAliasStrengthening, this.cfa.getVarClassification());
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        AcceptAllVariableSelection<CompoundInterval> variableSelection;
        LinkedHashSet<MemoryLocation> interestingVariables;
        boolean determineTargetLocations;
        LinkedHashSet<CFANode> relevantLocations = new LinkedHashSet<CFANode>();
        ImmutableSet<CFANode> targetLocations = new LinkedHashSet();
        int interestingVariableLimit = this.options.interestingVariableLimit;
        boolean bl = determineTargetLocations = this.options.analyzeTargetPathsOnly || this.options.interestingVariableLimit > 0;
        if (determineTargetLocations) {
            targetLocations = this.targetLocationProvider.tryGetAutomatonTargetLocations(pNode, this.specification);
            boolean bl2 = determineTargetLocations = targetLocations != null;
            if (targetLocations == null) {
                targetLocations = ImmutableSet.of();
            }
        }
        this.shutdownNotifier.shutdownIfNecessary();
        AbstractionState abstractionState = this.options.abstractionStateFactory.createStrategy(this.compoundIntervalManagerFactory, this.machineModel).getAbstractionState();
        this.shutdownNotifier.shutdownIfNecessary();
        if (this.options.analyzeTargetPathsOnly && determineTargetLocations) {
            relevantLocations.addAll((Collection<CFANode>)targetLocations);
        } else {
            relevantLocations.addAll(this.cfa.getAllNodes());
        }
        LinkedHashSet<CFAEdge> relevantEdges = new LinkedHashSet<CFAEdge>();
        Set<MemoryLocation> set = this.currentInterestingVariables;
        synchronized (set) {
            interestingVariables = new LinkedHashSet<MemoryLocation>(this.currentInterestingVariables);
        }
        if (interestingVariableLimit > 0 && !determineTargetLocations) {
            this.logManager.log(Level.WARNING, new Object[]{"Target states were not determined. Guessing interesting information is arbitrary."});
        }
        for (CFANode location : relevantLocations) {
            ArrayDeque<CFANode> nodes = new ArrayDeque<CFANode>();
            nodes.offer(location);
            while (!nodes.isEmpty()) {
                this.shutdownNotifier.shutdownIfNecessary();
                location = (CFANode)nodes.poll();
                for (CFAEdge edge : CFAUtils.enteringEdges(location)) {
                    if (!relevantEdges.add(edge)) continue;
                    nodes.offer(edge.getPredecessor());
                }
            }
        }
        LinkedHashSet<MemoryLocation> relevantVariables = new LinkedHashSet<MemoryLocation>();
        boolean specifyRelevantVariables = this.options.analyzeRelevantVariablesOnly;
        if (specifyRelevantVariables) {
            this.expandFixpoint(relevantVariables, (Set<CFANode>)targetLocations, -1);
            for (MemoryLocation variable : relevantVariables) {
                if (interestingVariableLimit >= 0 && interestingVariables.size() >= interestingVariableLimit) break;
                interestingVariables.add(variable);
                this.expandFixpoint(interestingVariables, (Set<CFANode>)targetLocations, interestingVariableLimit);
            }
            variableSelection = new AcceptSpecifiedVariableSelection(relevantVariables);
        } else {
            variableSelection = new AcceptAllVariableSelection();
        }
        this.relevantVariableLimitReached = interestingVariableLimit < 0 || interestingVariableLimit > interestingVariables.size();
        InvariantsPrecision precision = new InvariantsPrecision(relevantEdges, (Set<MemoryLocation>)ImmutableSet.copyOf(InvariantsCPA.limit(interestingVariables, interestingVariableLimit)), this.options.maximumFormulaDepth, this.options.abstractionStateFactory.createStrategy(this.compoundIntervalManagerFactory, this.machineModel), this.options.useMod2Template);
        this.initialPrecisionMap.put(pNode, precision);
        InvariantsState state = new InvariantsState(variableSelection, this.compoundIntervalManagerFactory, this.machineModel, abstractionState, this.options.includeTypeInformation);
        BooleanFormula<CompoundInterval> invariant = this.invariants.get(pNode);
        if (invariant != null) {
            state = state.assume(invariant);
        }
        return state;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        InvariantsPrecision precision = this.initialPrecisionMap.get(pNode);
        if (precision != null) {
            return precision;
        }
        this.getInitialState(pNode, pPartition);
        precision = this.initialPrecisionMap.get(pNode);
        if (precision == null) {
            return InvariantsPrecision.getEmptyPrecision(this.options.abstractionStateFactory.createStrategy(this.compoundIntervalManagerFactory, this.machineModel));
        }
        return precision;
    }

    public void injectInvariant(CFANode pLocation, AssumeEdge pAssumption) throws UnrecognizedCodeException {
        if (pAssumption instanceof CAssumeEdge) {
            CAssumeEdge assumeEdge = (CAssumeEdge)pAssumption;
            MemoryLocationExtractor vne = new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pAssumption);
            ExpressionToFormulaVisitor etfv = new ExpressionToFormulaVisitor(this.compoundIntervalManagerFactory, this.machineModel, vne);
            CompoundIntervalFormulaManager compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
            BooleanFormula<CompoundInterval> assumption = compoundIntervalFormulaManager.fromNumeral(assumeEdge.getExpression().accept(etfv));
            if (!pAssumption.getTruthAssumption()) {
                assumption = compoundIntervalFormulaManager.logicalNot(assumption);
            }
            this.injectInvariant(pLocation, assumption);
        }
    }

    public void injectInvariant(CFANode pLocation, BooleanFormula<CompoundInterval> pAssumption) {
        this.invariants.put(pLocation, pAssumption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInterestingVariables(Iterable<MemoryLocation> pInterestingVariables) {
        Set<MemoryLocation> set = this.currentInterestingVariables;
        synchronized (set) {
            Iterables.addAll(this.currentInterestingVariables, pInterestingVariables);
        }
    }

    private static <T> Iterable<T> limit(Iterable<T> pIterable, int pLimit) {
        if (pLimit >= 0) {
            return FluentIterable.from(pIterable).limit(pLimit);
        }
        return pIterable;
    }

    @Override
    public boolean adjustPrecision() {
        return this.conditionAdjuster.adjustConditions();
    }

    @Override
    public void adjustReachedSet(ReachedSet pReachedSet) {
        this.conditionAdjuster.adjustReachedSet(pReachedSet);
    }

    public boolean isLikelyLongRunning() {
        return this.options.abstractionStateFactory == AbstractionStrategyFactories.NEVER;
    }

    private static <T> boolean reachesLimit(Collection<T> pCollection, int pLimit) {
        return pLimit >= 0 && pCollection.size() >= pLimit;
    }

    private void expandFixpoint(Set<MemoryLocation> pRelevantVariables, Set<CFANode> pRelevantLocations, int pLimit) throws InterruptedException {
        for (CFANode relevantLocation : pRelevantLocations) {
            this.expandFixpoint(pRelevantVariables, relevantLocation, pLimit);
        }
    }

    private void expandFixpoint(Set<MemoryLocation> pRelevantVariables, CFANode pRelevantLocation, int pLimit) throws InterruptedException {
        int prevSize = -1;
        while (pRelevantVariables.size() > prevSize && !InvariantsCPA.reachesLimit(pRelevantVariables, pLimit)) {
            this.shutdownNotifier.shutdownIfNecessary();
            prevSize = pRelevantVariables.size();
            this.expandOnce(pRelevantVariables, pRelevantLocation, pLimit);
        }
    }

    private void expandOnce(Set<MemoryLocation> pRelevantVariables, CFANode pRelevantLocation, int pLimit) {
        HashSet<CFANode> pVisitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> relevantLocations = new ArrayDeque<CFANode>();
        pVisitedNodes.add(pRelevantLocation);
        relevantLocations.offer(pRelevantLocation);
        while (!relevantLocations.isEmpty() && !InvariantsCPA.reachesLimit(pRelevantVariables, pLimit)) {
            CFANode currentRelevantLocation = (CFANode)relevantLocations.poll();
            HashSet<Pair<AssumeEdge, List>> assumeEdgesAndPaths = new HashSet<Pair<AssumeEdge, List>>();
            ArrayDeque<Pair<CFANode, Object>> waitlist = new ArrayDeque<Pair<CFANode, Object>>();
            waitlist.offer(Pair.of(currentRelevantLocation, ImmutableList.of()));
            while (!waitlist.isEmpty()) {
                Pair currentPair = (Pair)waitlist.poll();
                CFANode currentNode = (CFANode)currentPair.getFirst();
                List currentPath = (List)currentPair.getSecond();
                for (CFAEdge enteringEdge : CFAUtils.enteringEdges(currentNode)) {
                    if (enteringEdge.getEdgeType() == CFAEdgeType.AssumeEdge) {
                        assumeEdgesAndPaths.add(Pair.of((AssumeEdge)enteringEdge, currentPath));
                        continue;
                    }
                    if (!pVisitedNodes.add(enteringEdge.getPredecessor())) continue;
                    ArrayList<CFAEdge> newPath = new ArrayList<CFAEdge>(currentPath);
                    newPath.add(enteringEdge);
                    waitlist.offer(Pair.of(enteringEdge.getPredecessor(), newPath));
                    this.addTransitivelyRelevantInvolvedVariables(pRelevantVariables, enteringEdge, pLimit);
                }
            }
            for (Pair assumeEdgeAndPath : assumeEdgesAndPaths) {
                AssumeEdge assumeEdge = (AssumeEdge)assumeEdgeAndPath.getFirst();
                CFANode predecessor = assumeEdge.getPredecessor();
                if (!pVisitedNodes.add(predecessor)) continue;
                this.addTransitivelyRelevantInvolvedVariables(pRelevantVariables, assumeEdge, pLimit);
                for (CFAEdge sisterEdge : CFAUtils.leavingEdges(predecessor)) {
                    CFANode brotherNode;
                    if (assumeEdge.equals(sisterEdge) || InvariantsCPA.mustReach(brotherNode = sisterEdge.getSuccessor(), currentRelevantLocation, assumeEdge) && !this.anyOnPath((List)assumeEdgeAndPath.getSecond(), pRelevantVariables)) continue;
                    this.addInvolvedVariables(pRelevantVariables, assumeEdge, pLimit);
                }
                relevantLocations.add(predecessor);
            }
        }
    }

    private boolean anyOnPath(List<CFAEdge> pPath, Set<MemoryLocation> pRelevantVariables) {
        for (CFAEdge edge : pPath) {
            if (Collections.disjoint(this.edgeAnalyzer.getInvolvedVariableTypes(edge).keySet(), pRelevantVariables)) continue;
            return true;
        }
        return false;
    }

    private static boolean mustReach(CFANode pStart, CFANode pTarget, CFAEdge pForbiddenEdge) {
        HashSet<CFANode> visited = new HashSet<CFANode>();
        visited.add(pStart);
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.offer(pStart);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.poll();
            if (current.equals(pTarget)) continue;
            FluentIterable<CFAEdge> leavingEdges = CFAUtils.leavingEdges(current);
            boolean continued = false;
            for (CFAEdge leavingEdge : leavingEdges) {
                CFANode successor;
                if (leavingEdge.equals(pForbiddenEdge) || !(continued |= visited.add(successor = leavingEdge.getSuccessor()))) continue;
                waitlist.offer(successor);
            }
            if (continued) continue;
            return false;
        }
        return true;
    }

    private void addTransitivelyRelevantInvolvedVariables(Set<MemoryLocation> pRelevantVariables, CFAEdge pEdge, int pLimit) {
        Set<MemoryLocation> involvedVariables = this.edgeAnalyzer.getInvolvedVariableTypes(pEdge).keySet();
        if (!Collections.disjoint(pRelevantVariables, involvedVariables)) {
            InvariantsCPA.addAll(pRelevantVariables, involvedVariables, pLimit);
        }
    }

    private void addInvolvedVariables(Set<MemoryLocation> pRelevantVariables, CFAEdge pEdge, int pLimit) {
        InvariantsCPA.addAll(pRelevantVariables, this.edgeAnalyzer.getInvolvedVariableTypes(pEdge).keySet(), pLimit);
    }

    private static <T> void addAll(Collection<T> pTarget, Collection<T> pSource, int pLimit) {
        Iterator<T> elementIterator = pSource.iterator();
        while (!InvariantsCPA.reachesLimit(pTarget, pLimit) && elementIterator.hasNext()) {
            pTarget.add(elementIterator.next());
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        this.writer.collectStatistics(pStatsCollection);
    }

    private static class AbstractionStrategyAdjuster
    implements ConditionAdjuster {
        private final InvariantsCPA cpa;

        public AbstractionStrategyAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        @Override
        public boolean adjustConditions() {
            if (this.cpa.options.abstractionStateFactory == AbstractionStrategyFactories.ALWAYS) {
                this.cpa.options.abstractionStateFactory = AbstractionStrategyFactories.ENTERING_EDGES;
            } else if (this.cpa.options.abstractionStateFactory == AbstractionStrategyFactories.ENTERING_EDGES) {
                this.cpa.options.abstractionStateFactory = AbstractionStrategyFactories.NEVER;
            } else {
                return false;
            }
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting abstraction strategy to", this.cpa.options.abstractionStateFactory});
            return true;
        }
    }

    private static class FormulaDepthAdjuster
    implements ValueIncreasingAdjuster {
        private final InvariantsCPA cpa;
        private int inc = 1;

        private FormulaDepthAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean adjustConditions() {
            if (this.cpa.options.maximumFormulaDepth >= 2) {
                return false;
            }
            this.cpa.initialPrecisionMap.clear();
            InvariantsCPA invariantsCPA = this.cpa;
            synchronized (invariantsCPA) {
                this.cpa.options.maximumFormulaDepth += this.inc;
            }
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting maximum formula depth to", this.cpa.options.maximumFormulaDepth});
            return true;
        }

        @Override
        public int getInc() {
            return this.inc;
        }

        @Override
        public void setInc(int pInc) {
            Preconditions.checkArgument((pInc > 0 ? 1 : 0) != 0);
            this.inc = pInc;
        }
    }

    private static class InterestingVariableLimitAdjuster
    implements ValueIncreasingAdjuster {
        private final InvariantsCPA cpa;
        private int inc = 1;
        private int amountAdjustments = 0;

        private InterestingVariableLimitAdjuster(InvariantsCPA pCPA) {
            this.cpa = pCPA;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean adjustConditions() {
            if (this.cpa.relevantVariableLimitReached || this.amountAdjustments >= this.cpa.options.maxInterestingVariableAdjustments && this.cpa.options.maxInterestingVariableAdjustments >= 0) {
                return false;
            }
            ++this.amountAdjustments;
            this.cpa.initialPrecisionMap.clear();
            InvariantsCPA invariantsCPA = this.cpa;
            synchronized (invariantsCPA) {
                this.cpa.options.interestingVariableLimit += this.inc;
            }
            this.cpa.logManager.log(Level.INFO, new Object[]{"Adjusting interestingVariableLimit to", this.cpa.options.interestingVariableLimit});
            return true;
        }

        @Override
        public int getInc() {
            return this.inc;
        }

        @Override
        public void setInc(int pInc) {
            Preconditions.checkArgument((pInc > 0 ? 1 : 0) != 0);
            this.inc = pInc;
        }
    }

    private static class CompoundConditionAdjuster
    implements ConditionAdjuster {
        private final InvariantsCPA cpa;
        private Timer timer = new Timer();
        private TimeSpan previousTimeSpan = null;
        private Deque<ValueIncreasingAdjuster> innerAdjusters = new ArrayDeque<ValueIncreasingAdjuster>();
        private ConditionAdjuster defaultInner;

        public CompoundConditionAdjuster(InvariantsCPA pCPA) {
            this.cpa = Objects.requireNonNull(pCPA);
            this.innerAdjusters.add(new InterestingVariableLimitAdjuster(pCPA));
            this.innerAdjusters.add(new FormulaDepthAdjuster(pCPA));
            this.defaultInner = new AbstractionStrategyAdjuster(pCPA);
        }

        @Override
        public boolean adjustConditions() {
            if (!this.hasInner()) {
                return this.defaultInner.adjustConditions();
            }
            ValueIncreasingAdjuster inner = this.getCurrentInner();
            boolean onlyIntVars = false;
            boolean pointersRelevant = true;
            if (inner instanceof InterestingVariableLimitAdjuster && this.cpa.cfa.getVarClassification().isPresent()) {
                VariableClassification classification = this.cpa.cfa.getVarClassification().orElseThrow();
                if (classification.getAddressedVariables().isEmpty() && classification.getAddressedFields().isEmpty()) {
                    pointersRelevant = false;
                }
                Sets.SetView intVars = Sets.union(classification.getIntAddVars(), classification.getIntBoolVars());
                intVars = Sets.union((Set)intVars, classification.getIntEqualVars());
                onlyIntVars = intVars.containsAll(classification.getRelevantVariables());
            }
            if (this.previousTimeSpan == null && !pointersRelevant && onlyIntVars) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                    this.previousTimeSpan = this.timer.getLengthOfLastInterval();
                }
                inner.setInc(6);
            } else if (this.previousTimeSpan != null) {
                this.timer.stop();
                TimeSpan sinceLastAdjustment = this.timer.getLengthOfLastInterval();
                int comp = sinceLastAdjustment.compareTo(this.previousTimeSpan);
                int inc = inner.getInc();
                if (comp < 0) {
                    inc *= 2;
                } else if (comp > 0 && inc > 1) {
                    inc /= 2;
                    this.swapInner();
                }
                inner.setInc(inc);
                this.previousTimeSpan = sinceLastAdjustment;
            } else if (this.timer.isRunning()) {
                this.timer.stop();
                this.previousTimeSpan = this.timer.getLengthOfLastInterval();
            }
            this.timer.start();
            if (inner.adjustConditions()) {
                return true;
            }
            this.innerAdjusters.remove(inner);
            return this.adjustConditions();
        }

        @Override
        public void adjustReachedSet(ReachedSet pReachedSet) {
            if (this.hasInner()) {
                this.getCurrentInner().adjustReachedSet(pReachedSet);
            } else {
                this.defaultInner.adjustReachedSet(pReachedSet);
            }
        }

        private boolean hasInner() {
            return !this.innerAdjusters.isEmpty();
        }

        private ValueIncreasingAdjuster getCurrentInner() {
            Preconditions.checkArgument((boolean)this.hasInner());
            return this.innerAdjusters.getFirst();
        }

        private void swapInner() {
            if (this.hasInner()) {
                this.innerAdjusters.addLast(this.innerAdjusters.removeFirst());
            }
        }
    }

    public static enum ConditionAdjusterFactories implements ConditionAdjusterFactory
    {
        STATIC{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new ConditionAdjuster(){

                    @Override
                    public boolean adjustConditions() {
                        return false;
                    }

                    @Override
                    public void adjustReachedSet(ReachedSet pReachedSet) {
                    }
                };
            }
        }
        ,
        INTERESTING_VARIABLES{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new InterestingVariableLimitAdjuster(pCPA);
            }
        }
        ,
        MAXIMUM_FORMULA_DEPTH{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new FormulaDepthAdjuster(pCPA);
            }
        }
        ,
        ABSTRACTION_STRATEGY{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new AbstractionStrategyAdjuster(pCPA);
            }
        }
        ,
        COMPOUND{

            @Override
            public ConditionAdjuster createConditionAdjuster(InvariantsCPA pCPA) {
                return new CompoundConditionAdjuster(pCPA);
            }
        };

    }

    public static interface ConditionAdjusterFactory {
        public ConditionAdjuster createConditionAdjuster(InvariantsCPA var1);
    }

    private static interface ValueIncreasingAdjuster
    extends ConditionAdjuster {
        public int getInc();

        public void setInc(int var1);
    }

    public static interface ConditionAdjuster {
        public boolean adjustConditions();

        default public void adjustReachedSet(ReachedSet pReachedSet) {
            pReachedSet.clear();
        }
    }

    @Options(prefix="cpa.invariants")
    public static class InvariantsOptions {
        @Option(secure=true, values={"JOIN", "SEP", "PRECISIONDEPENDENT"}, toUppercase=true, description="which merge operator to use for InvariantCPA")
        private String merge = "PRECISIONDEPENDENT";
        @Option(secure=true, description="determine target locations in advance and analyse paths to the target locations only.")
        private boolean analyzeTargetPathsOnly = true;
        @Option(secure=true, description="determine variables relevant to the decision whether or not a target path assume edge is taken and limit the analyis to those variables.")
        private boolean analyzeRelevantVariablesOnly = true;
        @Option(secure=true, description="the maximum number of variables to consider as interesting. -1 one disables the limit, but this is not recommended. 0 means that no variables are considered to be interesting.")
        @IntegerOption(min=-1L)
        private volatile int interestingVariableLimit = 2;
        @Option(secure=true, description="the maximum number of adjustments of the interestingVariableLimit. -1 one disables the limit")
        @IntegerOption(min=-1L)
        private volatile int maxInterestingVariableAdjustments = -1;
        @Option(secure=true, description="the maximum tree depth of a formula recorded in the environment.")
        private volatile int maximumFormulaDepth = 4;
        @Option(secure=true, description="controls whether to use abstract evaluation always, never, or depending on entering edges.")
        private AbstractionStrategyFactories abstractionStateFactory = AbstractionStrategyFactories.ENTERING_EDGES;
        @Option(secure=true, description="controls the condition adjustment logic: STATIC means that condition adjustment is a no-op, INTERESTING_VARIABLES increases the interesting variable limit, MAXIMUM_FORMULA_DEPTH increases the maximum formula depth, ABSTRACTION_STRATEGY tries to choose a more precise abstraction strategy, COMPOUND combines the other strategies (minus STATIC).")
        private ConditionAdjusterFactories conditionAdjusterFactory = ConditionAdjusterFactories.COMPOUND;
        @Option(secure=true, description="include type information for variables, such as x >= MIN_INT && x <= MAX_INT")
        private boolean includeTypeInformation = true;
        @Option(secure=true, description="enables the over-approximation of unsupported features instead of failing fast; this is imprecise")
        private boolean allowOverapproximationOfUnsupportedFeatures = true;
        @Option(secure=true, description="use pointer-alias information in strengthening, if available.")
        private boolean usePointerAliasStrengthening = true;
        @Option(secure=true, description="use modulo-2 template during widening if applicable.")
        public boolean useMod2Template = false;
    }
}

