/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class InvariantsMergeOperator
implements MergeOperator {
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();

    InvariantsMergeOperator() {
    }

    @Override
    public AbstractState merge(AbstractState pState1, AbstractState pState2, Precision pPrecision) throws CPAException, InterruptedException {
        AbstractionState abstractionState2;
        InvariantsState state1 = (InvariantsState)pState1;
        InvariantsState state2 = (InvariantsState)pState2;
        InvariantsPrecision precision = (InvariantsPrecision)pPrecision;
        boolean isMergeAllowed = InvariantsMergeOperator.isMergeAllowed(state1, state2, precision);
        AbstractionState abstractionState1 = state1.determineAbstractionState(precision);
        Set<MemoryLocation> wideningTargets = abstractionState1.determineWideningTargets(abstractionState2 = state2.determineAbstractionState(precision));
        wideningTargets = wideningTargets == null ? state1.getEnvironment().keySet() : wideningTargets;
        Sets.SetView wideningHints = Sets.union(abstractionState1.getWideningHints(), abstractionState2.getWideningHints());
        state1 = state1.widen(state2, precision, wideningTargets, (Set<BooleanFormula<CompoundInterval>>)wideningHints);
        isMergeAllowed = isMergeAllowed || state1 != pState1 && InvariantsMergeOperator.definitelyImplies(state2, InvariantsMergeOperator.reduceToGivenVariables(InvariantsMergeOperator.reduceToInterestingVariables(state1, precision), (Iterable<? extends MemoryLocation>)Sets.difference(state1.getEnvironment().keySet(), wideningTargets)));
        InvariantsState result = state2;
        if (isMergeAllowed) {
            result = state1.join(state2, precision);
        }
        return result;
    }

    private static boolean isMergeAllowed(InvariantsState pState1, InvariantsState pState2, InvariantsPrecision pPrecision) {
        return InvariantsMergeOperator.environmentsEqualWithRespectToInterestingVariables(pState1, pState2, pPrecision) || InvariantsMergeOperator.definitelyImplies(pState2, InvariantsMergeOperator.reduceToInterestingVariables(pState1, pPrecision));
    }

    private static boolean definitelyImplies(InvariantsState pState1, InvariantsState pState2) {
        for (BooleanFormula assumption : pState2.getEnvironmentAsAssumptions()) {
            if (pState1.definitelyImplies(assumption)) continue;
            return false;
        }
        return true;
    }

    private static InvariantsState reduceToInterestingVariables(InvariantsState pState, InvariantsPrecision pPrecision) {
        return InvariantsMergeOperator.reduceToGivenVariables(pState, pPrecision.getInterestingVariables());
    }

    private static InvariantsState reduceToGivenVariables(InvariantsState pState, Iterable<? extends MemoryLocation> pVariables) {
        return pState.clearAll((Predicate<MemoryLocation>)((Predicate)pMemoryLocation -> !Iterables.contains((Iterable)pVariables, (Object)pMemoryLocation)));
    }

    private static boolean environmentsEqualWithRespectToInterestingVariables(InvariantsState pState1, InvariantsState pState2, InvariantsPrecision pPrecision) {
        HashSet<MemoryLocation> checkedVariables = new HashSet<MemoryLocation>();
        ArrayDeque<MemoryLocation> waitlist = new ArrayDeque<MemoryLocation>(pPrecision.getInterestingVariables());
        Map<MemoryLocation, NumeralFormula<CompoundInterval>> environment1 = pState1.getEnvironment();
        Map<MemoryLocation, NumeralFormula<CompoundInterval>> environment2 = pState2.getEnvironment();
        while (!waitlist.isEmpty()) {
            NumeralFormula<CompoundInterval> right;
            MemoryLocation memoryLocation = (MemoryLocation)waitlist.poll();
            if (!checkedVariables.add(memoryLocation)) continue;
            NumeralFormula<CompoundInterval> left = environment1.get(memoryLocation);
            if (!(left == (right = environment2.get(memoryLocation)) || left != null && left.equals(right))) {
                return false;
            }
            if (left == null) continue;
            waitlist.addAll((Collection)left.accept(COLLECT_VARS_VISITOR));
        }
        return true;
    }
}

