/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStrategy;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class InvariantsPrecision
implements Precision {
    private final ImmutableSet<CFAEdge> relevantEdges;
    private final ImmutableSet<MemoryLocation> interestingVariables;
    private final int maximumFormulaDepth;
    private final AbstractionStrategy abstractionStrategy;
    private final boolean useMod2Template;

    public static InvariantsPrecision getEmptyPrecision(AbstractionStrategy pAbstractionStrategy) {
        return new InvariantsPrecision(ImmutableSet.of(), ImmutableSet.of(), 0, pAbstractionStrategy, false){

            @Override
            public boolean isRelevant(CFAEdge pEdge) {
                return true;
            }

            @Override
            public String toString() {
                return "no precision";
            }
        };
    }

    public InvariantsPrecision(Set<CFAEdge> pRelevantEdges, Set<MemoryLocation> pInterestingVariables, int pMaximumFormulaDepth, AbstractionStrategy pAbstractionStrategy, boolean pUseMod2Template) {
        this((ImmutableSet<CFAEdge>)(pRelevantEdges == null ? null : ImmutableSet.copyOf(pRelevantEdges)), (ImmutableSet<MemoryLocation>)ImmutableSet.copyOf(pInterestingVariables), pMaximumFormulaDepth, pAbstractionStrategy, pUseMod2Template);
    }

    public InvariantsPrecision(ImmutableSet<CFAEdge> pRelevantEdges, ImmutableSet<MemoryLocation> pInterestingVariables, int pMaximumFormulaDepth, AbstractionStrategy pAbstractionStrategy, boolean pUseMod2Template) {
        this.relevantEdges = pRelevantEdges;
        this.interestingVariables = pInterestingVariables;
        this.maximumFormulaDepth = pMaximumFormulaDepth;
        this.abstractionStrategy = pAbstractionStrategy;
        this.useMod2Template = pUseMod2Template;
    }

    public boolean isRelevant(CFAEdge pEdge) {
        return pEdge != null && (this.relevantEdges == null || this.relevantEdges.contains((Object)pEdge));
    }

    public Set<MemoryLocation> getInterestingVariables() {
        return this.interestingVariables;
    }

    public String toString() {
        return String.format("Number of relevant edges: %d; Interesting variables: %s;", this.relevantEdges.size(), this.interestingVariables);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof InvariantsPrecision) {
            InvariantsPrecision other = (InvariantsPrecision)pOther;
            return this.relevantEdges.equals(other.relevantEdges) && this.interestingVariables.equals(other.interestingVariables) && this.maximumFormulaDepth == other.maximumFormulaDepth;
        }
        return false;
    }

    public int hashCode() {
        return this.interestingVariables.hashCode();
    }

    public int getMaximumFormulaDepth() {
        return this.maximumFormulaDepth;
    }

    public AbstractionStrategy getAbstractionStrategy() {
        return this.abstractionStrategy;
    }

    public boolean shouldUseMod2Template() {
        return this.useMod2Template;
    }
}

