/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.ibm.icu.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.LatticeAbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.core.interfaces.FormulaReportingState;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionState;
import org.sosy_lab.cpachecker.cpa.invariants.AbstractionStrategyFactories;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsCPA;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectFormulasVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsVarVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaAbstractionVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaDepthCountVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IsLinearVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Mod2AbstractionVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushAssumptionToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ReplaceVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitConjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.StateEqualsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToBitvectorFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ToCodeFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.cpa.invariants.variableselection.VariableSelection;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class InvariantsState
implements AbstractState,
ExpressionTreeReportingState,
FormulaReportingState,
LatticeAbstractState<InvariantsState>,
AbstractQueryableState {
    private static final String PROPERTY_OVERFLOW = "overflow";
    private static final FormulaDepthCountVisitor<CompoundInterval> FORMULA_DEPTH_COUNT_VISITOR = new FormulaDepthCountVisitor();
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private static final SplitConjunctionsVisitor<CompoundInterval> SPLIT_CONJUNCTIONS_VISITOR = new SplitConjunctionsVisitor();
    private final Tools tools;
    private final NonRecursiveEnvironment environment;
    private final VariableSelection<CompoundInterval> variableSelection;
    private final PersistentSortedMap<MemoryLocation, CType> variableTypes;
    private final PartialEvaluator partialEvaluator;
    private final MachineModel machineModel;
    private final AbstractionState abstractionState;
    private final boolean overflowDetected;
    private final boolean includeTypeInformation;
    private final boolean overapproximatesUnsupportedFeature;
    private final ImmutableSet<BooleanFormula<CompoundInterval>> assumptions;
    private ImmutableSet<BooleanFormula<CompoundInterval>> environmentAsAssumptions;
    private volatile int hash = 0;

    private static boolean isUnsupportedVariableName(MemoryLocation pMemoryLocation) {
        return pMemoryLocation == null || pMemoryLocation.getIdentifier().contains("[");
    }

    public InvariantsState(VariableSelection<CompoundInterval> pVariableSelection, CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, AbstractionState pAbstractionState, boolean pIncludeTypeInformation) {
        this.environment = NonRecursiveEnvironment.of(pCompoundIntervalManagerFactory);
        this.partialEvaluator = new PartialEvaluator(pCompoundIntervalManagerFactory, this.environment);
        this.variableSelection = pVariableSelection;
        this.variableTypes = PathCopyingPersistentTreeMap.of();
        this.tools = new Tools(pCompoundIntervalManagerFactory);
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
        this.overflowDetected = false;
        this.includeTypeInformation = pIncludeTypeInformation;
        this.overapproximatesUnsupportedFeature = false;
        this.assumptions = ImmutableSet.of();
    }

    private InvariantsState(VariableSelection<CompoundInterval> pVariableSelection, Tools pTools, MachineModel pMachineModel, PersistentSortedMap<MemoryLocation, CType> pVariableTypes, AbstractionState pAbstractionState, NonRecursiveEnvironment pEnvironment, Set<BooleanFormula<CompoundInterval>> pAssumptions, boolean pOverflowDetected, boolean pIncludeTypeInformation, boolean pOverapproximatesUnsupportedFeature) {
        this.environment = pEnvironment;
        this.tools = pTools;
        this.partialEvaluator = new PartialEvaluator(pTools.compoundIntervalManagerFactory, this.environment);
        this.variableSelection = pVariableSelection;
        this.variableTypes = pVariableTypes;
        this.machineModel = pMachineModel;
        this.abstractionState = pAbstractionState;
        this.overflowDetected = pOverflowDetected;
        this.includeTypeInformation = pIncludeTypeInformation;
        this.overapproximatesUnsupportedFeature = pOverapproximatesUnsupportedFeature;
        this.assumptions = ImmutableSet.copyOf(pAssumptions);
    }

    private AbstractionState determineAbstractionState(AbstractionState pMasterState) {
        AbstractionState state = pMasterState;
        if (state.getClass() == this.abstractionState.getClass()) {
            state = this.abstractionState.join(state);
        }
        return state;
    }

    public AbstractionState determineAbstractionState(InvariantsPrecision pPrecision) {
        return this.determineAbstractionState(pPrecision.getAbstractionStrategy().from(this.abstractionState));
    }

    public InvariantsState updateAbstractionState(InvariantsPrecision pPrecision, CFAEdge pEdge) {
        AbstractionState state = pPrecision.getAbstractionStrategy().getSuccessorState(this.abstractionState);
        if ((state = state.addEnteringEdge(pEdge)).equals(this.abstractionState)) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, state, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    public Type getType(MemoryLocation pMemoryLocation) {
        return (Type)this.variableTypes.get((Object)pMemoryLocation);
    }

    public InvariantsState setType(MemoryLocation pMemoryLocation, CType pType) {
        if (pType.equals(this.variableTypes.get((Object)pMemoryLocation))) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, (PersistentSortedMap<MemoryLocation, CType>)this.variableTypes.putAndCopy((Object)pMemoryLocation, (Object)pType), this.abstractionState, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    public InvariantsState setTypes(Map<MemoryLocation, CType> pVarTypes) {
        boolean allContained = true;
        for (Map.Entry<MemoryLocation, CType> entry : pVarTypes.entrySet()) {
            if (entry.getValue().equals(this.variableTypes.get((Object)entry.getKey()))) continue;
            allContained = false;
            break;
        }
        if (allContained) {
            return this;
        }
        PersistentSortedMap newVariableTypes = this.variableTypes;
        for (Map.Entry<MemoryLocation, CType> entry : pVarTypes.entrySet()) {
            MemoryLocation memoryLocation = entry.getKey();
            if (entry.getValue().equals(newVariableTypes.get((Object)memoryLocation))) continue;
            newVariableTypes = newVariableTypes.putAndCopy((Object)memoryLocation, (Object)entry.getValue());
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, (PersistentSortedMap<MemoryLocation, CType>)newVariableTypes, this.abstractionState, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    public InvariantsState assignArray(MemoryLocation pArray, NumeralFormula<CompoundInterval> pSubscript, NumeralFormula<CompoundInterval> pValue) {
        FormulaEvaluationVisitor<CompoundInterval> fev = this.getFormulaResolver();
        CompoundInterval value = (CompoundInterval)pSubscript.accept(fev, this.environment);
        if (value.isSingleton()) {
            return this.assignInternal(MemoryLocation.parseExtendedQualifiedName(pArray.getExtendedQualifiedName() + "[" + value.getValue() + "]"), pValue);
        }
        InvariantsState result = this.overapproximateUnsupportedFeature();
        for (MemoryLocation memoryLocation : this.environment.keySet()) {
            String subscriptValueStr;
            String prefix = pArray.getExtendedQualifiedName() + "[";
            if (!memoryLocation.getExtendedQualifiedName().startsWith(prefix) || !(subscriptValueStr = memoryLocation.getExtendedQualifiedName().replace(prefix, "").replaceAll("].*", "")).equals("*") && !value.contains(new BigInteger(subscriptValueStr))) continue;
            result = result.assignInternal(memoryLocation, this.allPossibleValuesFormula(pValue.getTypeInfo()));
        }
        return result;
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pTypeInfo) {
        return this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo);
    }

    private CompoundInterval allPossibleValues(TypeInfo pTypeInfo) {
        return this.getCompoundIntervalManager(pTypeInfo).allPossibleValues();
    }

    private NumeralFormula<CompoundInterval> allPossibleValuesFormula(TypeInfo pInfo) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pInfo, this.allPossibleValues(pInfo));
    }

    public InvariantsState assign(MemoryLocation pMemoryLocation, NumeralFormula<CompoundInterval> pValue) {
        InvariantsState result = this;
        Type variableType = (Type)this.variableTypes.get((Object)pMemoryLocation);
        if (variableType == null) {
            return this;
        }
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, variableType);
        NumeralFormula<CompoundInterval> value = this.tools.compoundIntervalFormulaManager.cast(typeInfo, pValue);
        for (MemoryLocation memoryLocation : this.environment.keySet()) {
            TypeInfo varTypeInfo = BitVectorInfo.from(this.machineModel, this.getType(memoryLocation));
            if (!memoryLocation.getExtendedQualifiedName().startsWith(pMemoryLocation.getExtendedQualifiedName() + "->") && !memoryLocation.getExtendedQualifiedName().startsWith(pMemoryLocation.getExtendedQualifiedName() + ".")) continue;
            result = result.assign(memoryLocation, this.allPossibleValuesFormula(varTypeInfo));
        }
        if (value instanceof Variable) {
            MemoryLocation valueMemoryLocation = ((Variable)value).getMemoryLocation();
            if (valueMemoryLocation.getExtendedQualifiedName().startsWith(pMemoryLocation.getExtendedQualifiedName() + "->") || valueMemoryLocation.getExtendedQualifiedName().startsWith(pMemoryLocation.getExtendedQualifiedName() + ".")) {
                return this.assign(pMemoryLocation, this.allPossibleValuesFormula(typeInfo));
            }
            String pointerDerefPrefix = valueMemoryLocation.getExtendedQualifiedName() + "->";
            String nonPointerDerefPrefix = valueMemoryLocation.getExtendedQualifiedName() + ".";
            for (Map.Entry entry : this.environment.entrySet()) {
                MemoryLocation memoryLocation;
                Object previous;
                String suffix = ((MemoryLocation)entry.getKey()).getExtendedQualifiedName().startsWith(pointerDerefPrefix) ? ((MemoryLocation)entry.getKey()).getExtendedQualifiedName().substring(pointerDerefPrefix.length()) : (((MemoryLocation)entry.getKey()).getExtendedQualifiedName().startsWith(nonPointerDerefPrefix) ? ((MemoryLocation)entry.getKey()).getExtendedQualifiedName().substring(nonPointerDerefPrefix.length()) : null);
                if (suffix == null || (previous = this.environment.get(memoryLocation = MemoryLocation.parseExtendedQualifiedName(pMemoryLocation.getExtendedQualifiedName() + "->" + suffix))) == null) continue;
                result = result.assign(memoryLocation, InvariantsFormulaManager.INSTANCE.asVariable(previous.getTypeInfo(), (MemoryLocation)entry.getKey()));
            }
            return result.assignInternal(pMemoryLocation, value);
        }
        return result.assignInternal(pMemoryLocation, value);
    }

    private InvariantsState assignInternal(MemoryLocation pMemoryLocation, NumeralFormula<CompoundInterval> pValue) {
        Preconditions.checkNotNull(pValue);
        if (InvariantsState.isUnsupportedVariableName(pMemoryLocation)) {
            return this.overapproximateUnsupportedFeature();
        }
        if (FluentIterable.from((Iterable)((Iterable)pValue.accept(COLLECT_VARS_VISITOR))).anyMatch(InvariantsState::isUnsupportedVariableName)) {
            NumeralFormula<CompoundInterval> newEnvValue = InvariantsFormulaManager.INSTANCE.asConstant(pValue.getTypeInfo(), (CompoundInterval)pValue.accept(this.getFormulaResolver(), this.environment));
            InvariantsState result = this.assignInternal(pMemoryLocation, newEnvValue);
            if (result != null) {
                return result.overapproximateUnsupportedFeature();
            }
            return result;
        }
        VariableSelection<CompoundInterval> newVariableSelection = this.variableSelection.acceptAssignment(pMemoryLocation, pValue);
        if (newVariableSelection == null) {
            NonRecursiveEnvironment newEnvironment = this.environment;
            if (this.environment.containsKey(pMemoryLocation)) {
                newEnvironment = newEnvironment.removeAndCopy(pMemoryLocation);
            }
            if (this.environment == newEnvironment) {
                return this;
            }
            return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, newEnvironment, (Set<BooleanFormula<CompoundInterval>>)ImmutableSet.of(), this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
        }
        TypeInfo typeInfo = pValue.getTypeInfo();
        Variable variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, pMemoryLocation);
        if (this.getEnvironmentValue(typeInfo, pMemoryLocation).equals(pValue) && (pValue instanceof Variable || pValue instanceof Constant && ((CompoundInterval)((Constant)pValue).getValue()).isSingleton()) || variable.accept(new StateEqualsVisitor(this.getFormulaResolver(), this.environment, this.tools.compoundIntervalManagerFactory), pValue).booleanValue()) {
            return this;
        }
        InvariantsState result = this.assignInternal(pMemoryLocation, pValue, newVariableSelection, this.tools.evaluationVisitor);
        if (this.equals(result)) {
            return this;
        }
        return result;
    }

    private InvariantsState overapproximateUnsupportedFeature() {
        if (this.overapproximatesUnsupportedFeature) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions, this.overflowDetected, this.includeTypeInformation, true);
    }

    private InvariantsState assignInternal(MemoryLocation pMemoryLocation, NumeralFormula<CompoundInterval> pValue, VariableSelection<CompoundInterval> newVariableSelection, FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor) {
        NonRecursiveEnvironment resultEnvironment = this.environment;
        ContainsVarVisitor containsVarVisitor = new ContainsVarVisitor();
        TypeInfo typeInfo = pValue.getTypeInfo();
        Variable<CompoundInterval> variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, pMemoryLocation);
        NumeralFormula<CompoundInterval> previousValue = this.getEnvironmentValue(typeInfo, pMemoryLocation);
        ReplaceVisitor<CompoundInterval> replaceVisitor = new ReplaceVisitor<CompoundInterval>(variable, previousValue);
        resultEnvironment = resultEnvironment.putAndCopy(pMemoryLocation, ((NumeralFormula)pValue.accept(replaceVisitor)).accept(this.partialEvaluator, evaluationVisitor));
        if (((Boolean)pValue.accept(new IsLinearVisitor(), variable)).booleanValue() && ((Boolean)pValue.accept(containsVarVisitor, pMemoryLocation)).booleanValue()) {
            CompoundInterval zero = this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo).singleton(0L);
            previousValue = (NumeralFormula<CompoundInterval>)pValue.accept(new ReplaceVisitor<Object>(variable, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, zero)));
            previousValue = this.tools.compoundIntervalFormulaManager.subtract(variable, previousValue);
        }
        replaceVisitor = new ReplaceVisitor<CompoundInterval>(variable, previousValue);
        for (Map.Entry environmentEntry : this.environment.entrySet()) {
            NumeralFormula prevEnvValue;
            if (((MemoryLocation)environmentEntry.getKey()).equals(pMemoryLocation) || !((Boolean)(prevEnvValue = (NumeralFormula)environmentEntry.getValue()).accept(containsVarVisitor, pMemoryLocation)).booleanValue()) continue;
            NumeralFormula<CompoundInterval> newEnvValue = ((NumeralFormula)prevEnvValue.accept(replaceVisitor)).accept(this.partialEvaluator, evaluationVisitor);
            resultEnvironment = resultEnvironment.putAndCopy((MemoryLocation)environmentEntry.getKey(), newEnvValue);
        }
        InvariantsState result = new InvariantsState(newVariableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, resultEnvironment, (Set<BooleanFormula<CompoundInterval>>)ImmutableSet.of(), this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
        if (!this.assumptions.isEmpty()) {
            HashSet<BooleanFormula<CompoundInterval>> additionalAssumptions = new HashSet<BooleanFormula<CompoundInterval>>();
            for (BooleanFormula assumption : this.assumptions) {
                BooleanFormula<CompoundInterval> evenTemplate = this.instantiateModTemplate(variable, 2, 0);
                BooleanFormula<CompoundInterval> oddTemplate = this.instantiateModTemplate(variable, 2, 1);
                BooleanFormula<CompoundInterval> complement = null;
                if (assumption.equals(evenTemplate)) {
                    complement = oddTemplate;
                } else if (assumption.equals(oddTemplate)) {
                    complement = evenTemplate;
                } else {
                    additionalAssumptions.add((BooleanFormula)assumption.accept(replaceVisitor));
                    if (pValue instanceof Variable) {
                        additionalAssumptions.add((BooleanFormula)assumption.accept(new ReplaceVisitor<CompoundInterval>(pValue, variable)));
                        Mod2AbstractionVisitor.Type t = pValue.accept(new Mod2AbstractionVisitor(this.tools.compoundIntervalManagerFactory, evaluationVisitor, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions));
                        if (t == Mod2AbstractionVisitor.Type.EVEN) {
                            additionalAssumptions.add(this.instantiateModTemplate(variable, 2, 0));
                        } else if (t == Mod2AbstractionVisitor.Type.ODD) {
                            additionalAssumptions.add(this.instantiateModTemplate(variable, 2, 1));
                        }
                    }
                }
                if (complement == null) continue;
                if (this.preservesOrSwitchesMod2(variable, pValue, true)) {
                    additionalAssumptions.add(assumption);
                    result = result.assume(assumption);
                    continue;
                }
                if (this.preservesOrSwitchesMod2(variable, pValue, false)) {
                    additionalAssumptions.add(complement);
                    result = result.assume(complement);
                    continue;
                }
                if (pValue instanceof Variable) {
                    Variable assignedVariable = (Variable)pValue;
                    if (this.definitelyImplies((BooleanFormula)assumption.accept(new ReplaceVisitor<CompoundInterval>(variable, assignedVariable)))) {
                        additionalAssumptions.add(assumption);
                        continue;
                    }
                    additionalAssumptions.add((BooleanFormula)assumption.accept(replaceVisitor));
                    continue;
                }
                additionalAssumptions.add((BooleanFormula)assumption.accept(replaceVisitor));
            }
            result = result.addAssumptions(additionalAssumptions);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean preservesOrSwitchesMod2(Variable<CompoundInterval> pVariable, NumeralFormula<CompoundInterval> pValue, boolean pPreserves) {
        Constant constant;
        TypeInfo typeInfo = pValue.getTypeInfo();
        CompoundIntervalManager cim = this.getCompoundIntervalManager(typeInfo);
        if (pValue instanceof Add) {
            Add addition = (Add)pValue;
            if (addition.getOperand1().equals(pVariable) && addition.getOperand2() instanceof Constant) {
                constant = (Constant)addition.getOperand2();
            } else {
                if (!addition.getOperand2().equals(pVariable) || !(addition.getOperand1() instanceof Constant)) return false;
                constant = (Constant)addition.getOperand1();
            }
        } else {
            if (!(pValue instanceof Multiply)) return false;
            Multiply multiplication = (Multiply)pValue;
            if (multiplication.getOperand1().equals(pVariable) && multiplication.getOperand2() instanceof Constant) {
                constant = (Constant)multiplication.getOperand2();
            } else {
                if (!multiplication.getOperand2().equals(pVariable) || !(multiplication.getOperand1() instanceof Constant)) return false;
                constant = (Constant)multiplication.getOperand1();
            }
        }
        int remainder = pPreserves ? 0 : 1;
        return cim.modulo((CompoundInterval)constant.getValue(), cim.singleton(2L)).equals(cim.singleton(remainder));
    }

    private InvariantsState addAssumptions(Set<BooleanFormula<CompoundInterval>> pAdditionalAssumptions) {
        if (this.assumptions.containsAll(pAdditionalAssumptions)) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, this.environment, (Set<BooleanFormula<CompoundInterval>>)Sets.union(this.assumptions, pAdditionalAssumptions), this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    public InvariantsState clear() {
        if (this.environment.isEmpty()) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, NonRecursiveEnvironment.of(this.tools.compoundIntervalManagerFactory), (Set<BooleanFormula<CompoundInterval>>)ImmutableSet.of(), this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    public InvariantsState clear(MemoryLocation pMemoryLocation) {
        TypeInfo typeInfo;
        Object previous = this.environment.get(pMemoryLocation);
        if (previous == null) {
            Type type = (Type)this.variableTypes.get((Object)pMemoryLocation);
            if (type == null) {
                return this;
            }
            typeInfo = BitVectorInfo.from(this.machineModel, type);
        } else {
            typeInfo = previous.getTypeInfo();
        }
        NumeralFormula<CompoundInterval> allPossibleValues = this.allPossibleValuesFormula(typeInfo);
        InvariantsState result = this.assignInternal(pMemoryLocation, allPossibleValues, this.variableSelection, this.tools.evaluationVisitor);
        NonRecursiveEnvironment resultEnvironment = result.environment.removeAndCopy(pMemoryLocation);
        result = new InvariantsState(result.variableSelection, result.tools, result.machineModel, result.variableTypes, result.abstractionState, resultEnvironment, (Set<BooleanFormula<CompoundInterval>>)result.assumptions, this.overflowDetected, this.includeTypeInformation, result.overapproximatesUnsupportedFeature);
        if (this.equals(result)) {
            return this;
        }
        return result;
    }

    public InvariantsState clearAll(Predicate<MemoryLocation> pMemoryLocationPredicate) {
        Set<Variable<CompoundInterval>> toClear = this.getVariables(pMemoryLocationPredicate);
        ContainsVisitor containsVisitor = new ContainsVisitor();
        ContainsVarVisitor containsVarVisitor = new ContainsVarVisitor();
        Predicate toClearPredicate = toClear::contains;
        ArrayDeque<MemoryLocation> potentialReferrers = new ArrayDeque<MemoryLocation>();
        for (Map.Entry entry : this.environment.entrySet()) {
            if (!((Boolean)((NumeralFormula)entry.getValue()).accept(containsVisitor, toClearPredicate)).booleanValue()) continue;
            potentialReferrers.add((MemoryLocation)entry.getKey());
        }
        NonRecursiveEnvironment resultEnvironment = this.environment;
        HashSet<BooleanFormula<CompoundInterval>> resultAssumptions = new HashSet<BooleanFormula<CompoundInterval>>();
        CollectFormulasVisitor variableCollectionVisitor = new CollectFormulasVisitor(Predicates.instanceOf(Variable.class));
        for (BooleanFormula assumption : this.assumptions) {
            if (!Collections.disjoint((Collection)assumption.accept(variableCollectionVisitor), toClear)) continue;
            resultAssumptions.add(assumption);
        }
        Iterator<Variable<CompoundInterval>> toClearIterator = toClear.iterator();
        while (toClearIterator.hasNext()) {
            TypeInfo typeInfo;
            Variable<CompoundInterval> variable = toClearIterator.next();
            MemoryLocation memoryLocation = variable.getMemoryLocation();
            Object previous = resultEnvironment.get(memoryLocation);
            if (previous == null) {
                Type type = (Type)this.variableTypes.get((Object)memoryLocation);
                if (type == null) continue;
                typeInfo = BitVectorInfo.from(this.machineModel, type);
            } else {
                typeInfo = previous.getTypeInfo();
            }
            NumeralFormula<CompoundInterval> allPossibleValues = this.allPossibleValuesFormula(typeInfo);
            ReplaceVisitor<CompoundInterval> replaceVisitor = new ReplaceVisitor<CompoundInterval>((NumeralFormula<CompoundInterval>)variable, (NumeralFormula<CompoundInterval>)(previous == null ? allPossibleValues : previous));
            Iterator potentialReferrerIterator = potentialReferrers.iterator();
            while (potentialReferrerIterator.hasNext()) {
                MemoryLocation key = (MemoryLocation)potentialReferrerIterator.next();
                if (key.equals(memoryLocation)) {
                    potentialReferrerIterator.remove();
                    continue;
                }
                Object previousValue = resultEnvironment.get(key);
                if (!((Boolean)previousValue.accept(containsVarVisitor, memoryLocation)).booleanValue()) continue;
                NumeralFormula<CompoundInterval> newEnvValue = ((NumeralFormula)previousValue.accept(replaceVisitor)).accept(this.partialEvaluator, this.tools.evaluationVisitor);
                resultEnvironment = resultEnvironment.putAndCopy(key, newEnvValue);
                if (((Boolean)newEnvValue.accept(containsVisitor, toClearPredicate)).booleanValue()) continue;
                potentialReferrerIterator.remove();
            }
            resultEnvironment = resultEnvironment.removeAndCopy(memoryLocation);
            toClearIterator.remove();
        }
        InvariantsState result = new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, resultEnvironment, resultAssumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
        if (this.equals(result)) {
            return this;
        }
        return result;
    }

    public ImmutableSet<BooleanFormula<CompoundInterval>> getEnvironmentAsAssumptions() {
        if (this.environmentAsAssumptions == null) {
            this.environmentAsAssumptions = this.getEnvironmentAsAssumptions0();
        }
        return this.environmentAsAssumptions;
    }

    private Iterable<BooleanFormula<CompoundInterval>> getTypeInformationAsAssumptions() {
        ArrayList<BooleanFormula<CompoundInterval>> assumptionsIntervals = new ArrayList<BooleanFormula<CompoundInterval>>();
        for (Map.Entry typeEntry : this.variableTypes.entrySet()) {
            MemoryLocation memoryLocation = (MemoryLocation)typeEntry.getKey();
            Type type = (Type)typeEntry.getValue();
            if (!BitVectorInfo.isSupported(type)) continue;
            TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, (Type)typeEntry.getValue());
            CompoundIntervalManager cim = this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
            CompoundInterval range = cim.allPossibleValues();
            Variable<CompoundInterval> variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, memoryLocation);
            Object value = this.environment.get(memoryLocation);
            if (value != null && !((CompoundInterval)value.accept(this.tools.evaluationVisitor, this.environment)).containsAllPossibleValues()) continue;
            if (range.hasLowerBound()) {
                BooleanFormula<CompoundInterval> lowerBound = this.tools.compoundIntervalFormulaManager.greaterThanOrEqual(variable, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.singleton(range.getLowerBound())));
                if (!BooleanConstant.getTrue().equals(lowerBound)) {
                    assumptionsIntervals.add(lowerBound);
                }
            }
            if (!range.hasUpperBound()) continue;
            BooleanFormula<CompoundInterval> upperBound = this.tools.compoundIntervalFormulaManager.lessThanOrEqual(variable, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.singleton(range.getUpperBound())));
            if (BooleanConstant.getTrue().equals(upperBound)) continue;
            assumptionsIntervals.add(upperBound);
        }
        return assumptionsIntervals;
    }

    private ImmutableSet<BooleanFormula<CompoundInterval>> getEnvironmentAsAssumptions0() {
        CompoundIntervalFormulaManager compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.tools.compoundIntervalManagerFactory);
        ImmutableSet.Builder environmentalAssumptions = ImmutableSet.builderWithExpectedSize((int)this.assumptions.size());
        environmentalAssumptions.addAll(this.assumptions);
        ArrayList<NumeralFormula> atomic = new ArrayList<NumeralFormula>(1);
        ArrayDeque<NumeralFormula> toCheck = new ArrayDeque<NumeralFormula>(1);
        for (Map.Entry entry : this.environment.entrySet()) {
            Variable<CompoundInterval> variable = InvariantsFormulaManager.INSTANCE.asVariable(((NumeralFormula)entry.getValue()).getTypeInfo(), (MemoryLocation)entry.getKey());
            NumeralFormula value = (NumeralFormula)entry.getValue();
            boolean isExclusion = false;
            if (value instanceof Exclusion) {
                isExclusion = true;
                value = ((Exclusion)value).getExcluded();
            }
            atomic.clear();
            toCheck.clear();
            toCheck.add(value);
            while (!toCheck.isEmpty()) {
                NumeralFormula current = (NumeralFormula)toCheck.poll();
                if (current instanceof Union) {
                    Union union = (Union)current;
                    toCheck.add(union.getOperand1());
                    toCheck.add(union.getOperand2());
                    continue;
                }
                atomic.add(current);
            }
            assert (!atomic.isEmpty());
            Iterator iterator = atomic.iterator();
            BooleanFormula<CompoundInterval> assumption = null;
            while (iterator.hasNext()) {
                BooleanFormula<CompoundInterval> equation = compoundIntervalFormulaManager.equal(variable, (NumeralFormula)iterator.next());
                if (isExclusion) {
                    equation = compoundIntervalFormulaManager.logicalNot(equation);
                }
                assumption = assumption == null ? equation : compoundIntervalFormulaManager.logicalOr(assumption, equation);
            }
            if (assumption == null) continue;
            environmentalAssumptions.add(assumption);
        }
        return environmentalAssumptions.build();
    }

    private NumeralFormula<CompoundInterval> getEnvironmentValue(TypeInfo pTypeInfo, MemoryLocation pMemoryLocation) {
        Object environmentValue = this.environment.get(pMemoryLocation);
        if (environmentValue == null) {
            return this.allPossibleValuesFormula(pTypeInfo);
        }
        return environmentValue;
    }

    public FormulaEvaluationVisitor<CompoundInterval> getFormulaResolver() {
        return this.tools.evaluationVisitor;
    }

    private InvariantsState assumeInternal(Collection<? extends BooleanFormula<CompoundInterval>> pAssumptions, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, VariableSelection<CompoundInterval> pNewVariableSelection) {
        InvariantsState result = this;
        for (BooleanFormula<CompoundInterval> booleanFormula : pAssumptions) {
            result = this.assumeInternal(booleanFormula, pEvaluationVisitor, pNewVariableSelection);
            if (result != null) continue;
            return null;
        }
        return result;
    }

    private InvariantsState assumeInternal(BooleanFormula<CompoundInterval> pAssumption, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, VariableSelection<CompoundInterval> pNewVariableSelection) {
        BooleanFormula<CompoundInterval> assumption = pAssumption.accept(this.partialEvaluator, pEvaluationVisitor);
        List assumptionParts = (List)assumption.accept(SPLIT_CONJUNCTIONS_VISITOR);
        if (assumptionParts.size() > 1) {
            return this.assumeInternal(assumptionParts, pEvaluationVisitor, pNewVariableSelection);
        }
        if (assumption instanceof BooleanConstant) {
            return BooleanConstant.isTrue(assumption) ? this : null;
        }
        BooleanConstant assumptionEvaluation = (BooleanConstant)assumption.accept(pEvaluationVisitor, this.getEnvironment());
        if (BooleanConstant.isFalse(assumptionEvaluation)) {
            return null;
        }
        if (BooleanConstant.isTrue(assumptionEvaluation)) {
            return this;
        }
        if (FluentIterable.from((Iterable)((Iterable)assumption.accept(COLLECT_VARS_VISITOR))).anyMatch(InvariantsState::isUnsupportedVariableName)) {
            return this.overapproximateUnsupportedFeature();
        }
        NonRecursiveEnvironment.Builder environmentBuilder = new NonRecursiveEnvironment.Builder(this.environment);
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(this.tools.compoundIntervalManagerFactory, pEvaluationVisitor, environmentBuilder);
        if (!assumption.accept(patev, BooleanConstant.getTrue()).booleanValue()) {
            assert (!BooleanConstant.isTrue(assumptionEvaluation));
            return null;
        }
        if (this.isDefinitelyFalse(assumption, pEvaluationVisitor)) {
            return null;
        }
        return new InvariantsState(pNewVariableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, environmentBuilder.build(), (Set<BooleanFormula<CompoundInterval>>)this.assumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    private boolean isDefinitelyFalse(BooleanFormula<CompoundInterval> pAssumption, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return BooleanConstant.isFalse((BooleanFormula)pAssumption.accept(pEvaluationVisitor, this.getEnvironment()));
    }

    public InvariantsState assume(BooleanFormula<CompoundInterval> pAssumption) {
        VariableSelection<CompoundInterval> newVariableSelection = this.variableSelection.acceptAssumption(pAssumption);
        if (newVariableSelection == null) {
            return this;
        }
        FormulaEvaluationVisitor<CompoundInterval> evaluator = this.getFormulaResolver();
        BooleanFormula<CompoundInterval> assumption = pAssumption.accept(this.partialEvaluator, evaluator);
        if (assumption instanceof BooleanConstant) {
            if (BooleanConstant.isFalse(assumption)) {
                return null;
            }
            return this;
        }
        InvariantsState result = this.assumeInternal(assumption, evaluator, newVariableSelection);
        if (this.equalsState(result)) {
            return this;
        }
        for (BooleanFormula additionalAssumption : this.assumptions) {
            if (result == null) {
                return result;
            }
            result = result.assumeInternal(additionalAssumption, evaluator, newVariableSelection);
        }
        return result;
    }

    @Override
    public org.sosy_lab.java_smt.api.BooleanFormula getFormulaApproximation(FormulaManagerView pManager) {
        ToBitvectorFormulaVisitor toBooleanFormulaVisitor = new ToBitvectorFormulaVisitor(pManager, this.getFormulaResolver());
        return this.getApproximationFormulas().stream().map(approximation -> approximation.accept(toBooleanFormulaVisitor, this.getEnvironment())).filter(f -> f != null).collect(pManager.getBooleanFormulaManager().toConjunction());
    }

    @Override
    public ExpressionTree<Object> getFormulaApproximation(FunctionEntryNode pFunctionEntryNode, CFANode pReferenceNode) {
        Predicate isInvalidVar = pFormula -> pFormula instanceof Variable && !InvariantsState.isExportable(((Variable)pFormula).getMemoryLocation(), pFunctionEntryNode);
        LinkedHashSet approximationsAsCode = new LinkedHashSet();
        for (BooleanFormula<CompoundInterval> approximation : this.getApproximationFormulas()) {
            ExpressionTree<Object> code;
            Set memLocs = (Set)(approximation = this.replaceInvalid(approximation, (Predicate<NumeralFormula<CompoundInterval>>)isInvalidVar)).accept(new CollectVarsVisitor());
            if (memLocs.isEmpty() || !Iterables.all((Iterable)memLocs, memloc -> InvariantsState.isExportable(memloc, pFunctionEntryNode)) || (code = this.formulaToCode(approximation)) == null) continue;
            approximationsAsCode.add(code);
        }
        HashSet<MemoryLocation> safePointers = new HashSet<MemoryLocation>();
        isInvalidVar = Predicates.or((Predicate)isInvalidVar, pFormula -> {
            if (pFormula instanceof Variable) {
                return !safePointers.contains(((Variable)pFormula).getMemoryLocation());
            }
            return !Iterables.any((Iterable)((Iterable)pFormula.accept(COLLECT_VARS_VISITOR)), this::isPointerOrArray);
        });
        Predicate isNonSingletonConstant = pFormula -> pFormula instanceof Constant && !((CompoundInterval)((Constant)pFormula).getValue()).isSingleton();
        for (Map.Entry entry : this.environment.entrySet()) {
            ContainsVisitor containsVisitor;
            NumeralFormula value;
            MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
            CType type = (CType)this.variableTypes.get((Object)memoryLocation);
            if (!(type instanceof CPointerType) || !InvariantsState.isExportable(memoryLocation, pFunctionEntryNode) || ((Boolean)(value = (NumeralFormula)entry.getValue()).accept(containsVisitor = new ContainsVisitor(), isNonSingletonConstant)).booleanValue()) continue;
            Variable var = InvariantsFormulaManager.INSTANCE.asVariable(value.getTypeInfo(), memoryLocation);
            safePointers.add(memoryLocation);
            for (MemoryLocation otherSafePointer : safePointers) {
                ExpressionTree<Object> code;
                Object otherValue;
                Variable otherVar;
                BooleanFormula<CompoundInterval> equality;
                CType otherType;
                if (otherSafePointer == memoryLocation || !type.equals(otherType = (CType)this.variableTypes.get((Object)otherSafePointer)) || !this.definitelyImplies(equality = InvariantsFormulaManager.INSTANCE.equal(otherVar = InvariantsFormulaManager.INSTANCE.asVariable((otherValue = this.environment.get(otherSafePointer)).getTypeInfo(), otherSafePointer), var)) || (code = this.formulaToCode(this.replaceInvalid(equality, (Predicate<NumeralFormula<CompoundInterval>>)isInvalidVar))) == null) continue;
                approximationsAsCode.add(code);
            }
        }
        return And.of(approximationsAsCode);
    }

    private ExpressionTree<Object> formulaToCode(BooleanFormula<CompoundInterval> pFormula) {
        return ExpressionTrees.cast(pFormula.accept(new ToCodeFormulaVisitor(this.tools.evaluationVisitor, this.machineModel), this.getEnvironment()));
    }

    private ReplaceVisitor<CompoundInterval> getInvalidReplacementVisitor(Predicate<NumeralFormula<CompoundInterval>> isInvalidVar) {
        return new ReplaceVisitor<CompoundInterval>(isInvalidVar, pFormula -> this.replaceOrEvaluateInvalid((NumeralFormula<CompoundInterval>)pFormula, isInvalidVar));
    }

    private BooleanFormula<CompoundInterval> replaceInvalid(BooleanFormula<CompoundInterval> pFormula, Predicate<NumeralFormula<CompoundInterval>> pIsAlwaysInvalid) {
        Predicate pIsPointerOrArray = pFormula1 -> pFormula1 instanceof Variable && this.isPointerOrArray(((Variable)pFormula1).getMemoryLocation());
        if (pFormula instanceof LogicalAnd) {
            LogicalAnd and = (LogicalAnd)pFormula;
            return InvariantsFormulaManager.INSTANCE.logicalAnd(this.replaceInvalid(and.getOperand1(), pIsAlwaysInvalid), this.replaceInvalid(and.getOperand2(), pIsAlwaysInvalid));
        }
        if (pFormula instanceof LogicalNot) {
            return InvariantsFormulaManager.INSTANCE.logicalNot((BooleanFormula)Preconditions.checkNotNull(this.replaceInvalid(((LogicalNot)pFormula).getNegated(), pIsAlwaysInvalid)));
        }
        if (pFormula instanceof Equal) {
            Equal eq = (Equal)pFormula;
            if (eq.getOperand1() instanceof Variable && eq.getOperand2() instanceof Variable && !pIsAlwaysInvalid.apply(eq.getOperand1()) && !pIsAlwaysInvalid.apply(eq.getOperand2())) {
                return pFormula;
            }
            Predicate isAlwaysInvalid = Predicates.or(pIsAlwaysInvalid, (Predicate)pIsPointerOrArray);
            NumeralFormula op1 = (NumeralFormula)eq.getOperand1().accept(this.getInvalidReplacementVisitor((Predicate<NumeralFormula<CompoundInterval>>)isAlwaysInvalid));
            Set op1Vars = (Set)op1.accept(COLLECT_VARS_VISITOR);
            isAlwaysInvalid = Predicates.or((Predicate)isAlwaysInvalid, f -> !Collections.disjoint(op1Vars, (Collection)f.accept(COLLECT_VARS_VISITOR)));
            NumeralFormula op2 = (NumeralFormula)eq.getOperand2().accept(this.getInvalidReplacementVisitor((Predicate<NumeralFormula<CompoundInterval>>)isAlwaysInvalid));
            return InvariantsFormulaManager.INSTANCE.equal(op1, op2);
        }
        return (BooleanFormula)pFormula.accept(this.getInvalidReplacementVisitor((Predicate<NumeralFormula<CompoundInterval>>)Predicates.or(pIsAlwaysInvalid, (Predicate)pIsPointerOrArray)));
    }

    private NumeralFormula<CompoundInterval> replaceOrEvaluateInvalid(NumeralFormula<CompoundInterval> pFormula, Predicate<NumeralFormula<CompoundInterval>> pIsInvalid) {
        if (!pIsInvalid.apply(pFormula)) {
            return pFormula;
        }
        CompoundInterval evaluated = (CompoundInterval)pFormula.accept(this.tools.evaluationVisitor, this.environment);
        if (!evaluated.isSingleton() && pFormula instanceof Variable) {
            ReplaceVisitor<CompoundInterval> evaluateInvalidVars = new ReplaceVisitor<CompoundInterval>(pIsInvalid, f -> this.replaceOrEvaluateInvalid((NumeralFormula<CompoundInterval>)f, pIsInvalid));
            MemoryLocation memoryLocation = ((Variable)pFormula).getMemoryLocation();
            NumeralFormula value = this.getEnvironmentValue(pFormula.getTypeInfo(), memoryLocation);
            if ((value = (NumeralFormula)value.accept(evaluateInvalidVars)) instanceof Variable) {
                return value;
            }
            CompoundIntervalManager cim = this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(pFormula.getTypeInfo());
            if (value instanceof Constant && cim.contains(evaluated, (CompoundInterval)((Constant)value).getValue())) {
                evaluated = (CompoundInterval)((Constant)value).getValue();
            }
            if (!evaluated.isSingleton()) {
                HashSet visited = new HashSet();
                ArrayDeque waitlist = new ArrayDeque();
                visited.add((Variable)pFormula);
                waitlist.addAll(visited);
                while (!waitlist.isEmpty()) {
                    Variable currentVar = (Variable)waitlist.poll();
                    if (!pIsInvalid.apply((Object)currentVar)) {
                        return currentVar;
                    }
                    for (Map.Entry entry : this.environment.entrySet()) {
                        Variable entryVar;
                        if (!((NumeralFormula)entry.getValue()).equals(currentVar) || !visited.add(entryVar = InvariantsFormulaManager.INSTANCE.asVariable(((NumeralFormula)entry.getValue()).getTypeInfo(), (MemoryLocation)entry.getKey()))) continue;
                        waitlist.offer(entryVar);
                    }
                }
            }
        }
        return InvariantsFormulaManager.INSTANCE.asConstant(pFormula.getTypeInfo(), evaluated);
    }

    private Set<BooleanFormula<CompoundInterval>> getApproximationFormulas() {
        Object formulas = this.getEnvironmentAsAssumptions();
        if (this.includeTypeInformation) {
            formulas = Iterables.concat(formulas, this.getTypeInformationAsAssumptions());
        }
        LinkedHashSet<BooleanFormula<CompoundInterval>> result = new LinkedHashSet<BooleanFormula<CompoundInterval>>();
        Iterator iterator = formulas.iterator();
        while (iterator.hasNext()) {
            BooleanFormula formula = (BooleanFormula)iterator.next();
            if (formula == null || !Iterables.all(CompoundIntervalFormulaManager.collectVariableNames(formula), InvariantsState::isExportable)) continue;
            result.add(formula);
        }
        return result;
    }

    @Override
    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof InvariantsState)) {
            return false;
        }
        return this.equalsState((InvariantsState)pObj);
    }

    private boolean equalsState(InvariantsState pOther) {
        return pOther != null && this.overflowDetected == pOther.overflowDetected && this.includeTypeInformation == pOther.includeTypeInformation && this.machineModel.equals((Object)pOther.machineModel) && this.tools.equals(pOther.tools) && this.variableTypes.equals(pOther.variableTypes) && this.variableSelection.equals(pOther.variableSelection) && this.environment.equals(pOther.environment) && this.assumptions.equals(pOther.assumptions) && this.abstractionState.equals(pOther.abstractionState);
    }

    @Override
    public int hashCode() {
        int result = this.hash;
        if (result == 0) {
            this.hash = result = Objects.hash(new Object[]{this.overflowDetected, this.includeTypeInformation, this.machineModel, this.tools, this.variableTypes, this.variableSelection, this.environment, this.assumptions, this.abstractionState});
        }
        return result;
    }

    @Override
    public String toString() {
        return Joiner.on((String)", ").join(Iterables.concat((Iterable)Collections2.transform((Collection)this.environment.entrySet(), pInput -> {
            MemoryLocation memoryLocation = (MemoryLocation)pInput.getKey();
            NumeralFormula value = (NumeralFormula)pInput.getValue();
            if (value instanceof Exclusion) {
                return String.format("%s\u2260%s", memoryLocation, ((Exclusion)value).getExcluded());
            }
            return String.format("%s=%s", memoryLocation, value);
        }), this.assumptions));
    }

    public AbstractionState getAbstractionState() {
        return this.abstractionState;
    }

    public Map<MemoryLocation, NumeralFormula<CompoundInterval>> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    public MachineModel getMachineModel() {
        return this.machineModel;
    }

    @Override
    public boolean isLessOrEqual(InvariantsState pState2) {
        if (this.equals(pState2)) {
            return true;
        }
        if (pState2 == null) {
            return false;
        }
        if (!this.abstractionState.isLessThanOrEqualTo(pState2.abstractionState)) {
            return false;
        }
        for (BooleanFormula rightAssumption : pState2.getEnvironmentAsAssumptions()) {
            if (this.definitelyImplies(rightAssumption)) continue;
            return false;
        }
        return true;
    }

    public boolean definitelyImplies(BooleanFormula<CompoundInterval> pFormula) {
        return this.tools.compoundIntervalFormulaManager.definitelyImplies((Collection<BooleanFormula<CompoundInterval>>)this.assumptions, this.environment, pFormula, false);
    }

    /*
     * WARNING - void declaration
     */
    public InvariantsState widen(InvariantsState pOlderState, InvariantsPrecision pPrecision, @Nullable Set<MemoryLocation> pWideningTargets, Set<BooleanFormula<CompoundInterval>> pWideningHints) {
        void var10_17;
        NumeralFormula<CompoundInterval> newValueFormula;
        Set wideningTargets;
        Set set = wideningTargets = pWideningTargets == null ? this.environment.keySet() : Sets.intersection(pWideningTargets, (Set)this.environment.keySet());
        if (wideningTargets.isEmpty()) {
            return this;
        }
        NonRecursiveEnvironment resultEnvironment = this.environment;
        HashMap<Object, NumeralFormula<CompoundInterval>> toDo = new HashMap<Object, NumeralFormula<CompoundInterval>>();
        for (Object memoryLocation : wideningTargets) {
            Object object = pOlderState.environment.get(memoryLocation);
            if (object == null) continue;
            NumeralFormula<CompoundInterval> currentFormula = this.environment.get(memoryLocation);
            TypeInfo typeInfo = object.getTypeInfo();
            CompoundIntervalManager compoundIntervalManager = this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
            NumeralFormula<CompoundInterval> numeralFormula = currentFormula = currentFormula == null ? this.allPossibleValuesFormula(typeInfo) : currentFormula;
            assert (currentFormula.getTypeInfo().equals(typeInfo));
            if (currentFormula.equals(object)) continue;
            newValueFormula = this.tools.compoundIntervalFormulaManager.union(currentFormula.accept(this.partialEvaluator, this.tools.evaluationVisitor), object.accept(pOlderState.partialEvaluator, this.tools.evaluationVisitor)).accept(new PartialEvaluator(this.tools.compoundIntervalManagerFactory), this.tools.evaluationVisitor);
            if ((Integer)currentFormula.accept(FORMULA_DEPTH_COUNT_VISITOR) > pPrecision.getMaximumFormulaDepth()) {
                CompoundInterval value = compoundIntervalManager.union((CompoundInterval)currentFormula.accept(this.tools.evaluationVisitor, this.environment), (CompoundInterval)object.accept(this.tools.evaluationVisitor, pOlderState.getEnvironment()));
                if (!value.isSingleton()) {
                    value = compoundIntervalManager.allPossibleValues();
                }
                newValueFormula = InvariantsFormulaManager.INSTANCE.asConstant(currentFormula.getTypeInfo(), value);
            }
            resultEnvironment = resultEnvironment.putAndCopy((MemoryLocation)memoryLocation, newValueFormula);
            toDo.put(memoryLocation, newValueFormula);
        }
        if (toDo.isEmpty()) {
            return this;
        }
        HashSet<BooleanFormula<CompoundInterval>> additionalHints = new HashSet<BooleanFormula<CompoundInterval>>();
        for (Map.Entry entry : toDo.entrySet()) {
            CompoundInterval newValue;
            CompoundInterval currentExactValue;
            CompoundInterval simpleExactValue;
            MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
            NumeralFormula numeralFormula = (NumeralFormula)entry.getValue();
            TypeInfo typeInfo = ((NumeralFormula)entry.getValue()).getTypeInfo();
            if (pPrecision.shouldUseMod2Template()) {
                Variable<CompoundInterval> variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, memoryLocation);
                additionalHints.add(this.instantiateModTemplate(variable, 2, 0));
                additionalHints.add(this.instantiateModTemplate(variable, 2, 1));
            }
            if ((simpleExactValue = (CompoundInterval)numeralFormula.accept(this.tools.evaluationVisitor, resultEnvironment)).isSingleton()) {
                resultEnvironment = resultEnvironment.putAndCopy(memoryLocation, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, simpleExactValue));
                continue;
            }
            CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(typeInfo);
            NumeralFormula<CompoundInterval> oldFormula = pOlderState.getEnvironmentValue(typeInfo, memoryLocation);
            NumeralFormula<CompoundInterval> currentFormula = this.getEnvironmentValue(typeInfo, memoryLocation);
            CompoundInterval oldExactValue = (CompoundInterval)oldFormula.accept(this.tools.evaluationVisitor, pOlderState.environment);
            if (compoundIntervalManager.contains(oldExactValue, currentExactValue = (CompoundInterval)currentFormula.accept(this.tools.evaluationVisitor, this.environment))) {
                newValue = oldExactValue;
            } else if (compoundIntervalManager.lessEqual(oldExactValue, currentExactValue).isDefinitelyTrue() || oldExactValue.hasUpperBound() && (!currentExactValue.hasUpperBound() || InvariantsState.compare(oldExactValue.getUpperBound(), currentExactValue.getUpperBound()) < 0)) {
                newValue = compoundIntervalManager.union(oldExactValue, currentExactValue).extendToMaxValue();
            } else if (compoundIntervalManager.greaterEqual(oldExactValue, currentExactValue).isDefinitelyTrue() || oldExactValue.hasLowerBound() && (!currentExactValue.hasLowerBound() || InvariantsState.compare(oldExactValue.getLowerBound(), currentExactValue.getLowerBound()) > 0)) {
                newValue = compoundIntervalManager.union(oldExactValue, currentExactValue).extendToMinValue();
            } else {
                NumeralFormula<CompoundInterval> newFormula = resultEnvironment.get(memoryLocation);
                if (newFormula == null) {
                    newFormula = this.allPossibleValuesFormula(typeInfo);
                }
                newValue = (CompoundInterval)newFormula.accept(this.tools.abstractionVisitor, resultEnvironment);
            }
            resultEnvironment = resultEnvironment.putAndCopy(memoryLocation, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, newValue));
        }
        NonRecursiveEnvironment resEnv = resultEnvironment;
        InvariantsState invariantsState = new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, resEnv, (Set<BooleanFormula<CompoundInterval>>)ImmutableSet.of(), this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
        if (pPrecision.shouldUseMod2Template()) {
            for (Map.Entry entry : toDo.entrySet()) {
                void var10_14;
                MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
                newValueFormula = (NumeralFormula<CompoundInterval>)entry.getValue();
                TypeInfo typeInfo = ((NumeralFormula)entry.getValue()).getTypeInfo();
                Mod2AbstractionVisitor.Type t = newValueFormula.accept(new Mod2AbstractionVisitor(this.tools.compoundIntervalManagerFactory, this.tools.evaluationVisitor, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions));
                Variable<CompoundInterval> variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, memoryLocation);
                if (t == Mod2AbstractionVisitor.Type.EVEN) {
                    InvariantsState invariantsState2 = var10_14.assume(this.instantiateModTemplate(variable, 2, 0));
                    continue;
                }
                if (t != Mod2AbstractionVisitor.Type.ODD) continue;
                InvariantsState invariantsState3 = var10_14.assume(this.instantiateModTemplate(variable, 2, 1));
            }
        }
        Object additionalAssumptions = additionalHints.isEmpty() ? ImmutableSet.of() : new HashSet();
        for (BooleanFormula hint : FluentIterable.from((Iterable)Sets.union(pWideningHints, additionalHints)).filter(pHint -> wideningTargets.containsAll((Collection)pHint.accept(COLLECT_VARS_VISITOR))).filter(this::definitelyImplies)) {
            InvariantsState invariantsState4 = var10_17.assume(hint);
            Verify.verifyNotNull((Object)invariantsState4, (String)"Widening with hint '%s' led abstract state '%s' to become bottom", (Object[])new Object[]{hint, pOlderState});
            if (!additionalHints.contains(hint)) continue;
            additionalAssumptions.add(hint);
        }
        InvariantsState invariantsState5 = var10_17.addAssumptions((Set<BooleanFormula<CompoundInterval>>)additionalAssumptions);
        if (this.equals(invariantsState5)) {
            return this;
        }
        return invariantsState5;
    }

    private BooleanFormula<CompoundInterval> instantiateModTemplate(Variable<CompoundInterval> pDividend, int pDivisor, int pRemainder) {
        Preconditions.checkArgument((pDivisor >= 2 ? 1 : 0) != 0, (Object)"Divisor must be greater than 1.");
        if (pRemainder < 0 || pRemainder >= pDivisor) {
            throw new IllegalArgumentException(String.format("The remainder must be between 0 and %d.", pDivisor - 1));
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pDividend.getTypeInfo());
        BooleanFormula<CompoundInterval> hint = InvariantsFormulaManager.INSTANCE.equal(InvariantsFormulaManager.INSTANCE.modulo(pDividend, InvariantsFormulaManager.INSTANCE.asConstant(pDividend.getTypeInfo(), compoundIntervalManager.singleton(pDivisor))), InvariantsFormulaManager.INSTANCE.asConstant(pDividend.getTypeInfo(), compoundIntervalManager.singleton(pRemainder)));
        return hint;
    }

    @Override
    public InvariantsState join(InvariantsState state2) {
        return this.join(state2, InvariantsPrecision.getEmptyPrecision(AbstractionStrategyFactories.ALWAYS.createStrategy(this.tools.compoundIntervalManagerFactory, this.machineModel)));
    }

    public InvariantsState join(InvariantsState pState2, InvariantsPrecision pPrecision) {
        InvariantsState result;
        InvariantsState state1 = this;
        InvariantsState state2 = pState2;
        if (state1.isLessOrEqual(state2)) {
            result = state2;
        } else if (state2.isLessOrEqual(state1)) {
            result = state1;
        } else {
            Object commonAssumptions;
            NumeralFormula<CompoundInterval> leftFormula;
            NonRecursiveEnvironment resultEnvironment = NonRecursiveEnvironment.of(this.tools.compoundIntervalManagerFactory);
            HashSet todo = new HashSet();
            for (Object memoryLocation : state1.environment.keySet()) {
                Object object = state2.environment.get(memoryLocation);
                if (object == null) continue;
                leftFormula = this.getEnvironmentValue(object.getTypeInfo(), (MemoryLocation)memoryLocation);
                if (leftFormula.equals(object)) {
                    resultEnvironment = resultEnvironment.putAndCopy((MemoryLocation)memoryLocation, leftFormula);
                    continue;
                }
                todo.add(memoryLocation);
            }
            PersistentSortedMap mergedVariableTypes = state1.variableTypes;
            for (Map.Entry entry : state2.variableTypes.entrySet()) {
                if (mergedVariableTypes.containsKey(entry.getKey())) continue;
                mergedVariableTypes = mergedVariableTypes.putAndCopy((Object)((MemoryLocation)entry.getKey()), (Object)((CType)entry.getValue()));
            }
            for (MemoryLocation memoryLocation : todo) {
                leftFormula = this.environment.get(memoryLocation);
                Object rightFormula = state2.environment.get(memoryLocation);
                assert (leftFormula != null && rightFormula != null);
                CompoundIntervalManager cim = this.tools.compoundIntervalManagerFactory.createCompoundIntervalManager(leftFormula.getTypeInfo());
                NumeralFormula<CompoundInterval> evaluated = InvariantsFormulaManager.INSTANCE.asConstant(leftFormula.getTypeInfo(), cim.union((CompoundInterval)leftFormula.accept(this.tools.evaluationVisitor, this.environment), (CompoundInterval)rightFormula.accept(state2.tools.evaluationVisitor, state2.environment)));
                resultEnvironment = resultEnvironment.putAndCopy(memoryLocation, evaluated);
            }
            if (this.assumptions.isEmpty() && pState2.assumptions.isEmpty()) {
                commonAssumptions = ImmutableSet.of();
            } else {
                commonAssumptions = new HashSet(Sets.intersection(this.assumptions, pState2.assumptions));
                for (BooleanFormula assumption : Sets.difference(this.assumptions, pState2.assumptions)) {
                    if (!pState2.definitelyImplies(assumption)) continue;
                    commonAssumptions.add(assumption);
                }
                for (BooleanFormula assumption : Sets.difference(pState2.assumptions, this.assumptions)) {
                    if (!this.definitelyImplies(assumption)) continue;
                    commonAssumptions.add(assumption);
                }
            }
            VariableSelection<CompoundInterval> resultVariableSelection = state1.variableSelection.join(state2.variableSelection);
            AbstractionState abstractionState1 = this.determineAbstractionState(pPrecision);
            AbstractionState abstractionState = pState2.determineAbstractionState(pPrecision);
            AbstractionState joinedAbstractionState = abstractionState1.join(abstractionState);
            result = new InvariantsState(resultVariableSelection, this.tools, this.machineModel, this.variableTypes, joinedAbstractionState, resultEnvironment, (Set<BooleanFormula<CompoundInterval>>)commonAssumptions, this.overflowDetected, this.includeTypeInformation, this.overapproximatesUnsupportedFeature || pState2.overapproximatesUnsupportedFeature);
            if (result.equalsState(state1)) {
                result = state1;
            }
        }
        return result;
    }

    public BooleanFormula<CompoundInterval> asFormula() {
        BooleanFormula<CompoundInterval> result = BooleanConstant.getTrue();
        for (BooleanFormula assumption : this.getEnvironmentAsAssumptions()) {
            result = this.tools.compoundIntervalFormulaManager.logicalAnd(result, assumption);
        }
        return result;
    }

    public Set<MemoryLocation> getVariables() {
        return ImmutableSet.builder().addAll((Iterable)this.environment.keySet()).addAll((Iterable)FluentIterable.from(this.environment.values()).transformAndConcat(value -> (Iterable)value.accept(COLLECT_VARS_VISITOR))).build();
    }

    private Set<Variable<CompoundInterval>> getVariables(final Predicate<MemoryLocation> pMemoryLocationPredicate) {
        final LinkedHashSet<Variable<CompoundInterval>> result = new LinkedHashSet<Variable<CompoundInterval>>();
        Predicate<NumeralFormula<CompoundInterval>> pCondition = new Predicate<NumeralFormula<CompoundInterval>>(){

            public boolean apply(NumeralFormula<CompoundInterval> pFormula) {
                if (pFormula instanceof Variable) {
                    Variable variable = (Variable)pFormula;
                    MemoryLocation memoryLocation = variable.getMemoryLocation();
                    return pMemoryLocationPredicate.apply((Object)memoryLocation) && !result.contains(variable);
                }
                return false;
            }
        };
        CollectFormulasVisitor<CompoundInterval> collectVisitor = new CollectFormulasVisitor<CompoundInterval>(pCondition);
        for (Map.Entry entry : this.environment.entrySet()) {
            MemoryLocation memoryLocation = (MemoryLocation)entry.getKey();
            if (pMemoryLocationPredicate.apply((Object)memoryLocation)) {
                result.add(InvariantsFormulaManager.INSTANCE.asVariable(((NumeralFormula)entry.getValue()).getTypeInfo(), memoryLocation));
            }
            for (NumeralFormula formula : (Set)((NumeralFormula)entry.getValue()).accept(collectVisitor)) {
                Variable variable = (Variable)formula;
                result.add(variable);
            }
        }
        return result;
    }

    public InvariantsState overflowDetected() {
        if (this.overflowDetected) {
            return this;
        }
        return new InvariantsState(this.variableSelection, this.tools, this.machineModel, this.variableTypes, this.abstractionState, this.environment, (Set<BooleanFormula<CompoundInterval>>)this.assumptions, true, this.includeTypeInformation, this.overapproximatesUnsupportedFeature);
    }

    @Override
    public String getCPAName() {
        return InvariantsCPA.class.getSimpleName();
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equals(PROPERTY_OVERFLOW)) {
            return this.overflowDetected;
        }
        throw new InvalidQueryException("Query '" + pProperty + "' is invalid.");
    }

    public boolean overapproximatesUnsupportedFeature() {
        return this.overapproximatesUnsupportedFeature;
    }

    private boolean isPointerOrArray(MemoryLocation pMemoryLocation) {
        Type type = this.getType(pMemoryLocation);
        return type instanceof CPointerType || type instanceof CArrayType;
    }

    private static boolean isExportable(MemoryLocation pMemoryLocation, FunctionEntryNode pFunctionEntryNode) {
        if (pMemoryLocation.getIdentifier().startsWith("__CPAchecker_TMP_")) {
            return false;
        }
        if (pFunctionEntryNode.getReturnVariable().isPresent() && pMemoryLocation.isOnFunctionStack() && pMemoryLocation.getIdentifier().equals(pFunctionEntryNode.getReturnVariable().get().getName())) {
            return false;
        }
        if (!InvariantsState.isExportable(pMemoryLocation)) {
            return false;
        }
        String functionName = pFunctionEntryNode.getFunctionName();
        return !pMemoryLocation.isOnFunctionStack() || pMemoryLocation.getFunctionName().equals(functionName);
    }

    private static boolean isExportable(@Nullable MemoryLocation pMemoryLocation) {
        return pMemoryLocation != null && !pMemoryLocation.getIdentifier().contains("*") && !pMemoryLocation.getIdentifier().contains("->") && !pMemoryLocation.getIdentifier().contains(".") && !pMemoryLocation.getIdentifier().contains("[");
    }

    private static int compare(Number pOp1, Number pOp2) {
        if (pOp1 instanceof BigInteger && pOp2 instanceof BigInteger) {
            return ((BigInteger)pOp1).compareTo((BigInteger)pOp2);
        }
        if (pOp1 instanceof BigDecimal && pOp2 instanceof BigDecimal) {
            return ((BigDecimal)pOp1).compareTo((BigDecimal)pOp2);
        }
        if (InvariantsState.isAssignableToLong(pOp1) && InvariantsState.isAssignableToLong(pOp2)) {
            return Long.compare(pOp1.longValue(), pOp2.longValue());
        }
        if (InvariantsState.isAssignableToDouble(pOp1) && InvariantsState.isAssignableToDouble(pOp2)) {
            return Double.compare(pOp1.doubleValue(), pOp2.doubleValue());
        }
        throw new IllegalArgumentException("Unsupported comparsion: " + pOp1 + " to " + pOp2);
    }

    private static boolean isAssignableToLong(Number pNumber) {
        return pNumber instanceof Long || pNumber instanceof Integer || pNumber instanceof Short || pNumber instanceof Byte;
    }

    private static boolean isAssignableToDouble(Number pNumber) {
        return pNumber instanceof Double || pNumber instanceof Float;
    }

    private static class Tools {
        private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
        private final CompoundIntervalFormulaManager compoundIntervalFormulaManager;
        private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
        private final FormulaEvaluationVisitor<CompoundInterval> abstractionVisitor;

        private Tools(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
            this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
            this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
            this.evaluationVisitor = new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory);
            this.abstractionVisitor = new FormulaAbstractionVisitor(this.compoundIntervalManagerFactory);
        }

        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj instanceof Tools) {
                return this.compoundIntervalManagerFactory.equals(((Tools)pObj).compoundIntervalManagerFactory);
            }
            return false;
        }

        public int hashCode() {
            return this.compoundIntervalManagerFactory.hashCode();
        }
    }
}

