/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.ALeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.EdgeAnalyzer;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsPrecision;
import org.sosy_lab.cpachecker.cpa.invariants.InvariantsState;
import org.sosy_lab.cpachecker.cpa.invariants.MemoryLocationExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerState;
import org.sosy_lab.cpachecker.cpa.pointer2.PointerTransferRelation;
import org.sosy_lab.cpachecker.cpa.pointer2.util.LocationSet;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.exceptions.UnsupportedCodeException;
import org.sosy_lab.cpachecker.util.CFAEdgeUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.variableclassification.VariableClassification;

class InvariantsTransferRelation
extends SingleEdgeTransferRelation {
    private static final ImmutableMap<String, String> UNSUPPORTED_FUNCTIONS = ImmutableMap.of((Object)"memcpy", (Object)"memcpy", (Object)"memmove", (Object)"memmove", (Object)"memset", (Object)"memset");
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final CompoundIntervalFormulaManager compoundIntervalFormulaManager;
    private final MachineModel machineModel;
    private final EdgeAnalyzer edgeAnalyzer;
    private final boolean allowOverapproximationOfUnsupportedFeatures;
    private final boolean usePointerAliasStrengthening;
    private final Optional<VariableClassification> variableClassification;

    public InvariantsTransferRelation(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, boolean pAllowOverapproximationOfUnsupportedFeatures, boolean pUsePointerAliasStrengthening, Optional<VariableClassification> pVariableClassification) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.machineModel = pMachineModel;
        this.edgeAnalyzer = new EdgeAnalyzer(this.compoundIntervalManagerFactory, this.machineModel);
        this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
        this.allowOverapproximationOfUnsupportedFeatures = pAllowOverapproximationOfUnsupportedFeatures;
        this.usePointerAliasStrengthening = pUsePointerAliasStrengthening;
        this.variableClassification = Objects.requireNonNull(pVariableClassification);
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pTypeInfo) {
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo);
    }

    private NumeralFormula<CompoundInterval> allPossibleValues(Type pType) {
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pType);
        return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, this.getCompoundIntervalManager(typeInfo).allPossibleValues());
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pEdge) throws CPATransferException {
        CompoundBitVectorIntervalManagerFactory compoundBitVectorIntervalManagerFactory;
        InvariantsState state = (InvariantsState)pState;
        InvariantsPrecision precision = (InvariantsPrecision)pPrecision;
        AtomicBoolean overflowDetected = new AtomicBoolean(false);
        OverflowEventHandler overflowEventHandler = () -> overflowDetected.set(true);
        if (this.compoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory) {
            compoundBitVectorIntervalManagerFactory = (CompoundBitVectorIntervalManagerFactory)this.compoundIntervalManagerFactory;
            compoundBitVectorIntervalManagerFactory.addOverflowEventHandler(overflowEventHandler);
        }
        state = this.getSuccessor(pEdge, precision, state);
        if (this.compoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory) {
            compoundBitVectorIntervalManagerFactory = (CompoundBitVectorIntervalManagerFactory)this.compoundIntervalManagerFactory;
            compoundBitVectorIntervalManagerFactory.removeOverflowEventHandler(overflowEventHandler);
        }
        if (state == null) {
            return ImmutableSet.of();
        }
        state = state.updateAbstractionState(precision, pEdge);
        if (overflowDetected.get()) {
            state = state.overflowDetected();
        }
        if (!this.allowOverapproximationOfUnsupportedFeatures && state.overapproximatesUnsupportedFeature()) {
            throw new UnsupportedCodeException("Over-approximation of unsupported features is switched off", pEdge);
        }
        return Collections.singleton(state);
    }

    private InvariantsState getSuccessor(CFAEdge pEdge, InvariantsPrecision pPrecision, InvariantsState pState) throws UnrecognizedCFAEdgeException, UnrecognizedCodeException {
        InvariantsState state = pState.setTypes(this.edgeAnalyzer.getInvolvedVariableTypes(pEdge));
        switch (pEdge.getEdgeType()) {
            case BlankEdge: {
                break;
            }
            case FunctionReturnEdge: {
                state = this.handleFunctionReturn(state, (CFunctionReturnEdge)pEdge, pPrecision);
                break;
            }
            case ReturnStatementEdge: {
                state = this.handleReturnStatement(state, (CReturnStatementEdge)pEdge);
                break;
            }
            case AssumeEdge: {
                state = this.handleAssume(state, (CAssumeEdge)pEdge);
                break;
            }
            case DeclarationEdge: {
                state = this.handleDeclaration(state, (CDeclarationEdge)pEdge);
                break;
            }
            case FunctionCallEdge: {
                state = this.handleFunctionCall(state, (CFunctionCallEdge)pEdge);
                break;
            }
            case StatementEdge: {
                state = this.handleStatement(state, (CStatementEdge)pEdge, pPrecision);
                break;
            }
            default: {
                throw new UnrecognizedCFAEdgeException(pEdge);
            }
        }
        if (state != null && pPrecision != null && !pPrecision.isRelevant(pEdge)) {
            state = state.clear();
        }
        return state;
    }

    private InvariantsState handleAssume(InvariantsState pState, AssumeEdge pEdge) throws UnrecognizedCodeException {
        return this.handleAssume(pState, pEdge, this.getExpressionToFormulaVisitor(pEdge, pState));
    }

    private InvariantsState handleAssume(InvariantsState pState, AssumeEdge pEdge, ExpressionToFormulaVisitor pExpressionToFormulaVisitor) throws UnrecognizedCodeException {
        AExpression expression = pEdge.getExpression();
        BooleanFormula<CompoundInterval> assumption = null;
        if (expression instanceof CExpression) {
            NumeralFormula<CompoundInterval> expressionFormula = ((CExpression)expression).accept(pExpressionToFormulaVisitor);
            assumption = this.compoundIntervalFormulaManager.fromNumeral(expressionFormula);
        } else if (expression instanceof JExpression) {
            NumeralFormula<CompoundInterval> expressionFormula = ((JExpression)expression).accept(pExpressionToFormulaVisitor);
            assumption = this.compoundIntervalFormulaManager.fromNumeral(expressionFormula);
        } else {
            return pState;
        }
        if (!pEdge.getTruthAssumption()) {
            assumption = this.compoundIntervalFormulaManager.logicalNot(assumption);
        }
        return this.handleAssumption(pState, assumption);
    }

    private InvariantsState handleAssumption(InvariantsState pState, BooleanFormula<CompoundInterval> pAssumption) {
        InvariantsState result = pState.assume(pAssumption);
        return result;
    }

    private InvariantsState handleDeclaration(InvariantsState pElement, CDeclarationEdge pEdge) throws UnrecognizedCodeException {
        NumeralFormula<CompoundInterval> value;
        if (!(pEdge.getDeclaration() instanceof CVariableDeclaration)) {
            return pElement;
        }
        CVariableDeclaration decl = (CVariableDeclaration)pEdge.getDeclaration();
        if (decl.getType().isIncomplete()) {
            return pElement;
        }
        if (!BitVectorInfo.isSupported(decl.getType())) {
            return pElement;
        }
        MemoryLocation varName = MemoryLocation.parseExtendedQualifiedName(decl.getName());
        if (!decl.isGlobal()) {
            varName = MemoryLocationExtractor.scope(decl.getName(), pEdge.getSuccessor().getFunctionName());
        }
        if (decl.getInitializer() instanceof CInitializerExpression) {
            CExpression init = ((CInitializerExpression)decl.getInitializer()).getExpression();
            value = init.accept(this.getExpressionToFormulaVisitor(pEdge, pElement));
            if (InvariantsTransferRelation.containsArrayWildcard(value)) {
                value = this.toConstant(value, pElement.getEnvironment());
            }
        } else {
            value = this.allPossibleValues(decl.getType());
        }
        value = this.handlePotentialOverflow(pElement, value, decl.getType());
        return pElement.assign(varName, value);
    }

    private InvariantsState handleFunctionCall(InvariantsState pElement, CFunctionCallEdge pEdge) throws UnrecognizedCodeException {
        InvariantsState newElement = pElement;
        ImmutableList formalParams = pEdge.getSuccessor().getFunctionParameterNames();
        List<CParameterDeclaration> declarations = pEdge.getSuccessor().getFunctionParameters();
        ImmutableList actualParams = pEdge.getArguments();
        int limit = Math.min(formalParams.size(), actualParams.size());
        ExpressionToFormulaVisitor actualParamExpressionToFormulaVisitor = this.getExpressionToFormulaVisitor(new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pEdge, true, pElement.getEnvironment()), pElement);
        if (limit == 1 && "__VERIFIER_assume".equals(pEdge.getSuccessor().getFunctionName())) {
            NumeralFormula<CompoundInterval> assumptionExpression = actualParams.get(0).accept(actualParamExpressionToFormulaVisitor);
            BooleanFormula<CompoundInterval> assumption = this.compoundIntervalFormulaManager.fromNumeral(assumptionExpression);
            return this.handleAssumption(pElement, assumption);
        }
        formalParams = FluentIterable.from(formalParams).limit(limit).toList();
        actualParams = FluentIterable.from(actualParams).limit(limit).toList();
        Iterator<CParameterDeclaration> declarationIterator = declarations.iterator();
        for (Pair param : Pair.zipList(formalParams, actualParams)) {
            CExpression actualParam = (CExpression)param.getSecond();
            CParameterDeclaration declaration = declarationIterator.next();
            if (!BitVectorInfo.isSupported(declaration.getType())) continue;
            NumeralFormula<CompoundInterval> value = actualParam.accept(actualParamExpressionToFormulaVisitor);
            if (InvariantsTransferRelation.containsArrayWildcard(value)) {
                value = this.toConstant(value, pElement.getEnvironment());
            }
            MemoryLocation formalParam = MemoryLocationExtractor.scope((String)param.getFirst(), pEdge.getSuccessor().getFunctionName());
            value = this.handlePotentialOverflow(pElement, value, declaration.getType());
            newElement = newElement.assign(formalParam, value);
        }
        return newElement;
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return pFormula.accept(new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory), pEnvironment);
    }

    private NumeralFormula<CompoundInterval> toConstant(NumeralFormula<CompoundInterval> pFormula, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pFormula.getTypeInfo(), this.evaluate(pFormula, pEnvironment));
    }

    private InvariantsState handleStatement(InvariantsState pElement, CStatementEdge pEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        String func;
        CExpression fn;
        if (pEdge.getStatement() instanceof CFunctionCall && (fn = ((CFunctionCall)pEdge.getStatement()).getFunctionCallExpression().getFunctionNameExpression()) instanceof CIdExpression && UNSUPPORTED_FUNCTIONS.containsKey((Object)(func = ((CIdExpression)fn).getName()))) {
            throw new UnsupportedCodeException((String)UNSUPPORTED_FUNCTIONS.get((Object)func), pEdge, fn);
        }
        if (pEdge.getStatement() instanceof CAssignment) {
            CIdExpression idExpression;
            CFunctionCallExpression cFunctionCallExpression;
            CExpression functionNameExpression;
            CAssignment assignment = (CAssignment)pEdge.getStatement();
            ExpressionToFormulaVisitor etfv = this.getExpressionToFormulaVisitor(pEdge, pElement);
            CLeftHandSide leftHandSide = assignment.getLeftHandSide();
            CRightHandSide rightHandSide = assignment.getRightHandSide();
            NumeralFormula<CompoundInterval> value = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(assignment.getRightHandSide(), leftHandSide.getExpressionType()).accept(etfv);
            if (this.compoundIntervalFormulaManager.containsAllPossibleValues(value) && rightHandSide instanceof CFunctionCallExpression && (functionNameExpression = (cFunctionCallExpression = (CFunctionCallExpression)rightHandSide).getFunctionNameExpression()) instanceof CIdExpression && (idExpression = (CIdExpression)functionNameExpression).getName().equals("__VERIFIER_nondet_uint")) {
                TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, leftHandSide.getExpressionType());
                value = InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, this.getCompoundIntervalManager(typeInfo).singleton(0L).extendToMaxValue());
            }
            value = this.handlePotentialOverflow(pElement, value, leftHandSide.getExpressionType());
            return this.handleAssignment(pElement, pEdge, leftHandSide, value, pPrecision);
        }
        return pElement;
    }

    private InvariantsState handleAssignment(InvariantsState pElement, CFAEdge pEdge, CExpression pLeftHandSide, NumeralFormula<CompoundInterval> pValue, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        NumeralFormula<CompoundInterval> value = pValue;
        if (pPrecision.getMaximumFormulaDepth() == 0) {
            CompoundInterval v = this.evaluate(pValue, pElement.getEnvironment());
            value = v.isSingleton() ? InvariantsFormulaManager.INSTANCE.asConstant(value.getTypeInfo(), v) : this.allPossibleValues(pLeftHandSide.getExpressionType());
        }
        ExpressionToFormulaVisitor etfv = this.getExpressionToFormulaVisitor(pEdge, pElement);
        MemoryLocationExtractor variableNameExtractor = new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pEdge, pElement.getEnvironment());
        if (pLeftHandSide instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression arraySubscriptExpression = (CArraySubscriptExpression)pLeftHandSide;
            MemoryLocation array = variableNameExtractor.getMemoryLocation(arraySubscriptExpression.getArrayExpression());
            NumeralFormula<CompoundInterval> subscript = arraySubscriptExpression.getSubscriptExpression().accept(etfv);
            return pElement.assignArray(array, subscript, value);
        }
        MemoryLocation varName = variableNameExtractor.getMemoryLocation(pLeftHandSide);
        return pElement.assign(varName, value);
    }

    private NumeralFormula<CompoundInterval> handlePotentialOverflow(InvariantsState pState, NumeralFormula<CompoundInterval> pFormula, CType pType) {
        return ExpressionToFormulaVisitor.handlePotentialOverflow(this.compoundIntervalManagerFactory, pFormula, this.machineModel, pType, pState.getEnvironment());
    }

    private InvariantsState handleReturnStatement(InvariantsState pElement, CReturnStatementEdge pEdge) throws UnrecognizedCodeException {
        if (!pEdge.getExpression().isPresent()) {
            return pElement;
        }
        ExpressionToFormulaVisitor etfv = this.getExpressionToFormulaVisitor(pEdge, pElement);
        Optional<CAssignment> assignment = pEdge.asAssignment();
        if (assignment.isPresent()) {
            CAssignment cAssignment = assignment.orElseThrow();
            NumeralFormula<CompoundInterval> returnedState = cAssignment.getRightHandSide().accept(etfv);
            MemoryLocationExtractor variableNameExtractor = new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pEdge, pElement.getEnvironment());
            CLeftHandSide leftHandSide = cAssignment.getLeftHandSide();
            if (leftHandSide instanceof CArraySubscriptExpression) {
                CArraySubscriptExpression arraySubscriptExpression = (CArraySubscriptExpression)leftHandSide;
                MemoryLocation array = variableNameExtractor.getMemoryLocation(arraySubscriptExpression.getArrayExpression());
                NumeralFormula<CompoundInterval> subscript = arraySubscriptExpression.getSubscriptExpression().accept(etfv);
                return pElement.assignArray(array, subscript, returnedState);
            }
            MemoryLocation varName = variableNameExtractor.getMemoryLocation(leftHandSide);
            return pElement.assign(varName, returnedState);
        }
        NumeralFormula<CompoundInterval> returnedState = pEdge.getExpression().orElseThrow().accept(etfv);
        MemoryLocation returnValueName = MemoryLocation.forDeclaration(pEdge.getSuccessor().getEntryNode().getReturnVariable().get());
        return pElement.assign(returnValueName, returnedState);
    }

    private InvariantsState handleFunctionReturn(InvariantsState pElement, CFunctionReturnEdge pFunctionReturnEdge, InvariantsPrecision pPrecision) throws UnrecognizedCodeException {
        CFunctionSummaryEdge summaryEdge = pFunctionReturnEdge.getSummaryEdge();
        CFunctionCall expression = summaryEdge.getExpression();
        String calledFunctionName = pFunctionReturnEdge.getPredecessor().getFunctionName();
        Optional<CVariableDeclaration> var = pFunctionReturnEdge.getFunctionEntry().getReturnVariable();
        InvariantsState result = pElement;
        if (expression instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement funcExp = (CFunctionCallAssignmentStatement)expression;
            if (var.isPresent()) {
                ExpressionToFormulaVisitor expressionToFormulaVisitor = this.getExpressionToFormulaVisitor(new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, summaryEdge.getFunctionEntry().getFunctionName(), pElement.getEnvironment()), pElement);
                CExpression idExpression = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(new CIdExpression(pFunctionReturnEdge.getFileLocation(), var.orElseThrow()), funcExp.getLeftHandSide().getExpressionType());
                NumeralFormula<CompoundInterval> value = idExpression.accept(expressionToFormulaVisitor);
                result = this.handleAssignment(pElement, pFunctionReturnEdge, funcExp.getLeftHandSide(), value, pPrecision);
            }
        } else {
            Iterator<CExpression> actualParamIterator = summaryEdge.getExpression().getFunctionCallExpression().getParameterExpressions().iterator();
            for (String formalParamName : pFunctionReturnEdge.getPredecessor().getEntryNode().getFunctionParameterNames()) {
                if (!actualParamIterator.hasNext()) break;
                CExpression actualParam = actualParamIterator.next();
                NumeralFormula<CompoundInterval> actualParamFormula = actualParam.accept(this.getExpressionToFormulaVisitor(summaryEdge, pElement));
                if (!(actualParamFormula instanceof Variable)) continue;
                MemoryLocation actualParamName = ((Variable)actualParamFormula).getMemoryLocation();
                String formalParamPrefixDeref = calledFunctionName + "::" + formalParamName + "->";
                String formalParamPrefixAccess = calledFunctionName + "::" + formalParamName + ".";
                for (Map.Entry<MemoryLocation, NumeralFormula<CompoundInterval>> entry : pElement.getEnvironment().entrySet()) {
                    String formalParamSuffix;
                    String varName = entry.getKey().getExtendedQualifiedName();
                    if (varName.startsWith(formalParamPrefixDeref)) {
                        formalParamSuffix = varName.substring(formalParamPrefixDeref.length());
                        result = result.assign(MemoryLocation.parseExtendedQualifiedName(actualParamName + "->" + formalParamSuffix), entry.getValue());
                        continue;
                    }
                    if (!varName.startsWith(formalParamPrefixAccess)) continue;
                    formalParamSuffix = varName.substring(formalParamPrefixAccess.length());
                    result = result.assign(MemoryLocation.parseExtendedQualifiedName(actualParamName + "." + formalParamSuffix), entry.getValue());
                }
            }
        }
        result = result.clearAll((Predicate<MemoryLocation>)((Predicate)pMemoryLocation -> pMemoryLocation.isOnFunctionStack() && pMemoryLocation.getFunctionName().equals(calledFunctionName)));
        return result;
    }

    @Override
    public Collection<? extends AbstractState> strengthen(AbstractState pElement, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws UnrecognizedCodeException {
        InvariantsState state = (InvariantsState)pElement;
        for (AbstractStateWithAssumptions assumptionState : FluentIterable.from(pOtherElements).filter(AbstractStateWithAssumptions.class)) {
            AFunctionDeclaration function = pCfaEdge.getSuccessor().getFunction();
            for (AExpression aExpression : assumptionState.getAssumptions()) {
                AssumeEdge fakeEdge;
                if (aExpression instanceof CExpression) {
                    fakeEdge = new CAssumeEdge(aExpression.toASTString(), FileLocation.DUMMY, new CFANode(function), new CFANode(function), (CExpression)aExpression, true);
                } else if (aExpression instanceof JExpression) {
                    fakeEdge = new JAssumeEdge(aExpression.toASTString(), FileLocation.DUMMY, new CFANode(function), new CFANode(function), (JExpression)aExpression, true);
                } else {
                    throw new AssertionError((Object)("unexpected expression type " + aExpression));
                }
                if ((state = this.handleAssume(state, fakeEdge, this.getExpressionToFormulaVisitor(pCfaEdge, state))) != null) continue;
                return ImmutableSet.of();
            }
        }
        if (this.usePointerAliasStrengthening) {
            return this.pointerAliasStrengthening(pElement, pOtherElements, pCfaEdge, state);
        }
        return Collections.singleton(pElement);
    }

    private Collection<? extends AbstractState> pointerAliasStrengthening(AbstractState pElement, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, InvariantsState state) throws UnrecognizedCodeException {
        CFAEdge edge = pCfaEdge;
        ALeftHandSide leftHandSide = CFAEdgeUtils.getLeftHandSide(edge);
        if (leftHandSide instanceof CPointerExpression || leftHandSide instanceof CFieldReference && ((CFieldReference)leftHandSide).isPointerDereference()) {
            FluentIterable pointerStates = FluentIterable.from(pOtherElements).filter(PointerState.class);
            if (pointerStates.isEmpty()) {
                return Collections.singleton(this.clearAddressedVariables(state));
            }
            InvariantsState result = state;
            for (PointerState pointerState : pointerStates) {
                ExpressionToFormulaVisitor etfv = this.getExpressionToFormulaVisitor(edge, result);
                NumeralFormula<CompoundInterval> rhs = CFAEdgeUtils.getRightHandSide(edge).accept(etfv);
                LocationSet locationSet = PointerTransferRelation.asLocations((CExpression)((Object)leftHandSide), pointerState);
                if (locationSet.isTop()) {
                    return Collections.singleton(this.clearAddressedVariables(state));
                }
                Iterable<MemoryLocation> locations = PointerTransferRelation.toNormalSet(pointerState, locationSet);
                boolean moreThanOneLocation = InvariantsTransferRelation.hasMoreThanNElements(locations, 1);
                for (MemoryLocation location : locations) {
                    boolean hasArrow;
                    int lastIndexOfDot = location.getExtendedQualifiedName().lastIndexOf(46);
                    int lastIndexOfArrow = location.getExtendedQualifiedName().lastIndexOf("->");
                    boolean hasDot = lastIndexOfDot >= 0;
                    boolean bl = hasArrow = lastIndexOfArrow >= 0;
                    if (hasArrow || hasDot) {
                        if (hasArrow) {
                            ++lastIndexOfArrow;
                        }
                        int lastIndexOfSep = Math.max(lastIndexOfDot, lastIndexOfArrow);
                        String end = location.getExtendedQualifiedName().substring(lastIndexOfSep + 1);
                        FluentIterable targets = FluentIterable.from(result.getEnvironment().keySet()).filter(pVar -> pVar.getIdentifier().endsWith("." + end) || pVar.getIdentifier().endsWith("->" + end));
                        if (moreThanOneLocation || InvariantsTransferRelation.hasMoreThanNElements(targets, 1)) {
                            for (MemoryLocation variableName : targets) {
                                Type type = result.getType(variableName);
                                if (type == null) continue;
                                result = result.assign(variableName, this.allPossibleValues(type));
                            }
                            continue;
                        }
                        for (MemoryLocation variableName : targets) {
                            result = result.assign(variableName, rhs);
                        }
                        continue;
                    }
                    if (moreThanOneLocation) {
                        Type type = result.getType(location);
                        if (type == null) continue;
                        result = result.assign(location, this.allPossibleValues(type));
                        continue;
                    }
                    result = result.assign(location, rhs);
                }
            }
            return Collections.singleton(result);
        }
        return Collections.singleton(pElement);
    }

    private InvariantsState clearAddressedVariables(InvariantsState pState) {
        if (!this.variableClassification.isPresent()) {
            return pState.clear();
        }
        VariableClassification varClassification = this.variableClassification.orElseThrow();
        InvariantsState result = pState;
        for (String variable : varClassification.getAddressedVariables()) {
            MemoryLocation location = MemoryLocation.fromQualifiedName(variable);
            Type type = result.getType(location);
            if (type == null) continue;
            result = result.assign(location, this.allPossibleValues(type));
        }
        return result;
    }

    private ExpressionToFormulaVisitor getExpressionToFormulaVisitor(CFAEdge pEdge, InvariantsState pState) {
        return this.getExpressionToFormulaVisitor(new MemoryLocationExtractor(this.compoundIntervalManagerFactory, this.machineModel, pEdge, pState.getEnvironment()), pState);
    }

    private ExpressionToFormulaVisitor getExpressionToFormulaVisitor(MemoryLocationExtractor pVariableNameExtractor, InvariantsState pState) {
        return new ExpressionToFormulaVisitor(this.compoundIntervalManagerFactory, this.machineModel, pVariableNameExtractor, pState.getEnvironment());
    }

    private static boolean containsArrayWildcard(NumeralFormula<CompoundInterval> pFormula) {
        for (MemoryLocation memoryLocation : (Set)pFormula.accept(COLLECT_VARS_VISITOR)) {
            if (!memoryLocation.getIdentifier().contains("[*]")) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMoreThanNElements(Iterable<?> pIterable, int pN) {
        return !Iterables.isEmpty((Iterable)Iterables.skip(pIterable, (int)pN));
    }
}

