/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldAccess;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ExpressionToFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class MemoryLocationExtractor {
    private final String functionName;
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> environment;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final MachineModel machineModel;

    public MemoryLocationExtractor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, CFAEdge pEdge) {
        this(pCompoundIntervalManagerFactory, pMachineModel, pEdge, false, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of());
    }

    public MemoryLocationExtractor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, CFAEdge pEdge, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this(pCompoundIntervalManagerFactory, pMachineModel, pEdge, false, pEnvironment);
    }

    public MemoryLocationExtractor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, CFAEdge pEdge, boolean pUsePredecessorFunctionName, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this(pCompoundIntervalManagerFactory, pMachineModel, pUsePredecessorFunctionName ? pEdge.getPredecessor() : pEdge.getSuccessor(), pEnvironment);
    }

    private MemoryLocationExtractor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, CFANode pFunctionNode, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this(pCompoundIntervalManagerFactory, pMachineModel, pFunctionNode.getFunctionName(), pEnvironment);
    }

    public MemoryLocationExtractor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, String pFunctionName, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.machineModel = pMachineModel;
        this.functionName = pFunctionName;
        this.environment = pEnvironment;
    }

    public MemoryLocation getMemoryLocation(AParameterDeclaration pParameterDeclaration) {
        CSimpleDeclaration decl;
        String varName = pParameterDeclaration.getName();
        if (!(!(pParameterDeclaration instanceof CSimpleDeclaration) || (decl = (CSimpleDeclaration)((Object)pParameterDeclaration)) instanceof CDeclaration && ((CDeclaration)decl).isGlobal() || decl instanceof CEnumType.CEnumerator)) {
            return this.scope(varName);
        }
        return MemoryLocation.parseExtendedQualifiedName(varName);
    }

    public MemoryLocation getMemoryLocation(AExpression pLhs) throws UnrecognizedCodeException {
        if (pLhs instanceof AIdExpression) {
            return this.getMemoryLocation((AIdExpression)pLhs);
        }
        if (pLhs instanceof CFieldReference) {
            CFieldReference fieldRef = (CFieldReference)pLhs;
            String varName = fieldRef.getFieldName();
            CExpression owner = fieldRef.getFieldOwner();
            return this.getFieldReferenceMemoryLocation(varName, owner, fieldRef.isPointerDereference());
        }
        if (pLhs instanceof JFieldAccess) {
            JFieldAccess fieldRef = (JFieldAccess)pLhs;
            String varName = fieldRef.getName();
            JIdExpression owner = fieldRef.getReferencedVariable();
            return this.getFieldReferenceMemoryLocation(varName, owner, false);
        }
        if (pLhs instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression arraySubscript = (CArraySubscriptExpression)pLhs;
            CExpression subscript = arraySubscript.getSubscriptExpression();
            CExpression owner = arraySubscript.getArrayExpression();
            return this.getArraySubscriptMemoryLocation(owner, subscript);
        }
        if (pLhs instanceof JArraySubscriptExpression) {
            JArraySubscriptExpression arraySubscript = (JArraySubscriptExpression)pLhs;
            JExpression subscript = arraySubscript.getSubscriptExpression();
            JExpression owner = arraySubscript.getArrayExpression();
            return this.getArraySubscriptMemoryLocation(owner, subscript);
        }
        if (pLhs instanceof CPointerExpression) {
            CPointerExpression pe = (CPointerExpression)pLhs;
            if (pe.getOperand() instanceof CLeftHandSide) {
                return MemoryLocation.parseExtendedQualifiedName(String.format("*(%s)", this.getMemoryLocation(pe.getOperand())));
            }
            return this.scope(pLhs.toString());
        }
        if (pLhs instanceof CCastExpression) {
            CCastExpression cast = (CCastExpression)pLhs;
            return this.getMemoryLocation(cast.getOperand());
        }
        if (pLhs instanceof JCastExpression) {
            JCastExpression cast = (JCastExpression)pLhs;
            return this.getMemoryLocation(cast.getOperand());
        }
        if (pLhs instanceof CUnaryExpression && ((CUnaryExpression)pLhs).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            return MemoryLocation.parseExtendedQualifiedName(String.format("&(%s)", this.getMemoryLocation(((CUnaryExpression)pLhs).getOperand())));
        }
        return this.scope(pLhs.toString());
    }

    private MemoryLocation getMemoryLocation(AIdExpression pIdExpression) {
        CSimpleDeclaration decl;
        CIdExpression var = (CIdExpression)pIdExpression;
        String varName = var.getName();
        if (!(var.getDeclaration() == null || (decl = var.getDeclaration()) instanceof CDeclaration && ((CDeclaration)decl).isGlobal() || decl instanceof CEnumType.CEnumerator)) {
            return this.scope(varName);
        }
        return MemoryLocation.parseExtendedQualifiedName(varName);
    }

    private MemoryLocation getFieldReferenceMemoryLocation(String pVarName, @Nullable AExpression pOwner, boolean pIsPointerDereference) throws UnrecognizedCodeException {
        Object varName = pVarName;
        if (pOwner != null) {
            varName = this.getMemoryLocation(pOwner) + (pIsPointerDereference ? "->" : ".") + (String)varName;
        }
        return MemoryLocation.fromQualifiedName((String)varName);
    }

    private MemoryLocation getArraySubscriptMemoryLocation(AExpression pOwner, AExpression pSubscript) throws UnrecognizedCodeException {
        if (pSubscript instanceof CIntegerLiteralExpression) {
            CIntegerLiteralExpression literal = (CIntegerLiteralExpression)pSubscript;
            return MemoryLocation.parseExtendedQualifiedName(String.format("%s[%d]", this.getMemoryLocation(pOwner), literal.asLong()));
        }
        ExpressionToFormulaVisitor expressionToFormulaVisitor = new ExpressionToFormulaVisitor(this.compoundIntervalManagerFactory, this.machineModel, this, this.environment);
        CompoundInterval subscriptValue = pSubscript instanceof CExpression ? this.evaluate(((CExpression)pSubscript).accept(expressionToFormulaVisitor)) : (pSubscript instanceof JExpression ? this.evaluate(((JExpression)pSubscript).accept(expressionToFormulaVisitor)) : this.compoundIntervalManagerFactory.createCompoundIntervalManager(this.machineModel, pOwner.getExpressionType()).allPossibleValues());
        if (subscriptValue.isSingleton()) {
            return MemoryLocation.parseExtendedQualifiedName(String.format("%s[%s]", this.getMemoryLocation(pOwner), subscriptValue.getValue()));
        }
        return MemoryLocation.parseExtendedQualifiedName(String.format("%s[*]", this.getMemoryLocation(pOwner)));
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula) {
        return pFormula.accept(new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory, false), this.environment);
    }

    private MemoryLocation scope(String pVar) {
        return MemoryLocationExtractor.scope(pVar, this.functionName);
    }

    public static MemoryLocation scope(String pVar, String pFunction) {
        return MemoryLocation.forLocalVariable(pFunction, pVar);
    }

    public boolean isFunctionScoped(String pScopedVariableName) {
        return MemoryLocationExtractor.isFunctionScoped(pScopedVariableName, this.functionName);
    }

    public static boolean isFunctionScoped(String pScopedVariableName, String pFunction) {
        return pScopedVariableName.startsWith(pFunction + "::");
    }
}

