/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.sosy_lab.common.collect.PathCopyingPersistentTreeMap;
import org.sosy_lab.common.collect.PersistentSortedMap;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsVarVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class NonRecursiveEnvironment
implements Map<MemoryLocation, NumeralFormula<CompoundInterval>> {
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private final PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> inner;
    private final FormulaEvaluationVisitor<CompoundInterval> formulaEvaluationVisitor;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;

    private NonRecursiveEnvironment(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pInner) {
        this(pCompoundIntervalManagerFactory, (PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)PathCopyingPersistentTreeMap.copyOf(pInner));
    }

    private NonRecursiveEnvironment(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> pInner) {
        this.inner = pInner;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.formulaEvaluationVisitor = new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public boolean containsKey(Object pVarName) {
        return this.inner.containsKey(pVarName);
    }

    @Override
    public boolean containsValue(Object pValue) {
        return this.inner.containsValue(pValue);
    }

    @Override
    public NumeralFormula<CompoundInterval> get(Object pVarName) {
        return (NumeralFormula)this.inner.get(pVarName);
    }

    @Override
    @Deprecated
    public NumeralFormula<CompoundInterval> put(MemoryLocation pVarName, NumeralFormula<CompoundInterval> pValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public NumeralFormula<CompoundInterval> remove(Object pKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public void putAll(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pM) {
        throw new UnsupportedOperationException();
    }

    private boolean isConstantAndContainsAllPossibleValues(NumeralFormula<CompoundInterval> pFormula) {
        if (pFormula instanceof Constant) {
            return ((CompoundInterval)((Constant)pFormula).getValue()).containsAllPossibleValues();
        }
        return false;
    }

    private PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> sanitizedInnerPutAndCopy(PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> pTarget, MemoryLocation pMemoryLocation, NumeralFormula<CompoundInterval> pValue) {
        if (pValue == null || this.isConstantAndContainsAllPossibleValues(pValue)) {
            if (pTarget.containsKey((Object)pMemoryLocation)) {
                return pTarget.removeAndCopy((Object)pMemoryLocation);
            }
            return pTarget;
        }
        NumeralFormula previous = (NumeralFormula)pTarget.get((Object)pMemoryLocation);
        if (pValue.equals(previous)) {
            return pTarget;
        }
        pTarget = pTarget.removeAndCopy((Object)pMemoryLocation);
        ContainsVarVisitor containsVarVisitor = new ContainsVarVisitor(pTarget);
        TypeInfo typeInfo = pValue.getTypeInfo();
        if (((Boolean)pValue.accept(containsVarVisitor, pMemoryLocation)).booleanValue()) {
            return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)pTarget, pMemoryLocation, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, (CompoundInterval)pValue.accept(this.formulaEvaluationVisitor, this)));
        }
        Variable variable = InvariantsFormulaManager.INSTANCE.asVariable(typeInfo, pMemoryLocation);
        for (MemoryLocation containedMemoryLocation : (Set)pValue.accept(COLLECT_VARS_VISITOR)) {
            if (!((Boolean)variable.accept(containsVarVisitor, containedMemoryLocation)).booleanValue()) continue;
            return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)pTarget, pMemoryLocation, InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, (CompoundInterval)pValue.accept(this.formulaEvaluationVisitor, this)));
        }
        return this.sanitizedInnerPutAndCopyInternal((PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)pTarget, pMemoryLocation, pValue);
    }

    private PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> sanitizedInnerPutAndCopyInternal(PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> pTarget, MemoryLocation pMemoryLocation, NumeralFormula<CompoundInterval> pValue) {
        if (this.isConstantAndContainsAllPossibleValues(pValue)) {
            return pTarget;
        }
        Preconditions.checkArgument((!pTarget.containsKey((Object)pMemoryLocation) ? 1 : 0) != 0, (Object)"Variable must be TOP in previous environment");
        NumeralFormula previous = (NumeralFormula)pTarget.get((Object)pMemoryLocation);
        if (pValue.equals(previous)) {
            return pTarget;
        }
        return pTarget.putAndCopy((Object)pMemoryLocation, pValue);
    }

    public NonRecursiveEnvironment putAndCopy(MemoryLocation pVarName, NumeralFormula<CompoundInterval> pValue) {
        NumeralFormula<CompoundInterval> previous = this.get(pVarName);
        if (previous == null && pValue == null) {
            return this;
        }
        if (previous == null) {
            previous = this.getAllPossibleValues(pValue);
        }
        if (pValue == null) {
            pValue = this.getAllPossibleValues(previous);
        }
        if (previous.equals(pValue)) {
            return this;
        }
        PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> resultInner = this.sanitizedInnerPutAndCopy(this.inner, pVarName, pValue);
        if (this.inner == resultInner) {
            return this;
        }
        return new NonRecursiveEnvironment(this.compoundIntervalManagerFactory, resultInner);
    }

    public NonRecursiveEnvironment putAndCopyAll(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pM) {
        PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>> resultInner = this.inner;
        for (Map.Entry<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> entry : pM.entrySet()) {
            resultInner = this.sanitizedInnerPutAndCopy(resultInner, entry.getKey(), entry.getValue());
        }
        return new NonRecursiveEnvironment(this.compoundIntervalManagerFactory, resultInner);
    }

    public NonRecursiveEnvironment removeAndCopy(Object pKey) {
        if (!this.containsKey(pKey)) {
            return this;
        }
        return new NonRecursiveEnvironment(this.compoundIntervalManagerFactory, (PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)this.inner.removeAndCopy(pKey));
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NavigableSet<MemoryLocation> keySet() {
        return this.inner.keySet();
    }

    @Override
    public Collection<NumeralFormula<CompoundInterval>> values() {
        return Collections.unmodifiableCollection(this.inner.values());
    }

    @Override
    public NavigableSet<Map.Entry<MemoryLocation, NumeralFormula<CompoundInterval>>> entrySet() {
        return this.inner.entrySet();
    }

    public String toString() {
        return this.inner.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.inner.equals(o);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }

    private NumeralFormula<CompoundInterval> getAllPossibleValues(Typed pTyped) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pTyped.getTypeInfo(), this.compoundIntervalManagerFactory.createCompoundIntervalManager(pTyped.getTypeInfo()).allPossibleValues());
    }

    public static NonRecursiveEnvironment of(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        return new NonRecursiveEnvironment(pCompoundIntervalManagerFactory, (PersistentSortedMap<MemoryLocation, NumeralFormula<CompoundInterval>>)PathCopyingPersistentTreeMap.of());
    }

    public static NonRecursiveEnvironment copyOf(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pInner) {
        if (pInner instanceof NonRecursiveEnvironment && ((NonRecursiveEnvironment)pInner).compoundIntervalManagerFactory.equals(pCompoundIntervalManagerFactory)) {
            return (NonRecursiveEnvironment)pInner;
        }
        return new NonRecursiveEnvironment(pCompoundIntervalManagerFactory, pInner);
    }

    public static class Builder
    implements Map<MemoryLocation, NumeralFormula<CompoundInterval>> {
        private NonRecursiveEnvironment current;

        public Builder(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
            this(NonRecursiveEnvironment.of(pCompoundIntervalManagerFactory));
        }

        public Builder(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pInitialEnvironment) {
            this(NonRecursiveEnvironment.copyOf(pCompoundIntervalManagerFactory, pInitialEnvironment));
        }

        public Builder(NonRecursiveEnvironment pInitialEnvironment) {
            this.current = pInitialEnvironment;
        }

        @Override
        public void clear() {
            this.current = NonRecursiveEnvironment.of(this.current.compoundIntervalManagerFactory);
        }

        @Override
        public boolean containsKey(Object pKey) {
            return this.current.containsKey(pKey);
        }

        @Override
        public boolean containsValue(Object pValue) {
            return this.current.containsValue(pValue);
        }

        @Override
        public Set<Map.Entry<MemoryLocation, NumeralFormula<CompoundInterval>>> entrySet() {
            return this.current.entrySet();
        }

        @Override
        public NumeralFormula<CompoundInterval> get(Object pKey) {
            return this.current.get(pKey);
        }

        @Override
        public boolean isEmpty() {
            return this.current.isEmpty();
        }

        @Override
        public Set<MemoryLocation> keySet() {
            return this.current.keySet();
        }

        @Override
        public NumeralFormula<CompoundInterval> put(MemoryLocation pKey, NumeralFormula<CompoundInterval> pValue) {
            Object result = this.current.get(pKey);
            this.current = this.current.putAndCopy(pKey, pValue);
            return result;
        }

        @Override
        public void putAll(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pM) {
            this.current = this.current.putAndCopyAll(pM);
        }

        @Override
        public NumeralFormula<CompoundInterval> remove(Object pKey) {
            Object result = this.current.get(pKey);
            this.current = this.current.removeAndCopy(pKey);
            return result;
        }

        @Override
        public int size() {
            return this.current.size();
        }

        @Override
        public Collection<NumeralFormula<CompoundInterval>> values() {
            return this.current.values();
        }

        public NonRecursiveEnvironment build() {
            return this.current;
        }

        @Override
        public int hashCode() {
            return this.current.hashCode();
        }

        @Override
        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof Map) {
                return this.current.equals(pOther);
            }
            return false;
        }

        public String toString() {
            return this.current.toString();
        }

        public static Builder of(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pTmpEnvironment) {
            if (pTmpEnvironment instanceof Builder && ((Builder)pTmpEnvironment).current.compoundIntervalManagerFactory.equals(pCompoundIntervalManagerFactory)) {
                return (Builder)pTmpEnvironment;
            }
            return new Builder(pCompoundIntervalManagerFactory, pTmpEnvironment);
        }
    }
}

