/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleInterval {
    private final BigInteger lowerBound;
    private final BigInteger upperBound;
    private static final SimpleInterval INFINITE = new SimpleInterval(null, null);

    private SimpleInterval(@Nullable BigInteger pLowerBound, @Nullable BigInteger pUpperBound) {
        Preconditions.checkArgument((pLowerBound == null || pUpperBound == null || pLowerBound.compareTo(pUpperBound) <= 0 ? 1 : 0) != 0, (Object)"lower endpoint greater than upper end point");
        this.lowerBound = pLowerBound;
        this.upperBound = pUpperBound;
    }

    public BigInteger getLowerBound() {
        Preconditions.checkState((this.lowerBound != null ? 1 : 0) != 0);
        return this.lowerBound;
    }

    public BigInteger getUpperBound() {
        Preconditions.checkState((this.upperBound != null ? 1 : 0) != 0);
        return this.upperBound;
    }

    public boolean isTop() {
        return this.upperBound == null && this.lowerBound == null;
    }

    public SimpleInterval intersectWith(SimpleInterval pOther) {
        Preconditions.checkArgument((boolean)this.intersectsWith(pOther));
        if (this.isSingleton() || pOther.contains(this)) {
            return this;
        }
        if (pOther.isSingleton() || this.contains(pOther)) {
            return pOther;
        }
        BigInteger newLowerBound = this.lowerBound;
        if (pOther.hasLowerBound()) {
            BigInteger otherLowerBound = pOther.getLowerBound();
            newLowerBound = newLowerBound == null ? otherLowerBound : newLowerBound.max(otherLowerBound);
        }
        BigInteger newUpperBound = this.upperBound;
        if (pOther.hasUpperBound()) {
            BigInteger otherUpperBound = pOther.getUpperBound();
            newUpperBound = newUpperBound == null ? otherUpperBound : newUpperBound.min(otherUpperBound);
        }
        return new SimpleInterval(newLowerBound, newUpperBound);
    }

    public boolean hasLowerBound() {
        return this.lowerBound != null;
    }

    public boolean hasUpperBound() {
        return this.upperBound != null;
    }

    public boolean containsPositive() {
        return this.upperBound == null || this.upperBound.signum() == 1;
    }

    public boolean containsZero() {
        return !(this.upperBound != null && this.upperBound.signum() < 0 || this.lowerBound != null && this.lowerBound.signum() > 0);
    }

    public boolean contains(BigInteger pValue) {
        return !(this.upperBound != null && this.upperBound.compareTo(pValue) < 0 || this.lowerBound != null && this.lowerBound.compareTo(pValue) > 0);
    }

    public boolean containsNegative() {
        return this.lowerBound == null || this.lowerBound.signum() == -1;
    }

    public @Nullable BigInteger size() {
        if (this.hasLowerBound() && this.hasUpperBound()) {
            return this.upperBound.subtract(this.lowerBound).add(BigInteger.ONE);
        }
        return null;
    }

    public boolean isSingleton() {
        return this.hasLowerBound() && this.lowerBound.equals(this.upperBound);
    }

    public SimpleInterval negate() {
        BigInteger newLowerBound;
        BigInteger newUpperBound = this.lowerBound == null ? null : this.lowerBound.negate();
        BigInteger bigInteger = newLowerBound = this.upperBound == null ? null : this.upperBound.negate();
        if (newLowerBound == null && newUpperBound == null) {
            return SimpleInterval.infinite();
        }
        return new SimpleInterval(newLowerBound, newUpperBound);
    }

    public SimpleInterval extendToPositiveInfinity() {
        if (this.lowerBound == null) {
            return SimpleInterval.infinite();
        }
        if (this.upperBound == null) {
            return this;
        }
        return new SimpleInterval(this.lowerBound, null);
    }

    public SimpleInterval extendToNegativeInfinity() {
        if (this.upperBound == null) {
            return SimpleInterval.infinite();
        }
        if (this.lowerBound == null) {
            return this;
        }
        return new SimpleInterval(null, this.upperBound);
    }

    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (!(pObj instanceof SimpleInterval)) {
            return false;
        }
        SimpleInterval other = (SimpleInterval)pObj;
        return Objects.equals(this.lowerBound, other.lowerBound) && Objects.equals(this.upperBound, other.upperBound);
    }

    public int hashCode() {
        return Objects.hash(this.lowerBound, this.upperBound);
    }

    public String toString() {
        Object result = this.lowerBound == null ? "(-INF, " : "[" + this.lowerBound + ", ";
        result = this.upperBound == null ? (String)result + "INF)" : (String)result + this.upperBound + "]";
        return result;
    }

    public boolean contains(SimpleInterval other) {
        if (this == other) {
            return true;
        }
        if (this.lowerBound != null && other.lowerBound == null) {
            return false;
        }
        if (this.upperBound != null && other.upperBound == null) {
            return false;
        }
        return !(this.lowerBound != null && this.lowerBound.compareTo(other.lowerBound) > 0 || this.upperBound != null && this.upperBound.compareTo(other.upperBound) < 0);
    }

    public boolean touches(SimpleInterval pOther) {
        if (pOther == null) {
            return false;
        }
        if (this.intersectsWith(pOther)) {
            return true;
        }
        return this.lowerBound != null && pOther.upperBound != null && pOther.upperBound.add(BigInteger.ONE).equals(this.lowerBound) || pOther.lowerBound != null && this.upperBound != null && this.upperBound.add(BigInteger.ONE).equals(pOther.lowerBound);
    }

    public boolean intersectsWith(SimpleInterval other) {
        if (this == other) {
            return true;
        }
        if (this.lowerBound == null) {
            if (this.upperBound == null || other.lowerBound == null) {
                return true;
            }
            return this.upperBound.compareTo(other.lowerBound) >= 0;
        }
        if (this.upperBound == null) {
            if (other.upperBound == null) {
                return true;
            }
            return this.lowerBound.compareTo(other.upperBound) <= 0;
        }
        if (other.lowerBound == null && other.upperBound == null) {
            return true;
        }
        if (other.lowerBound == null) {
            return this.lowerBound.compareTo(other.upperBound) <= 0;
        }
        if (other.upperBound == null) {
            return this.upperBound.compareTo(other.lowerBound) >= 0;
        }
        boolean aLessThanOrEqB = this.lowerBound.compareTo(other.upperBound) <= 0;
        boolean bGreaterThanOrEqC = this.upperBound.compareTo(other.lowerBound) >= 0;
        return aLessThanOrEqB && bGreaterThanOrEqC;
    }

    public BigInteger closestNegativeToZero() {
        Preconditions.checkState((boolean)this.containsNegative());
        if (this.isSingleton()) {
            return this.getLowerBound();
        }
        if (this.hasUpperBound() && this.getUpperBound().signum() < 0) {
            return this.getUpperBound();
        }
        return BigInteger.ONE.negate();
    }

    public BigInteger closestPositiveToZero() {
        Preconditions.checkState((boolean)this.containsPositive());
        if (this.isSingleton()) {
            return this.getLowerBound();
        }
        if (this.hasLowerBound() && this.getLowerBound().signum() > 0) {
            return this.getLowerBound();
        }
        return BigInteger.ONE;
    }

    public static SimpleInterval infinite() {
        return INFINITE;
    }

    public static SimpleInterval singleton(BigInteger i) {
        return new SimpleInterval((BigInteger)Preconditions.checkNotNull((Object)i), i);
    }

    public static SimpleInterval greaterOrEqual(BigInteger i) {
        return new SimpleInterval((BigInteger)Preconditions.checkNotNull((Object)i), null);
    }

    public static SimpleInterval lessOrEqual(BigInteger i) {
        return new SimpleInterval(null, (BigInteger)Preconditions.checkNotNull((Object)i));
    }

    public static SimpleInterval of(BigInteger lowerBound, BigInteger upperBound) {
        return new SimpleInterval((BigInteger)Preconditions.checkNotNull((Object)lowerBound), (BigInteger)Preconditions.checkNotNull((Object)upperBound));
    }

    public static SimpleInterval span(SimpleInterval a, SimpleInterval b) {
        BigInteger lower = a.lowerBound == null || b.lowerBound == null ? null : a.lowerBound.min(b.lowerBound);
        BigInteger upper = a.upperBound == null || b.upperBound == null ? null : a.upperBound.max(b.upperBound);
        if (Objects.equals(lower, a.lowerBound) && Objects.equals(upper, a.upperBound)) {
            return a;
        }
        if (Objects.equals(lower, b.lowerBound) && Objects.equals(upper, b.upperBound)) {
            return b;
        }
        return new SimpleInterval(lower, upper);
    }
}

