/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;

public class SimpleIntervalTest {
    @Test
    public void testConstruction() {
        Truth.assertThat((Object)SimpleInterval.singleton(BigInteger.ZERO)).isNotNull();
        Truth.assertThat((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.lessOrEqual(BigInteger.ZERO)).isNotNull();
        Truth.assertThat((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.greaterOrEqual(BigInteger.ZERO)).isNotNull();
        Truth.assertThat((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE))).isNotNull();
        Truth.assertThat((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO)).isNotNull();
        Truth.assertThat((Object)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE)).isNotNull();
        Truth.assertThat((Object)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE))).isNotNull();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction1() {
        SimpleInterval.of(BigInteger.ONE, BigInteger.ZERO);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidConstruction2() {
        SimpleInterval.of(BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(Long.MIN_VALUE));
    }

    @Test
    public void testContains() {
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.ZERO).contains(BigInteger.ZERO)).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.TEN).contains(BigInteger.TEN)).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.ZERO).contains(BigInteger.TEN)).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.TEN).contains(BigInteger.ZERO)).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.ONE)).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.TEN)).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(5L))).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.ZERO)).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(-5L))).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).contains(BigInteger.valueOf(-10L))).isFalse();
    }

    @Test
    public void testIsSingleton() {
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.ZERO).isSingleton()).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton()).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton()).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.lessOrEqual(BigInteger.ZERO).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.greaterOrEqual(BigInteger.ZERO).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).isSingleton()).isTrue();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).isSingleton()).isFalse();
        Truth.assertThat((Boolean)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).isSingleton()).isFalse();
    }

    @Test
    public void testSize() {
        Truth.assertThat((Comparable)SimpleInterval.singleton(BigInteger.ZERO).size()).isEqualTo((Object)BigInteger.ONE);
        Truth.assertThat((Comparable)SimpleInterval.singleton(BigInteger.valueOf(Long.MAX_VALUE)).size()).isEqualTo((Object)BigInteger.ONE);
        Truth.assertThat((Comparable)SimpleInterval.singleton(BigInteger.valueOf(Long.MIN_VALUE)).size()).isEqualTo((Object)BigInteger.ONE);
        Truth.assertThat((Comparable)SimpleInterval.lessOrEqual(BigInteger.ZERO).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.lessOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.greaterOrEqual(BigInteger.ZERO).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MAX_VALUE)).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.greaterOrEqual(BigInteger.valueOf(Long.MIN_VALUE)).size()).isNull();
        Truth.assertThat((Comparable)SimpleInterval.of(BigInteger.ZERO, BigInteger.ZERO).size()).isEqualTo((Object)BigInteger.ONE);
        Truth.assertThat((Comparable)SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE).size()).isEqualTo((Object)BigInteger.valueOf(2L));
        Truth.assertThat((Comparable)SimpleInterval.of(BigInteger.ONE, BigInteger.TEN).size()).isEqualTo((Object)BigInteger.TEN);
        Truth.assertThat((Comparable)SimpleInterval.of(BigInteger.valueOf(-100L), BigInteger.valueOf(100L)).size()).isEqualTo((Object)BigInteger.valueOf(201L));
        Truth.assertThat((Comparable)SimpleInterval.of(BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(Long.MAX_VALUE)).size()).isEqualTo((Object)BigInteger.valueOf(Long.MAX_VALUE).subtract(BigInteger.valueOf(Long.MIN_VALUE)).add(BigInteger.ONE));
    }

    @Test
    public void testIntersectsWith() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        SimpleInterval two = SimpleInterval.singleton(BigInteger.valueOf(2L));
        SimpleInterval negFiveToTen = SimpleInterval.of(BigInteger.valueOf(-5L), BigInteger.TEN);
        SimpleInterval fiveToFifteen = SimpleInterval.of(BigInteger.valueOf(5L), BigInteger.valueOf(15L));
        SimpleInterval twentyToFifty = SimpleInterval.of(BigInteger.valueOf(20L), BigInteger.valueOf(50L));
        SimpleInterval oneToThousand = SimpleInterval.of(BigInteger.ONE, BigInteger.valueOf(1000L));
        Truth.assertThat((Boolean)zero.intersectsWith(one)).isFalse();
        Truth.assertThat((Boolean)one.intersectsWith(zero)).isFalse();
        Truth.assertThat((Boolean)zero.intersectsWith(zero)).isTrue();
        Truth.assertThat((Boolean)one.intersectsWith(one)).isTrue();
        Truth.assertThat((Boolean)zero.extendToNegativeInfinity().intersectsWith(zero.extendToPositiveInfinity())).isTrue();
        Truth.assertThat((Boolean)one.extendToNegativeInfinity().intersectsWith(one.extendToPositiveInfinity())).isTrue();
        Truth.assertThat((Boolean)zero.extendToNegativeInfinity().intersectsWith(one.extendToPositiveInfinity())).isFalse();
        Truth.assertThat((Boolean)one.extendToPositiveInfinity().intersectsWith(zero.extendToNegativeInfinity())).isFalse();
        Truth.assertThat((Boolean)one.extendToNegativeInfinity().intersectsWith(zero.extendToPositiveInfinity())).isTrue();
        Truth.assertThat((Boolean)zero.extendToPositiveInfinity().intersectsWith(one.extendToNegativeInfinity())).isTrue();
        Truth.assertThat((Boolean)negFiveToTen.intersectsWith(fiveToFifteen)).isTrue();
        Truth.assertThat((Boolean)negFiveToTen.intersectsWith(twentyToFifty)).isFalse();
        Truth.assertThat((Boolean)fiveToFifteen.intersectsWith(twentyToFifty)).isFalse();
        Truth.assertThat((Boolean)oneToThousand.intersectsWith(two)).isTrue();
    }
}

