/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cpa.invariants.formula.AbstractFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;

abstract class AbstractBinaryFormula<ConstantType>
extends AbstractFormula<ConstantType> {
    private final NumeralFormula<ConstantType> operand1;
    private final NumeralFormula<ConstantType> operand2;
    private final String operator;
    private final boolean isCommutative;

    AbstractBinaryFormula(String pOperator, boolean pIsCommutative, NumeralFormula<ConstantType> pOperand1, NumeralFormula<ConstantType> pOperand2) {
        super(pOperand1.getTypeInfo());
        Preconditions.checkNotNull((Object)pOperator);
        Preconditions.checkArgument((boolean)pOperand1.getTypeInfo().equals(pOperand2.getTypeInfo()));
        this.operator = pOperator;
        this.isCommutative = pIsCommutative;
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
    }

    public NumeralFormula<ConstantType> getOperand1() {
        return this.operand1;
    }

    public NumeralFormula<ConstantType> getOperand2() {
        return this.operand2;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (this.getClass().equals(o.getClass())) {
            AbstractBinaryFormula other = (AbstractBinaryFormula)o;
            if (!this.getTypeInfo().equals(other.getTypeInfo())) {
                return false;
            }
            if (this.operator.equals(other.operator) && this.isCommutative == other.isCommutative) {
                if (this.isCommutative) {
                    return this.getOperand1().equals(other.getOperand1()) && this.getOperand2().equals(other.getOperand2()) || this.getOperand1().equals(other.getOperand2()) && this.getOperand2().equals(other.getOperand1());
                }
                return this.getOperand1().equals(other.getOperand1()) && this.getOperand2().equals(other.getOperand2());
            }
        }
        return false;
    }

    public final int hashCode() {
        return 31 * this.operator.hashCode() + this.getOperand1().hashCode() * this.getOperand2().hashCode() + 43 * this.getTypeInfo().hashCode();
    }

    public String toString() {
        return String.format("(%s %s %s)", this.getOperand1(), this.operator, this.getOperand2());
    }
}

