/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;

public class BooleanConstant<ConstantType>
implements BooleanFormula<ConstantType> {
    private static final BooleanConstant<?> FALSE = new BooleanConstant(false);
    private static final BooleanConstant<?> TRUE = new BooleanConstant(true);
    private final boolean value;

    private BooleanConstant(boolean pValue) {
        this.value = pValue;
    }

    boolean getValue() {
        return this.value;
    }

    public boolean equals(Object pOther) {
        assert (this == pOther && pOther instanceof BooleanConstant && this.value == ((BooleanConstant)pOther).value || this != pOther && (!(pOther instanceof BooleanConstant) || this.value != ((BooleanConstant)pOther).value));
        return this == pOther;
    }

    public int hashCode() {
        return this.value ? 0 : 1;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    public BooleanConstant<CompoundInterval> negate() {
        return BooleanConstant.fromBool(!this.value);
    }

    @Override
    public <ReturnType> ReturnType accept(BooleanFormulaVisitor<ConstantType, ReturnType> pVisitor) {
        return this.value ? pVisitor.visitTrue() : pVisitor.visitFalse();
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedBooleanFormulaVisitor<ConstantType, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return this.value ? pVisitor.visitTrue(pParameter) : pVisitor.visitFalse(pParameter);
    }

    public static <ConstantType> BooleanConstant<ConstantType> fromBool(boolean pBoolean) {
        return pBoolean ? BooleanConstant.getTrue() : BooleanConstant.getFalse();
    }

    public static <ConstantType> BooleanConstant<ConstantType> getFalse() {
        return FALSE;
    }

    public static <ConstantType> BooleanConstant<ConstantType> getTrue() {
        return TRUE;
    }

    public static boolean isTrue(BooleanFormula<?> pConstant) {
        return TRUE.equals(pConstant);
    }

    public static boolean isFalse(BooleanFormula<?> pConstant) {
        return FALSE.equals(pConstant);
    }
}

