/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class CollectFormulasVisitor<T>
implements NumeralFormulaVisitor<T, Set<NumeralFormula<T>>>,
BooleanFormulaVisitor<T, Set<NumeralFormula<T>>> {
    private final Predicate<? super NumeralFormula<T>> condition;

    public CollectFormulasVisitor(Predicate<? super NumeralFormula<T>> pCondition) {
        this.condition = pCondition;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Add<T> pAdd) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pAdd.getSummand1().accept(this), (Set)pAdd.getSummand2().accept(this));
        if (this.condition.apply(pAdd)) {
            result = CollectFormulasVisitor.add(result, pAdd);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(BinaryAnd<T> pAnd) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
        if (this.condition.apply(pAnd)) {
            result = CollectFormulasVisitor.add(result, pAnd);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(BinaryNot<T> pNot) {
        Set<BinaryNot<T>> result = (Set<BinaryNot<T>>)pNot.getFlipped().accept(this);
        if (this.condition.apply(pNot)) {
            result = CollectFormulasVisitor.add(result, pNot);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(BinaryOr<T> pOr) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pOr.getOperand1().accept(this), (Set)pOr.getOperand2().accept(this));
        if (this.condition.apply(pOr)) {
            result = CollectFormulasVisitor.add(result, pOr);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(BinaryXor<T> pXor) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pXor.getOperand1().accept(this), (Set)pXor.getOperand2().accept(this));
        if (this.condition.apply(pXor)) {
            result = CollectFormulasVisitor.add(result, pXor);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Constant<T> pConstant) {
        if (this.condition.apply(pConstant)) {
            return Collections.singleton(pConstant);
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<NumeralFormula<T>> visit(Divide<T> pDivide) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pDivide.getNumerator().accept(this), (Set)pDivide.getDenominator().accept(this));
        if (this.condition.apply(pDivide)) {
            result = CollectFormulasVisitor.add(result, pDivide);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Equal<T> pEqual) {
        return CollectFormulasVisitor.concat((Set)pEqual.getOperand1().accept(this), (Set)pEqual.getOperand2().accept(this));
    }

    @Override
    public Set<NumeralFormula<T>> visit(Exclusion<T> pExclusion) {
        Set<Exclusion<T>> result = (Set<Exclusion<T>>)pExclusion.getExcluded().accept(this);
        if (this.condition.apply(pExclusion)) {
            result = CollectFormulasVisitor.add(result, pExclusion);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(LessThan<T> pLessThan) {
        return CollectFormulasVisitor.concat((Set)pLessThan.getOperand1().accept(this), (Set)pLessThan.getOperand2().accept(this));
    }

    @Override
    public Set<NumeralFormula<T>> visit(LogicalAnd<T> pAnd) {
        return CollectFormulasVisitor.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
    }

    @Override
    public Set<NumeralFormula<T>> visit(LogicalNot<T> pNot) {
        return (Set)pNot.getNegated().accept(this);
    }

    @Override
    public Set<NumeralFormula<T>> visit(Modulo<T> pModulo) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pModulo.getNumerator().accept(this), (Set)pModulo.getDenominator().accept(this));
        if (this.condition.apply(pModulo)) {
            result = CollectFormulasVisitor.add(result, pModulo);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Multiply<T> pMultiply) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pMultiply.getFactor1().accept(this), (Set)pMultiply.getFactor2().accept(this));
        if (this.condition.apply(pMultiply)) {
            result = CollectFormulasVisitor.add(result, pMultiply);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(ShiftLeft<T> pShiftLeft) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pShiftLeft.getShifted().accept(this), (Set)pShiftLeft.getShiftDistance().accept(this));
        if (this.condition.apply(pShiftLeft)) {
            result = CollectFormulasVisitor.add(result, pShiftLeft);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(ShiftRight<T> pShiftRight) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pShiftRight.getShifted().accept(this), (Set)pShiftRight.getShiftDistance().accept(this));
        if (this.condition.apply(pShiftRight)) {
            result = CollectFormulasVisitor.add(result, pShiftRight);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Union<T> pUnion) {
        Set<NumeralFormula<T>> result = CollectFormulasVisitor.concat((Set)pUnion.getOperand1().accept(this), (Set)pUnion.getOperand2().accept(this));
        if (this.condition.apply(pUnion)) {
            result = CollectFormulasVisitor.add(result, pUnion);
        }
        return result;
    }

    @Override
    public Set<NumeralFormula<T>> visit(Variable<T> pVariable) {
        if (this.condition.apply(pVariable)) {
            return Collections.singleton(pVariable);
        }
        return ImmutableSet.of();
    }

    @Override
    public Set<NumeralFormula<T>> visitFalse() {
        return ImmutableSet.of();
    }

    @Override
    public Set<NumeralFormula<T>> visitTrue() {
        return ImmutableSet.of();
    }

    @Override
    public Set<NumeralFormula<T>> visit(IfThenElse<T> pIfThenElse) {
        return CollectFormulasVisitor.concat((Set)pIfThenElse.getCondition().accept(this), CollectFormulasVisitor.concat((Set)pIfThenElse.getPositiveCase().accept(this), (Set)pIfThenElse.getNegativeCase().accept(this)));
    }

    @Override
    public Set<NumeralFormula<T>> visit(Cast<T> pCast) {
        return (Set)pCast.getCasted().accept(this);
    }

    private static <T> Set<T> add(Set<T> pSet, T pElement) {
        return CollectFormulasVisitor.concat(pSet, Collections.singleton(pElement));
    }

    private static <T> Set<T> concat(Set<T> a, Set<T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        if (a.size() == 1 && b.size() == 1) {
            LinkedHashSet<T> result = new LinkedHashSet<T>(a);
            result.addAll(b);
            return result;
        }
        if (a.size() == 1) {
            b.addAll(a);
            return b;
        }
        if (b.size() == 1) {
            a.addAll(b);
            return a;
        }
        a.addAll(b);
        return a;
    }
}

