/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class CollectVarsVisitor<T>
implements NumeralFormulaVisitor<T, Set<MemoryLocation>>,
BooleanFormulaVisitor<T, Set<MemoryLocation>> {
    @Override
    public Set<MemoryLocation> visit(Add<T> pAdd) {
        return CollectVarsVisitor.concat((Set)pAdd.getSummand1().accept(this), (Set)pAdd.getSummand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(BinaryAnd<T> pAnd) {
        return CollectVarsVisitor.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(BinaryNot<T> pNot) {
        return (Set)pNot.getFlipped().accept(this);
    }

    @Override
    public Set<MemoryLocation> visit(BinaryOr<T> pOr) {
        return CollectVarsVisitor.concat((Set)pOr.getOperand1().accept(this), (Set)pOr.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(BinaryXor<T> pXor) {
        return CollectVarsVisitor.concat((Set)pXor.getOperand1().accept(this), (Set)pXor.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Constant<T> pConstant) {
        return ImmutableSet.of();
    }

    @Override
    public Set<MemoryLocation> visit(Divide<T> pDivide) {
        return CollectVarsVisitor.concat((Set)pDivide.getNumerator().accept(this), (Set)pDivide.getDenominator().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Equal<T> pEqual) {
        return CollectVarsVisitor.concat((Set)pEqual.getOperand1().accept(this), (Set)pEqual.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Exclusion<T> pExclusion) {
        return (Set)pExclusion.getExcluded().accept(this);
    }

    @Override
    public Set<MemoryLocation> visit(LessThan<T> pLessThan) {
        return CollectVarsVisitor.concat((Set)pLessThan.getOperand1().accept(this), (Set)pLessThan.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(LogicalAnd<T> pAnd) {
        return CollectVarsVisitor.concat((Set)pAnd.getOperand1().accept(this), (Set)pAnd.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(LogicalNot<T> pNot) {
        return (Set)pNot.getNegated().accept(this);
    }

    @Override
    public Set<MemoryLocation> visit(Modulo<T> pModulo) {
        return CollectVarsVisitor.concat((Set)pModulo.getNumerator().accept(this), (Set)pModulo.getDenominator().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Multiply<T> pMultiply) {
        return CollectVarsVisitor.concat((Set)pMultiply.getFactor1().accept(this), (Set)pMultiply.getFactor2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(ShiftLeft<T> pShiftLeft) {
        return CollectVarsVisitor.concat((Set)pShiftLeft.getShifted().accept(this), (Set)pShiftLeft.getShiftDistance().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(ShiftRight<T> pShiftRight) {
        return CollectVarsVisitor.concat((Set)pShiftRight.getShifted().accept(this), (Set)pShiftRight.getShiftDistance().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Union<T> pUnion) {
        return CollectVarsVisitor.concat((Set)pUnion.getOperand1().accept(this), (Set)pUnion.getOperand2().accept(this));
    }

    @Override
    public Set<MemoryLocation> visit(Variable<T> pVariable) {
        return Collections.singleton(pVariable.getMemoryLocation());
    }

    @Override
    public Set<MemoryLocation> visitFalse() {
        return ImmutableSet.of();
    }

    @Override
    public Set<MemoryLocation> visitTrue() {
        return ImmutableSet.of();
    }

    @Override
    public Set<MemoryLocation> visit(IfThenElse<T> pIfThenElse) {
        return CollectVarsVisitor.concat((Set)pIfThenElse.getCondition().accept(this), CollectVarsVisitor.concat((Set)pIfThenElse.getPositiveCase().accept(this), (Set)pIfThenElse.getNegativeCase().accept(this)));
    }

    @Override
    public Set<MemoryLocation> visit(Cast<T> pCast) {
        return (Set)pCast.getCasted().accept(this);
    }

    private static <T> Set<T> concat(Set<T> a, Set<T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.equals(b)) {
            return a;
        }
        if (a.size() == 1 && b.size() == 1) {
            LinkedHashSet<T> result = new LinkedHashSet<T>(a);
            result.addAll(b);
            return result;
        }
        if (a.size() == 1) {
            b.addAll(a);
            return b;
        }
        if (b.size() == 1) {
            a.addAll(b);
            return a;
        }
        a.addAll(b);
        return a;
    }
}

