/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CollectVarsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ContainsOnlyEnvInfoVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushAssumptionToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitConjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.SplitDisjunctionsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.StateEqualsVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class CompoundIntervalFormulaManager {
    private static final ImmutableMap<MemoryLocation, NumeralFormula<CompoundInterval>> EMPTY_ENVIRONMENT = ImmutableMap.of();
    private static final CollectVarsVisitor<CompoundInterval> COLLECT_VARS_VISITOR = new CollectVarsVisitor();
    private static final ContainsOnlyEnvInfoVisitor<CompoundInterval> CONTAINS_ONLY_ENV_INFO_VISITOR = new ContainsOnlyEnvInfoVisitor();
    private static final SplitConjunctionsVisitor<CompoundInterval> SPLIT_CONJUNCTIONS_VISITOR = new SplitConjunctionsVisitor();
    private static final SplitDisjunctionsVisitor<CompoundInterval> SPLIT_DISJUNCTIONS_VISITOR = new SplitDisjunctionsVisitor();
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final PartialEvaluator partialEvaluator;

    public CompoundIntervalFormulaManager(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.evaluationVisitor = new FormulaCompoundStateEvaluationVisitor(pCompoundIntervalManagerFactory);
        this.partialEvaluator = new PartialEvaluator(this.compoundIntervalManagerFactory, this);
    }

    CompoundIntervalManagerFactory getCompoundIntervalManagerFactory() {
        return this.compoundIntervalManagerFactory;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof CompoundIntervalFormulaManager) {
            CompoundIntervalFormulaManager other = (CompoundIntervalFormulaManager)pObj;
            return this.compoundIntervalManagerFactory.equals(other.compoundIntervalManagerFactory) && this.evaluationVisitor.equals(other.evaluationVisitor) && this.partialEvaluator.equals(other.partialEvaluator);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.compoundIntervalManagerFactory, this.evaluationVisitor, this.partialEvaluator);
    }

    public static Set<MemoryLocation> collectVariableNames(NumeralFormula<CompoundInterval> pFormula) {
        return (Set)pFormula.accept(COLLECT_VARS_VISITOR);
    }

    public static Set<MemoryLocation> collectVariableNames(BooleanFormula<CompoundInterval> pFormula) {
        return (Set)pFormula.accept(COLLECT_VARS_VISITOR);
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula) {
        return this.evaluate(pFormula, false);
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula, boolean pDisableOverflowCheck) {
        return (CompoundInterval)pFormula.accept(this.getEvaluationVisitor(pDisableOverflowCheck), EMPTY_ENVIRONMENT);
    }

    private FormulaEvaluationVisitor<CompoundInterval> getEvaluationVisitor(boolean pDisableOverflowCheck) {
        if (pDisableOverflowCheck) {
            return new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory, false);
        }
        return this.evaluationVisitor;
    }

    private boolean isDefinitelyTrue(NumeralFormula<CompoundInterval> pFormula) {
        if (this.evaluate(pFormula, true).isDefinitelyTrue()) {
            return true;
        }
        return this.isDefinitelyTrue(this.fromNumeral(pFormula));
    }

    private boolean isDefinitelyTrue(BooleanFormula<CompoundInterval> pFormula) {
        return BooleanConstant.isTrue(pFormula) || this.definitelyImplies(Collections.singleton(BooleanConstant.getTrue()), pFormula, true);
    }

    private boolean isDefinitelyFalse(NumeralFormula<CompoundInterval> pFormula) {
        return this.evaluate(pFormula, true).isDefinitelyFalse();
    }

    private boolean isDefinitelyFalse(BooleanFormula<CompoundInterval> pFormula) {
        return BooleanConstant.isFalse(pFormula) || this.isDefinitelyFalse(this.fromBoolean(BitVectorInfo.from(1, false), pFormula));
    }

    public boolean isDefinitelyBottom(NumeralFormula<CompoundInterval> pFormula) {
        return this.evaluate(pFormula, true).isBottom();
    }

    public boolean containsAllPossibleValues(NumeralFormula<CompoundInterval> pFormula) {
        return pFormula instanceof Constant && ((CompoundInterval)((Constant)pFormula).getValue()).containsAllPossibleValues();
    }

    public boolean definitelyImplies(Iterable<BooleanFormula<CompoundInterval>> pFormulas, BooleanFormula<CompoundInterval> pFormula) {
        return this.definitelyImplies(pFormulas, pFormula, new HashMap<MemoryLocation, NumeralFormula<CompoundInterval>>(), false);
    }

    private boolean definitelyImplies(Iterable<BooleanFormula<CompoundInterval>> pFormulas, BooleanFormula<CompoundInterval> pFormula, boolean pOverflowCheck) {
        return this.definitelyImplies(pFormulas, pFormula, new HashMap<MemoryLocation, NumeralFormula<CompoundInterval>>(), pOverflowCheck);
    }

    private boolean definitelyImplies(Iterable<BooleanFormula<CompoundInterval>> pFormulas, BooleanFormula<CompoundInterval> pFormula, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pBaseEnvironment, boolean pDisableOverflowCheck) {
        HashMap<MemoryLocation, NumeralFormula<CompoundInterval>> newMap = new HashMap<MemoryLocation, NumeralFormula<CompoundInterval>>(pBaseEnvironment);
        if (pFormula instanceof Collection) {
            return this.definitelyImplies((Collection)pFormulas, pFormula, true, newMap, false, pDisableOverflowCheck);
        }
        return this.definitelyImplies((Collection<BooleanFormula<CompoundInterval>>)ImmutableSet.copyOf(pFormulas), pFormula, true, newMap, false, pDisableOverflowCheck);
    }

    private boolean definitelyImplies(Collection<BooleanFormula<CompoundInterval>> pInformationBaseFormulas, BooleanFormula<CompoundInterval> pFormula, boolean pExtend, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pInformationBaseEnvironment, boolean pEnvironmentComplete, boolean pDisableOverflowCheck) {
        Collection<BooleanFormula<CompoundInterval>> formulas;
        if (pExtend) {
            formulas = new HashSet<BooleanFormula<CompoundInterval>>();
            for (BooleanFormula<CompoundInterval> formula : pInformationBaseFormulas) {
                for (BooleanFormula booleanFormula : (List)formula.accept(SPLIT_CONJUNCTIONS_VISITOR)) {
                    formulas.add(booleanFormula.accept(this.partialEvaluator, this.getEvaluationVisitor(pDisableOverflowCheck)));
                }
            }
        } else {
            formulas = pInformationBaseFormulas;
        }
        for (BooleanFormula<CompoundInterval> formula : formulas) {
            Collection disjunctions = (Collection)formula.accept(SPLIT_DISJUNCTIONS_VISITOR);
            if (disjunctions.size() <= 1) continue;
            ArrayList<BooleanFormula<CompoundInterval>> arrayList = new ArrayList<BooleanFormula<CompoundInterval>>(formulas);
            HashMap<MemoryLocation, NumeralFormula<CompoundInterval>> newBaseEnvironment = new HashMap<MemoryLocation, NumeralFormula<CompoundInterval>>(pInformationBaseEnvironment);
            arrayList.remove(formula);
            for (BooleanFormula disjunctivePart : disjunctions) {
                Collection conjunctivePartsOfDisjunctivePart = (Collection)disjunctivePart.accept(SPLIT_CONJUNCTIONS_VISITOR);
                arrayList.addAll(conjunctivePartsOfDisjunctivePart);
                if (!this.definitelyImplies(arrayList, pFormula, false, newBaseEnvironment, false, pDisableOverflowCheck)) {
                    return false;
                }
                arrayList.removeAll(conjunctivePartsOfDisjunctivePart);
            }
            return true;
        }
        NonRecursiveEnvironment.Builder tmpEnvironment = NonRecursiveEnvironment.Builder.of(this.compoundIntervalManagerFactory, pInformationBaseEnvironment);
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(this.compoundIntervalManagerFactory, this.evaluationVisitor, tmpEnvironment);
        if (!pEnvironmentComplete) {
            for (BooleanFormula booleanFormula : formulas) {
                if (booleanFormula.accept(patev, BooleanConstant.getTrue()).booleanValue()) continue;
                return false;
            }
        }
        return this.definitelyImplies(formulas, tmpEnvironment, pFormula, pDisableOverflowCheck);
    }

    public boolean definitelyImplies(Map<MemoryLocation, NumeralFormula<CompoundInterval>> pCompleteEnvironment, BooleanFormula<CompoundInterval> pFormula) {
        return this.definitelyImplies((Collection<BooleanFormula<CompoundInterval>>)ImmutableList.of(), pCompleteEnvironment, pFormula, false);
    }

    public boolean definitelyImplies(Collection<BooleanFormula<CompoundInterval>> pExtendedFormulas, Map<MemoryLocation, NumeralFormula<CompoundInterval>> pCompleteEnvironment, BooleanFormula<CompoundInterval> pFormula, boolean pDisableOverflowCheck) {
        FormulaEvaluationVisitor<CompoundInterval> evalVisitor = this.getEvaluationVisitor(pDisableOverflowCheck);
        PartialEvaluator variableResolver = new PartialEvaluator(this.compoundIntervalManagerFactory, pCompleteEnvironment);
        NonRecursiveEnvironment.Builder impliedEnvironment = NonRecursiveEnvironment.Builder.of(this.compoundIntervalManagerFactory, EMPTY_ENVIRONMENT);
        block0: for (BooleanFormula f : (List)pFormula.accept(SPLIT_CONJUNCTIONS_VISITOR)) {
            LogicalNot negation;
            BooleanFormula negated;
            BooleanConstant evaluated;
            BooleanFormula<CompoundInterval> formulaAtom = f.accept(this.partialEvaluator, evalVisitor);
            if (pExtendedFormulas.contains(formulaAtom)) continue;
            Collection disjunctions = (Collection)formulaAtom.accept(SPLIT_DISJUNCTIONS_VISITOR);
            if (disjunctions.size() > 1) {
                for (BooleanFormula disjunctionPart : disjunctions) {
                    if (!this.definitelyImplies(pExtendedFormulas, disjunctionPart, false, pCompleteEnvironment, true, pDisableOverflowCheck)) continue;
                    continue block0;
                }
            }
            if (BooleanConstant.isTrue(evaluated = (BooleanConstant)pFormula.accept(evalVisitor, pCompleteEnvironment))) continue;
            if (BooleanConstant.isFalse(evaluated)) {
                return false;
            }
            BooleanFormula<CompoundInterval> resolved = formulaAtom.accept(variableResolver, evalVisitor);
            StateEqualsVisitor stateEqualsVisitor = new StateEqualsVisitor(evalVisitor, pCompleteEnvironment, this.compoundIntervalManagerFactory);
            if (resolved instanceof Equal) {
                CompoundInterval rightEval;
                CompoundInterval leftEval;
                NumeralFormula op2;
                Equal equation = (Equal)resolved;
                NumeralFormula<CompoundInterval> op1 = equation.getOperand1();
                if (op1.accept(stateEqualsVisitor, op2 = equation.getOperand2()).booleanValue()) continue;
                CompoundIntervalManager cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(op1.getTypeInfo());
                if (!cim.doIntersect(leftEval = (CompoundInterval)op1.accept(evalVisitor, pCompleteEnvironment), rightEval = (CompoundInterval)op2.accept(evalVisitor, pCompleteEnvironment))) {
                    return false;
                }
            } else if (resolved instanceof LogicalNot && (negated = (negation = (LogicalNot)resolved).getNegated()) instanceof Equal) {
                CompoundInterval rightEval;
                CompoundInterval leftEval;
                NumeralFormula op2;
                Equal equation = (Equal)negated;
                NumeralFormula<CompoundInterval> op1 = equation.getOperand1();
                if (op1.accept(stateEqualsVisitor, op2 = equation.getOperand2()).booleanValue()) {
                    return false;
                }
                CompoundIntervalManager cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(op1.getTypeInfo());
                if (!cim.doIntersect(leftEval = (CompoundInterval)op1.accept(evalVisitor, pCompleteEnvironment), rightEval = (CompoundInterval)op2.accept(evalVisitor, pCompleteEnvironment))) continue;
                return false;
            }
            if (!pCompleteEnvironment.isEmpty() && ((Boolean)formulaAtom.accept(CONTAINS_ONLY_ENV_INFO_VISITOR)).booleanValue()) {
                impliedEnvironment.clear();
                Set memoryLocations = (Set)formulaAtom.accept(COLLECT_VARS_VISITOR);
                if (!pCompleteEnvironment.keySet().containsAll(memoryLocations)) {
                    return false;
                }
                PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(this.compoundIntervalManagerFactory, evalVisitor, impliedEnvironment);
                formulaAtom.accept(patev, BooleanConstant.getTrue());
                for (MemoryLocation memoryLocation : memoryLocations) {
                    NumeralFormula<CompoundInterval> leftFormula = pCompleteEnvironment.get(memoryLocation);
                    NumeralFormula<CompoundInterval> rightFormula = impliedEnvironment.get(memoryLocation);
                    if (rightFormula == null || leftFormula == null) {
                        return false;
                    }
                    if (rightFormula.equals(leftFormula) || (rightFormula = rightFormula.accept(this.partialEvaluator, evalVisitor)).equals(leftFormula = leftFormula.accept(this.partialEvaluator, evalVisitor))) continue;
                    if (rightFormula instanceof Constant) {
                        TypeInfo typeInfo = rightFormula.getTypeInfo();
                        CompoundIntervalManager cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
                        CompoundInterval leftValue = leftFormula == null ? cim.allPossibleValues() : (CompoundInterval)leftFormula.accept(evalVisitor, pCompleteEnvironment);
                        CompoundInterval rightValue = (CompoundInterval)rightFormula.accept(evalVisitor, impliedEnvironment);
                        if (cim.contains(rightValue, leftValue)) continue;
                    }
                    return false;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public boolean definitelyImplies(BooleanFormula<CompoundInterval> pFormula1, BooleanFormula<CompoundInterval> pFormula2, boolean pDisableOverflowCheck) {
        if (BooleanConstant.isFalse(pFormula1) || pFormula1.equals(pFormula2) || BooleanConstant.isTrue(pFormula2)) {
            return true;
        }
        if (pFormula1 instanceof Equal && pFormula2 instanceof Equal) {
            Equal p1 = (Equal)pFormula1;
            Equal p2 = (Equal)pFormula2;
            Variable var = null;
            CompoundInterval value = null;
            if (p1.getOperand1() instanceof Variable && p1.getOperand2() instanceof Constant) {
                var = (Variable)p1.getOperand1();
                value = (CompoundInterval)((Constant)p1.getOperand2()).getValue();
            } else if (p1.getOperand2() instanceof Variable && p1.getOperand1() instanceof Constant) {
                var = (Variable)p1.getOperand2();
                value = (CompoundInterval)((Constant)p1.getOperand1()).getValue();
            }
            if (var != null && value != null) {
                CompoundInterval newValue = null;
                if (var.equals(p2.getOperand1()) && p2.getOperand2() instanceof Constant) {
                    newValue = (CompoundInterval)((Constant)p2.getOperand2()).getValue();
                } else if (var.equals(p2.getOperand2()) && p2.getOperand1() instanceof Constant) {
                    newValue = (CompoundInterval)((Constant)p2.getOperand1()).getValue();
                }
                if (newValue != null) {
                    TypeInfo typeInfo = p2.getOperand1().getTypeInfo();
                    CompoundIntervalManager cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
                    return cim.contains(newValue, value);
                }
            }
        }
        Collection leftFormulas = (Collection)pFormula1.accept(SPLIT_CONJUNCTIONS_VISITOR);
        return this.definitelyImplies(leftFormulas, pFormula2, false, new HashMap<MemoryLocation, NumeralFormula<CompoundInterval>>(), false, pDisableOverflowCheck);
    }

    public NumeralFormula<CompoundInterval> add(NumeralFormula<CompoundInterval> pSummand1, NumeralFormula<CompoundInterval> pSummand2) {
        if (this.isDefinitelyBottom(pSummand1)) {
            return this.bottom(pSummand1);
        }
        if (this.isDefinitelyBottom(pSummand2)) {
            return this.bottom(pSummand2);
        }
        if (this.containsAllPossibleValues(pSummand1)) {
            return this.allPossibleValues(pSummand1);
        }
        if (this.containsAllPossibleValues(pSummand2)) {
            return this.allPossibleValues(pSummand2);
        }
        return InvariantsFormulaManager.INSTANCE.add(pSummand1, pSummand2);
    }

    public NumeralFormula<CompoundInterval> binaryAnd(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (this.isDefinitelyBottom(pOperand1)) {
            return this.bottom(pOperand1);
        }
        if (this.isDefinitelyBottom(pOperand2)) {
            return this.bottom(pOperand2);
        }
        HashSet<NumeralFormula> uniqueOperands = new HashSet<NumeralFormula>();
        ArrayDeque unprocessedOperands = new ArrayDeque();
        unprocessedOperands.offer(pOperand1);
        unprocessedOperands.offer(pOperand2);
        while (!unprocessedOperands.isEmpty()) {
            NumeralFormula unprocessedOperand = (NumeralFormula)unprocessedOperands.poll();
            if (unprocessedOperand instanceof BinaryAnd) {
                BinaryAnd and = (BinaryAnd)unprocessedOperand;
                unprocessedOperands.offer(and.getOperand1());
                unprocessedOperands.offer(and.getOperand2());
                continue;
            }
            uniqueOperands.add(unprocessedOperand);
        }
        assert (!uniqueOperands.isEmpty());
        Iterator operandsIterator = uniqueOperands.iterator();
        NumeralFormula result = (NumeralFormula)operandsIterator.next();
        while (operandsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.binaryAnd(result, (NumeralFormula)operandsIterator.next());
        }
        return result;
    }

    public NumeralFormula<CompoundInterval> binaryNot(NumeralFormula<CompoundInterval> pToFlip) {
        if (this.isDefinitelyBottom(pToFlip)) {
            return this.bottom(pToFlip);
        }
        if (this.containsAllPossibleValues(pToFlip)) {
            return this.allPossibleValues(pToFlip);
        }
        return InvariantsFormulaManager.INSTANCE.binaryNot(pToFlip);
    }

    public NumeralFormula<CompoundInterval> binaryOr(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (this.isDefinitelyBottom(pOperand1)) {
            return this.bottom(pOperand1);
        }
        if (this.isDefinitelyBottom(pOperand2)) {
            return this.bottom(pOperand2);
        }
        HashSet<NumeralFormula> uniqueOperands = new HashSet<NumeralFormula>();
        ArrayDeque unprocessedOperands = new ArrayDeque();
        unprocessedOperands.offer(pOperand1);
        unprocessedOperands.offer(pOperand2);
        while (!unprocessedOperands.isEmpty()) {
            NumeralFormula unprocessedOperand = (NumeralFormula)unprocessedOperands.poll();
            if (unprocessedOperand instanceof BinaryOr) {
                BinaryOr or = (BinaryOr)unprocessedOperand;
                unprocessedOperands.offer(or.getOperand1());
                unprocessedOperands.offer(or.getOperand2());
                continue;
            }
            uniqueOperands.add(unprocessedOperand);
        }
        assert (!uniqueOperands.isEmpty());
        Iterator operandsIterator = uniqueOperands.iterator();
        NumeralFormula result = (NumeralFormula)operandsIterator.next();
        while (operandsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.binaryOr(result, (NumeralFormula)operandsIterator.next());
        }
        return result;
    }

    public NumeralFormula<CompoundInterval> binaryXor(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (this.isDefinitelyBottom(pOperand1)) {
            return this.bottom(pOperand1);
        }
        if (this.isDefinitelyBottom(pOperand2)) {
            return this.bottom(pOperand2);
        }
        return InvariantsFormulaManager.INSTANCE.binaryXor(pOperand1, pOperand2);
    }

    public NumeralFormula<CompoundInterval> divide(NumeralFormula<CompoundInterval> pNumerator, NumeralFormula<CompoundInterval> pDenominator) {
        if (this.isDefinitelyBottom(pNumerator)) {
            return this.bottom(pNumerator);
        }
        if (this.isDefinitelyBottom(pDenominator)) {
            return this.bottom(pDenominator);
        }
        return InvariantsFormulaManager.INSTANCE.divide(pNumerator, pDenominator);
    }

    public BooleanFormula<CompoundInterval> equal(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.equal(union.getOperand1(), pOperand2), this.equal(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.equal(pOperand1, union.getOperand1()), this.equal(pOperand1, union.getOperand2()));
        }
        return InvariantsFormulaManager.INSTANCE.equal(pOperand1, pOperand2);
    }

    public BooleanFormula<CompoundInterval> greaterThan(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        return this.lessThan(pOperand2, pOperand1);
    }

    public BooleanFormula<CompoundInterval> greaterThanOrEqual(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        return this.lessThanOrEqual(pOperand2, pOperand1);
    }

    public BooleanFormula<CompoundInterval> lessThan(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.lessThan(union.getOperand1(), pOperand2), this.lessThan(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.lessThan(pOperand1, union.getOperand1()), this.lessThan(pOperand1, union.getOperand2()));
        }
        BooleanFormula<CompoundInterval> result = InvariantsFormulaManager.INSTANCE.lessThan(pOperand1, pOperand2);
        if (this.isDefinitelyTrue(result)) {
            return BooleanConstant.getTrue();
        }
        if (this.isDefinitelyFalse(result)) {
            return BooleanConstant.getFalse();
        }
        return result;
    }

    public BooleanFormula<CompoundInterval> lessThanOrEqual(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (pOperand1 instanceof Union) {
            Union union = (Union)pOperand1;
            return this.logicalOr(this.lessThanOrEqual(union.getOperand1(), pOperand2), this.lessThanOrEqual(union.getOperand2(), pOperand2));
        }
        if (pOperand2 instanceof Union) {
            Union union = (Union)pOperand2;
            return this.logicalOr(this.lessThanOrEqual(pOperand1, union.getOperand1()), this.lessThanOrEqual(pOperand1, union.getOperand2()));
        }
        BooleanFormula<CompoundInterval> result = InvariantsFormulaManager.INSTANCE.lessThanOrEqual(pOperand1, pOperand2);
        if (this.isDefinitelyTrue(result)) {
            return BooleanConstant.getTrue();
        }
        if (this.isDefinitelyFalse(result)) {
            return BooleanConstant.getFalse();
        }
        return result;
    }

    public BooleanFormula<CompoundInterval> logicalAnd(BooleanFormula<CompoundInterval> pOperand1, BooleanFormula<CompoundInterval> pOperand2) {
        if (BooleanConstant.isFalse(pOperand1) || BooleanConstant.isFalse(pOperand2)) {
            return BooleanConstant.getFalse();
        }
        if (BooleanConstant.isTrue(pOperand1)) {
            return pOperand2;
        }
        if (BooleanConstant.isTrue(pOperand2)) {
            return pOperand1;
        }
        NonRecursiveEnvironment.Builder tmpEnvironment = new NonRecursiveEnvironment.Builder(this.compoundIntervalManagerFactory);
        PushAssumptionToEnvironmentVisitor patev = new PushAssumptionToEnvironmentVisitor(this.compoundIntervalManagerFactory, this.evaluationVisitor, tmpEnvironment);
        if (!pOperand1.accept(patev, BooleanConstant.getTrue()).booleanValue()) {
            return BooleanConstant.getFalse();
        }
        if (!pOperand2.accept(patev, BooleanConstant.getTrue()).booleanValue()) {
            return BooleanConstant.getFalse();
        }
        if (this.definitelyImplies(pOperand1, pOperand2, true)) {
            return pOperand1;
        }
        if (this.definitelyImplies(pOperand2, pOperand1, true)) {
            return pOperand2;
        }
        if (pOperand1 instanceof Equal && pOperand2 instanceof Equal) {
            Equal p1 = (Equal)pOperand1;
            Equal p2 = (Equal)pOperand2;
            Variable var = null;
            CompoundInterval value = null;
            if (p1.getOperand1() instanceof Variable && p1.getOperand2() instanceof Constant) {
                var = (Variable)p1.getOperand1();
                value = (CompoundInterval)((Constant)p1.getOperand2()).getValue();
            } else if (p1.getOperand2() instanceof Variable && p1.getOperand1() instanceof Constant) {
                var = (Variable)p1.getOperand2();
                value = (CompoundInterval)((Constant)p1.getOperand1()).getValue();
            }
            if (var != null && value != null) {
                CompoundInterval newValue = null;
                TypeInfo typeInfo = p2.getOperand1().getTypeInfo();
                CompoundIntervalManager cim = this.getCompoundIntervalManager(typeInfo);
                if (var.equals(p2.getOperand1()) && p2.getOperand2() instanceof Constant) {
                    newValue = cim.intersect(value, (CompoundInterval)((Constant)p2.getOperand2()).getValue());
                } else if (var.equals(p2.getOperand2()) && p2.getOperand1() instanceof Constant) {
                    newValue = cim.intersect(value, (CompoundInterval)((Constant)p2.getOperand1()).getValue());
                }
                if (newValue != null) {
                    if (newValue.containsAllPossibleValues()) {
                        return BooleanConstant.getTrue();
                    }
                    if (newValue.isBottom()) {
                        return BooleanConstant.getFalse();
                    }
                    return this.equal(var, this.asConstant(typeInfo, newValue));
                }
            }
        }
        return InvariantsFormulaManager.INSTANCE.logicalAnd(pOperand1, pOperand2);
    }

    public BooleanFormula<CompoundInterval> logicalNot(BooleanFormula<CompoundInterval> pToNegate) {
        if (pToNegate instanceof BooleanConstant) {
            return ((BooleanConstant)pToNegate).negate();
        }
        if (this.isDefinitelyTrue(pToNegate)) {
            return BooleanConstant.getFalse();
        }
        if (this.isDefinitelyFalse(pToNegate)) {
            return BooleanConstant.getTrue();
        }
        if (pToNegate instanceof LogicalNot) {
            return ((LogicalNot)pToNegate).getNegated();
        }
        return InvariantsFormulaManager.INSTANCE.logicalNot(pToNegate);
    }

    public BooleanFormula<CompoundInterval> logicalOr(BooleanFormula<CompoundInterval> pOperand1, BooleanFormula<CompoundInterval> pOperand2) {
        if (BooleanConstant.isTrue(pOperand1) || BooleanConstant.isTrue(pOperand2)) {
            return BooleanConstant.getTrue();
        }
        if (BooleanConstant.isFalse(pOperand1)) {
            return pOperand2;
        }
        if (BooleanConstant.isFalse(pOperand2)) {
            return pOperand1;
        }
        if (this.definitelyImplies(pOperand1, pOperand2, true)) {
            return pOperand2;
        }
        if (this.definitelyImplies(pOperand2, pOperand1, true)) {
            return pOperand1;
        }
        if (pOperand1 instanceof Equal && pOperand2 instanceof Equal) {
            Equal p1 = (Equal)pOperand1;
            Equal p2 = (Equal)pOperand2;
            Variable var = null;
            NumeralFormula<CompoundInterval> value = null;
            if (p1.getOperand1() instanceof Variable) {
                var = (Variable)p1.getOperand1();
                value = p1.getOperand2();
            } else if (p1.getOperand2() instanceof Variable) {
                var = (Variable)p1.getOperand2();
                value = p1.getOperand1();
            }
            if (var != null && value != null) {
                NumeralFormula<CompoundInterval> newValue = null;
                NumeralFormula otherValue = null;
                if (var.equals(p2.getOperand1())) {
                    otherValue = p2.getOperand2();
                } else if (var.equals(p2.getOperand2())) {
                    otherValue = p2.getOperand1();
                }
                if (otherValue != null) {
                    newValue = this.union(value, p2.getOperand2());
                    CompoundInterval val = this.evaluate(newValue = newValue.accept(new PartialEvaluator(this.compoundIntervalManagerFactory), this.evaluationVisitor), true);
                    if (val.containsAllPossibleValues() && newValue instanceof Constant) {
                        return BooleanConstant.getTrue();
                    }
                    if (val.isBottom()) {
                        return BooleanConstant.getFalse();
                    }
                    boolean useNewValue = true;
                    if (newValue instanceof Union) {
                        Union union = (Union)newValue;
                        NumeralFormula op1 = union.getOperand1();
                        NumeralFormula op2 = union.getOperand2();
                        boolean bl = useNewValue = !(op1.equals(value) && op2.equals(otherValue) || op1.equals(otherValue) && op2.equals(value));
                    }
                    if (useNewValue) {
                        return this.equal(var, newValue);
                    }
                }
            }
        }
        return this.logicalNot(this.logicalAnd(this.logicalNot(pOperand1), this.logicalNot(pOperand2)));
    }

    public BooleanFormula<CompoundInterval> logicalImplies(BooleanFormula<CompoundInterval> pOperand1, BooleanFormula<CompoundInterval> pOperand2) {
        if (this.definitelyImplies(pOperand1, pOperand2, true)) {
            return BooleanConstant.getTrue();
        }
        return this.logicalNot(this.logicalAnd(pOperand1, this.logicalNot(pOperand2)));
    }

    public NumeralFormula<CompoundInterval> modulo(NumeralFormula<CompoundInterval> pNumerator, NumeralFormula<CompoundInterval> pDenominator) {
        if (this.isDefinitelyBottom(pNumerator)) {
            return this.bottom(pNumerator);
        }
        if (this.isDefinitelyBottom(pDenominator)) {
            return this.bottom(pDenominator);
        }
        return InvariantsFormulaManager.INSTANCE.modulo(pNumerator, pDenominator);
    }

    public NumeralFormula<CompoundInterval> multiply(NumeralFormula<CompoundInterval> pFactor1, NumeralFormula<CompoundInterval> pFactor2) {
        if (this.isDefinitelyBottom(pFactor1)) {
            return this.bottom(pFactor1);
        }
        if (this.isDefinitelyBottom(pFactor2)) {
            return this.bottom(pFactor2);
        }
        return InvariantsFormulaManager.INSTANCE.multiply(pFactor1, pFactor2);
    }

    public NumeralFormula<CompoundInterval> negate(NumeralFormula<CompoundInterval> pToNegate) {
        if (this.isDefinitelyBottom(pToNegate)) {
            return this.bottom(pToNegate);
        }
        if (this.containsAllPossibleValues(pToNegate)) {
            return this.allPossibleValues(pToNegate);
        }
        if (pToNegate instanceof Multiply) {
            NumeralFormula<CompoundInterval> factor1 = ((Multiply)pToNegate).getFactor1();
            NumeralFormula<CompoundInterval> factor2 = ((Multiply)pToNegate).getFactor2();
            if (this.isMinusOne(factor1)) {
                return factor2;
            }
            if (this.isMinusOne(factor2)) {
                return factor1;
            }
        }
        TypeInfo typeInfo = pToNegate.getTypeInfo();
        CompoundIntervalManager cim = this.getCompoundIntervalManager(typeInfo);
        if (pToNegate instanceof Constant) {
            return this.asConstant(typeInfo, cim.negate((CompoundInterval)((Constant)pToNegate).getValue()));
        }
        if (cim.allPossibleValues().contains(BigInteger.valueOf(-1L))) {
            NumeralFormula<CompoundInterval> minusOne = this.asConstant(typeInfo, cim.singleton(-1L));
            return InvariantsFormulaManager.INSTANCE.multiply(pToNegate, minusOne);
        }
        CompoundInterval value = this.evaluate(pToNegate);
        return this.asConstant(typeInfo, cim.negate(value));
    }

    private boolean isMinusOne(NumeralFormula<CompoundInterval> pFormula) {
        CompoundInterval value = this.evaluate(pFormula, true);
        return value.isSingleton() && value.contains(BigInteger.valueOf(-1L));
    }

    public NumeralFormula<CompoundInterval> subtract(NumeralFormula<CompoundInterval> pMinuend, NumeralFormula<CompoundInterval> pSubtrahend) {
        if (this.isDefinitelyBottom(pMinuend)) {
            return this.bottom(pMinuend);
        }
        if (this.isDefinitelyBottom(pSubtrahend)) {
            return this.bottom(pSubtrahend);
        }
        if (this.containsAllPossibleValues(pMinuend)) {
            return this.allPossibleValues(pMinuend);
        }
        if (this.containsAllPossibleValues(pSubtrahend)) {
            return this.allPossibleValues(pSubtrahend);
        }
        return InvariantsFormulaManager.INSTANCE.add(pMinuend, this.negate(pSubtrahend));
    }

    public NumeralFormula<CompoundInterval> shiftLeft(NumeralFormula<CompoundInterval> pToShift, NumeralFormula<CompoundInterval> pShiftDistance) {
        if (this.isDefinitelyBottom(pToShift)) {
            return this.bottom(pToShift);
        }
        if (this.isDefinitelyBottom(pShiftDistance)) {
            return this.bottom(pShiftDistance);
        }
        if (this.containsAllPossibleValues(pShiftDistance)) {
            return this.allPossibleValues(pShiftDistance);
        }
        return InvariantsFormulaManager.INSTANCE.shiftLeft(pToShift, pShiftDistance);
    }

    public NumeralFormula<CompoundInterval> shiftRight(NumeralFormula<CompoundInterval> pToShift, NumeralFormula<CompoundInterval> pShiftDistance) {
        if (this.isDefinitelyBottom(pToShift)) {
            return this.bottom(pToShift);
        }
        if (this.isDefinitelyBottom(pShiftDistance)) {
            return this.bottom(pShiftDistance);
        }
        if (this.containsAllPossibleValues(pShiftDistance)) {
            return this.allPossibleValues(pShiftDistance);
        }
        return InvariantsFormulaManager.INSTANCE.shiftRight(pToShift, pShiftDistance);
    }

    public NumeralFormula<CompoundInterval> union(NumeralFormula<CompoundInterval> pOperand1, NumeralFormula<CompoundInterval> pOperand2) {
        if (this.isDefinitelyBottom(pOperand1)) {
            return pOperand2;
        }
        if (this.isDefinitelyBottom(pOperand2)) {
            return pOperand1;
        }
        if (this.containsAllPossibleValues(pOperand1)) {
            return this.allPossibleValues(pOperand1);
        }
        if (this.containsAllPossibleValues(pOperand2)) {
            return this.allPossibleValues(pOperand2);
        }
        if (pOperand1.equals(pOperand2)) {
            return pOperand1;
        }
        HashSet<NumeralFormula<CompoundInterval>> atomicUnionParts = new HashSet<NumeralFormula<CompoundInterval>>();
        ArrayDeque<NumeralFormula> unionParts = new ArrayDeque<NumeralFormula>();
        TypeInfo typeInfo = pOperand1.getTypeInfo();
        CompoundIntervalManager cim = this.getCompoundIntervalManager(typeInfo);
        CompoundInterval constantPart = cim.bottom();
        unionParts.offer(pOperand1);
        unionParts.offer(pOperand2);
        while (!unionParts.isEmpty()) {
            NumeralFormula currentPart = (NumeralFormula)unionParts.poll();
            if (currentPart instanceof Union) {
                Union currentUnion = (Union)currentPart;
                unionParts.add(currentUnion.getOperand1());
                unionParts.add(currentUnion.getOperand2());
                continue;
            }
            if (currentPart instanceof Constant) {
                constantPart = cim.union(constantPart, (CompoundInterval)((Constant)currentPart).getValue());
                continue;
            }
            atomicUnionParts.add(currentPart);
        }
        return this.unionAll(typeInfo, constantPart, atomicUnionParts);
    }

    private NumeralFormula<CompoundInterval> unionAll(TypeInfo pInfo, CompoundInterval pConstantPart, Collection<NumeralFormula<CompoundInterval>> pFormulas) {
        if (pFormulas.isEmpty() || pConstantPart.containsAllPossibleValues()) {
            return this.asConstant(pInfo, pConstantPart);
        }
        Iterator<NumeralFormula<CompoundInterval>> atomicUnionPartsIterator = pFormulas.iterator();
        NumeralFormula<CompoundInterval> result = atomicUnionPartsIterator.next();
        while (atomicUnionPartsIterator.hasNext()) {
            result = InvariantsFormulaManager.INSTANCE.union(result, atomicUnionPartsIterator.next());
        }
        if (!pConstantPart.isBottom()) {
            NumeralFormula<CompoundInterval> constantPartFormula = this.asConstant(pInfo, pConstantPart);
            result = InvariantsFormulaManager.INSTANCE.union(result, constantPartFormula);
        }
        return result;
    }

    public NumeralFormula<CompoundInterval> exclude(NumeralFormula<CompoundInterval> pToExclude) {
        if (pToExclude instanceof Constant) {
            Constant c = (Constant)pToExclude;
            TypeInfo bitVectorInfo = pToExclude.getTypeInfo();
            if (((CompoundInterval)c.getValue()).isSingleton()) {
                return this.asConstant(bitVectorInfo, ((CompoundInterval)c.getValue()).invert());
            }
            return this.allPossibleValues(bitVectorInfo);
        }
        return InvariantsFormulaManager.INSTANCE.exclude(pToExclude);
    }

    public NumeralFormula<CompoundInterval> ifThenElse(BooleanFormula<CompoundInterval> pCondition, NumeralFormula<CompoundInterval> pPositiveCase, NumeralFormula<CompoundInterval> pNegativeCase) {
        if (BooleanConstant.isTrue(pCondition)) {
            return pPositiveCase;
        }
        if (BooleanConstant.isFalse(pCondition)) {
            return pNegativeCase;
        }
        if (this.isDefinitelyBottom(pPositiveCase) && this.isDefinitelyBottom(pNegativeCase)) {
            return this.bottom(pPositiveCase);
        }
        if (pCondition instanceof LogicalNot) {
            return this.ifThenElse(((LogicalNot)pCondition).getNegated(), pNegativeCase, pPositiveCase);
        }
        return InvariantsFormulaManager.INSTANCE.ifThenElse(pCondition, pPositiveCase, pNegativeCase);
    }

    public NumeralFormula<CompoundInterval> fromBoolean(TypeInfo pTypeInfo, BooleanFormula<CompoundInterval> pFormula) {
        CompoundIntervalManager cim = this.getCompoundIntervalManager(pTypeInfo);
        NumeralFormula<CompoundInterval> trueNumeralFormula = this.asConstant(pTypeInfo, cim.singleton(BigInteger.ONE));
        NumeralFormula<CompoundInterval> falseNumeralFormula = this.asConstant(pTypeInfo, cim.logicalFalse());
        return this.ifThenElse(pFormula, trueNumeralFormula, falseNumeralFormula);
    }

    public BooleanFormula<CompoundInterval> fromNumeral(NumeralFormula<CompoundInterval> pFormula) {
        TypeInfo typeInfo = pFormula.getTypeInfo();
        CompoundIntervalManager cim = this.getCompoundIntervalManager(typeInfo);
        if (pFormula instanceof IfThenElse) {
            IfThenElse ifThenElse = (IfThenElse)pFormula;
            if (this.isDefinitelyTrue(ifThenElse.getPositiveCase()) && this.isDefinitelyFalse(ifThenElse.getNegativeCase())) {
                return ifThenElse.getCondition();
            }
            if (this.isDefinitelyFalse(ifThenElse.getPositiveCase()) && this.isDefinitelyTrue(ifThenElse.getNegativeCase())) {
                return this.logicalNot(ifThenElse.getCondition());
            }
        }
        return this.logicalNot(this.equal(pFormula, this.asConstant(typeInfo, cim.singleton(BigInteger.ZERO))));
    }

    public NumeralFormula<CompoundInterval> cast(TypeInfo pTypeInfo, NumeralFormula<CompoundInterval> pToCast) {
        if (pToCast.getTypeInfo().equals(pTypeInfo)) {
            return pToCast;
        }
        NumeralFormula<CompoundInterval> casted = InvariantsFormulaManager.INSTANCE.cast(pTypeInfo, pToCast);
        if (pToCast instanceof Constant) {
            casted = this.asConstant(pTypeInfo, (CompoundInterval)casted.accept(this.evaluationVisitor, EMPTY_ENVIRONMENT));
        }
        return casted;
    }

    private NumeralFormula<CompoundInterval> bottom(TypeInfo pInfo) {
        return this.asConstant(pInfo, this.getCompoundIntervalManager(pInfo).bottom());
    }

    private NumeralFormula<CompoundInterval> bottom(Typed pTyped) {
        return this.bottom(pTyped.getTypeInfo());
    }

    private NumeralFormula<CompoundInterval> allPossibleValues(TypeInfo pInfo) {
        return this.asConstant(pInfo, this.getCompoundIntervalManager(pInfo).allPossibleValues());
    }

    private NumeralFormula<CompoundInterval> allPossibleValues(Typed pBitVectorType) {
        return this.allPossibleValues(pBitVectorType.getTypeInfo());
    }

    private NumeralFormula<CompoundInterval> asConstant(TypeInfo pInfo, CompoundInterval pValue) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pInfo, pValue);
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pInfo) {
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pInfo);
    }
}

