/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.AbstractFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;

public class Constant<T>
extends AbstractFormula<T>
implements NumeralFormula<T> {
    private final T value;

    private Constant(TypeInfo pInfo, T pValue) {
        super(pInfo);
        Preconditions.checkNotNull(pValue);
        if (pValue instanceof Typed) {
            Preconditions.checkArgument((boolean)pInfo.equals(((Typed)pValue).getTypeInfo()));
        }
        this.value = pValue;
    }

    public T getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue().toString();
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof Constant) {
            Constant other = (Constant)pOther;
            return this.getTypeInfo().equals(other.getTypeInfo()) && this.getValue().equals(other.getValue());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getTypeInfo(), this.getValue());
    }

    @Override
    public <ReturnType> ReturnType accept(NumeralFormulaVisitor<T, ReturnType> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedNumeralFormulaVisitor<T, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return pVisitor.visit(this, pParameter);
    }

    static <T> Constant<T> of(TypeInfo pInfo, T pValue) {
        return new Constant<T>(pInfo, pValue);
    }

    static <T extends Typed> Constant<T> of(T pValue) {
        return new Constant<T>(pValue.getTypeInfo(), pValue);
    }
}

