/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ContainsVarVisitor<T>
implements ParameterizedNumeralFormulaVisitor<T, MemoryLocation, Boolean>,
ParameterizedBooleanFormulaVisitor<T, MemoryLocation, Boolean> {
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<T>> environment;

    public ContainsVarVisitor() {
        this(null);
    }

    public ContainsVarVisitor(Map<? extends MemoryLocation, ? extends NumeralFormula<T>> pEnvironment) {
        this.environment = pEnvironment;
    }

    @Override
    public Boolean visit(Add<T> pAdd, MemoryLocation pVarName) {
        return (Boolean)pAdd.getSummand1().accept(this, pVarName) != false || (Boolean)pAdd.getSummand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryAnd<T> pAnd, MemoryLocation pVarName) {
        return (Boolean)pAnd.getOperand1().accept(this, pVarName) != false || (Boolean)pAnd.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryNot<T> pNot, MemoryLocation pVarName) {
        return (Boolean)pNot.getFlipped().accept(this, pVarName);
    }

    @Override
    public Boolean visit(BinaryOr<T> pOr, MemoryLocation pVarName) {
        return (Boolean)pOr.getOperand1().accept(this, pVarName) != false || (Boolean)pOr.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(BinaryXor<T> pXor, MemoryLocation pVarName) {
        return (Boolean)pXor.getOperand1().accept(this, pVarName) != false || (Boolean)pXor.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Constant<T> pConstant, MemoryLocation pVarName) {
        return false;
    }

    @Override
    public Boolean visit(Divide<T> pDivide, MemoryLocation pVarName) {
        return (Boolean)pDivide.getNumerator().accept(this, pVarName) != false || (Boolean)pDivide.getDenominator().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Equal<T> pEqual, MemoryLocation pVarName) {
        return (Boolean)pEqual.getOperand1().accept(this, pVarName) != false || (Boolean)pEqual.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Exclusion<T> pExclusion, MemoryLocation pParameter) {
        return (Boolean)pExclusion.getExcluded().accept(this, pParameter);
    }

    @Override
    public Boolean visit(LessThan<T> pLessThan, MemoryLocation pVarName) {
        return (Boolean)pLessThan.getOperand1().accept(this, pVarName) != false || (Boolean)pLessThan.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(LogicalAnd<T> pAnd, MemoryLocation pVarName) {
        return (Boolean)pAnd.getOperand1().accept(this, pVarName) != false || (Boolean)pAnd.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(LogicalNot<T> pNot, MemoryLocation pVarName) {
        return (Boolean)pNot.getNegated().accept(this, pVarName);
    }

    @Override
    public Boolean visit(Modulo<T> pModulo, MemoryLocation pVarName) {
        return (Boolean)pModulo.getNumerator().accept(this, pVarName) != false || (Boolean)pModulo.getDenominator().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Multiply<T> pMultiply, MemoryLocation pVarName) {
        return (Boolean)pMultiply.getFactor1().accept(this, pVarName) != false || (Boolean)pMultiply.getFactor2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(ShiftLeft<T> pShiftLeft, MemoryLocation pVarName) {
        return (Boolean)pShiftLeft.getShifted().accept(this, pVarName) != false || (Boolean)pShiftLeft.getShiftDistance().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(ShiftRight<T> pShiftRight, MemoryLocation pVarName) {
        return (Boolean)pShiftRight.getShifted().accept(this, pVarName) != false || (Boolean)pShiftRight.getShiftDistance().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visit(Union<T> pUnion, MemoryLocation pVarName) {
        return (Boolean)pUnion.getOperand1().accept(this, pVarName) != false || (Boolean)pUnion.getOperand2().accept(this, pVarName) != false;
    }

    @Override
    public Boolean visitFalse(MemoryLocation pParameter) {
        return false;
    }

    @Override
    public Boolean visitTrue(MemoryLocation pParameter) {
        return false;
    }

    @Override
    public Boolean visit(Variable<T> pVariable, MemoryLocation pVarName) {
        return pVariable.getMemoryLocation().equals(pVarName) || this.refersTo(pVariable, pVarName);
    }

    @Override
    public Boolean visit(Cast<T> pCast, MemoryLocation pVarName) {
        return (Boolean)pCast.getCasted().accept(this, pVarName);
    }

    @Override
    public Boolean visit(IfThenElse<T> pIfThenElse, MemoryLocation pVarName) {
        return (Boolean)pIfThenElse.getCondition().accept(this, pVarName) != false || (Boolean)pIfThenElse.getPositiveCase().accept(this, pVarName) != false || (Boolean)pIfThenElse.getNegativeCase().accept(this, pVarName) != false;
    }

    private boolean refersTo(Variable<T> pVariable, MemoryLocation pVarName) {
        if (this.environment == null) {
            return false;
        }
        NumeralFormula<T> value = this.environment.get(pVariable.getMemoryLocation());
        if (value == null) {
            return false;
        }
        return (Boolean)value.accept(this, pVarName);
    }
}

