/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.ARightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayCreationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayInitializer;
import org.sosy_lab.cpachecker.cfa.ast.java.JArrayLengthExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JBooleanLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassInstanceCreation;
import org.sosy_lab.cpachecker.cfa.ast.java.JClassLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JEnumConstantExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodInvocationExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JNullLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.java.JRunTimeTypeEqualsType;
import org.sosy_lab.cpachecker.cfa.ast.java.JStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JThisExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableRunTimeType;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.java.JBasicType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntegralInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.MemoryLocationExtractor;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ExpressionToFormulaVisitor
extends DefaultCExpressionVisitor<NumeralFormula<CompoundInterval>, UnrecognizedCodeException>
implements CRightHandSideVisitor<NumeralFormula<CompoundInterval>, UnrecognizedCodeException>,
JRightHandSideVisitor<NumeralFormula<CompoundInterval>, UnrecognizedCodeException> {
    private final MemoryLocationExtractor variableNameExtractor;
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> environment;
    private final MachineModel machineModel;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final CompoundIntervalFormulaManager compoundIntervalFormulaManager;

    public ExpressionToFormulaVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, MemoryLocationExtractor pVariableNameExtractor) {
        this(pCompoundIntervalManagerFactory, pMachineModel, pVariableNameExtractor, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of());
    }

    public ExpressionToFormulaVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, MachineModel pMachineModel, MemoryLocationExtractor pVariableNameExtractor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.machineModel = pMachineModel;
        this.variableNameExtractor = pVariableNameExtractor;
        this.environment = pEnvironment;
        this.evaluationVisitor = new FormulaCompoundStateEvaluationVisitor(this.compoundIntervalManagerFactory);
        this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
    }

    private CompoundIntervalManager getIntervalManager(Type pType) {
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(this.machineModel, pType);
    }

    private NumeralFormula<CompoundInterval> allPossibleValues(AExpression pExpression) {
        return this.allPossibleValues(pExpression.getExpressionType());
    }

    private NumeralFormula<CompoundInterval> allPossibleValues(Type pType) {
        return this.asConstant(pType, this.getIntervalManager(pType).allPossibleValues());
    }

    private NumeralFormula<CompoundInterval> asConstant(Type pType, boolean pValue) {
        return this.asConstant(pType, this.getIntervalManager(pType).fromBoolean(pValue));
    }

    private NumeralFormula<CompoundInterval> asConstant(Type pType, BigInteger pValue) {
        return this.asConstant(pType, this.getIntervalManager(pType).castedSingleton(pValue));
    }

    private NumeralFormula<CompoundInterval> asConstant(Type pType, long pValue) {
        return this.asConstant(pType, BigInteger.valueOf(pValue));
    }

    private NumeralFormula<CompoundInterval> asConstant(Type pType, CompoundInterval pValue) {
        return InvariantsFormulaManager.INSTANCE.asConstant(BitVectorInfo.from(this.machineModel, pType), pValue);
    }

    private NumeralFormula<CompoundInterval> asVariable(Type pType, MemoryLocation pMemoryLocation) {
        return InvariantsFormulaManager.INSTANCE.asVariable(BitVectorInfo.from(this.machineModel, pType), pMemoryLocation);
    }

    @Override
    protected NumeralFormula<CompoundInterval> visitDefault(CExpression pCExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pCExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CIdExpression pCIdExpression) throws UnrecognizedCodeException {
        return this.asVariable(pCIdExpression.getExpressionType(), this.variableNameExtractor.getMemoryLocation((AExpression)pCIdExpression));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CFieldReference pCFieldReference) throws UnrecognizedCodeException {
        return this.asVariable(pCFieldReference.getExpressionType(), this.variableNameExtractor.getMemoryLocation(pCFieldReference));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CArraySubscriptExpression pCArraySubscriptExpression) throws UnrecognizedCodeException {
        return this.asVariable(pCArraySubscriptExpression.getExpressionType(), this.variableNameExtractor.getMemoryLocation(pCArraySubscriptExpression));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CIntegerLiteralExpression pE) {
        return this.asConstant((Type)pE.getExpressionType(), pE.getValue());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CCharLiteralExpression pE) {
        return this.asConstant((Type)pE.getExpressionType(), pE.getCharacter());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CImaginaryLiteralExpression pE) throws UnrecognizedCodeException {
        return pE.getValue().accept(this);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CUnaryExpression pCUnaryExpression) throws UnrecognizedCodeException {
        NumeralFormula result;
        CExpression operandExpression = pCUnaryExpression.getOperand();
        if (pCUnaryExpression.getOperator() != CUnaryExpression.UnaryOperator.AMPER) {
            operandExpression = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(operandExpression, pCUnaryExpression.getExpressionType());
        }
        NumeralFormula<CompoundInterval> operand = operandExpression.accept(this);
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pCUnaryExpression.getExpressionType());
        operand = this.compoundIntervalFormulaManager.cast(typeInfo, operand);
        switch (pCUnaryExpression.getOperator()) {
            case MINUS: {
                result = this.compoundIntervalFormulaManager.negate(operand);
                break;
            }
            case TILDE: {
                result = this.compoundIntervalFormulaManager.binaryNot(operand);
                break;
            }
            case AMPER: {
                result = this.allPossibleValues(pCUnaryExpression);
                break;
            }
            default: {
                result = (NumeralFormula)super.visit(pCUnaryExpression);
            }
        }
        return this.compoundIntervalFormulaManager.cast(typeInfo, result);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CPointerExpression pCPointerExpression) throws UnrecognizedCodeException {
        return this.asVariable(pCPointerExpression.getExpressionType(), this.variableNameExtractor.getMemoryLocation(pCPointerExpression));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CCastExpression pCCastExpression) throws UnrecognizedCodeException {
        CExpression expression = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(pCCastExpression.getOperand(), pCCastExpression.getCastType());
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pCCastExpression.getCastType());
        return this.compoundIntervalFormulaManager.cast(typeInfo, expression.accept(this));
    }

    private CType getPromotedCType(CType t) {
        if (CTypes.isIntegerType(t = t.getCanonicalType())) {
            return this.machineModel.applyIntegerPromotion(t);
        }
        return t;
    }

    private NumeralFormula<CompoundInterval> getPointerTargetSizeLiteral(CPointerType pointerType, CType implicitType) {
        BigInteger pointerTargetSize = this.machineModel.getSizeof(pointerType.getType());
        return this.asConstant((Type)implicitType, pointerTargetSize);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CBinaryExpression pCBinaryExpression) throws UnrecognizedCodeException {
        NumeralFormula<CompoundInterval> result;
        CType calculationType = pCBinaryExpression.getCalculationType();
        CType t1 = pCBinaryExpression.getOperand1().getExpressionType();
        CType t2 = pCBinaryExpression.getOperand2().getExpressionType();
        CType promLeft = this.getPromotedCType(t1).getCanonicalType();
        CType promRight = this.getPromotedCType(t2).getCanonicalType();
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, calculationType);
        NumeralFormula<CompoundInterval> left = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(pCBinaryExpression.getOperand1(), calculationType).accept(this);
        NumeralFormula<CompoundInterval> right = ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary(pCBinaryExpression.getOperand2(), calculationType).accept(this);
        left = this.compoundIntervalFormulaManager.cast(typeInfo, left);
        right = this.compoundIntervalFormulaManager.cast(typeInfo, right);
        left = this.topIfProblematicType(calculationType, left);
        right = this.topIfProblematicType(calculationType, right);
        switch (pCBinaryExpression.getOperator()) {
            case BINARY_AND: {
                result = this.allPossibleValues(pCBinaryExpression);
                break;
            }
            case BINARY_OR: {
                result = this.allPossibleValues(pCBinaryExpression);
                break;
            }
            case BINARY_XOR: {
                result = this.allPossibleValues(pCBinaryExpression);
                break;
            }
            case DIVIDE: {
                result = this.compoundIntervalFormulaManager.divide(left, right);
                break;
            }
            case EQUALS: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.equal(left, right));
                break;
            }
            case GREATER_EQUAL: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.greaterThanOrEqual(left, right));
                break;
            }
            case GREATER_THAN: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.greaterThan(left, right));
                break;
            }
            case LESS_EQUAL: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.lessThanOrEqual(left, right));
                break;
            }
            case LESS_THAN: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.lessThan(left, right));
                break;
            }
            case MINUS: {
                if (!(promLeft instanceof CPointerType) && !(promRight instanceof CPointerType)) {
                    result = this.compoundIntervalFormulaManager.subtract(left, right);
                    break;
                }
                if (!(promRight instanceof CPointerType)) {
                    result = this.compoundIntervalFormulaManager.subtract(left, this.compoundIntervalFormulaManager.multiply(right, this.getPointerTargetSizeLiteral((CPointerType)promLeft, calculationType)));
                    break;
                }
                if (promLeft instanceof CPointerType) {
                    if (promLeft.equals(promRight)) {
                        result = this.compoundIntervalFormulaManager.divide(this.compoundIntervalFormulaManager.subtract(left, right), this.getPointerTargetSizeLiteral((CPointerType)promLeft, calculationType));
                        break;
                    }
                    throw new UnrecognizedCodeException("Can't subtract pointers of different types", pCBinaryExpression);
                }
                throw new UnrecognizedCodeException("Can't subtract a pointer from a non-pointer", pCBinaryExpression);
            }
            case MODULO: {
                result = this.compoundIntervalFormulaManager.modulo(left, right);
                break;
            }
            case MULTIPLY: {
                result = this.compoundIntervalFormulaManager.multiply(left, right);
                break;
            }
            case NOT_EQUALS: {
                result = this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalNot(this.compoundIntervalFormulaManager.equal(left, right)));
                break;
            }
            case PLUS: {
                if (!(promLeft instanceof CPointerType) && !(promRight instanceof CPointerType)) {
                    result = this.compoundIntervalFormulaManager.add(left, right);
                    break;
                }
                if (!(promRight instanceof CPointerType)) {
                    result = this.compoundIntervalFormulaManager.add(left, this.compoundIntervalFormulaManager.multiply(right, this.getPointerTargetSizeLiteral((CPointerType)promLeft, calculationType)));
                    break;
                }
                if (!(promLeft instanceof CPointerType)) {
                    result = this.compoundIntervalFormulaManager.add(right, this.compoundIntervalFormulaManager.multiply(left, this.getPointerTargetSizeLiteral((CPointerType)promRight, calculationType)));
                    break;
                }
                throw new UnrecognizedCodeException("Can't add pointers", pCBinaryExpression);
            }
            case SHIFT_LEFT: {
                result = this.compoundIntervalFormulaManager.shiftLeft(left, right);
                break;
            }
            case SHIFT_RIGHT: {
                result = this.compoundIntervalFormulaManager.shiftRight(left, right);
                break;
            }
            default: {
                result = this.allPossibleValues(pCBinaryExpression);
            }
        }
        return this.compoundIntervalFormulaManager.cast(typeInfo, result);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(CFunctionCallExpression pIastFunctionCallExpression) {
        return this.allPossibleValues(pIastFunctionCallExpression.getExpressionType());
    }

    private NumeralFormula<CompoundInterval> topIfProblematicType(CType pType, NumeralFormula<CompoundInterval> pFormula) {
        if (pType instanceof CSimpleType && ((CSimpleType)pType).getCanonicalType().isUnsigned()) {
            CompoundInterval value = (CompoundInterval)pFormula.accept(this.evaluationVisitor, this.environment);
            if (value.containsAllPossibleValues()) {
                return pFormula;
            }
            if (value.containsNegative()) {
                return this.allPossibleValues(pType);
            }
        }
        return pFormula;
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JCharLiteralExpression pCharLiteralExpression) throws UnrecognizedCodeException {
        return this.asConstant((Type)pCharLiteralExpression.getExpressionType(), pCharLiteralExpression.getCharacter());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JStringLiteralExpression pStringLiteralExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pStringLiteralExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JBinaryExpression pBinaryExpression) throws UnrecognizedCodeException {
        NumeralFormula<CompoundInterval> left = pBinaryExpression.getOperand1().accept(this);
        NumeralFormula<CompoundInterval> right = pBinaryExpression.getOperand2().accept(this);
        BooleanFormula<CompoundInterval> logicalLeft = this.compoundIntervalFormulaManager.fromNumeral(left);
        BooleanFormula<CompoundInterval> logicalRight = this.compoundIntervalFormulaManager.fromNumeral(right);
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pBinaryExpression.getExpressionType());
        switch (pBinaryExpression.getOperator()) {
            case BINARY_AND: {
                return this.allPossibleValues(pBinaryExpression);
            }
            case BINARY_OR: {
                return this.allPossibleValues(pBinaryExpression);
            }
            case BINARY_XOR: {
                return this.allPossibleValues(pBinaryExpression);
            }
            case CONDITIONAL_AND: {
                return this.allPossibleValues(pBinaryExpression);
            }
            case CONDITIONAL_OR: {
                return this.allPossibleValues(pBinaryExpression);
            }
            case DIVIDE: {
                return this.compoundIntervalFormulaManager.divide(left, right);
            }
            case EQUALS: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.equal(left, right));
            }
            case GREATER_EQUAL: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.greaterThanOrEqual(left, right));
            }
            case GREATER_THAN: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.greaterThan(left, right));
            }
            case LESS_EQUAL: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.lessThan(left, right));
            }
            case LESS_THAN: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.lessThanOrEqual(left, right));
            }
            case LOGICAL_AND: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalAnd(logicalLeft, logicalRight));
            }
            case LOGICAL_OR: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalOr(logicalLeft, logicalRight));
            }
            case LOGICAL_XOR: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalOr(this.compoundIntervalFormulaManager.logicalAnd(logicalLeft, this.compoundIntervalFormulaManager.logicalNot(logicalRight)), this.compoundIntervalFormulaManager.logicalAnd(this.compoundIntervalFormulaManager.logicalNot(logicalLeft), logicalRight)));
            }
            case MINUS: {
                return this.compoundIntervalFormulaManager.subtract(left, right);
            }
            case MODULO: {
                return this.compoundIntervalFormulaManager.modulo(left, right);
            }
            case MULTIPLY: {
                return this.compoundIntervalFormulaManager.multiply(left, right);
            }
            case NOT_EQUALS: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalNot(this.compoundIntervalFormulaManager.equal(left, right)));
            }
            case PLUS: {
                return this.compoundIntervalFormulaManager.add(left, right);
            }
            case SHIFT_LEFT: {
                right = this.truncateShiftOperand(pBinaryExpression.getExpressionType(), right);
                return this.compoundIntervalFormulaManager.shiftLeft(left, right);
            }
            case SHIFT_RIGHT_SIGNED: {
                right = this.truncateShiftOperand(pBinaryExpression.getExpressionType(), right);
                return this.compoundIntervalFormulaManager.shiftRight(left, right);
            }
            case SHIFT_RIGHT_UNSIGNED: {
                right = this.truncateShiftOperand(pBinaryExpression.getExpressionType(), right);
                CompoundInterval leftEval = (CompoundInterval)left.accept(this.evaluationVisitor, this.environment);
                NumeralFormula<CompoundInterval> forPositiveLeft = this.compoundIntervalFormulaManager.shiftRight(left, right);
                if (!leftEval.containsNegative()) {
                    return forPositiveLeft;
                }
                NumeralFormula<CompoundInterval> forNegativeLeft = this.compoundIntervalFormulaManager.add(forPositiveLeft, this.compoundIntervalFormulaManager.shiftLeft(this.asConstant((Type)pBinaryExpression.getExpressionType(), this.compoundIntervalManagerFactory.createCompoundIntervalManager(left.getTypeInfo()).singleton(2L)), this.compoundIntervalFormulaManager.binaryNot(right)));
                if (!leftEval.containsPositive()) {
                    return forNegativeLeft;
                }
                return this.compoundIntervalFormulaManager.union(forPositiveLeft, forNegativeLeft);
            }
            case STRING_CONCATENATION: {
                return this.allPossibleValues(pBinaryExpression);
            }
        }
        throw new AssertionError((Object)("Unhandled enum value in switch: " + pBinaryExpression.getOperator()));
    }

    private NumeralFormula<CompoundInterval> truncateShiftOperand(JType pExpressionType, NumeralFormula<CompoundInterval> pOperand) {
        if (pExpressionType instanceof JSimpleType) {
            JSimpleType simpleType = (JSimpleType)pExpressionType;
            if (simpleType.getType() == JBasicType.INT) {
                return this.compoundIntervalFormulaManager.binaryAnd(pOperand, this.asConstant((Type)pExpressionType, 31L));
            }
            if (simpleType.getType() == JBasicType.LONG) {
                return this.compoundIntervalFormulaManager.binaryAnd(pOperand, this.asConstant((Type)pExpressionType, 63L));
            }
        }
        return pOperand;
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JUnaryExpression pUnaryExpression) throws UnrecognizedCodeException {
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pUnaryExpression.getExpressionType());
        switch (pUnaryExpression.getOperator()) {
            case MINUS: {
                return this.compoundIntervalFormulaManager.negate(pUnaryExpression.getOperand().accept(this));
            }
            case COMPLEMENT: {
                return this.allPossibleValues(pUnaryExpression);
            }
            case NOT: {
                return this.compoundIntervalFormulaManager.fromBoolean(typeInfo, this.compoundIntervalFormulaManager.logicalNot(this.compoundIntervalFormulaManager.fromNumeral(pUnaryExpression.getOperand().accept(this))));
            }
            case PLUS: {
                return pUnaryExpression.getOperand().accept(this);
            }
        }
        return this.allPossibleValues(pUnaryExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JIntegerLiteralExpression pIntegerLiteralExpression) throws UnrecognizedCodeException {
        return this.asConstant((Type)pIntegerLiteralExpression.getExpressionType(), pIntegerLiteralExpression.getValue());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JBooleanLiteralExpression pBooleanLiteralExpression) throws UnrecognizedCodeException {
        return this.asConstant((Type)pBooleanLiteralExpression.getExpressionType(), pBooleanLiteralExpression.getBoolean());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JFloatLiteralExpression pFloatLiteralExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pFloatLiteralExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JArrayCreationExpression pArrayCreationExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pArrayCreationExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JArrayInitializer pArrayInitializer) throws UnrecognizedCodeException {
        return this.allPossibleValues(pArrayInitializer);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JArrayLengthExpression pArrayLengthExpression) {
        return this.allPossibleValues(pArrayLengthExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JVariableRunTimeType pThisRunTimeType) throws UnrecognizedCodeException {
        return this.allPossibleValues(pThisRunTimeType);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JRunTimeTypeEqualsType pRunTimeTypeEqualsType) throws UnrecognizedCodeException {
        return this.allPossibleValues(pRunTimeTypeEqualsType);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JNullLiteralExpression pNullLiteralExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pNullLiteralExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JEnumConstantExpression pEnumConstantExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pEnumConstantExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JCastExpression pCastExpression) throws UnrecognizedCodeException {
        TypeInfo typeInfo = BitVectorInfo.from(this.machineModel, pCastExpression.getCastType());
        return this.compoundIntervalFormulaManager.cast(typeInfo, pCastExpression.getOperand().accept(this));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JThisExpression pThisExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pThisExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JClassLiteralExpression pJClassLiteralExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pJClassLiteralExpression.getExpressionType());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JArraySubscriptExpression pArraySubscriptExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pArraySubscriptExpression);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JIdExpression pIdExpression) throws UnrecognizedCodeException {
        return this.asVariable(pIdExpression.getExpressionType(), this.variableNameExtractor.getMemoryLocation((AExpression)pIdExpression));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JMethodInvocationExpression pFunctionCallExpression) throws UnrecognizedCodeException {
        return this.allPossibleValues(pFunctionCallExpression.getExpressionType());
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(JClassInstanceCreation pClassInstanceCreation) throws UnrecognizedCodeException {
        return this.allPossibleValues(pClassInstanceCreation.getExpressionType());
    }

    public static NumeralFormula<CompoundInterval> handlePotentialOverflow(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, NumeralFormula<CompoundInterval> pFormula, MachineModel pMachineModel, Type pTargetType, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = BitVectorInfo.from(pMachineModel, pTargetType);
        CompoundIntervalFormulaManager cifm = new CompoundIntervalFormulaManager(pCompoundIntervalManagerFactory);
        NumeralFormula<CompoundInterval> formula = cifm.cast(typeInfo, pFormula);
        CompoundIntervalManager cim = pCompoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
        FormulaCompoundStateEvaluationVisitor evaluator = new FormulaCompoundStateEvaluationVisitor(pCompoundIntervalManagerFactory);
        CompoundInterval value = formula.accept(evaluator, pEnvironment);
        if (value instanceof CompoundIntegralInterval && typeInfo instanceof BitVectorInfo) {
            BitVectorInfo bitVectorInfo = (BitVectorInfo)typeInfo;
            BigInteger lowerInclusiveBound = bitVectorInfo.getMinValue();
            BigInteger upperExclusiveBound = bitVectorInfo.getMaxValue().add(BigInteger.ONE);
            CompoundIntegralInterval integralValue = (CompoundIntegralInterval)value;
            if (typeInfo.isSigned()) {
                CompoundInterval ci;
                if (!value.hasLowerBound() || !value.hasUpperBound()) {
                    return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.allPossibleValues());
                }
                if (integralValue.getLowerBound().compareTo(lowerInclusiveBound) < 0) {
                    return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.allPossibleValues());
                }
                if (integralValue.getUpperBound().compareTo(upperExclusiveBound) >= 0) {
                    return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.allPossibleValues());
                }
                if (pCompoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory && !((CompoundBitVectorIntervalManagerFactory)pCompoundIntervalManagerFactory).isSignedWrapAroundAllowed() && (ci = pFormula.accept(evaluator, pEnvironment)) instanceof CompoundBitVectorInterval) {
                    CompoundBitVectorInterval cbvi = (CompoundBitVectorInterval)ci;
                    AtomicBoolean overflows = new AtomicBoolean();
                    OverflowEventHandler overflowEventHandler = () -> overflows.set(true);
                    cbvi.cast(bitVectorInfo, false, overflowEventHandler);
                    if (overflows.get()) {
                        return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.allPossibleValues());
                    }
                }
                return formula;
            }
            assert (lowerInclusiveBound.compareTo(upperExclusiveBound) < 0);
            if (!value.hasLowerBound()) {
                return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.allPossibleValues());
            }
            if (integralValue.getLowerBound().compareTo(lowerInclusiveBound) >= 0 && value.hasUpperBound() && integralValue.getUpperBound().compareTo(upperExclusiveBound) < 0) {
                return formula;
            }
            CompoundInterval negativePart = cim.intersect(value, cim.negate(cim.singleton(1L)).extendToMinValue());
            CompoundInterval negativePartMod = cim.modulo(negativePart, cim.singleton(upperExclusiveBound));
            CompoundInterval negativePartResult = cim.add(cim.singleton(upperExclusiveBound), negativePartMod);
            CompoundInterval nonNegativePart = cim.intersect(value, cim.singleton(0L).extendToMaxValue());
            CompoundInterval nonNegativePartResult = cim.modulo(nonNegativePart, cim.singleton(upperExclusiveBound));
            return InvariantsFormulaManager.INSTANCE.asConstant(typeInfo, cim.union(negativePartResult, nonNegativePartResult));
        }
        return formula;
    }

    public static CRightHandSide makeCastFromArrayToPointerIfNecessary(CRightHandSide pExpression, CType pTargetType) {
        if (pExpression instanceof CExpression) {
            return ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary((CExpression)pExpression, pTargetType);
        }
        return pExpression;
    }

    public static AExpression makeCastFromArrayToPointerIfNecessary(AExpression pExpression, Type pTargetType) {
        if (pExpression instanceof CExpression && pTargetType instanceof CType) {
            return ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary((CExpression)pExpression, (CType)pTargetType);
        }
        return pExpression;
    }

    public static ARightHandSide makeCastFromArrayToPointerIfNecessary(ARightHandSide pExpression, Type pTargetType) {
        if (pExpression instanceof CExpression && pTargetType instanceof CType) {
            return ExpressionToFormulaVisitor.makeCastFromArrayToPointerIfNecessary((CExpression)pExpression, (CType)pTargetType);
        }
        return pExpression;
    }

    public static CExpression makeCastFromArrayToPointerIfNecessary(CExpression pExpression, CType pTargetType) {
        CType targetType;
        if (pExpression.getExpressionType().getCanonicalType() instanceof CArrayType && ((targetType = pTargetType.getCanonicalType()) instanceof CPointerType || targetType instanceof CSimpleType)) {
            return ExpressionToFormulaVisitor.makeCastFromArrayToPointer(pExpression);
        }
        return pExpression;
    }

    private static CExpression makeCastFromArrayToPointer(CExpression pArrayExpression) {
        CArrayType arrayType = (CArrayType)pArrayExpression.getExpressionType().getCanonicalType();
        CPointerType pointerType = arrayType.asPointerType();
        return new CUnaryExpression(pArrayExpression.getFileLocation(), pointerType, pArrayExpression, CUnaryExpression.UnaryOperator.AMPER);
    }
}

