/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaCompoundStateEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class FormulaAbstractionVisitor
extends DefaultParameterizedNumeralFormulaVisitor<CompoundInterval, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>, CompoundInterval>
implements FormulaEvaluationVisitor<CompoundInterval> {
    private final FormulaCompoundStateEvaluationVisitor evaluationVisitor;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;

    public FormulaAbstractionVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        this.evaluationVisitor = new FormulaCompoundStateEvaluationVisitor(pCompoundIntervalManagerFactory);
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pInfo) {
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pInfo);
    }

    private CompoundIntervalManager getCompoundIntervalManager(Typed pTyped) {
        return this.getCompoundIntervalManager(pTyped.getTypeInfo());
    }

    @Override
    public CompoundInterval visit(Add<CompoundInterval> pAdd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.weakAdd(pAdd.getTypeInfo(), pAdd.getSummand1().accept(this.evaluationVisitor, pEnvironment), pAdd.getSummand2().accept(this.evaluationVisitor, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Constant<CompoundInterval> pConstant, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return pConstant.getValue();
    }

    @Override
    public CompoundInterval visit(Multiply<CompoundInterval> pMultiply, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.weakMultiply(pMultiply.getTypeInfo(), pMultiply.getFactor1().accept(this, pEnvironment), pMultiply.getFactor2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval toShift = pShiftLeft.getShifted().accept(this, pEnvironment);
        CompoundInterval shiftDistance = pShiftLeft.getShiftDistance().accept(this, pEnvironment);
        CompoundInterval evaluation = this.getCompoundIntervalManager(pShiftLeft).shiftLeft(toShift, shiftDistance);
        if (!shiftDistance.containsPositive()) {
            return evaluation;
        }
        return this.abstractionOf(pShiftLeft.getTypeInfo(), evaluation);
    }

    @Override
    public CompoundInterval visit(Variable<CompoundInterval> pVariable, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula<CompoundInterval> varState = pEnvironment.get(pVariable.getMemoryLocation());
        if (varState == null) {
            return this.getCompoundIntervalManager(pVariable).allPossibleValues();
        }
        return varState.accept(this, pEnvironment);
    }

    @Override
    protected CompoundInterval visitDefault(NumeralFormula<CompoundInterval> pFormula, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pParam) {
        return this.abstractionOf(pFormula.getTypeInfo(), pFormula.accept(this.evaluationVisitor, pParam));
    }

    private CompoundInterval abstractionOf(TypeInfo pTypeInfo, CompoundInterval pValue) {
        if (pValue.isBottom() || pValue.containsAllPossibleValues()) {
            return pValue;
        }
        CompoundInterval result = pValue.signum();
        boolean extendToNeg = false;
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pTypeInfo);
        if (!compoundIntervalManager.lessThan(pValue, result).isDefinitelyFalse()) {
            extendToNeg = true;
        }
        if (!compoundIntervalManager.greaterThan(pValue, result).isDefinitelyFalse()) {
            result = result.extendToMaxValue();
        }
        if (extendToNeg) {
            result = result.extendToMinValue();
        }
        assert (compoundIntervalManager.union(result, pValue).equals(result));
        return result;
    }

    private CompoundInterval weakAdd(TypeInfo pTypeInfo, CompoundInterval pA, CompoundInterval pB) {
        if (pA.isSingleton() && pA.contains(BigInteger.ZERO)) {
            return pB;
        }
        if (pB.isSingleton() && pB.contains(BigInteger.ZERO)) {
            return pA;
        }
        return this.abstractionOf(pTypeInfo, this.getCompoundIntervalManager(pTypeInfo).add(pA, pB));
    }

    private CompoundInterval weakMultiply(TypeInfo pTypeInfo, CompoundInterval a, CompoundInterval b) {
        if (a.isSingleton() && a.contains(BigInteger.ZERO)) {
            return a;
        }
        if (b.isSingleton() && b.contains(BigInteger.ZERO)) {
            return b;
        }
        if (a.isSingleton() && a.contains(BigInteger.ONE)) {
            return b;
        }
        if (b.isSingleton() && b.contains(BigInteger.ONE)) {
            return a;
        }
        CompoundIntervalManager cim = this.getCompoundIntervalManager(pTypeInfo);
        if (a.isSingleton() && a.contains(BigInteger.ONE.negate())) {
            return cim.negate(b);
        }
        if (b.isSingleton() && b.contains(BigInteger.ONE.negate())) {
            return cim.negate(a);
        }
        return this.abstractionOf(pTypeInfo, cim.multiply(a, b));
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(Equal<CompoundInterval> pEqual, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visit(pEqual, pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LessThan<CompoundInterval> pLessThan, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visit(pLessThan, pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visit(pAnd, pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LogicalNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visit(pNot, pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visitFalse(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visitFalse(pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visitTrue(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluationVisitor.visitTrue(pEnvironment);
    }

    public int hashCode() {
        return Objects.hash(this.evaluationVisitor, this.compoundIntervalManagerFactory);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof FormulaAbstractionVisitor) {
            FormulaAbstractionVisitor other = (FormulaAbstractionVisitor)pOther;
            return this.evaluationVisitor.equals(other.evaluationVisitor) && this.compoundIntervalManagerFactory.equals(other.compoundIntervalManagerFactory);
        }
        return false;
    }
}

