/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class FormulaCompoundStateEvaluationVisitor
implements FormulaEvaluationVisitor<CompoundInterval> {
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final boolean withOverflowEventHandlers;

    public FormulaCompoundStateEvaluationVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        this(pCompoundIntervalManagerFactory, true);
    }

    public FormulaCompoundStateEvaluationVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, boolean pWithOverflowEventHandlers) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.withOverflowEventHandlers = pWithOverflowEventHandlers;
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pTypeInfo) {
        if (this.compoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory) {
            CompoundBitVectorIntervalManagerFactory compoundBitVectorIntervalManagerFactory = (CompoundBitVectorIntervalManagerFactory)this.compoundIntervalManagerFactory;
            return compoundBitVectorIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo, this.withOverflowEventHandlers);
        }
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo);
    }

    private CompoundIntervalManager getCompoundIntervalManager(Typed pTyped) {
        return this.getCompoundIntervalManager(pTyped.getTypeInfo());
    }

    @Override
    public CompoundInterval visit(Add<CompoundInterval> pAdd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pAdd).add(pAdd.getSummand1().accept(this, pEnvironment), pAdd.getSummand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pAnd).binaryAnd(pAnd.getOperand1().accept(this, pEnvironment), pAnd.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pNot).binaryNot(pNot.getFlipped().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryOr<CompoundInterval> pOr, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pOr).binaryOr(pOr.getOperand1().accept(this, pEnvironment), pOr.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(BinaryXor<CompoundInterval> pXor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pXor).binaryXor(pXor.getOperand1().accept(this, pEnvironment), pXor.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Constant<CompoundInterval> pConstant, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return pConstant.getValue();
    }

    @Override
    public CompoundInterval visit(Divide<CompoundInterval> pDivide, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pDivide).divide(pDivide.getNumerator().accept(this, pEnvironment), pDivide.getDenominator().accept(this, pEnvironment));
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(Equal<CompoundInterval> pEqual, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        Exclusion exclusion;
        NumeralFormula<CompoundInterval> value;
        Variable var;
        CompoundInterval operand1 = pEqual.getOperand1().accept(this, pEnvironment);
        CompoundInterval operand2 = pEqual.getOperand2().accept(this, pEnvironment);
        CompoundInterval result = this.getCompoundIntervalManager(pEqual.getOperand1()).logicalEquals(operand1, operand2);
        if (result.isDefinitelyTrue()) {
            return BooleanConstant.getTrue();
        }
        if (result.isDefinitelyFalse()) {
            return BooleanConstant.getFalse();
        }
        if (pEqual.getOperand1() instanceof Variable) {
            var = (Variable)pEqual.getOperand1();
            value = pEnvironment.get(var.getMemoryLocation());
            while (value != null) {
                if (value instanceof Exclusion && (exclusion = (Exclusion)value).getExcluded().equals(pEqual.getOperand2())) {
                    return BooleanConstant.getFalse();
                }
                if (value instanceof Variable) {
                    if (value.equals(var)) {
                        return BooleanConstant.getTrue();
                    }
                    var = (Variable)value;
                    value = pEnvironment.get(var.getMemoryLocation());
                    continue;
                }
                value = null;
            }
        }
        if (pEqual.getOperand2() instanceof Variable) {
            var = (Variable)pEqual.getOperand2();
            value = pEnvironment.get(var.getMemoryLocation());
            while (value != null) {
                if (value.equals(pEqual.getOperand1())) {
                    return BooleanConstant.getTrue();
                }
                if (value instanceof Exclusion && (exclusion = (Exclusion)value).getExcluded().equals(pEqual.getOperand1())) {
                    return BooleanConstant.getFalse();
                }
                if (value instanceof Variable) {
                    var = (Variable)value;
                    value = pEnvironment.get(var.getMemoryLocation());
                    continue;
                }
                value = null;
            }
        }
        return null;
    }

    @Override
    public CompoundInterval visit(Exclusion<CompoundInterval> pExclusion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval excluded = pExclusion.getExcluded().accept(this, pEnvironment);
        if (excluded.isSingleton()) {
            return excluded.invert();
        }
        return this.getCompoundIntervalManager(pExclusion).allPossibleValues();
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LessThan<CompoundInterval> pLessThan, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval value = this.getCompoundIntervalManager(pLessThan.getOperand1()).lessThan(pLessThan.getOperand1().accept(this, pEnvironment), pLessThan.getOperand2().accept(this, pEnvironment));
        if (value.isDefinitelyTrue()) {
            return BooleanConstant.getTrue();
        }
        if (value.isDefinitelyFalse()) {
            return BooleanConstant.getFalse();
        }
        return null;
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BooleanConstant<CompoundInterval> leftEval = pAnd.getOperand1().accept(this, pEnvironment);
        BooleanConstant<CompoundInterval> rightEval = pAnd.getOperand2().accept(this, pEnvironment);
        if (leftEval != null && !leftEval.getValue()) {
            return leftEval;
        }
        if (rightEval != null && !rightEval.getValue()) {
            return rightEval;
        }
        if (leftEval != null && rightEval != null && leftEval.getValue() && rightEval.getValue()) {
            return leftEval;
        }
        return null;
    }

    @Override
    public BooleanConstant<CompoundInterval> visit(LogicalNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BooleanConstant<CompoundInterval> operandEval = pNot.getNegated().accept(this, pEnvironment);
        if (operandEval == null) {
            return operandEval;
        }
        return operandEval.negate();
    }

    @Override
    public CompoundInterval visit(Modulo<CompoundInterval> pModulo, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pModulo).modulo(pModulo.getNumerator().accept(this, pEnvironment), pModulo.getDenominator().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Multiply<CompoundInterval> pMultiply, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pMultiply).multiply(pMultiply.getFactor1().accept(this, pEnvironment), pMultiply.getFactor2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pShiftLeft).shiftLeft(pShiftLeft.getShifted().accept(this, pEnvironment), pShiftLeft.getShiftDistance().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pShiftRight).shiftRight(pShiftRight.getShifted().accept(this, pEnvironment), pShiftRight.getShiftDistance().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Union<CompoundInterval> pUnion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.getCompoundIntervalManager(pUnion).union(pUnion.getOperand1().accept(this, pEnvironment), pUnion.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Variable<CompoundInterval> pVariable, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        NumeralFormula<CompoundInterval> varState = pEnvironment.get(pVariable.getMemoryLocation());
        if (varState == null) {
            return this.getCompoundIntervalManager(pVariable).allPossibleValues();
        }
        return varState.accept(this, pEnvironment);
    }

    @Override
    public BooleanConstant<CompoundInterval> visitFalse(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return BooleanConstant.getFalse();
    }

    @Override
    public BooleanConstant<CompoundInterval> visitTrue(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return BooleanConstant.getTrue();
    }

    @Override
    public CompoundInterval visit(IfThenElse<CompoundInterval> pIfThenElse, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BooleanConstant<CompoundInterval> condition = pIfThenElse.getCondition().accept(this, pEnvironment);
        if (BooleanConstant.isTrue(condition)) {
            return pIfThenElse.getPositiveCase().accept(this, pEnvironment);
        }
        if (BooleanConstant.isFalse(condition)) {
            return pIfThenElse.getNegativeCase().accept(this, pEnvironment);
        }
        return this.getCompoundIntervalManager(pIfThenElse).union(pIfThenElse.getPositiveCase().accept(this, pEnvironment), pIfThenElse.getNegativeCase().accept(this, pEnvironment));
    }

    @Override
    public CompoundInterval visit(Cast<CompoundInterval> pCast, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        CompoundInterval casted = pCast.getCasted().accept(this, pEnvironment);
        return this.getCompoundIntervalManager(pCast).cast(pCast.getTypeInfo(), casted);
    }

    public int hashCode() {
        return Objects.hash(this.withOverflowEventHandlers, this.compoundIntervalManagerFactory);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof FormulaCompoundStateEvaluationVisitor) {
            FormulaCompoundStateEvaluationVisitor other = (FormulaCompoundStateEvaluationVisitor)pOther;
            return this.withOverflowEventHandlers == other.withOverflowEventHandlers && this.compoundIntervalManagerFactory.equals(other.compoundIntervalManagerFactory);
        }
        return false;
    }
}

