/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.formula.AbstractFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;

class IfThenElse<ConstantType>
extends AbstractFormula<ConstantType> {
    private final BooleanFormula<ConstantType> condition;
    private final NumeralFormula<ConstantType> positiveCase;
    private final NumeralFormula<ConstantType> negativeCase;

    private IfThenElse(BooleanFormula<ConstantType> pCondition, NumeralFormula<ConstantType> pPositiveCase, NumeralFormula<ConstantType> pNegativeCase) {
        super(pPositiveCase.getTypeInfo());
        Preconditions.checkNotNull(pCondition);
        Preconditions.checkNotNull(pNegativeCase);
        Preconditions.checkArgument((boolean)pPositiveCase.getTypeInfo().equals(pNegativeCase.getTypeInfo()));
        this.condition = pCondition;
        this.positiveCase = pPositiveCase;
        this.negativeCase = pNegativeCase;
    }

    public BooleanFormula<ConstantType> getCondition() {
        return this.condition;
    }

    public NumeralFormula<ConstantType> getPositiveCase() {
        return this.positiveCase;
    }

    public NumeralFormula<ConstantType> getNegativeCase() {
        return this.negativeCase;
    }

    public String toString() {
        return String.format("(%s ? %s : %s)", this.getCondition(), this.getPositiveCase(), this.getNegativeCase());
    }

    public int hashCode() {
        return Objects.hash(this.getCondition(), this.getPositiveCase(), this.getNegativeCase());
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof IfThenElse) {
            IfThenElse other = (IfThenElse)pOther;
            return this.getCondition().equals(other.getCondition()) && this.getPositiveCase().equals(other.getPositiveCase()) && this.getNegativeCase().equals(other.getNegativeCase());
        }
        return false;
    }

    @Override
    public <ReturnType> ReturnType accept(NumeralFormulaVisitor<ConstantType, ReturnType> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedNumeralFormulaVisitor<ConstantType, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return pVisitor.visit(this, pParameter);
    }

    public static <ConstantType> IfThenElse<ConstantType> of(BooleanFormula<ConstantType> pCondition, NumeralFormula<ConstantType> pPositiveCase, NumeralFormula<ConstantType> pNegativeCase) {
        return new IfThenElse<ConstantType>(pCondition, pPositiveCase, pNegativeCase);
    }
}

