/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public enum InvariantsFormulaManager {
    INSTANCE;


    public <T> NumeralFormula<T> add(NumeralFormula<T> pSummand1, NumeralFormula<T> pSummand2) {
        return Add.of(pSummand1, pSummand2);
    }

    public <T> NumeralFormula<T> binaryAnd(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return BinaryAnd.of(pOperand1, pOperand2);
    }

    public <T> NumeralFormula<T> binaryNot(NumeralFormula<T> pToFlip) {
        return BinaryNot.of(pToFlip);
    }

    public <T> NumeralFormula<T> binaryOr(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return BinaryOr.of(pOperand1, pOperand2);
    }

    public <T> NumeralFormula<T> binaryXor(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return BinaryXor.of(pOperand1, pOperand2);
    }

    public <T extends Typed> NumeralFormula<T> asConstant(T pValue) {
        return Constant.of(pValue);
    }

    public <T> NumeralFormula<T> asConstant(TypeInfo pTypeInfo, T pValue) {
        return Constant.of(pTypeInfo, pValue);
    }

    public <T> NumeralFormula<T> divide(NumeralFormula<T> pNumerator, NumeralFormula<T> pDenominator) {
        return Divide.of(pNumerator, pDenominator);
    }

    public <T> BooleanFormula<T> equal(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        if (pOperand1 instanceof Exclusion) {
            return this.logicalNot(Equal.of(((Exclusion)pOperand1).getExcluded(), pOperand2));
        }
        if (pOperand2 instanceof Exclusion) {
            return this.logicalNot(Equal.of(pOperand1, ((Exclusion)pOperand2).getExcluded()));
        }
        return Equal.of(pOperand1, pOperand2);
    }

    public <T> NumeralFormula<T> exclude(NumeralFormula<T> pToExclude) {
        return Exclusion.of(pToExclude);
    }

    public <T> BooleanFormula<T> greaterThan(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return this.lessThan(pOperand2, pOperand1);
    }

    public <T> BooleanFormula<T> greaterThanOrEqual(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return this.logicalNot(this.lessThan(pOperand1, pOperand2));
    }

    public <T> BooleanFormula<T> lessThan(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return LessThan.of(pOperand1, pOperand2);
    }

    public <T> BooleanFormula<T> lessThanOrEqual(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        return this.greaterThanOrEqual(pOperand2, pOperand1);
    }

    public <T> BooleanFormula<T> logicalAnd(BooleanFormula<T> pOperand1, BooleanFormula<T> pOperand2) {
        return LogicalAnd.of(pOperand1, pOperand2);
    }

    public <T> BooleanFormula<T> logicalNot(BooleanFormula<T> pToNegate) {
        if (pToNegate instanceof LogicalNot) {
            return ((LogicalNot)pToNegate).getNegated();
        }
        return LogicalNot.of(pToNegate);
    }

    public <T> BooleanFormula<T> logicalOr(BooleanFormula<T> pOperand1, BooleanFormula<T> pOperand2) {
        return this.logicalNot(LogicalAnd.of(this.logicalNot(pOperand1), this.logicalNot(pOperand2)));
    }

    public <T> BooleanFormula<T> logicalImplies(BooleanFormula<T> pOperand1, BooleanFormula<T> pOperand2) {
        return this.logicalNot(LogicalAnd.of(pOperand1, this.logicalNot(pOperand2)));
    }

    public <T> NumeralFormula<T> modulo(NumeralFormula<T> pNumerator, NumeralFormula<T> pDenominator) {
        return Modulo.of(pNumerator, pDenominator);
    }

    public <T> NumeralFormula<T> multiply(NumeralFormula<T> pFactor1, NumeralFormula<T> pFactor2) {
        return Multiply.of(pFactor1, pFactor2);
    }

    public <T> NumeralFormula<T> shiftLeft(NumeralFormula<T> pToShift, NumeralFormula<T> pShiftDistance) {
        return ShiftLeft.of(pToShift, pShiftDistance);
    }

    public <T> NumeralFormula<T> shiftRight(NumeralFormula<T> pToShift, NumeralFormula<T> pShiftDistance) {
        return ShiftRight.of(pToShift, pShiftDistance);
    }

    public <T> NumeralFormula<T> union(NumeralFormula<T> pOperand1, NumeralFormula<T> pOperand2) {
        if (pOperand1.equals(pOperand2)) {
            return pOperand1;
        }
        return Union.of(pOperand1, pOperand2);
    }

    public <T> Variable<T> asVariable(TypeInfo pTypeInfo, MemoryLocation pMemoryLocation) {
        return Variable.of(pTypeInfo, pMemoryLocation);
    }

    public <T> NumeralFormula<T> ifThenElse(BooleanFormula<T> pCondition, NumeralFormula<T> pPositiveCase, NumeralFormula<T> pNegativeCase) {
        if (BooleanConstant.isTrue(pCondition)) {
            return pPositiveCase;
        }
        if (BooleanConstant.isFalse(pCondition)) {
            return pNegativeCase;
        }
        return IfThenElse.of(pCondition, pPositiveCase, pNegativeCase);
    }

    public <T> NumeralFormula<T> cast(TypeInfo pTypeInfo, NumeralFormula<T> pToCast) {
        if (pTypeInfo.equals(pToCast.getTypeInfo())) {
            return pToCast;
        }
        return Cast.of(pTypeInfo, pToCast);
    }
}

