/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;

public class LessThan<ConstantType>
implements BooleanFormula<ConstantType> {
    private final NumeralFormula<ConstantType> operand1;
    private final NumeralFormula<ConstantType> operand2;

    private LessThan(NumeralFormula<ConstantType> pOperand1, NumeralFormula<ConstantType> pOperand2) {
        Preconditions.checkArgument((boolean)pOperand1.getTypeInfo().equals(pOperand2.getTypeInfo()));
        this.operand1 = pOperand1;
        this.operand2 = pOperand2;
    }

    public NumeralFormula<ConstantType> getOperand1() {
        return this.operand1;
    }

    public NumeralFormula<ConstantType> getOperand2() {
        return this.operand2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LessThan) {
            LessThan other = (LessThan)o;
            return this.getOperand1().equals(other.getOperand1()) && this.getOperand2().equals(other.getOperand2());
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.getOperand1().hashCode() + this.getOperand2().hashCode();
    }

    public String toString() {
        return String.format("(%s < %s)", this.getOperand1(), this.getOperand2());
    }

    @Override
    public <ReturnType> ReturnType accept(BooleanFormulaVisitor<ConstantType, ReturnType> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedBooleanFormulaVisitor<ConstantType, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return pVisitor.visit(this, pParameter);
    }

    static <ConstantType> LessThan<ConstantType> of(NumeralFormula<ConstantType> pOperand1, NumeralFormula<ConstantType> pOperand2) {
        return new LessThan<ConstantType>(pOperand1, pOperand2);
    }
}

