/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;

public class LogicalNot<ConstantType>
implements BooleanFormula<ConstantType> {
    private final BooleanFormula<ConstantType> negatedFormula;

    private LogicalNot(BooleanFormula<ConstantType> pToNegate) {
        Preconditions.checkNotNull(pToNegate);
        this.negatedFormula = pToNegate;
    }

    public BooleanFormula<ConstantType> getNegated() {
        return this.negatedFormula;
    }

    public String toString() {
        BooleanFormula<ConstantType> negated = this.getNegated();
        if (negated instanceof LogicalNot) {
            return ((LogicalNot)negated).getNegated().toString();
        }
        if (negated instanceof Equal) {
            Equal equation = (Equal)negated;
            return String.format("(%s != %s)", equation.getOperand1(), equation.getOperand2());
        }
        if (negated instanceof LessThan) {
            LessThan lessThan = (LessThan)negated;
            return String.format("(%s >= %s)", lessThan.getOperand1(), lessThan.getOperand2());
        }
        if (negated instanceof LogicalAnd) {
            LogicalAnd and = (LogicalAnd)negated;
            String left = and.getOperand1() instanceof LogicalNot ? ((LogicalNot)and.getOperand1()).getNegated().toString() : String.format("(!%s)", and.getOperand1());
            String right = and.getOperand2() instanceof LogicalNot ? ((LogicalNot)and.getOperand2()).getNegated().toString() : String.format("(!%s)", and.getOperand2());
            return String.format("(%s || %s)", left, right);
        }
        return String.format("(!%s)", negated);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LogicalNot) {
            return this.getNegated().equals(((LogicalNot)o).getNegated());
        }
        return false;
    }

    public int hashCode() {
        return -this.getNegated().hashCode();
    }

    @Override
    public <ReturnType> ReturnType accept(BooleanFormulaVisitor<ConstantType, ReturnType> pVisitor) {
        return pVisitor.visit(this);
    }

    @Override
    public <ReturnType, ParamType> ReturnType accept(ParameterizedBooleanFormulaVisitor<ConstantType, ParamType, ReturnType> pVisitor, ParamType pParameter) {
        return pVisitor.visit(this, pParameter);
    }

    static <ConstantType> LogicalNot<ConstantType> of(BooleanFormula<ConstantType> pToNegate) {
        return new LogicalNot<ConstantType>(pToNegate);
    }
}

