/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class Mod2AbstractionVisitor
extends DefaultNumeralFormulaVisitor<CompoundInterval, Type> {
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> environment;
    private final Set<BooleanFormula<CompoundInterval>> assumptions;

    public Mod2AbstractionVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment, Set<BooleanFormula<CompoundInterval>> pAssumptions) {
        this.compoundIntervalManagerFactory = Objects.requireNonNull(pCompoundIntervalManagerFactory);
        this.evaluationVisitor = Objects.requireNonNull(pEvaluationVisitor);
        this.environment = Objects.requireNonNull(pEnvironment);
        this.assumptions = Objects.requireNonNull(pAssumptions);
    }

    @Override
    public Type visit(Add<CompoundInterval> pAdd) {
        Type op2Type;
        Type op1Type = pAdd.getOperand1().accept(this);
        if (op1Type != Type.UNKNOWN && (op2Type = pAdd.getOperand2().accept(this)) != Type.UNKNOWN) {
            if (op1Type == op2Type) {
                return Type.EVEN;
            }
            return Type.ODD;
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pAdd);
    }

    @Override
    public Type visit(Multiply<CompoundInterval> pMultiply) {
        Type op1Type = pMultiply.getOperand1().accept(this);
        if (op1Type == Type.EVEN) {
            return Type.EVEN;
        }
        Type op2Type = pMultiply.getOperand2().accept(this);
        if (op2Type == Type.EVEN) {
            return Type.EVEN;
        }
        if (op1Type == Type.ODD && op2Type == Type.ODD) {
            return Type.ODD;
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pMultiply);
    }

    @Override
    public Type visit(Variable<CompoundInterval> pVariable) {
        Type t;
        NumeralFormula<CompoundInterval> value = this.environment.get(pVariable.getMemoryLocation());
        if (value != null && (t = value.accept(this)) != Type.UNKNOWN) {
            return t;
        }
        return (Type)((Object)super.visit(pVariable));
    }

    @Override
    protected Type visitDefault(NumeralFormula<CompoundInterval> pFormula) {
        BooleanFormula<CompoundInterval> evenTemplate = this.instantiateModTemplate(pFormula, 2, 0);
        if (this.assumptions.contains(evenTemplate)) {
            return Type.EVEN;
        }
        BooleanFormula<CompoundInterval> oddTemplate = this.instantiateModTemplate(pFormula, 2, 1);
        if (this.assumptions.contains(oddTemplate)) {
            return Type.ODD;
        }
        CompoundIntervalManager compoundIntervalManager = this.compoundIntervalManagerFactory.createCompoundIntervalManager(pFormula.getTypeInfo());
        CompoundInterval value = (CompoundInterval)InvariantsFormulaManager.INSTANCE.modulo(pFormula, InvariantsFormulaManager.INSTANCE.asConstant(pFormula.getTypeInfo(), compoundIntervalManager.singleton(2L))).accept(this.evaluationVisitor, this.environment);
        if (value.isSingleton()) {
            if (value.contains(BigInteger.ZERO)) {
                return Type.EVEN;
            }
            return Type.ODD;
        }
        return Type.UNKNOWN;
    }

    private BooleanFormula<CompoundInterval> instantiateModTemplate(NumeralFormula<CompoundInterval> pDividend, int pDivisor, int pRemainder) {
        Preconditions.checkArgument((pDivisor >= 2 ? 1 : 0) != 0, (Object)"Divisor must be greater than 1.");
        if (pRemainder < 0 || pRemainder >= pDivisor) {
            throw new IllegalArgumentException(String.format("The remainder must be between 0 and %d.", pDivisor - 1));
        }
        CompoundIntervalManager compoundIntervalManager = this.compoundIntervalManagerFactory.createCompoundIntervalManager(pDividend.getTypeInfo());
        BooleanFormula<CompoundInterval> hint = InvariantsFormulaManager.INSTANCE.equal(InvariantsFormulaManager.INSTANCE.modulo(pDividend, InvariantsFormulaManager.INSTANCE.asConstant(pDividend.getTypeInfo(), compoundIntervalManager.singleton(pDivisor))), InvariantsFormulaManager.INSTANCE.asConstant(pDividend.getTypeInfo(), compoundIntervalManager.singleton(pRemainder)));
        return hint;
    }

    public static enum Type {
        EVEN,
        ODD,
        UNKNOWN;

    }
}

