/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushSummandVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class PartialEvaluator
implements ParameterizedNumeralFormulaVisitor<CompoundInterval, FormulaEvaluationVisitor<CompoundInterval>, NumeralFormula<CompoundInterval>>,
ParameterizedBooleanFormulaVisitor<CompoundInterval, FormulaEvaluationVisitor<CompoundInterval>, BooleanFormula<CompoundInterval>> {
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> environment;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final CompoundIntervalFormulaManager compoundIntervalFormulaManager;

    public PartialEvaluator(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        this(pCompoundIntervalManagerFactory, (Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>)ImmutableMap.of());
    }

    public PartialEvaluator(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, CompoundIntervalFormulaManager pCompoundIntervalFormulaManager) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.environment = ImmutableMap.of();
        this.compoundIntervalFormulaManager = pCompoundIntervalFormulaManager;
    }

    public PartialEvaluator(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.environment = pEnvironment;
        this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof PartialEvaluator) {
            PartialEvaluator other = (PartialEvaluator)pObj;
            return this.compoundIntervalManagerFactory.equals(other.compoundIntervalManagerFactory) && this.compoundIntervalFormulaManager.equals(other.compoundIntervalFormulaManager) && this.environment.equals(other.environment);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.compoundIntervalManagerFactory, this.compoundIntervalFormulaManager, this.environment);
    }

    private CompoundIntervalManager getCompoundIntervalManager(TypeInfo pTypeInfo) {
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo);
    }

    private CompoundIntervalManager getCompoundIntervalManager(Typed pTyped) {
        return this.getCompoundIntervalManager(pTyped.getTypeInfo());
    }

    private NumeralFormula<CompoundInterval> evaluateAndWrap(NumeralFormula<CompoundInterval> pFormula, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pFormula.getTypeInfo(), (CompoundInterval)pFormula.accept(pEvaluationVisitor, this.environment));
    }

    private NumeralFormula<CompoundInterval> asConstant(Typed pTyped, CompoundInterval pValue) {
        return InvariantsFormulaManager.INSTANCE.asConstant(pTyped.getTypeInfo(), pValue);
    }

    private NumeralFormula<CompoundInterval> singleton(Typed pTyped, BigInteger pValue) {
        TypeInfo info = pTyped.getTypeInfo();
        return InvariantsFormulaManager.INSTANCE.asConstant(info, this.getCompoundIntervalManager(info).singleton(pValue));
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Add<CompoundInterval> pAdd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> summand1 = pAdd.getSummand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> summand2 = pAdd.getSummand2().accept(this, pEvaluationVisitor);
        if (summand1 instanceof Constant && summand2 instanceof Constant) {
            return this.evaluateAndWrap(pAdd, pEvaluationVisitor);
        }
        Constant c = null;
        NumeralFormula<CompoundInterval> other = null;
        if (summand1 instanceof Constant) {
            c = (Constant)summand1;
            other = summand2;
        } else if (summand2 instanceof Constant) {
            c = (Constant)summand2;
            other = summand1;
        }
        if (c != null && other != null) {
            CompoundInterval value = (CompoundInterval)c.getValue();
            if (value.isSingleton() && value.getValue().equals(BigInteger.ZERO)) {
                return other;
            }
            if (value.containsAllPossibleValues() || value.isBottom()) {
                return c;
            }
            PushSummandVisitor<CompoundInterval> psv = new PushSummandVisitor<CompoundInterval>(pEvaluationVisitor);
            other = (NumeralFormula<CompoundInterval>)other.accept(psv, value);
            if (psv.isSummandConsumed()) {
                other = other.accept(this, pEvaluationVisitor);
            }
            return other;
        }
        if (summand1 == pAdd.getSummand1() && summand2 == pAdd.getSummand2()) {
            return pAdd;
        }
        return this.compoundIntervalFormulaManager.add(summand1, summand2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(BinaryAnd<CompoundInterval> pAnd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> operand1 = pAnd.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pAnd.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return this.evaluateAndWrap(pAnd, pEvaluationVisitor);
        }
        if (operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2()) {
            return pAnd;
        }
        return this.compoundIntervalFormulaManager.binaryAnd(operand1, operand2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(BinaryNot<CompoundInterval> pNot, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> operand = pNot.getFlipped().accept(this, pEvaluationVisitor);
        if (operand instanceof Constant) {
            return this.evaluateAndWrap(pNot, pEvaluationVisitor);
        }
        if (operand == pNot.getFlipped()) {
            return pNot;
        }
        return this.compoundIntervalFormulaManager.binaryNot(operand);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(BinaryOr<CompoundInterval> pOr, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> operand1 = pOr.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pOr.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return this.evaluateAndWrap(pOr, pEvaluationVisitor);
        }
        if (operand1 == pOr.getOperand1() && operand2 == pOr.getOperand2()) {
            return pOr;
        }
        return this.compoundIntervalFormulaManager.binaryOr(operand1, operand2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(BinaryXor<CompoundInterval> pXor, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> operand1 = pXor.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pXor.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return this.evaluateAndWrap(pXor, pEvaluationVisitor);
        }
        if (operand1 == pXor.getOperand1() && operand2 == pXor.getOperand2()) {
            return pXor;
        }
        return this.compoundIntervalFormulaManager.binaryXor(operand1, operand2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Constant<CompoundInterval> pConstant, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return pConstant;
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Divide<CompoundInterval> pDivide, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        CompoundInterval value;
        NumeralFormula<CompoundInterval> numerator = pDivide.getNumerator().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> denominator = pDivide.getDenominator().accept(this, pEvaluationVisitor);
        if (numerator instanceof Constant && denominator instanceof Constant) {
            return this.evaluateAndWrap(pDivide, pEvaluationVisitor);
        }
        if (denominator instanceof Constant && (value = (CompoundInterval)(c = (Constant)denominator).getValue()).isSingleton()) {
            if (value.getValue().equals(BigInteger.ONE)) {
                return numerator;
            }
            if (value.getValue().equals(BigInteger.valueOf(-1L))) {
                return this.compoundIntervalFormulaManager.negate(numerator);
            }
        }
        if (numerator == pDivide.getNumerator() && denominator == pDivide.getDenominator()) {
            return pDivide;
        }
        return this.compoundIntervalFormulaManager.divide(numerator, denominator);
    }

    @Override
    public BooleanFormula<CompoundInterval> visit(Equal<CompoundInterval> pEqual, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        BooleanFormula result;
        NumeralFormula<CompoundInterval> operand1 = pEqual.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pEqual.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant && (result = (BooleanFormula)pEqual.accept(pEvaluationVisitor, this.environment)) != null) {
            return result;
        }
        if (operand1 == pEqual.getOperand1() && operand2 == pEqual.getOperand2()) {
            return pEqual;
        }
        return Equal.of(operand1, operand2);
    }

    @Override
    public BooleanFormula<CompoundInterval> visit(LessThan<CompoundInterval> pLessThan, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        BooleanFormula result;
        NumeralFormula<CompoundInterval> operand1 = pLessThan.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pLessThan.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant && (result = (BooleanFormula)pLessThan.accept(pEvaluationVisitor, this.environment)) != null) {
            return result;
        }
        if (operand1 == pLessThan.getOperand1() && operand2 == pLessThan.getOperand2()) {
            return pLessThan;
        }
        return LessThan.of(operand1, operand2);
    }

    @Override
    public BooleanFormula<CompoundInterval> visit(LogicalAnd<CompoundInterval> pAnd, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        BooleanFormula result;
        BooleanFormula<CompoundInterval> operand1 = pAnd.getOperand1().accept(this, pEvaluationVisitor);
        BooleanFormula<CompoundInterval> operand2 = pAnd.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant && (result = (BooleanFormula)pAnd.accept(pEvaluationVisitor, this.environment)) != null) {
            return result;
        }
        if (operand1 instanceof BooleanConstant && !((BooleanConstant)operand1).getValue()) {
            return operand1;
        }
        if (operand2 instanceof BooleanConstant && !((BooleanConstant)operand2).getValue()) {
            return operand2;
        }
        if (operand1 instanceof BooleanConstant && ((BooleanConstant)operand1).getValue() && operand2 instanceof BooleanConstant && ((BooleanConstant)operand2).getValue()) {
            return operand1;
        }
        if (operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2()) {
            return pAnd;
        }
        return LogicalAnd.of(operand1, operand2);
    }

    @Override
    public BooleanFormula<CompoundInterval> visit(LogicalNot<CompoundInterval> pNot, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        BooleanFormula result;
        BooleanFormula<CompoundInterval> operand = pNot.getNegated().accept(this, pEvaluationVisitor);
        if (operand instanceof Constant && (result = (BooleanFormula)pNot.accept(pEvaluationVisitor, this.environment)) != null) {
            return result;
        }
        if (operand instanceof LogicalNot) {
            return ((LogicalNot)operand).getNegated();
        }
        if (operand instanceof BooleanConstant) {
            return ((BooleanConstant)operand).negate();
        }
        if (operand == pNot.getNegated()) {
            return pNot;
        }
        return LogicalNot.of(operand);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Modulo<CompoundInterval> pModulo, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        CompoundInterval value;
        NumeralFormula<CompoundInterval> numerator = pModulo.getNumerator().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> denominator = pModulo.getDenominator().accept(this, pEvaluationVisitor);
        if (numerator instanceof Constant && denominator instanceof Constant) {
            return this.evaluateAndWrap(pModulo, pEvaluationVisitor);
        }
        if (denominator instanceof Constant && (value = (CompoundInterval)(c = (Constant)denominator).getValue()).isSingleton() && (value.getValue().equals(BigInteger.ONE) || value.getValue().equals(BigInteger.valueOf(-1L)))) {
            return this.singleton(pModulo, BigInteger.ZERO);
        }
        if (numerator == pModulo.getNumerator() && denominator == pModulo.getDenominator()) {
            return pModulo;
        }
        return this.compoundIntervalFormulaManager.modulo(numerator, denominator);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Multiply<CompoundInterval> pMultiply, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval state;
        NumeralFormula<CompoundInterval> factor1 = pMultiply.getFactor1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> factor2 = pMultiply.getFactor2().accept(this, pEvaluationVisitor);
        if (factor1 instanceof Constant && factor2 instanceof Constant) {
            return this.evaluateAndWrap(pMultiply, pEvaluationVisitor);
        }
        Constant c = null;
        NumeralFormula<CompoundInterval> otherFactor = null;
        if (factor1 instanceof Constant) {
            c = (Constant)factor1;
            otherFactor = factor2;
        } else if (factor2 instanceof Constant) {
            c = (Constant)factor2;
            otherFactor = factor1;
        }
        if (c != null && otherFactor != null && (state = (CompoundInterval)c.getValue()).isSingleton()) {
            Number value = state.getValue();
            if (value.equals(BigInteger.ONE)) {
                return otherFactor;
            }
            if (value.equals(BigInteger.valueOf(-1L))) {
                return this.compoundIntervalFormulaManager.negate(otherFactor);
            }
            if (value.equals(BigInteger.ZERO)) {
                return this.singleton(pMultiply, BigInteger.ZERO);
            }
        }
        if (factor1 == pMultiply.getFactor1() && factor2 == pMultiply.getFactor2()) {
            return pMultiply;
        }
        return this.compoundIntervalFormulaManager.multiply(factor1, factor2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(ShiftLeft<CompoundInterval> pShiftLeft, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        NumeralFormula<CompoundInterval> shifted = pShiftLeft.getShifted().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> shiftDistance = pShiftLeft.getShiftDistance().accept(this, pEvaluationVisitor);
        if (shifted instanceof Constant && shiftDistance instanceof Constant) {
            return this.evaluateAndWrap(pShiftLeft, pEvaluationVisitor);
        }
        if (shiftDistance instanceof Constant && ((CompoundInterval)(c = (Constant)shiftDistance).getValue()).isSingleton() && ((CompoundInterval)c.getValue()).getValue().equals(BigInteger.ZERO)) {
            return shifted;
        }
        if (shifted == pShiftLeft.getShifted() && shiftDistance == pShiftLeft.getShiftDistance()) {
            return pShiftLeft;
        }
        return this.compoundIntervalFormulaManager.shiftLeft(shifted, shiftDistance);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(ShiftRight<CompoundInterval> pShiftRight, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        Constant c;
        NumeralFormula<CompoundInterval> shifted = pShiftRight.getShifted().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> shiftDistance = pShiftRight.getShiftDistance().accept(this, pEvaluationVisitor);
        if (shifted instanceof Constant && shiftDistance instanceof Constant) {
            return this.evaluateAndWrap(pShiftRight, pEvaluationVisitor);
        }
        if (shiftDistance instanceof Constant && ((CompoundInterval)(c = (Constant)shiftDistance).getValue()).isSingleton() && ((CompoundInterval)c.getValue()).getValue().equals(BigInteger.ZERO)) {
            return shifted;
        }
        if (shifted == pShiftRight.getShifted() && shiftDistance == pShiftRight.getShiftDistance()) {
            return pShiftRight;
        }
        return this.compoundIntervalFormulaManager.shiftRight(shifted, shiftDistance);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Union<CompoundInterval> pUnion, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        NumeralFormula<CompoundInterval> operand1 = pUnion.getOperand1().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> operand2 = pUnion.getOperand2().accept(this, pEvaluationVisitor);
        if (operand1 instanceof Constant && operand2 instanceof Constant) {
            return this.evaluateAndWrap(pUnion, pEvaluationVisitor);
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pUnion);
        NumeralFormula<CompoundInterval> allPossibleValues = this.asConstant(pUnion, compoundIntervalManager.allPossibleValues());
        if (operand1.equals(allPossibleValues) || operand2.equals(allPossibleValues)) {
            return allPossibleValues;
        }
        NumeralFormula<CompoundInterval> bottom = this.asConstant(pUnion, compoundIntervalManager.bottom());
        if (operand1.equals(bottom)) {
            return operand2;
        }
        if (operand2.equals(bottom)) {
            return operand1;
        }
        HashSet<NumeralFormula> atomicUnionParts = new HashSet<NumeralFormula>();
        ArrayDeque<NumeralFormula> unionParts = new ArrayDeque<NumeralFormula>();
        CompoundInterval constantPart = compoundIntervalManager.bottom();
        unionParts.offer(pUnion);
        int partsFound = 0;
        while (!unionParts.isEmpty()) {
            NumeralFormula currentPart = (NumeralFormula)unionParts.poll();
            if (currentPart instanceof Union) {
                Union currentUnion = (Union)currentPart;
                unionParts.add(currentUnion.getOperand1());
                unionParts.add(currentUnion.getOperand2());
                partsFound += 2;
                continue;
            }
            if (currentPart instanceof Constant) {
                constantPart = compoundIntervalManager.union(constantPart, (CompoundInterval)((Constant)currentPart).getValue());
                continue;
            }
            atomicUnionParts.add(currentPart);
        }
        if (partsFound > atomicUnionParts.size()) {
            NumeralFormula<CompoundInterval> result = null;
            if (!atomicUnionParts.isEmpty()) {
                Iterator atomicUnionPartsIterator = atomicUnionParts.iterator();
                result = (NumeralFormula<CompoundInterval>)atomicUnionPartsIterator.next();
                while (atomicUnionPartsIterator.hasNext()) {
                    result = this.compoundIntervalFormulaManager.union(result, (NumeralFormula)atomicUnionPartsIterator.next());
                }
            }
            if (!constantPart.isBottom()) {
                NumeralFormula<CompoundInterval> constantPartFormula = this.asConstant(pUnion, constantPart);
                NumeralFormula<CompoundInterval> numeralFormula = result = result == null ? constantPartFormula : this.compoundIntervalFormulaManager.union(result, constantPartFormula);
            }
            if (result != null) {
                return result;
            }
        }
        if (operand1 == pUnion.getOperand1() && operand2 == pUnion.getOperand2()) {
            return pUnion;
        }
        return this.compoundIntervalFormulaManager.union(operand1, operand2);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Variable<CompoundInterval> pVariable, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval value = (CompoundInterval)pVariable.accept(pEvaluationVisitor, this.environment);
        if (value.isSingleton()) {
            return this.asConstant(pVariable, value);
        }
        return pVariable;
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Exclusion<CompoundInterval> pExclusion, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval value = (CompoundInterval)pExclusion.accept(pEvaluationVisitor, this.environment);
        if (value.isSingleton() || pExclusion.getExcluded() instanceof Constant) {
            return this.asConstant(pExclusion, value);
        }
        return pExclusion;
    }

    @Override
    public BooleanFormula<CompoundInterval> visitFalse(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return (BooleanFormula)pEvaluationVisitor.visitFalse(this.environment);
    }

    @Override
    public BooleanFormula<CompoundInterval> visitTrue(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        return (BooleanFormula)pEvaluationVisitor.visitTrue(this.environment);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(IfThenElse<CompoundInterval> pIfThenElse, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        BooleanFormula<CompoundInterval> condition = pIfThenElse.getCondition().accept(this, pEvaluationVisitor);
        NumeralFormula<CompoundInterval> positiveCase = pIfThenElse.getPositiveCase().accept(this, pEvaluationVisitor);
        if (BooleanConstant.isTrue(condition)) {
            return positiveCase;
        }
        NumeralFormula<CompoundInterval> negativeCase = pIfThenElse.getNegativeCase().accept(this, pEvaluationVisitor);
        if (BooleanConstant.isFalse(condition)) {
            return negativeCase;
        }
        if (pIfThenElse.getCondition().equals(condition) && pIfThenElse.getPositiveCase().equals(positiveCase) && pIfThenElse.getNegativeCase().equals(negativeCase)) {
            return pIfThenElse;
        }
        return this.compoundIntervalFormulaManager.ifThenElse(condition, positiveCase, negativeCase);
    }

    @Override
    public NumeralFormula<CompoundInterval> visit(Cast<CompoundInterval> pCast, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        CompoundInterval value = (CompoundInterval)pCast.accept(pEvaluationVisitor, this.environment);
        if (value.isSingleton()) {
            return this.asConstant(pCast, value);
        }
        NumeralFormula<CompoundInterval> operand = pCast.getCasted().accept(this, pEvaluationVisitor);
        if (operand == pCast.getCasted()) {
            return pCast;
        }
        return this.compoundIntervalFormulaManager.cast(pCast.getTypeInfo(), operand);
    }
}

