/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntegralInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PartialEvaluator;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushValueToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class PushAssumptionToEnvironmentVisitor
implements ParameterizedBooleanFormulaVisitor<CompoundInterval, BooleanConstant<CompoundInterval>, Boolean> {
    private final PushValueToEnvironmentVisitor pushValueToEnvironmentVisitor;
    private final NonRecursiveEnvironment.Builder environment;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;
    private final CompoundIntervalFormulaManager compoundIntervalFormulaManager;

    public PushAssumptionToEnvironmentVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, NonRecursiveEnvironment.Builder pEnvironment) {
        this.pushValueToEnvironmentVisitor = new PushValueToEnvironmentVisitor(this, pCompoundIntervalManagerFactory, pEvaluationVisitor, pEnvironment);
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
    }

    private CompoundIntervalManager createCompoundIntervalManager(TypeInfo pTypeInfo) {
        if (this.compoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory) {
            CompoundBitVectorIntervalManagerFactory compoundBitVectorIntervalManagerFactory = (CompoundBitVectorIntervalManagerFactory)this.compoundIntervalManagerFactory;
            return compoundBitVectorIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo, false);
        }
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(pTypeInfo);
    }

    public PushAssumptionToEnvironmentVisitor(PushValueToEnvironmentVisitor pPushValueToEnvironmentVisitor, CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, NonRecursiveEnvironment.Builder pEnvironment) {
        this.pushValueToEnvironmentVisitor = pPushValueToEnvironmentVisitor;
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
        this.compoundIntervalFormulaManager = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula) {
        return (CompoundInterval)pFormula.accept(this.evaluationVisitor, this.environment);
    }

    private BooleanConstant<CompoundInterval> evaluate(BooleanFormula<CompoundInterval> pFormula) {
        return (BooleanConstant)pFormula.accept(this.evaluationVisitor, this.environment);
    }

    private boolean areContradictory(BooleanFormula<CompoundInterval> pFormula, BooleanConstant<CompoundInterval> pConstant) {
        if (pFormula == null || pConstant == null) {
            return false;
        }
        BooleanConstant<CompoundInterval> formulaValue = this.evaluate(pFormula);
        if (formulaValue == null) {
            return false;
        }
        return !pConstant.equals(formulaValue);
    }

    @Override
    public Boolean visit(Equal<CompoundInterval> pEqual, BooleanConstant<CompoundInterval> pParameter) {
        MemoryLocation memoryLocation;
        if (pParameter == null) {
            return true;
        }
        if (this.areContradictory(pEqual, pParameter)) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pEqual.getOperand1());
        CompoundInterval rightValue = this.evaluate(pEqual.getOperand2());
        if (pParameter.getValue()) {
            Object previous;
            MemoryLocation memoryLocation2;
            NumeralFormula<CompoundInterval> op1 = pEqual.getOperand1();
            NumeralFormula<CompoundInterval> op2 = pEqual.getOperand2();
            if (op1 instanceof Variable) {
                memoryLocation2 = ((Variable)op1).getMemoryLocation();
                previous = this.environment.get(memoryLocation2);
                this.environment.put(memoryLocation2, op2);
                if (previous != null && !this.compoundIntervalFormulaManager.definitelyImplies(this.environment, this.compoundIntervalFormulaManager.equal(op1, (NumeralFormula<CompoundInterval>)previous))) {
                    this.environment.put(memoryLocation2, (NumeralFormula<CompoundInterval>)previous);
                }
            }
            if (op2 instanceof Variable) {
                memoryLocation2 = ((Variable)op2).getMemoryLocation();
                previous = this.environment.get(memoryLocation2);
                this.environment.put(memoryLocation2, op1);
                if (previous != null && !this.compoundIntervalFormulaManager.definitelyImplies(this.environment, this.compoundIntervalFormulaManager.equal(op2, (NumeralFormula<CompoundInterval>)previous))) {
                    this.environment.put(memoryLocation2, (NumeralFormula<CompoundInterval>)previous);
                }
            }
            return pEqual.getOperand1().accept(this.pushValueToEnvironmentVisitor, rightValue) != false && pEqual.getOperand2().accept(this.pushValueToEnvironmentVisitor, leftValue) != false;
        }
        NumeralFormula<CompoundInterval> op1 = pEqual.getOperand1();
        NumeralFormula<CompoundInterval> op2 = pEqual.getOperand2();
        if (op1 instanceof Variable) {
            memoryLocation = ((Variable)op1).getMemoryLocation();
            this.environment.putIfAbsent(memoryLocation, this.compoundIntervalFormulaManager.exclude(op2));
        }
        if (op2 instanceof Variable) {
            memoryLocation = ((Variable)op2).getMemoryLocation();
            this.environment.putIfAbsent(memoryLocation, this.compoundIntervalFormulaManager.exclude(op1));
        }
        if (rightValue.isSingleton() && !pEqual.getOperand1().accept(this.pushValueToEnvironmentVisitor, rightValue.invert()).booleanValue()) {
            return false;
        }
        if (leftValue.isSingleton() && !pEqual.getOperand2().accept(this.pushValueToEnvironmentVisitor, leftValue.invert()).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(LessThan<CompoundInterval> pLessThan, BooleanConstant<CompoundInterval> pParameter) {
        if (pParameter == null) {
            return true;
        }
        if (this.areContradictory(pLessThan, pParameter)) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pLessThan.getOperand1());
        CompoundInterval rightValue = this.evaluate(pLessThan.getOperand2());
        if (leftValue.isBottom() || rightValue.isBottom()) {
            return false;
        }
        if (leftValue instanceof CompoundIntegralInterval && rightValue instanceof CompoundIntegralInterval) {
            CompoundInterval rightPushValue;
            CompoundInterval leftPushValue;
            if (pParameter.getValue()) {
                TypeInfo typeInfo = pLessThan.getOperand1().getTypeInfo();
                CompoundIntervalManager cim = this.createCompoundIntervalManager(typeInfo);
                CompoundInterval compoundInterval = rightValue.isSingleton() ? cim.intersect(rightValue.invert(), rightValue.extendToMinValue()) : (leftPushValue = rightValue.hasUpperBound() ? cim.singleton(((BigInteger)rightValue.getUpperBound()).subtract(BigInteger.ONE)).extendToMinValue() : rightValue.span().extendToMinValue());
                rightPushValue = leftValue.isSingleton() ? cim.intersect(leftValue.invert(), leftValue.extendToMaxValue()) : (leftValue.hasLowerBound() ? cim.singleton(((BigInteger)leftValue.getLowerBound()).add(BigInteger.ONE)).extendToMaxValue() : leftValue.span().extendToMaxValue());
            } else {
                leftPushValue = rightValue.span().extendToMaxValue();
                rightPushValue = leftValue.span().extendToMinValue();
            }
            return pLessThan.getOperand1().accept(this.pushValueToEnvironmentVisitor, leftPushValue) != false && pLessThan.getOperand2().accept(this.pushValueToEnvironmentVisitor, rightPushValue) != false;
        }
        return true;
    }

    @Override
    public Boolean visit(LogicalAnd<CompoundInterval> pAnd, BooleanConstant<CompoundInterval> pParameter) {
        if (pParameter == null) {
            return true;
        }
        if (this.areContradictory(pAnd, pParameter)) {
            return false;
        }
        if (pParameter.getValue()) {
            return pAnd.getOperand1().accept(this, pParameter) != false && pAnd.getOperand2().accept(this, pParameter) != false;
        }
        NonRecursiveEnvironment.Builder env1 = new NonRecursiveEnvironment.Builder(this.compoundIntervalManagerFactory, this.environment);
        boolean push1 = pAnd.getOperand1().accept(new PushAssumptionToEnvironmentVisitor(this.compoundIntervalManagerFactory, this.evaluationVisitor, env1), pParameter);
        if (!push1) {
            return pAnd.getOperand2().accept(this, pParameter);
        }
        NonRecursiveEnvironment.Builder env2 = new NonRecursiveEnvironment.Builder(this.compoundIntervalManagerFactory, this.environment);
        boolean push2 = pAnd.getOperand2().accept(new PushAssumptionToEnvironmentVisitor(this.compoundIntervalManagerFactory, this.evaluationVisitor, env2), pParameter);
        if (!push2) {
            return pAnd.getOperand1().accept(this, pParameter);
        }
        for (Map.Entry<MemoryLocation, NumeralFormula<CompoundInterval>> entry : env2.entrySet()) {
            MemoryLocation memoryLocation = entry.getKey();
            Object value1 = env1.get(memoryLocation);
            if (value1 == null) continue;
            NumeralFormula<CompoundInterval> value2 = entry.getValue();
            NumeralFormula<CompoundInterval> newValueFormula = this.compoundIntervalFormulaManager.union((NumeralFormula<CompoundInterval>)value1, value2).accept(new PartialEvaluator(this.compoundIntervalManagerFactory, this.environment), this.evaluationVisitor);
            if (((CompoundInterval)newValueFormula.accept(this.evaluationVisitor, this.environment)).isBottom()) {
                return false;
            }
            if (newValueFormula instanceof Constant && ((CompoundInterval)((Constant)newValueFormula).getValue()).containsAllPossibleValues()) continue;
            this.environment.put(memoryLocation, newValueFormula);
        }
        return true;
    }

    @Override
    public Boolean visit(LogicalNot<CompoundInterval> pNot, BooleanConstant<CompoundInterval> pParameter) {
        if (pParameter == null) {
            return true;
        }
        if (this.areContradictory(pNot, pParameter)) {
            return false;
        }
        return pNot.getNegated().accept(this, pParameter.negate());
    }

    @Override
    public Boolean visitFalse(BooleanConstant<CompoundInterval> pParameter) {
        return pParameter == null || !pParameter.getValue();
    }

    @Override
    public Boolean visitTrue(BooleanConstant<CompoundInterval> pParameter) {
        return pParameter == null || pParameter.getValue();
    }
}

