/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class PushSummandVisitor<T>
extends DefaultParameterizedNumeralFormulaVisitor<T, T, NumeralFormula<T>> {
    private static final String SUMMAND_ALREADY_CONSUMED_MESSAGE = "Summand already consumed.";
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<T>> EMPTY_ENVIRONMENT = ImmutableMap.of();
    private final FormulaEvaluationVisitor<T> evaluationVisitor;
    private boolean consumed = false;

    public PushSummandVisitor(FormulaEvaluationVisitor<T> pEvaluationVisitor) {
        this.evaluationVisitor = pEvaluationVisitor;
    }

    public boolean isSummandConsumed() {
        return this.consumed;
    }

    private void checkNotConsumed() throws IllegalStateException {
        Preconditions.checkState((!this.isSummandConsumed() ? 1 : 0) != 0, (Object)SUMMAND_ALREADY_CONSUMED_MESSAGE);
    }

    @Override
    public NumeralFormula<T> visit(Add<T> pAdd, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        NumeralFormula candidateS1 = (NumeralFormula)pAdd.getSummand1().accept(this, pToPush);
        if (this.isSummandConsumed()) {
            return InvariantsFormulaManager.INSTANCE.add(candidateS1, pAdd.getSummand2());
        }
        NumeralFormula summand2 = (NumeralFormula)pAdd.getSummand2().accept(this, pToPush);
        return InvariantsFormulaManager.INSTANCE.add(pAdd.getSummand1(), summand2);
    }

    @Override
    public NumeralFormula<T> visit(Constant<T> pConstant, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        InvariantsFormulaManager ifm = InvariantsFormulaManager.INSTANCE;
        NumeralFormula<T> toPush = ifm.asConstant(pConstant.getTypeInfo(), pToPush);
        NumeralFormula<T> sum = ifm.add(pConstant, toPush);
        this.consumed = true;
        Object sumValue = sum.accept(this.evaluationVisitor, this.EMPTY_ENVIRONMENT);
        return InvariantsFormulaManager.INSTANCE.asConstant(pConstant.getTypeInfo(), sumValue);
    }

    @Override
    protected NumeralFormula<T> visitDefault(NumeralFormula<T> pFormula, T pToPush) throws IllegalStateException {
        this.checkNotConsumed();
        InvariantsFormulaManager ifm = InvariantsFormulaManager.INSTANCE;
        NumeralFormula<T> toPush = ifm.asConstant(pFormula.getTypeInfo(), pToPush);
        return ifm.add(pFormula, toPush);
    }
}

