/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.NonRecursiveEnvironment;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.Typed;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.PushAssumptionToEnvironmentVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

class PushValueToEnvironmentVisitor
implements ParameterizedNumeralFormulaVisitor<CompoundInterval, CompoundInterval, Boolean> {
    private final PushAssumptionToEnvironmentVisitor pushAssumptionToEnvironmentVisitor;
    private final NonRecursiveEnvironment.Builder environment;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;

    public PushValueToEnvironmentVisitor(CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, NonRecursiveEnvironment.Builder pEnvironment) {
        this.pushAssumptionToEnvironmentVisitor = new PushAssumptionToEnvironmentVisitor(this, pCompoundIntervalManagerFactory, pEvaluationVisitor, pEnvironment);
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
    }

    public PushValueToEnvironmentVisitor(PushAssumptionToEnvironmentVisitor pPushAssumptionToEnvironmentVisitor, CompoundIntervalManagerFactory pCompoundIntervalManagerFactory, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, NonRecursiveEnvironment.Builder pEnvironment) {
        this.pushAssumptionToEnvironmentVisitor = pPushAssumptionToEnvironmentVisitor;
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
    }

    private CompoundInterval evaluate(NumeralFormula<CompoundInterval> pFormula) {
        return (CompoundInterval)pFormula.accept(this.evaluationVisitor, this.environment);
    }

    private CompoundIntervalManager getCompoundIntervalManager(Typed pBitVectorType) {
        TypeInfo typeInfo = pBitVectorType.getTypeInfo();
        if (this.compoundIntervalManagerFactory instanceof CompoundBitVectorIntervalManagerFactory) {
            CompoundBitVectorIntervalManagerFactory compoundBitVectorIntervalManagerFactory = (CompoundBitVectorIntervalManagerFactory)this.compoundIntervalManagerFactory;
            return compoundBitVectorIntervalManagerFactory.createCompoundIntervalManager(typeInfo, false);
        }
        return this.compoundIntervalManagerFactory.createCompoundIntervalManager(typeInfo);
    }

    @Override
    public Boolean visit(Add<CompoundInterval> pAdd, CompoundInterval pParameter) {
        CompoundInterval pushRightValue;
        CompoundInterval pushLeftValue;
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager cim = this.getCompoundIntervalManager(pAdd);
        CompoundInterval parameter = cim.intersect(this.evaluate(pAdd), pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pAdd.getSummand1());
        CompoundInterval rightValue = this.evaluate(pAdd.getSummand2());
        TypeInfo typeInfo = pAdd.getTypeInfo();
        if (typeInfo instanceof BitVectorInfo && pAdd.getTypeInfo().isSigned()) {
            BitVectorInfo bitVectorInfo = (BitVectorInfo)typeInfo;
            BitVectorInfo extendedType = bitVectorInfo.extend(1);
            CompoundInterval extendedRange = cim.cast(extendedType, CompoundBitVectorInterval.of(bitVectorInfo.getRange()));
            CompoundInterval extendedLeftValue = cim.cast(extendedType, leftValue);
            CompoundInterval extendedRightValue = cim.cast(extendedType, rightValue);
            CompoundInterval extendedParameter = cim.cast(extendedType, parameter);
            pushLeftValue = cim.cast(bitVectorInfo, cim.intersect(cim.add(extendedParameter, cim.negate(extendedRightValue)), extendedRange));
            pushRightValue = cim.cast(bitVectorInfo, cim.intersect(cim.add(extendedParameter, cim.negate(extendedLeftValue)), extendedRange));
        } else {
            pushLeftValue = cim.add(parameter, cim.negate(rightValue));
            pushRightValue = cim.add(parameter, cim.negate(leftValue));
        }
        if (!pAdd.getSummand1().accept(this, pushLeftValue).booleanValue() || !pAdd.getSummand2().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryAnd<CompoundInterval> pAnd, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.getCompoundIntervalManager(pAnd).doIntersect(this.evaluate(pAnd), pParameter);
    }

    @Override
    public Boolean visit(BinaryNot<CompoundInterval> pNot, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pNot);
        CompoundInterval parameter = compoundIntervalManager.intersect(this.evaluate(pNot), pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (!pNot.getFlipped().accept(this, parameter.invert()).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(BinaryOr<CompoundInterval> pOr, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.getCompoundIntervalManager(pOr).doIntersect(this.evaluate(pOr), pParameter);
    }

    @Override
    public Boolean visit(BinaryXor<CompoundInterval> pXor, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.getCompoundIntervalManager(pXor).doIntersect(this.evaluate(pXor), pParameter);
    }

    @Override
    public Boolean visit(Constant<CompoundInterval> pConstant, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        return this.getCompoundIntervalManager(pConstant).doIntersect(pConstant.getValue(), pParameter);
    }

    @Override
    public Boolean visit(Divide<CompoundInterval> pDivide, CompoundInterval pParameter) {
        CompoundInterval pushRightValue;
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager cim = this.getCompoundIntervalManager(pDivide);
        CompoundInterval parameter = cim.intersect(this.evaluate(pDivide), pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pDivide.getNumerator());
        CompoundInterval rightValue = this.evaluate(pDivide.getDenominator());
        CompoundInterval computedLeftValue = cim.multiply(parameter, rightValue);
        Iterator<? extends CompoundInterval> iterator = computedLeftValue.splitIntoIntervals().iterator();
        while (iterator.hasNext()) {
            CompoundInterval interval;
            CompoundInterval borderA = interval = iterator.next();
            CompoundInterval borderB = cim.add(borderA, cim.add(rightValue, cim.negate(rightValue.signum())));
            computedLeftValue = cim.union(computedLeftValue, cim.span(borderA, borderB));
        }
        CompoundInterval pushLeftValue = cim.intersect(leftValue, computedLeftValue);
        CompoundInterval compoundInterval = pushRightValue = parameter.isSingleton() && parameter.contains(BigInteger.ZERO) ? cim.allPossibleValues() : cim.divide(leftValue, parameter);
        if (!pDivide.getNumerator().accept(this, pushLeftValue).booleanValue() || !pDivide.getDenominator().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Exclusion<CompoundInterval> pExclusion, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pExclusion);
        return compoundIntervalManager.doIntersect(this.evaluate(pExclusion), pParameter);
    }

    @Override
    public Boolean visit(Modulo<CompoundInterval> pModulo, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pModulo);
        return compoundIntervalManager.doIntersect(this.evaluate(pModulo), pParameter);
    }

    @Override
    public Boolean visit(Multiply<CompoundInterval> pMultiply, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pMultiply);
        CompoundInterval parameter = compoundIntervalManager.intersect(this.evaluate(pMultiply), pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        CompoundInterval leftValue = this.evaluate(pMultiply.getFactor1());
        CompoundInterval rightValue = this.evaluate(pMultiply.getFactor2());
        if (parameter.contains(BigInteger.ZERO)) {
            if (parameter.isSingleton()) {
                if (!leftValue.contains(BigInteger.ZERO)) {
                    return pMultiply.getFactor2().accept(this, parameter);
                }
                if (!rightValue.contains(BigInteger.ZERO)) {
                    return pMultiply.getFactor1().accept(this, parameter);
                }
            }
            return true;
        }
        CompoundInterval pushLeftValue = compoundIntervalManager.divide(parameter, rightValue);
        CompoundInterval pushRightValue = compoundIntervalManager.divide(parameter, leftValue);
        if (!pMultiply.getFactor1().accept(this, pushLeftValue).booleanValue() || !pMultiply.getFactor2().accept(this, pushRightValue).booleanValue()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(ShiftLeft<CompoundInterval> pShiftLeft, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pShiftLeft);
        return compoundIntervalManager.doIntersect(this.evaluate(pShiftLeft), pParameter);
    }

    @Override
    public Boolean visit(ShiftRight<CompoundInterval> pShiftRight, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pShiftRight);
        return compoundIntervalManager.doIntersect(this.evaluate(pShiftRight), pParameter);
    }

    @Override
    public Boolean visit(Union<CompoundInterval> pUnion, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        NumeralFormula operand1 = pUnion.getOperand1();
        NumeralFormula operand2 = pUnion.getOperand2();
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pUnion);
        if (!compoundIntervalManager.doIntersect(this.evaluate(operand1), pParameter) && !operand2.accept(this, pParameter).booleanValue()) {
            return false;
        }
        if (!compoundIntervalManager.doIntersect(this.evaluate(operand2), pParameter) && !operand1.accept(this, pParameter).booleanValue()) {
            return false;
        }
        NumeralFormula<CompoundInterval> parameter = InvariantsFormulaManager.INSTANCE.asConstant(pUnion.getTypeInfo(), pParameter);
        LogicalNot<CompoundInterval> disjunctiveForm = LogicalNot.of(LogicalAnd.of(LogicalNot.of(Equal.of(pUnion.getOperand1(), parameter)), LogicalNot.of(Equal.of(pUnion.getOperand2(), parameter))));
        return disjunctiveForm.accept(this.pushAssumptionToEnvironmentVisitor, BooleanConstant.getTrue());
    }

    @Override
    public Boolean visit(Variable<CompoundInterval> pVariable, CompoundInterval pParameter) {
        CompoundInterval newValue;
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager compoundIntervalManager = this.getCompoundIntervalManager(pVariable);
        CompoundInterval parameter = compoundIntervalManager.intersect(this.evaluate(pVariable), pParameter);
        if (parameter.isBottom()) {
            return false;
        }
        if (parameter.containsAllPossibleValues()) {
            return true;
        }
        MemoryLocation memoryLocation = pVariable.getMemoryLocation();
        NumeralFormula<CompoundInterval> resolved = this.getFromEnvironment(pVariable);
        if (!resolved.accept(this, parameter).booleanValue()) {
            return false;
        }
        if (resolved instanceof Constant) {
            CompoundInterval resolvedValue = (CompoundInterval)((Constant)resolved).getValue();
            newValue = compoundIntervalManager.intersect(resolvedValue, parameter);
        } else if (!parameter.equals(pParameter)) {
            newValue = parameter;
        } else {
            return true;
        }
        if (newValue.isBottom()) {
            return false;
        }
        if (newValue.containsAllPossibleValues()) {
            this.environment.remove(memoryLocation);
        } else {
            this.environment.put(memoryLocation, InvariantsFormulaManager.INSTANCE.asConstant(pVariable.getTypeInfo(), newValue));
        }
        return true;
    }

    @Override
    public Boolean visit(IfThenElse<CompoundInterval> pIfThenElse, CompoundInterval pParameter) {
        BooleanFormula<CompoundInterval> conditionFormula = pIfThenElse.getCondition();
        NumeralFormula<CompoundInterval> positiveCaseFormula = pIfThenElse.getPositiveCase();
        NumeralFormula<CompoundInterval> negativeCaseFormula = pIfThenElse.getNegativeCase();
        CompoundInterval positiveCaseValue = this.evaluate(positiveCaseFormula);
        CompoundInterval negativeCaseValue = this.evaluate(negativeCaseFormula);
        CompoundIntervalManager cim = this.getCompoundIntervalManager(pIfThenElse);
        CompoundInterval positiveCaseIntersection = cim.intersect(pParameter, positiveCaseValue);
        CompoundInterval negativeCaseIntersection = cim.intersect(pParameter, negativeCaseValue);
        if (positiveCaseIntersection.isBottom() && negativeCaseIntersection.isBottom()) {
            return false;
        }
        if (positiveCaseIntersection.isBottom() && !conditionFormula.accept(this.pushAssumptionToEnvironmentVisitor, BooleanConstant.getFalse()).booleanValue()) {
            return false;
        }
        if (negativeCaseIntersection.isBottom() && !conditionFormula.accept(this.pushAssumptionToEnvironmentVisitor, BooleanConstant.getTrue()).booleanValue()) {
            return false;
        }
        boolean positiveCaseConsistent = positiveCaseFormula.accept(this, positiveCaseIntersection);
        if (!positiveCaseConsistent && !positiveCaseIntersection.isBottom()) {
            return false;
        }
        boolean negativeCaseConsistent = negativeCaseFormula.accept(this, negativeCaseIntersection);
        if (!negativeCaseConsistent && !negativeCaseIntersection.isBottom()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean visit(Cast<CompoundInterval> pCast, CompoundInterval pParameter) {
        if (pParameter == null || pParameter.isBottom()) {
            return false;
        }
        CompoundIntervalManager targetManager = this.getCompoundIntervalManager(pCast);
        TypeInfo targetInfo = pCast.getTypeInfo();
        TypeInfo sourceInfo = pCast.getCasted().getTypeInfo();
        if (targetInfo instanceof BitVectorInfo && sourceInfo instanceof BitVectorInfo) {
            BitVectorInfo targetBVInfo = (BitVectorInfo)targetInfo;
            BitVectorInfo sourceBVInfo = (BitVectorInfo)sourceInfo;
            if (targetBVInfo.getRange().contains(sourceBVInfo.getRange())) {
                if (!pCast.getCasted().accept(this, targetManager.cast(sourceInfo, pParameter)).booleanValue()) {
                    return false;
                }
            } else if (!targetInfo.isSigned()) {
                BigInteger numberOfPotentialOrigins = sourceBVInfo.getRange().size().divide(targetBVInfo.getRange().size());
                CompoundIntervalManager sourceManager = this.getCompoundIntervalManager(pCast.getCasted());
                CompoundInterval originFactors = sourceManager.span(sourceManager.singleton(BigInteger.ZERO), sourceManager.singleton(numberOfPotentialOrigins.subtract(BigInteger.ONE)));
                if (sourceInfo.isSigned()) {
                    originFactors = sourceManager.add(originFactors, sourceManager.singleton(numberOfPotentialOrigins.divide(BigInteger.valueOf(2L).negate())));
                }
                CompoundInterval potentialOrigins = sourceManager.add(sourceManager.multiply(originFactors, sourceManager.singleton(targetBVInfo.getRange().size().min(sourceBVInfo.getRange().getUpperBound()))), targetManager.cast(sourceInfo, pParameter));
                if (!pCast.getCasted().accept(this, potentialOrigins).booleanValue()) {
                    return false;
                }
            }
            return targetManager.doIntersect(this.evaluate(pCast), pParameter);
        }
        return true;
    }

    private NumeralFormula<CompoundInterval> getFromEnvironment(Variable<CompoundInterval> pVariable) {
        Object result = this.environment.get(pVariable.getMemoryLocation());
        if (result == null) {
            return InvariantsFormulaManager.INSTANCE.asConstant(pVariable.getTypeInfo(), this.getCompoundIntervalManager(pVariable).allPossibleValues());
        }
        return result;
    }
}

