/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.RecursiveNumeralFormulaVisitor;

abstract class RecursiveBooleanFormulaVisitor<T>
implements BooleanFormulaVisitor<T, BooleanFormula<T>> {
    private final RecursiveNumeralFormulaVisitor<T> recursiveNumeralFormulaVisitor;

    protected RecursiveBooleanFormulaVisitor() {
        this(null);
    }

    protected RecursiveBooleanFormulaVisitor(RecursiveNumeralFormulaVisitor<T> pRecursiveNumeralFormulaVisitor) {
        this.recursiveNumeralFormulaVisitor = pRecursiveNumeralFormulaVisitor;
    }

    protected abstract BooleanFormula<T> visitPost(BooleanFormula<T> var1);

    private NumeralFormula<T> visitNumeralChildIfVisitorExists(NumeralFormula<T> pChild) {
        return this.recursiveNumeralFormulaVisitor == null ? pChild : (NumeralFormula)pChild.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public BooleanFormula<T> visit(Equal<T> pEqual) {
        NumeralFormula<T> operand1 = this.visitNumeralChildIfVisitorExists(pEqual.getOperand1());
        NumeralFormula<T> operand2 = this.visitNumeralChildIfVisitorExists(pEqual.getOperand2());
        Equal<T> toVisit = operand1 == pEqual.getOperand1() && operand2 == pEqual.getOperand2() ? pEqual : Equal.of(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public BooleanFormula<T> visit(LessThan<T> pLessThan) {
        NumeralFormula<T> operand1 = this.visitNumeralChildIfVisitorExists(pLessThan.getOperand1());
        NumeralFormula<T> operand2 = this.visitNumeralChildIfVisitorExists(pLessThan.getOperand2());
        LessThan<T> toVisit = operand1 == pLessThan.getOperand1() && operand2 == pLessThan.getOperand2() ? pLessThan : LessThan.of(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public BooleanFormula<T> visit(LogicalAnd<T> pAnd) {
        BooleanFormula operand1 = (BooleanFormula)pAnd.getOperand1().accept(this);
        BooleanFormula operand2 = (BooleanFormula)pAnd.getOperand2().accept(this);
        LogicalAnd<Object> toVisit = operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2() ? pAnd : LogicalAnd.of(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public BooleanFormula<T> visit(LogicalNot<T> pNot) {
        BooleanFormula operand = (BooleanFormula)pNot.getNegated().accept(this);
        LogicalNot<Object> toVisit = operand == pNot.getNegated() ? pNot : LogicalNot.of(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public BooleanFormula<T> visitFalse() {
        return this.visitPost(BooleanConstant.getFalse());
    }

    @Override
    public BooleanFormula<T> visitTrue() {
        return this.visitPost(BooleanConstant.getTrue());
    }
}

