/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

abstract class RecursiveNumeralFormulaVisitor<T>
implements NumeralFormulaVisitor<T, NumeralFormula<T>> {
    RecursiveNumeralFormulaVisitor() {
    }

    protected abstract NumeralFormula<T> visitPost(NumeralFormula<T> var1);

    @Override
    public NumeralFormula<T> visit(Add<T> pAdd) {
        NumeralFormula summand1 = (NumeralFormula)pAdd.getSummand1().accept(this);
        NumeralFormula summand2 = (NumeralFormula)pAdd.getSummand2().accept(this);
        NumeralFormula toVisit = summand1 == pAdd.getSummand1() && summand2 == pAdd.getSummand2() ? pAdd : InvariantsFormulaManager.INSTANCE.add(summand1, summand2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(BinaryAnd<T> pAnd) {
        NumeralFormula operand1 = (NumeralFormula)pAnd.getOperand1().accept(this);
        NumeralFormula operand2 = (NumeralFormula)pAnd.getOperand2().accept(this);
        NumeralFormula toVisit = operand1 == pAnd.getOperand1() && operand2 == pAnd.getOperand2() ? pAnd : InvariantsFormulaManager.INSTANCE.binaryAnd(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(BinaryNot<T> pNot) {
        NumeralFormula operand = (NumeralFormula)pNot.getFlipped().accept(this);
        NumeralFormula<T> toVisit = operand == pNot.getFlipped() ? pNot : InvariantsFormulaManager.INSTANCE.binaryNot(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(BinaryOr<T> pOr) {
        NumeralFormula operand1 = (NumeralFormula)pOr.getOperand1().accept(this);
        NumeralFormula operand2 = (NumeralFormula)pOr.getOperand2().accept(this);
        NumeralFormula toVisit = operand1 == pOr.getOperand1() && operand2 == pOr.getOperand2() ? pOr : InvariantsFormulaManager.INSTANCE.binaryOr(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(BinaryXor<T> pXor) {
        NumeralFormula operand1 = (NumeralFormula)pXor.getOperand1().accept(this);
        NumeralFormula operand2 = (NumeralFormula)pXor.getOperand2().accept(this);
        NumeralFormula toVisit = operand1 == pXor.getOperand1() && operand2 == pXor.getOperand2() ? pXor : InvariantsFormulaManager.INSTANCE.binaryXor(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Constant<T> pConstant) {
        return this.visitPost(pConstant);
    }

    @Override
    public NumeralFormula<T> visit(Divide<T> pDivide) {
        NumeralFormula numerator = (NumeralFormula)pDivide.getNumerator().accept(this);
        NumeralFormula denominator = (NumeralFormula)pDivide.getDenominator().accept(this);
        NumeralFormula toVisit = numerator == pDivide.getNumerator() && denominator == pDivide.getDenominator() ? pDivide : InvariantsFormulaManager.INSTANCE.divide(numerator, denominator);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Exclusion<T> pExclusion) {
        NumeralFormula operand = (NumeralFormula)pExclusion.getExcluded().accept(this);
        NumeralFormula<T> toVisit = operand == pExclusion.getExcluded() ? pExclusion : InvariantsFormulaManager.INSTANCE.exclude(operand);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Modulo<T> pModulo) {
        NumeralFormula numerator = (NumeralFormula)pModulo.getNumerator().accept(this);
        NumeralFormula denominator = (NumeralFormula)pModulo.getDenominator().accept(this);
        NumeralFormula toVisit = numerator == pModulo.getNumerator() && denominator == pModulo.getDenominator() ? pModulo : InvariantsFormulaManager.INSTANCE.modulo(numerator, denominator);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Multiply<T> pMultiply) {
        NumeralFormula factor1 = (NumeralFormula)pMultiply.getFactor1().accept(this);
        NumeralFormula factor2 = (NumeralFormula)pMultiply.getFactor2().accept(this);
        NumeralFormula toVisit = factor1 == pMultiply.getFactor1() && factor2 == pMultiply.getFactor2() ? pMultiply : InvariantsFormulaManager.INSTANCE.multiply(factor1, factor2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(ShiftLeft<T> pShiftLeft) {
        NumeralFormula shifted = (NumeralFormula)pShiftLeft.getShifted().accept(this);
        NumeralFormula shiftDistance = (NumeralFormula)pShiftLeft.getShiftDistance().accept(this);
        NumeralFormula toVisit = shifted == pShiftLeft.getShifted() && shiftDistance == pShiftLeft.getShiftDistance() ? pShiftLeft : InvariantsFormulaManager.INSTANCE.shiftLeft(shifted, shiftDistance);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(ShiftRight<T> pShiftRight) {
        NumeralFormula shifted = (NumeralFormula)pShiftRight.getShifted().accept(this);
        NumeralFormula shiftDistance = (NumeralFormula)pShiftRight.getShiftDistance().accept(this);
        NumeralFormula toVisit = shifted == pShiftRight.getShifted() && shiftDistance == pShiftRight.getShiftDistance() ? pShiftRight : InvariantsFormulaManager.INSTANCE.shiftRight(shifted, shiftDistance);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Union<T> pUnion) {
        NumeralFormula operand1 = (NumeralFormula)pUnion.getOperand1().accept(this);
        NumeralFormula operand2 = (NumeralFormula)pUnion.getOperand2().accept(this);
        NumeralFormula toVisit = operand1 == pUnion.getOperand1() && operand2 == pUnion.getOperand2() ? pUnion : InvariantsFormulaManager.INSTANCE.union(operand1, operand2);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Variable<T> pVariable) {
        return this.visitPost(pVariable);
    }

    @Override
    public NumeralFormula<T> visit(IfThenElse<T> pIfThenElse) {
        NumeralFormula positiveCase = (NumeralFormula)pIfThenElse.getPositiveCase().accept(this);
        NumeralFormula negativeCase = (NumeralFormula)pIfThenElse.getNegativeCase().accept(this);
        NumeralFormula<T> toVisit = positiveCase == pIfThenElse.getPositiveCase() && negativeCase == pIfThenElse.getNegativeCase() ? pIfThenElse : InvariantsFormulaManager.INSTANCE.ifThenElse(pIfThenElse.getCondition(), positiveCase, negativeCase);
        return this.visitPost(toVisit);
    }

    @Override
    public NumeralFormula<T> visit(Cast<T> pCast) {
        NumeralFormula operand = (NumeralFormula)pCast.getCasted().accept(this);
        NumeralFormula<T> toVisit = operand == pCast.getCasted() ? pCast : InvariantsFormulaManager.INSTANCE.cast(pCast.getTypeInfo(), operand);
        return this.visitPost(toVisit);
    }
}

