/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.RecursiveBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.RecursiveNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;

public class ReplaceVisitor<T>
implements NumeralFormulaVisitor<T, NumeralFormula<T>>,
BooleanFormulaVisitor<T, BooleanFormula<T>> {
    private final Predicate<? super NumeralFormula<T>> toReplaceN;
    private final Function<? super NumeralFormula<T>, ? extends NumeralFormula<T>> replacementN;
    private final Predicate<? super BooleanFormula<T>> toReplaceB;
    private final Function<? super BooleanFormula<T>, ? extends BooleanFormula<T>> replacementB;
    private final RecursiveNumeralFormulaVisitor<T> recursiveNumeralFormulaVisitor;
    private final RecursiveBooleanFormulaVisitor<T> recursiveBooleanFormulaVisitor;

    public ReplaceVisitor(NumeralFormula<T> pToReplace, NumeralFormula<T> pReplacement) {
        this(pToReplace == null ? Predicates.alwaysFalse() : Predicates.equalTo(pToReplace), Functions.constant(pReplacement), Predicates.alwaysFalse(), Functions.identity());
    }

    public ReplaceVisitor(Predicate<? super NumeralFormula<T>> pToReplace, Function<NumeralFormula<T>, NumeralFormula<T>> pReplacement) {
        this(pToReplace, pReplacement, Predicates.alwaysFalse(), Functions.identity());
    }

    public ReplaceVisitor(BooleanFormula<T> pToReplace, BooleanFormula<T> pReplacement) {
        this(Predicates.alwaysFalse(), Functions.identity(), pToReplace == null ? Predicates.alwaysFalse() : Predicates.equalTo(pToReplace), Functions.constant(pReplacement));
    }

    private ReplaceVisitor(Predicate<? super NumeralFormula<T>> pToReplaceN, Function<? super NumeralFormula<T>, ? extends NumeralFormula<T>> pReplacementN, Predicate<? super BooleanFormula<T>> pToReplaceB, Function<? super BooleanFormula<T>, ? extends BooleanFormula<T>> pReplacementB) {
        Preconditions.checkNotNull(pToReplaceN);
        Preconditions.checkNotNull(pReplacementN);
        Preconditions.checkNotNull(pToReplaceB);
        Preconditions.checkNotNull(pReplacementB);
        this.toReplaceN = pToReplaceN;
        this.replacementN = pReplacementN;
        this.toReplaceB = pToReplaceB;
        this.replacementB = pReplacementB;
        this.recursiveNumeralFormulaVisitor = new RecursiveNumeralFormulaVisitor<T>(){

            @Override
            protected NumeralFormula<T> visitPost(NumeralFormula<T> pFormula) {
                if (ReplaceVisitor.this.toReplaceN.apply(pFormula)) {
                    return (NumeralFormula)ReplaceVisitor.this.replacementN.apply(pFormula);
                }
                return pFormula;
            }
        };
        this.recursiveBooleanFormulaVisitor = new RecursiveBooleanFormulaVisitor<T>(this.recursiveNumeralFormulaVisitor){

            @Override
            protected BooleanFormula<T> visitPost(BooleanFormula<T> pFormula) {
                if (ReplaceVisitor.this.toReplaceB.apply(pFormula)) {
                    return (BooleanFormula)ReplaceVisitor.this.replacementB.apply(pFormula);
                }
                return pFormula;
            }
        };
    }

    @Override
    public BooleanFormula<T> visitFalse() {
        return this.recursiveBooleanFormulaVisitor.visitFalse();
    }

    @Override
    public BooleanFormula<T> visitTrue() {
        return this.recursiveBooleanFormulaVisitor.visitTrue();
    }

    @Override
    public BooleanFormula<T> visit(Equal<T> pEqual) {
        return (BooleanFormula)pEqual.accept(this.recursiveBooleanFormulaVisitor);
    }

    @Override
    public BooleanFormula<T> visit(LessThan<T> pLessThan) {
        return (BooleanFormula)pLessThan.accept(this.recursiveBooleanFormulaVisitor);
    }

    @Override
    public BooleanFormula<T> visit(LogicalAnd<T> pAnd) {
        return (BooleanFormula)pAnd.accept(this.recursiveBooleanFormulaVisitor);
    }

    @Override
    public BooleanFormula<T> visit(LogicalNot<T> pNot) {
        return (BooleanFormula)pNot.accept(this.recursiveBooleanFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Add<T> pAdd) {
        return (NumeralFormula)pAdd.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(BinaryAnd<T> pAnd) {
        return (NumeralFormula)pAnd.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(BinaryNot<T> pNot) {
        return (NumeralFormula)pNot.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(BinaryOr<T> pOr) {
        return (NumeralFormula)pOr.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(BinaryXor<T> pXor) {
        return (NumeralFormula)pXor.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Constant<T> pConstant) {
        return (NumeralFormula)pConstant.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Divide<T> pDivide) {
        return (NumeralFormula)pDivide.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Exclusion<T> pExclusion) {
        return (NumeralFormula)pExclusion.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Modulo<T> pModulo) {
        return (NumeralFormula)pModulo.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Multiply<T> pMultiply) {
        return (NumeralFormula)pMultiply.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(ShiftLeft<T> pShiftLeft) {
        return (NumeralFormula)pShiftLeft.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(ShiftRight<T> pShiftRight) {
        return (NumeralFormula)pShiftRight.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Union<T> pUnion) {
        return (NumeralFormula)pUnion.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Variable<T> pVariable) {
        return (NumeralFormula)pVariable.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(IfThenElse<T> pIfThenElse) {
        return (NumeralFormula)pIfThenElse.accept(this.recursiveNumeralFormulaVisitor);
    }

    @Override
    public NumeralFormula<T> visit(Cast<T> pCast) {
        return (NumeralFormula)pCast.accept(this.recursiveNumeralFormulaVisitor);
    }
}

