/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;

public class SplitConjunctionsVisitor<T>
implements BooleanFormulaVisitor<T, List<BooleanFormula<T>>> {
    @Override
    public List<BooleanFormula<T>> visit(Equal<T> pEqual) {
        return Collections.singletonList(pEqual);
    }

    @Override
    public List<BooleanFormula<T>> visit(LessThan<T> pLessThan) {
        return Collections.singletonList(pLessThan);
    }

    @Override
    public List<BooleanFormula<T>> visit(LogicalAnd<T> pAnd) {
        List left = (List)pAnd.getOperand1().accept(this);
        if (left.contains(BooleanConstant.getFalse())) {
            return this.visitFalse();
        }
        List right = (List)pAnd.getOperand2().accept(this);
        if (right.contains(BooleanConstant.getFalse())) {
            return this.visitFalse();
        }
        return SplitConjunctionsVisitor.concat(left, right);
    }

    @Override
    public List<BooleanFormula<T>> visit(LogicalNot<T> pNot) {
        return Collections.singletonList(pNot);
    }

    @Override
    public List<BooleanFormula<T>> visitFalse() {
        return Collections.singletonList(BooleanConstant.getFalse());
    }

    @Override
    public List<BooleanFormula<T>> visitTrue() {
        return ImmutableList.of();
    }

    private static <T> List<T> concat(List<T> a, List<T> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        if (a.size() == 1 && b.size() == 1) {
            ArrayList<T> result = new ArrayList<T>(a);
            result.addAll(b);
            return result;
        }
        if (a.size() == 1) {
            b.addAll(a);
            return b;
        }
        a.addAll(b);
        return a;
    }
}

