/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;

class SplitDisjunctionsVisitor<T>
implements BooleanFormulaVisitor<T, ImmutableList<BooleanFormula<T>>> {
    SplitDisjunctionsVisitor() {
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visit(Equal<T> pEqual) {
        return ImmutableList.of(pEqual);
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visit(LessThan<T> pLessThan) {
        return ImmutableList.of(pLessThan);
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visit(LogicalAnd<T> pAnd) {
        return ImmutableList.of(pAnd);
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visit(LogicalNot<T> pNot) {
        if (pNot.getNegated() instanceof LogicalAnd) {
            ArrayList result = new ArrayList();
            LogicalAnd formula = (LogicalAnd)pNot.getNegated();
            BooleanFormula term = formula.getOperand1();
            term = !(term instanceof LogicalNot) ? LogicalNot.of(term) : ((LogicalNot)term).getNegated();
            result.addAll((Collection)term.accept(this));
            if (result.contains(BooleanConstant.getTrue())) {
                return this.visitTrue();
            }
            term = formula.getOperand2();
            term = !(term instanceof LogicalNot) ? LogicalNot.of(term) : ((LogicalNot)term).getNegated();
            Collection toAdd = (Collection)term.accept(this);
            if (toAdd.contains(BooleanConstant.getTrue())) {
                return this.visitTrue();
            }
            result.addAll(toAdd);
            return ImmutableList.copyOf(result);
        }
        return ImmutableList.of(pNot);
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visitFalse() {
        return ImmutableList.of();
    }

    @Override
    public ImmutableList<BooleanFormula<T>> visitTrue() {
        return ImmutableList.of(BooleanConstant.getTrue());
    }
}

