/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.util.Map;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManager;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundIntervalManagerFactory;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.CompoundIntervalFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.DefaultParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class StateEqualsVisitor
extends DefaultParameterizedNumeralFormulaVisitor<CompoundInterval, NumeralFormula<CompoundInterval>, Boolean>
implements ParameterizedBooleanFormulaVisitor<CompoundInterval, BooleanFormula<CompoundInterval>, Boolean> {
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> environment;
    private final CompoundIntervalManagerFactory compoundIntervalManagerFactory;

    public StateEqualsVisitor(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment, CompoundIntervalManagerFactory pCompoundIntervalManagerFactory) {
        this.evaluationVisitor = pEvaluationVisitor;
        this.environment = pEnvironment;
        this.compoundIntervalManagerFactory = pCompoundIntervalManagerFactory;
    }

    @Override
    protected Boolean visitDefault(NumeralFormula<CompoundInterval> pFormula, NumeralFormula<CompoundInterval> pOther) {
        CompoundInterval leftValue = (CompoundInterval)pFormula.accept(this.evaluationVisitor, this.environment);
        CompoundInterval rightValue = (CompoundInterval)pOther.accept(this.evaluationVisitor, this.environment);
        return leftValue.isSingleton() && leftValue.equals(rightValue);
    }

    @Override
    private Boolean visitDefault(BooleanFormula<CompoundInterval> pFormula, BooleanFormula<CompoundInterval> pOther) {
        BooleanConstant leftValue = (BooleanConstant)pFormula.accept(this.evaluationVisitor, this.environment);
        BooleanConstant rightValue = (BooleanConstant)pOther.accept(this.evaluationVisitor, this.environment);
        return leftValue != null && leftValue.equals(rightValue);
    }

    private Boolean visitCommutative(NumeralFormula<CompoundInterval> pO1, NumeralFormula<CompoundInterval> pO2, NumeralFormula<CompoundInterval> pOtherO1, NumeralFormula<CompoundInterval> pOtherO2) {
        return this.visitNonCommutative(pO1, pO2, pOtherO1, pOtherO2) != false || pO1.accept(this, pOtherO2) != false && pO2.accept(this, pOtherO1) != false;
    }

    private Boolean visitCommutative(BooleanFormula<CompoundInterval> pO1, BooleanFormula<CompoundInterval> pO2, BooleanFormula<CompoundInterval> pOtherO1, BooleanFormula<CompoundInterval> pOtherO2) {
        return this.visitNonCommutative(pO1, pO2, pOtherO1, pOtherO2) != false || pO1.accept(this, pOtherO2) != false && pO2.accept(this, pOtherO1) != false;
    }

    private Boolean visitNonCommutative(NumeralFormula<CompoundInterval> pO1, NumeralFormula<CompoundInterval> pO2, NumeralFormula<CompoundInterval> pOtherO1, NumeralFormula<CompoundInterval> pOtherO2) {
        return pO1.accept(this, pOtherO1) != false && pO2.accept(this, pOtherO2) != false;
    }

    private Boolean visitNonCommutative(BooleanFormula<CompoundInterval> pO1, BooleanFormula<CompoundInterval> pO2, BooleanFormula<CompoundInterval> pOtherO1, BooleanFormula<CompoundInterval> pOtherO2) {
        return pO1.accept(this, pOtherO1) != false && pO2.accept(this, pOtherO2) != false;
    }

    @Override
    public Boolean visit(Add<CompoundInterval> pAdd, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Add) {
            Add other = (Add)pOther;
            if (this.visitCommutative(pAdd.getSummand1(), pAdd.getSummand2(), other.getSummand1(), other.getSummand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pAdd, pOther);
    }

    @Override
    public Boolean visit(BinaryAnd<CompoundInterval> pAnd, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryAnd) {
            BinaryAnd other = (BinaryAnd)pOther;
            if (this.visitCommutative(pAnd.getOperand1(), pAnd.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pAnd, pOther);
    }

    @Override
    public Boolean visit(BinaryNot<CompoundInterval> pNot, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryNot) {
            BinaryNot other = (BinaryNot)pOther;
            if (pNot.getFlipped().accept(this, other.getFlipped()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pNot, pOther);
    }

    @Override
    public Boolean visit(BinaryOr<CompoundInterval> pOr, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryOr) {
            BinaryOr other = (BinaryOr)pOther;
            if (this.visitCommutative(pOr.getOperand1(), pOr.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pOr, pOther);
    }

    @Override
    public Boolean visit(BinaryXor<CompoundInterval> pXor, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof BinaryXor) {
            BinaryXor other = (BinaryXor)pOther;
            if (this.visitCommutative(pXor.getOperand1(), pXor.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pXor, pOther);
    }

    @Override
    public Boolean visit(Divide<CompoundInterval> pDivide, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Divide) {
            Divide other = (Divide)pOther;
            if (this.visitNonCommutative(pDivide.getNumerator(), pDivide.getDenominator(), other.getNumerator(), other.getDenominator()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pDivide, pOther);
    }

    @Override
    public Boolean visit(Modulo<CompoundInterval> pModulo, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Modulo) {
            Modulo other = (Modulo)pOther;
            if (this.visitNonCommutative(pModulo.getNumerator(), pModulo.getDenominator(), other.getNumerator(), other.getDenominator()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pModulo, pOther);
    }

    @Override
    public Boolean visit(Multiply<CompoundInterval> pMultiply, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Multiply) {
            Multiply other = (Multiply)pOther;
            if (this.visitCommutative(pMultiply.getFactor1(), pMultiply.getFactor2(), other.getFactor1(), other.getFactor2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pMultiply, pOther);
    }

    @Override
    public Boolean visit(ShiftLeft<CompoundInterval> pShiftLeft, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof ShiftLeft) {
            ShiftLeft other = (ShiftLeft)pOther;
            if (this.visitNonCommutative(pShiftLeft.getShifted(), pShiftLeft.getShiftDistance(), other.getShifted(), other.getShiftDistance()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pShiftLeft, pOther);
    }

    @Override
    public Boolean visit(ShiftRight<CompoundInterval> pShiftRight, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof ShiftRight) {
            ShiftRight other = (ShiftRight)pOther;
            if (this.visitNonCommutative(pShiftRight.getShifted(), pShiftRight.getShiftDistance(), other.getShifted(), other.getShiftDistance()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pShiftRight, pOther);
    }

    @Override
    public Boolean visit(Union<CompoundInterval> pUnion, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Union) {
            Union other = (Union)pOther;
            if (this.visitCommutative(pUnion.getOperand1(), pUnion.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pUnion, pOther);
    }

    @Override
    public Boolean visit(Variable<CompoundInterval> pVariable, NumeralFormula<CompoundInterval> pOther) {
        if (pVariable.equals(pOther)) {
            return true;
        }
        MemoryLocation leftVarLocation = pVariable.getMemoryLocation();
        NumeralFormula<CompoundInterval> resolvedLeft = this.environment.get(leftVarLocation);
        CompoundIntervalManager cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(pVariable.getTypeInfo());
        NumeralFormula<CompoundInterval> numeralFormula = resolvedLeft = resolvedLeft == null ? InvariantsFormulaManager.INSTANCE.asConstant(pVariable.getTypeInfo(), cim.allPossibleValues()) : resolvedLeft;
        if (pOther instanceof Variable) {
            MemoryLocation rightVarLocation = ((Variable)pOther).getMemoryLocation();
            if (leftVarLocation.equals(rightVarLocation)) {
                return true;
            }
            NumeralFormula<CompoundInterval> resolvedRight = this.environment.get(rightVarLocation);
            cim = this.compoundIntervalManagerFactory.createCompoundIntervalManager(pOther.getTypeInfo());
            NumeralFormula<CompoundInterval> numeralFormula2 = resolvedRight = resolvedRight == null ? InvariantsFormulaManager.INSTANCE.asConstant(pOther.getTypeInfo(), cim.allPossibleValues()) : resolvedRight;
            if (resolvedLeft.accept(this, resolvedRight).booleanValue()) {
                return true;
            }
            if (resolvedRight.accept(this, pVariable).booleanValue()) {
                return true;
            }
        }
        if (resolvedLeft.accept(this, pOther).booleanValue()) {
            return true;
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pVariable, pOther);
    }

    @Override
    public Boolean visit(Exclusion<CompoundInterval> pExclusion, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Exclusion) {
            return pExclusion.getExcluded().accept(this, ((Exclusion)pOther).getExcluded());
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pExclusion, pOther);
    }

    @Override
    public Boolean visit(Cast<CompoundInterval> pCast, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof Cast) {
            return pCast.getTypeInfo().equals(pOther.getTypeInfo()) && pCast.getCasted().accept(this, ((Cast)pOther).getCasted()) != false;
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pCast, pOther);
    }

    @Override
    public Boolean visit(IfThenElse<CompoundInterval> pIfThenElse, NumeralFormula<CompoundInterval> pOther) {
        if (pOther instanceof IfThenElse) {
            IfThenElse other = (IfThenElse)pOther;
            if (pIfThenElse.getCondition().accept(this, other.getCondition()).booleanValue()) {
                return this.visitNonCommutative(pIfThenElse.getPositiveCase(), pIfThenElse.getNegativeCase(), other.getPositiveCase(), other.getNegativeCase());
            }
            CompoundIntervalFormulaManager cifm = new CompoundIntervalFormulaManager(this.compoundIntervalManagerFactory);
            if (pIfThenElse.getCondition().accept(this, cifm.logicalNot(pIfThenElse.getCondition())).booleanValue()) {
                return this.visitNonCommutative(pIfThenElse.getPositiveCase(), pIfThenElse.getNegativeCase(), other.getNegativeCase(), other.getPositiveCase());
            }
        }
        return this.visitDefault((NumeralFormula<CompoundInterval>)pIfThenElse, pOther);
    }

    @Override
    public Boolean visit(Equal<CompoundInterval> pEqual, BooleanFormula<CompoundInterval> pOther) {
        if (pOther instanceof Equal) {
            Equal other = (Equal)pOther;
            if (this.visitCommutative(pEqual.getOperand1(), pEqual.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault(pEqual, pOther);
    }

    @Override
    public Boolean visit(LessThan<CompoundInterval> pLessThan, BooleanFormula<CompoundInterval> pOther) {
        if (pOther instanceof LessThan) {
            LessThan other = (LessThan)pOther;
            if (this.visitNonCommutative(pLessThan.getOperand1(), pLessThan.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault(pLessThan, pOther);
    }

    @Override
    public Boolean visit(LogicalAnd<CompoundInterval> pAnd, BooleanFormula<CompoundInterval> pOther) {
        if (pOther instanceof LogicalAnd) {
            LogicalAnd other = (LogicalAnd)pOther;
            if (this.visitCommutative(pAnd.getOperand1(), pAnd.getOperand2(), other.getOperand1(), other.getOperand2()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault(pAnd, pOther);
    }

    @Override
    public Boolean visit(LogicalNot<CompoundInterval> pNot, BooleanFormula<CompoundInterval> pOther) {
        if (pOther instanceof LogicalNot) {
            LogicalNot other = (LogicalNot)pOther;
            if (pNot.getNegated().accept(this, other.getNegated()).booleanValue()) {
                return true;
            }
        }
        return this.visitDefault(pNot, pOther);
    }

    @Override
    public Boolean visitFalse(BooleanFormula<CompoundInterval> pOther) {
        return BooleanConstant.isFalse(pOther);
    }

    @Override
    public Boolean visitTrue(BooleanFormula<CompoundInterval> pOther) {
        return BooleanConstant.isTrue(pOther);
    }
}

