/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundFloatingPointInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.java_smt.api.BitvectorFormula;
import org.sosy_lab.java_smt.api.BitvectorFormulaManager;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.BooleanFormulaManager;
import org.sosy_lab.java_smt.api.Formula;

public class ToBitvectorFormulaVisitor
implements ParameterizedNumeralFormulaVisitor<CompoundInterval, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>, BitvectorFormula>,
ParameterizedBooleanFormulaVisitor<CompoundInterval, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>, BooleanFormula> {
    private final BooleanFormulaManager bfmgr;
    private final BitvectorFormulaManager bvfmgr;
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;

    public ToBitvectorFormulaVisitor(FormulaManagerView pFmgr, FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor) {
        this.bfmgr = pFmgr.getBooleanFormulaManager();
        this.bvfmgr = pFmgr.getBitvectorFormulaManager();
        this.evaluationVisitor = pEvaluationVisitor;
    }

    private @Nullable BitvectorFormula evaluate(NumeralFormula<CompoundInterval> pFormula, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo;
        CompoundInterval intervals = (CompoundInterval)pFormula.accept(this.evaluationVisitor, pEnvironment);
        if (intervals.isSingleton() && (typeInfo = pFormula.getTypeInfo()) instanceof BitVectorInfo) {
            return this.asBitVectorFormula(pFormula.getTypeInfo(), intervals.getValue());
        }
        return null;
    }

    private BitvectorFormula asBitVectorFormula(TypeInfo pTypeInfo, Number pValue) {
        boolean negative;
        if (!(pTypeInfo instanceof BitVectorInfo) || !(pValue instanceof BigInteger)) {
            return null;
        }
        int size = ((BitVectorInfo)pTypeInfo).getSize();
        BigInteger value = (BigInteger)pValue;
        BigInteger upperExclusive = BigInteger.valueOf(2L).pow(size);
        boolean bl = negative = value.signum() < 0;
        if (negative && !value.equals(upperExclusive.shiftRight(1).negate())) {
            value = value.negate();
            value = value.and(BigInteger.valueOf(2L).pow(size - 1).subtract(BigInteger.valueOf(1L))).negate();
        } else if (!negative) {
            value = value.and(BigInteger.valueOf(2L).pow(size).subtract(BigInteger.valueOf(1L)));
        }
        return this.bvfmgr.makeBitvector(size, value);
    }

    @Override
    public BitvectorFormula visit(Add<CompoundInterval> pAdd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula summand1 = pAdd.getSummand1().accept(this, pEnvironment);
        BitvectorFormula summand2 = pAdd.getSummand2().accept(this, pEnvironment);
        if (summand1 == null || summand2 == null) {
            return this.evaluate(pAdd, pEnvironment);
        }
        return this.bvfmgr.add(summand1, summand2);
    }

    @Override
    public BitvectorFormula visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pAnd, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pNot, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryOr<CompoundInterval> pOr, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pOr, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(BinaryXor<CompoundInterval> pXor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pXor, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Constant<CompoundInterval> pConstant, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pConstant, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Divide<CompoundInterval> pDivide, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula numerator = pDivide.getNumerator().accept(this, pEnvironment);
        BitvectorFormula denominator = pDivide.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pDivide, pEnvironment);
        }
        return this.bvfmgr.divide(numerator, denominator, true);
    }

    @Override
    public BitvectorFormula visit(Exclusion<CompoundInterval> pExclusion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pExclusion, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Modulo<CompoundInterval> pModulo, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula numerator = pModulo.getNumerator().accept(this, pEnvironment);
        BitvectorFormula denominator = pModulo.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pModulo, pEnvironment);
        }
        return this.bvfmgr.modulo(numerator, denominator, true);
    }

    @Override
    public BitvectorFormula visit(Multiply<CompoundInterval> pMultiply, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula factor1 = pMultiply.getFactor1().accept(this, pEnvironment);
        BitvectorFormula factor2 = pMultiply.getFactor2().accept(this, pEnvironment);
        if (factor1 == null || factor2 == null) {
            return this.evaluate(pMultiply, pEnvironment);
        }
        return this.bvfmgr.multiply(factor1, factor2);
    }

    @Override
    public BitvectorFormula visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftLeft, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftRight, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Union<CompoundInterval> pUnion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pUnion, pEnvironment);
    }

    @Override
    public BitvectorFormula visit(Variable<CompoundInterval> pVariable, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = pVariable.getTypeInfo();
        if (typeInfo instanceof BitVectorInfo) {
            return this.bvfmgr.makeVariable(((BitVectorInfo)typeInfo).getSize(), pVariable.getMemoryLocation().getExtendedQualifiedName());
        }
        return null;
    }

    @Override
    public BitvectorFormula visit(Cast<CompoundInterval> pCast, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BitvectorFormula sourceFormula = pCast.getCasted().accept(this, pEnvironment);
        if (sourceFormula == null) {
            return sourceFormula;
        }
        TypeInfo sourceInfo = pCast.getCasted().getTypeInfo();
        TypeInfo targetInfo = pCast.getTypeInfo();
        if (sourceInfo instanceof BitVectorInfo && targetInfo instanceof BitVectorInfo) {
            int targetSize;
            int sourceSize = ((BitVectorInfo)sourceInfo).getSize();
            if (sourceSize < (targetSize = ((BitVectorInfo)targetInfo).getSize())) {
                return this.bvfmgr.extend(sourceFormula, targetSize - sourceSize, targetInfo.isSigned());
            }
            return this.bvfmgr.extract(sourceFormula, targetSize - 1, 0);
        }
        return null;
    }

    @Override
    public BitvectorFormula visit(IfThenElse<CompoundInterval> pIfThenElse, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BooleanConstant conditionEval = (BooleanConstant)pIfThenElse.getCondition().accept(this.evaluationVisitor, pEnvironment);
        if (BooleanConstant.isTrue(conditionEval)) {
            return pIfThenElse.getPositiveCase().accept(this, pEnvironment);
        }
        if (BooleanConstant.isFalse(conditionEval)) {
            return pIfThenElse.getNegativeCase().accept(this, pEnvironment);
        }
        BooleanFormula conditionFormula = pIfThenElse.getCondition().accept(this, pEnvironment);
        if (conditionFormula == null) {
            return InvariantsFormulaManager.INSTANCE.union(pIfThenElse.getPositiveCase(), pIfThenElse.getNegativeCase()).accept(this, pEnvironment);
        }
        BitvectorFormula positiveCaseFormula = pIfThenElse.getPositiveCase().accept(this, pEnvironment);
        if (positiveCaseFormula == null) {
            return null;
        }
        BitvectorFormula negativeCaseFormula = pIfThenElse.getNegativeCase().accept(this, pEnvironment);
        if (negativeCaseFormula == null) {
            return null;
        }
        return (BitvectorFormula)this.bfmgr.ifThenElse(conditionFormula, (Formula)positiveCaseFormula, (Formula)negativeCaseFormula);
    }

    @Override
    public BooleanFormula visit(Equal<CompoundInterval> pEqual, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = pEqual.getOperand1().getTypeInfo();
        BitvectorFormula operand1 = pEqual.getOperand1().accept(this, pEnvironment);
        BitvectorFormula operand2 = pEqual.getOperand2().accept(this, pEnvironment);
        if (operand1 == null && operand2 == null) {
            return null;
        }
        if (operand1 == null || operand2 == null) {
            BooleanFormula bf;
            NumeralFormula<CompoundInterval> right;
            BitvectorFormula left;
            if (operand1 != null) {
                left = operand1;
                right = pEqual.getOperand2();
            } else {
                left = operand2;
                right = pEqual.getOperand1();
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            if (rightValue instanceof CompoundFloatingPointInterval) {
                bf = this.bfmgr.makeTrue();
            } else {
                bf = this.bfmgr.makeFalse();
                for (SimpleInterval interval : rightValue.getIntervals()) {
                    BooleanFormula intervalFormula = this.bfmgr.makeTrue();
                    if (interval.isSingleton()) {
                        BitvectorFormula value = this.asBitVectorFormula(typeInfo, interval.getLowerBound());
                        intervalFormula = this.bfmgr.and(intervalFormula, this.bvfmgr.equal(left, value));
                    } else {
                        if (interval.hasLowerBound()) {
                            BitvectorFormula lb = this.asBitVectorFormula(typeInfo, interval.getLowerBound());
                            intervalFormula = this.bfmgr.and(intervalFormula, this.bvfmgr.greaterOrEquals(left, lb, typeInfo.isSigned()));
                        }
                        if (interval.hasUpperBound()) {
                            BitvectorFormula ub = this.asBitVectorFormula(typeInfo, interval.getUpperBound());
                            intervalFormula = this.bfmgr.and(intervalFormula, this.bvfmgr.lessOrEquals(left, ub, typeInfo.isSigned()));
                        }
                    }
                    bf = this.bfmgr.or(bf, intervalFormula);
                }
            }
            return bf;
        }
        return this.bvfmgr.equal(operand1, operand2);
    }

    @Override
    public BooleanFormula visit(LessThan<CompoundInterval> pLessThan, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = pLessThan.getOperand1().getTypeInfo();
        BitvectorFormula operand1 = pLessThan.getOperand1().accept(this, pEnvironment);
        BitvectorFormula operand2 = pLessThan.getOperand2().accept(this, pEnvironment);
        if (operand1 == null && operand2 == null) {
            return null;
        }
        if (operand1 == null || operand2 == null) {
            boolean lessThan;
            NumeralFormula<CompoundInterval> right;
            BitvectorFormula left;
            if (operand1 != null) {
                left = operand1;
                right = pLessThan.getOperand2();
                lessThan = true;
            } else {
                left = operand2;
                right = pLessThan.getOperand1();
                lessThan = false;
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            if (rightValue.isBottom()) {
                return this.bfmgr.makeFalse();
            }
            if (lessThan) {
                if (rightValue.hasUpperBound()) {
                    return this.bvfmgr.lessThan(left, this.asBitVectorFormula(typeInfo, rightValue.getUpperBound()), typeInfo.isSigned());
                }
            } else if (rightValue.hasLowerBound()) {
                return this.bvfmgr.greaterThan(left, this.asBitVectorFormula(typeInfo, rightValue.getLowerBound()), typeInfo.isSigned());
            }
            return null;
        }
        return this.bvfmgr.lessThan(operand1, operand2, typeInfo.isSigned());
    }

    @Override
    public BooleanFormula visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.bfmgr.and(pAnd.getOperand1().accept(this, pEnvironment), pAnd.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public BooleanFormula visit(LogicalNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.bfmgr.not(pNot.getNegated().accept(this, pEnvironment));
    }

    @Override
    public BooleanFormula visitFalse(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.bfmgr.makeFalse();
    }

    @Override
    public BooleanFormula visitTrue(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.bfmgr.makeTrue();
    }
}

