/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.formula;

import java.math.BigInteger;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundFloatingPointInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundInterval;
import org.sosy_lab.cpachecker.cpa.invariants.FloatingPointTypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.TypeInfo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Add;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryOr;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BinaryXor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.BooleanConstant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Cast;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Constant;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Divide;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Equal;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Exclusion;
import org.sosy_lab.cpachecker.cpa.invariants.formula.FormulaEvaluationVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.IfThenElse;
import org.sosy_lab.cpachecker.cpa.invariants.formula.InvariantsFormulaManager;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LessThan;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalAnd;
import org.sosy_lab.cpachecker.cpa.invariants.formula.LogicalNot;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Modulo;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Multiply;
import org.sosy_lab.cpachecker.cpa.invariants.formula.NumeralFormula;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedBooleanFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ParameterizedNumeralFormulaVisitor;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftLeft;
import org.sosy_lab.cpachecker.cpa.invariants.formula.ShiftRight;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Union;
import org.sosy_lab.cpachecker.cpa.invariants.formula.Variable;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class ToCodeFormulaVisitor
implements ParameterizedNumeralFormulaVisitor<CompoundInterval, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>, String>,
ParameterizedBooleanFormulaVisitor<CompoundInterval, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>>, ExpressionTree<String>> {
    private static final CSimpleType[] TYPES = new CSimpleType[]{CNumericTypes.SIGNED_CHAR, CNumericTypes.UNSIGNED_CHAR, CNumericTypes.SHORT_INT, CNumericTypes.UNSIGNED_SHORT_INT, CNumericTypes.INT, CNumericTypes.SIGNED_INT, CNumericTypes.UNSIGNED_INT, CNumericTypes.LONG_INT, CNumericTypes.UNSIGNED_LONG_INT, CNumericTypes.LONG_LONG_INT, CNumericTypes.UNSIGNED_LONG_LONG_INT};
    private final FormulaEvaluationVisitor<CompoundInterval> evaluationVisitor;
    private final MachineModel machineModel;

    public ToCodeFormulaVisitor(FormulaEvaluationVisitor<CompoundInterval> pEvaluationVisitor, MachineModel pMachineModel) {
        this.evaluationVisitor = pEvaluationVisitor;
        this.machineModel = pMachineModel;
    }

    private CSimpleType determineType(TypeInfo pTypeInfo) {
        if (pTypeInfo instanceof BitVectorInfo) {
            BitVectorInfo bitVectorInfo = (BitVectorInfo)pTypeInfo;
            int sizeOfChar = this.machineModel.getSizeofCharInBits();
            int size = bitVectorInfo.getSize();
            boolean isSigned = bitVectorInfo.isSigned();
            for (CSimpleType type : TYPES) {
                if (this.machineModel.isSigned(type) != isSigned || this.machineModel.getSizeof(type) * sizeOfChar < size) continue;
                return type;
            }
            return CNumericTypes.INT;
        }
        if (pTypeInfo instanceof FloatingPointTypeInfo) {
            FloatingPointTypeInfo fpTypeInfo = (FloatingPointTypeInfo)pTypeInfo;
            switch (fpTypeInfo) {
                case FLOAT: {
                    return CNumericTypes.FLOAT;
                }
                case DOUBLE: {
                    return CNumericTypes.DOUBLE;
                }
            }
        }
        throw new AssertionError((Object)("Unsupported type: " + pTypeInfo));
    }

    private @Nullable String evaluate(NumeralFormula<CompoundInterval> pFormula, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo info;
        CompoundInterval intervals = (CompoundInterval)pFormula.accept(this.evaluationVisitor, pEnvironment);
        if (intervals.isSingleton() && (info = pFormula.getTypeInfo()) instanceof BitVectorInfo) {
            return this.asFormulaString(info, intervals.getValue());
        }
        return null;
    }

    private String asFormulaString(TypeInfo pInfo, Number pValue) {
        if (pInfo instanceof BitVectorInfo && pValue instanceof BigInteger) {
            boolean negative;
            BitVectorInfo bitVectorInfo = (BitVectorInfo)pInfo;
            int size = bitVectorInfo.getSize();
            BigInteger value = (BigInteger)pValue;
            BigInteger upperExclusive = BigInteger.valueOf(2L).pow(size - 1);
            boolean bl = negative = value.signum() < 0;
            if (negative && !value.equals(upperExclusive.negate())) {
                value = value.negate();
                value = value.and(BigInteger.valueOf(2L).pow(size - 1).subtract(BigInteger.valueOf(1L))).negate();
            } else if (!negative) {
                value = value.and(BigInteger.valueOf(2L).pow(size).subtract(BigInteger.valueOf(1L)));
            }
            Object typeSuffix = "";
            if (!bitVectorInfo.isSigned()) {
                typeSuffix = (String)typeSuffix + "U";
            }
            if (bitVectorInfo.getSize() > 32) {
                typeSuffix = (String)typeSuffix + "LL";
            }
            if (bitVectorInfo.isSigned() && value.equals(upperExclusive.negate())) {
                return "(" + value.add(BigInteger.ONE) + (String)typeSuffix + " - 1)";
            }
            return value.toString() + (String)typeSuffix;
        }
        throw new AssertionError((Object)("Unsupported type: " + pInfo));
    }

    @Override
    public String visit(Add<CompoundInterval> pAdd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        String negatedStr;
        NumeralFormula<CompoundInterval> summand1 = pAdd.getSummand1();
        NumeralFormula<CompoundInterval> summand2 = pAdd.getSummand2();
        String summand1Str = summand1.accept(this, pEnvironment);
        String summand2Str = summand2.accept(this, pEnvironment);
        if (summand1Str == null || summand2Str == null) {
            return this.evaluate(pAdd, pEnvironment);
        }
        NumeralFormula<CompoundInterval> negated = this.getNegated(summand1);
        String string = negatedStr = negated == null ? null : negated.accept(this, pEnvironment);
        if (negatedStr != null) {
            return "(" + summand2Str + " - " + negatedStr + ")";
        }
        negated = this.getNegated(summand2);
        String string2 = negatedStr = negated == null ? null : negated.accept(this, pEnvironment);
        if (negated != null) {
            return "(" + summand1Str + " - " + negatedStr + ")";
        }
        return "(" + summand1Str + " + " + summand2Str + ")";
    }

    private NumeralFormula<CompoundInterval> getNegated(NumeralFormula<CompoundInterval> pFormula) {
        Constant constant;
        CompoundInterval value;
        if (!(pFormula instanceof Multiply)) {
            return null;
        }
        Multiply multiply = (Multiply)pFormula;
        if (multiply.getFactor1() instanceof Constant && (value = (CompoundInterval)(constant = (Constant)multiply.getFactor1()).getValue()).isSingleton() && value.contains(BigInteger.valueOf(-1L))) {
            return multiply.getFactor2();
        }
        if (multiply.getFactor2() instanceof Constant && (value = (CompoundInterval)(constant = (Constant)multiply.getFactor2()).getValue()).isSingleton() && value.contains(BigInteger.valueOf(-1L))) {
            return multiply.getFactor1();
        }
        return null;
    }

    @Override
    public String visit(BinaryAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pAnd, pEnvironment);
    }

    @Override
    public String visit(BinaryNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pNot, pEnvironment);
    }

    @Override
    public String visit(BinaryOr<CompoundInterval> pOr, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pOr, pEnvironment);
    }

    @Override
    public String visit(BinaryXor<CompoundInterval> pXor, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pXor, pEnvironment);
    }

    @Override
    public String visit(Constant<CompoundInterval> pConstant, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pConstant, pEnvironment);
    }

    @Override
    public String visit(Divide<CompoundInterval> pDivide, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        String numerator = pDivide.getNumerator().accept(this, pEnvironment);
        String denominator = pDivide.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pDivide, pEnvironment);
        }
        return "(" + numerator + " / " + denominator + ")";
    }

    @Override
    public String visit(Exclusion<CompoundInterval> pExclusion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pExclusion, pEnvironment);
    }

    @Override
    public String visit(Modulo<CompoundInterval> pModulo, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        String numerator = pModulo.getNumerator().accept(this, pEnvironment);
        String denominator = pModulo.getDenominator().accept(this, pEnvironment);
        if (numerator == null || denominator == null) {
            return this.evaluate(pModulo, pEnvironment);
        }
        return "(" + numerator + " % " + denominator + ")";
    }

    @Override
    public String visit(Multiply<CompoundInterval> pMultiply, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        String negatedStr;
        String factor1 = pMultiply.getFactor1().accept(this, pEnvironment);
        String factor2 = pMultiply.getFactor2().accept(this, pEnvironment);
        if (factor1 == null || factor2 == null) {
            return this.evaluate(pMultiply, pEnvironment);
        }
        NumeralFormula<CompoundInterval> negated = this.getNegated(pMultiply);
        String string = negatedStr = negated == null ? null : negated.accept(this, pEnvironment);
        if (negatedStr != null) {
            return "(-" + negatedStr + ")";
        }
        return "(" + factor1 + " * " + factor2 + ")";
    }

    @Override
    public String visit(ShiftLeft<CompoundInterval> pShiftLeft, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftLeft, pEnvironment);
    }

    @Override
    public String visit(ShiftRight<CompoundInterval> pShiftRight, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pShiftRight, pEnvironment);
    }

    @Override
    public String visit(Union<CompoundInterval> pUnion, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return this.evaluate(pUnion, pEnvironment);
    }

    @Override
    public String visit(Variable<CompoundInterval> pVariable, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return pVariable.getMemoryLocation().getIdentifier();
    }

    @Override
    public String visit(Cast<CompoundInterval> pCast, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        int targetSize;
        BitVectorInfo sourceBitVectorInfo;
        int sourceSize;
        TypeInfo targetInfo = pCast.getTypeInfo();
        String sourceFormula = pCast.getCasted().accept(this, pEnvironment);
        TypeInfo sourceInfo = pCast.getCasted().getTypeInfo();
        if (targetInfo instanceof BitVectorInfo && sourceInfo instanceof BitVectorInfo && ((sourceSize = (sourceBitVectorInfo = (BitVectorInfo)sourceInfo).getSize()) == (targetSize = ((BitVectorInfo)targetInfo).getSize()) && sourceBitVectorInfo.isSigned() == targetInfo.isSigned() || sourceFormula == null)) {
            return sourceFormula;
        }
        CSimpleType castType = this.determineType(targetInfo);
        return String.format("(%s) %s", castType, sourceFormula);
    }

    @Override
    public String visit(IfThenElse<CompoundInterval> pIfThenElse, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        BooleanConstant conditionEval = (BooleanConstant)pIfThenElse.getCondition().accept(this.evaluationVisitor, pEnvironment);
        if (BooleanConstant.isTrue(conditionEval)) {
            return pIfThenElse.getPositiveCase().accept(this, pEnvironment);
        }
        if (BooleanConstant.isFalse(conditionEval)) {
            return pIfThenElse.getNegativeCase().accept(this, pEnvironment);
        }
        ExpressionTree<String> conditionFormula = pIfThenElse.getCondition().accept(this, pEnvironment);
        if (conditionFormula == null) {
            return InvariantsFormulaManager.INSTANCE.union(pIfThenElse.getPositiveCase(), pIfThenElse.getNegativeCase()).accept(this, pEnvironment);
        }
        String positiveCaseFormula = pIfThenElse.getPositiveCase().accept(this, pEnvironment);
        if (positiveCaseFormula == null) {
            return null;
        }
        String negativeCaseFormula = pIfThenElse.getNegativeCase().accept(this, pEnvironment);
        if (negativeCaseFormula == null) {
            return null;
        }
        return "(" + conditionFormula + " ? " + positiveCaseFormula + " : " + negativeCaseFormula + ")";
    }

    @Override
    public ExpressionTree<String> visit(Equal<CompoundInterval> pEqual, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = pEqual.getOperand1().getTypeInfo();
        ExpressionTree inversion = ExpressionTrees.getTrue();
        CompoundInterval op1EvalInvert = ((CompoundInterval)pEqual.getOperand1().accept(this.evaluationVisitor, pEnvironment)).invert();
        if (op1EvalInvert.isSingleton() && pEqual.getOperand2() instanceof Variable) {
            return ToCodeFormulaVisitor.not(Equal.of(Constant.of(typeInfo, op1EvalInvert), pEqual.getOperand2()).accept(this, pEnvironment));
        }
        CompoundInterval op2EvalInvert = ((CompoundInterval)pEqual.getOperand2().accept(this.evaluationVisitor, pEnvironment)).invert();
        if (op2EvalInvert.isSingleton() && pEqual.getOperand1() instanceof Variable) {
            return ToCodeFormulaVisitor.not(Equal.of(pEqual.getOperand1(), Constant.of(typeInfo, op2EvalInvert)).accept(this, pEnvironment));
        }
        String operand1 = pEqual.getOperand1().accept(this, pEnvironment);
        String operand2 = pEqual.getOperand2().accept(this, pEnvironment);
        if (operand1 == null && operand2 == null) {
            return null;
        }
        if (operand1 == null || operand2 == null) {
            ExpressionTree bf;
            NumeralFormula<CompoundInterval> right;
            String left;
            if (operand1 != null) {
                left = operand1;
                right = pEqual.getOperand2();
            } else {
                left = operand2;
                right = pEqual.getOperand1();
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            if (rightValue instanceof CompoundFloatingPointInterval) {
                bf = ExpressionTrees.getTrue();
            } else {
                bf = ExpressionTrees.getFalse();
                for (SimpleInterval interval : rightValue.getIntervals()) {
                    ExpressionTree<Object> intervalFormula = ExpressionTrees.getTrue();
                    if (interval.isSingleton()) {
                        String value = this.asFormulaString(typeInfo, interval.getLowerBound());
                        intervalFormula = And.of(intervalFormula, ToCodeFormulaVisitor.equal(left, value));
                    } else {
                        if (interval.hasLowerBound()) {
                            String lb = this.asFormulaString(typeInfo, interval.getLowerBound());
                            intervalFormula = And.of(intervalFormula, ToCodeFormulaVisitor.greaterEqual(left, lb));
                        }
                        if (interval.hasUpperBound()) {
                            String ub = this.asFormulaString(typeInfo, interval.getUpperBound());
                            intervalFormula = And.of(intervalFormula, ToCodeFormulaVisitor.lessEqual(left, ub));
                        }
                    }
                    bf = Or.of(bf, intervalFormula);
                }
            }
            return And.of(bf, inversion);
        }
        return And.of(ToCodeFormulaVisitor.equal(operand1, operand2), inversion);
    }

    @Override
    public ExpressionTree<String> visit(LessThan<CompoundInterval> pLessThan, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        TypeInfo typeInfo = pLessThan.getOperand1().getTypeInfo();
        String operand1 = pLessThan.getOperand1().accept(this, pEnvironment);
        String operand2 = pLessThan.getOperand2().accept(this, pEnvironment);
        if (operand1 == null && operand2 == null) {
            return null;
        }
        if (operand1 == null || operand2 == null) {
            boolean lessThan;
            NumeralFormula<CompoundInterval> right;
            String left;
            if (operand1 != null) {
                left = operand1;
                right = pLessThan.getOperand2();
                lessThan = true;
            } else {
                left = operand2;
                right = pLessThan.getOperand1();
                lessThan = false;
            }
            CompoundInterval rightValue = (CompoundInterval)right.accept(this.evaluationVisitor, pEnvironment);
            if (rightValue.isBottom()) {
                return ExpressionTrees.getFalse();
            }
            if (lessThan) {
                if (rightValue.hasUpperBound()) {
                    return ToCodeFormulaVisitor.lessThan(left, this.asFormulaString(typeInfo, rightValue.getUpperBound()));
                }
            } else if (rightValue.hasLowerBound()) {
                return ToCodeFormulaVisitor.greaterThan(left, this.asFormulaString(typeInfo, rightValue.getLowerBound()));
            }
            return null;
        }
        return ToCodeFormulaVisitor.lessThan(operand1, operand2);
    }

    private static ExpressionTree<String> lessThan(String pLess, String pMore) {
        return LeafExpression.of(String.format("(%s < %s)", pLess, pMore));
    }

    private static ExpressionTree<String> lessEqual(String pLess, String pMore) {
        return LeafExpression.of(String.format("(%s <= %s)", pLess, pMore));
    }

    private static ExpressionTree<String> greaterThan(String pMore, String pLess) {
        return LeafExpression.of(String.format("(%s > %s)", pMore, pLess));
    }

    private static ExpressionTree<String> greaterEqual(String pMore, String pLess) {
        return LeafExpression.of(String.format("(%s >= %s)", pMore, pLess));
    }

    private static ExpressionTree<String> equal(String pLess, String pMore) {
        return LeafExpression.of(String.format("(%s == %s)", pLess, pMore));
    }

    private static ExpressionTree<String> not(ExpressionTree<String> pOp) {
        if (pOp.equals(ExpressionTrees.getFalse())) {
            return ExpressionTrees.getTrue();
        }
        if (pOp.equals(ExpressionTrees.getTrue())) {
            return ExpressionTrees.getFalse();
        }
        if (pOp instanceof LeafExpression) {
            return ((LeafExpression)pOp).negate();
        }
        return LeafExpression.of(String.format("(!(%s))", pOp));
    }

    @Override
    public ExpressionTree<String> visit(LogicalAnd<CompoundInterval> pAnd, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return And.of(pAnd.getOperand1().accept(this, pEnvironment), pAnd.getOperand2().accept(this, pEnvironment));
    }

    @Override
    public ExpressionTree<String> visit(LogicalNot<CompoundInterval> pNot, Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return ToCodeFormulaVisitor.not(pNot.getNegated().accept(this, pEnvironment));
    }

    @Override
    public ExpressionTree<String> visitFalse(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return ExpressionTrees.getFalse();
    }

    @Override
    public ExpressionTree<String> visitTrue(Map<? extends MemoryLocation, ? extends NumeralFormula<CompoundInterval>> pEnvironment) {
        return ExpressionTrees.getTrue();
    }
}

