/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.IICOperatorFactory;

public enum ICCOperatorFactory {
    INSTANCE;


    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getAdd(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> pSecondOperand.add((BitVectorInterval)pFirstOperand, pAllowSignedWrapAround, pOverflowEventHandler);
    }

    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getDivide(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, CompoundBitVectorInterval pSecondOperand) {
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                for (BitVectorInterval interval : pSecondOperand.getBitVectorIntervals()) {
                    CompoundBitVectorInterval current = IICOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, interval);
                    if (current == null || !(result = result.unionWith(current)).containsAllPossibleValues()) continue;
                    return result;
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getModulo(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, CompoundBitVectorInterval pSecondOperand) {
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                for (BitVectorInterval interval : pSecondOperand.getBitVectorIntervals()) {
                    CompoundBitVectorInterval current = IICOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, interval);
                    if (current == null || !(result = result.unionWith(current)).containsAllPossibleValues()) continue;
                    return result;
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getMultiply(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> pSecondOperand.multiply((BitVectorInterval)pFirstOperand, pAllowSignedWrapAround, pOverflowEventHandler);
    }

    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getShiftLeft(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, CompoundBitVectorInterval pSecondOperand) {
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                for (BitVectorInterval interval : pSecondOperand.getBitVectorIntervals()) {
                    CompoundBitVectorInterval current = IICOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, interval);
                    if (current == null || !(result = result.unionWith(current)).containsAllPossibleValues()) continue;
                    return result;
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval> getShiftRight(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, CompoundBitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, CompoundBitVectorInterval pSecondOperand) {
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                for (BitVectorInterval interval : pSecondOperand.getBitVectorIntervals()) {
                    CompoundBitVectorInterval current = IICOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, interval);
                    if (current == null || !(result = result.unionWith(current)).containsAllPossibleValues()) continue;
                    return result;
                }
                return result;
            }
        };
    }
}

