/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.IIIOperatorFactory;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ISCOperatorFactory;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ISIOperatorFactory;

public enum IICOperatorFactory {
    INSTANCE;


    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getAdd(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                return CompoundBitVectorInterval.of(IIIOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, pSecondOperand));
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getDivide(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                BitVectorInterval result = IIIOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, pSecondOperand);
                return result == null ? CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo()) : CompoundBitVectorInterval.of(result);
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getModulo(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                if (pSecondOperand.isSingleton()) {
                    return CompoundBitVectorInterval.of(pFirstOperand).modulo(pSecondOperand.getLowerBound(), pAllowSignedWrapAround, pOverflowEventHandler);
                }
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(info);
                if (pFirstOperand.containsNegative()) {
                    BigInteger negUB = pFirstOperand.closestNegativeToZero();
                    BitVectorInterval asPositive = pFirstOperand.hasLowerBound() ? (pFirstOperand.getLowerBound().equals(info.getMinValue()) ? BitVectorInterval.of(info, negUB.negate(), info.getMaxValue()) : BitVectorInterval.of(info, negUB.negate(), pFirstOperand.getLowerBound().negate())) : BitVectorInterval.singleton(info, negUB.negate()).extendToMaxValue();
                    result = result.unionWith(this.applyPositiveUnknown(asPositive, pSecondOperand).negate(pAllowSignedWrapAround, pOverflowEventHandler));
                }
                if (pFirstOperand.containsPositive()) {
                    BigInteger posLB = pFirstOperand.closestPositiveToZero();
                    BitVectorInterval positivePart = pFirstOperand.hasUpperBound() ? BitVectorInterval.of(info, posLB, pFirstOperand.getUpperBound()) : BitVectorInterval.singleton(info, posLB).extendToMaxValue();
                    result = result.unionWith(this.applyPositiveUnknown(positivePart, pSecondOperand));
                }
                assert (result != null);
                return result;
            }

            private CompoundBitVectorInterval applyPositiveUnknown(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                if (pSecondOperand.isSingleton()) {
                    Operator<BitVectorInterval, BigInteger, BitVectorInterval> operator = ISIOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler);
                    return CompoundBitVectorInterval.of(operator.apply(pFirstOperand, pSecondOperand.getLowerBound()));
                }
                Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(info);
                if (pSecondOperand.containsNegative()) {
                    BigInteger negUB = pSecondOperand.closestNegativeToZero();
                    BitVectorInterval asPositive = pSecondOperand.hasLowerBound() ? (pSecondOperand.getLowerBound().equals(info.getMinValue()) ? BitVectorInterval.of(info, negUB.negate(), info.getMaxValue()) : BitVectorInterval.of(info, negUB.negate(), pSecondOperand.getLowerBound().negate())) : BitVectorInterval.singleton(info, negUB.negate()).extendToMaxValue();
                    result = result.unionWith(this.applyPositivePositive(pFirstOperand, asPositive));
                }
                if (pSecondOperand.containsPositive()) {
                    BigInteger posLB = pSecondOperand.closestPositiveToZero();
                    BitVectorInterval positivePart = pSecondOperand.hasUpperBound() ? BitVectorInterval.of(info, posLB, pSecondOperand.getUpperBound()) : BitVectorInterval.singleton(info, posLB).extendToMaxValue();
                    result = result.unionWith(this.applyPositivePositive(pFirstOperand, positivePart));
                }
                return result;
            }

            private BitVectorInterval applyPositivePositive(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                BigInteger resultUpperBound;
                if (pSecondOperand.isSingleton()) {
                    Operator<BitVectorInterval, BigInteger, BitVectorInterval> operator = ISIOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler);
                    return operator.apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pSecondOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pSecondOperand.containsZero() ? 1 : 0) != 0);
                if (pFirstOperand.hasUpperBound() && pSecondOperand.getLowerBound().compareTo(pFirstOperand.getUpperBound()) > 0) {
                    return pFirstOperand;
                }
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                if (pFirstOperand.hasUpperBound()) {
                    resultUpperBound = pSecondOperand.hasUpperBound() ? pFirstOperand.getUpperBound().min(pSecondOperand.getUpperBound().subtract(BigInteger.ONE)) : pFirstOperand.getUpperBound();
                } else if (pSecondOperand.hasUpperBound()) {
                    resultUpperBound = pSecondOperand.getUpperBound().subtract(BigInteger.ONE);
                } else {
                    return BitVectorInterval.singleton(info, BigInteger.ZERO).extendToMaxValue();
                }
                return BitVectorInterval.of(info, BigInteger.ZERO, resultUpperBound);
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getMultiply(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                return CompoundBitVectorInterval.of(IIIOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, pSecondOperand));
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getShiftLeft(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return CompoundBitVectorInterval.of(pFirstOperand);
                }
                BitVectorInfo bitVectorInfo = pFirstOperand.getTypeInfo();
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(bitVectorInfo);
                if (pSecondOperand.containsZero()) {
                    result = result.unionWith(pFirstOperand);
                }
                if (pSecondOperand.containsNegative() || pSecondOperand.intersectsWith(BitVectorInterval.singleton(bitVectorInfo, BigInteger.valueOf(bitVectorInfo.getSize())).extendToMaxValue())) {
                    return CompoundBitVectorInterval.of(bitVectorInfo.getRange());
                }
                if (pSecondOperand.containsPositive()) {
                    BitVectorInterval posPart = pSecondOperand.intersectWith(BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ONE, pAllowSignedWrapAround, pOverflowEventHandler).extendToMaxValue());
                    CompoundBitVectorInterval posPartResult = ISCOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getLowerBound());
                    posPartResult = CompoundBitVectorInterval.span(posPartResult, ISCOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getUpperBound()));
                    result = result.unionWith(posPartResult);
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval> getShiftRight(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return CompoundBitVectorInterval.of(pFirstOperand);
                }
                BitVectorInfo bitVectorInfo = pFirstOperand.getTypeInfo();
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(bitVectorInfo);
                if (pSecondOperand.containsZero()) {
                    result = result.unionWith(pFirstOperand);
                }
                if (pSecondOperand.containsNegative() || pSecondOperand.intersectsWith(BitVectorInterval.singleton(bitVectorInfo, BigInteger.valueOf(bitVectorInfo.getSize())).extendToMaxValue())) {
                    return CompoundBitVectorInterval.of(bitVectorInfo.getRange());
                }
                if (pSecondOperand.containsPositive()) {
                    BitVectorInterval posPart = pSecondOperand.getPositivePart();
                    CompoundBitVectorInterval posPartResult = ISCOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getLowerBound());
                    posPartResult = CompoundBitVectorInterval.span(posPartResult, ISCOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getUpperBound()));
                    result = result.unionWith(posPartResult);
                }
                return result;
            }
        };
    }
}

