/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ISIOperatorFactory;

enum IIIOperatorFactory {
    INSTANCE;


    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getAdd(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pOperand1, BitVectorInterval pOperand2) {
                IIIOperatorFactory.checkBitVectorCompatibility(pOperand1, pOperand2);
                if (pOperand1.isTop()) {
                    return pOperand1;
                }
                if (pOperand2.isTop()) {
                    return pOperand2;
                }
                if (pOperand2.isSingleton()) {
                    return ISIOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler).apply(pOperand1, pOperand2.getLowerBound());
                }
                if (pOperand1.isSingleton()) {
                    return ISIOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler).apply(pOperand2, pOperand1.getLowerBound());
                }
                BigInteger lowerBound = pOperand1.getLowerBound();
                BigInteger upperBound = pOperand1.getUpperBound();
                BigInteger pLowerBound = pOperand2.getLowerBound();
                BigInteger pUpperBound = pOperand2.getUpperBound();
                lowerBound = lowerBound.add(pLowerBound);
                upperBound = upperBound.add(pUpperBound);
                return BitVectorInterval.cast(pOperand1.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getDivide(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public @Nullable BitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                IIIOperatorFactory.checkBitVectorCompatibility(pFirstOperand, pSecondOperand);
                if (pSecondOperand.isSingleton()) {
                    return ISIOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                if (pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                List<BigInteger> divisors = pSecondOperand.getSplitZeroBounds();
                assert (!divisors.isEmpty()) : "Should only happen for singleton zero, but all singletons should be handled above.";
                Operator<BitVectorInterval, BigInteger, BitVectorInterval> isiDivider = ISIOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler);
                BitVectorInterval result = null;
                for (BigInteger divisor : divisors) {
                    BitVectorInterval componentInterval = isiDivider.apply(pFirstOperand, divisor);
                    if (componentInterval == null) continue;
                    if (result == null) {
                        result = componentInterval;
                        continue;
                    }
                    result = BitVectorInterval.span(result, componentInterval);
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getModulo(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                IIIOperatorFactory.checkBitVectorCompatibility(pFirstOperand, pSecondOperand);
                if (!pSecondOperand.hasLowerBound() || !pSecondOperand.hasUpperBound()) {
                    return pFirstOperand;
                }
                if (pSecondOperand.isSingleton()) {
                    Operator<BitVectorInterval, BigInteger, BitVectorInterval> operator = ISIOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler);
                    return operator.apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                BitVectorInterval result = null;
                if (pFirstOperand.containsNegative()) {
                    BigInteger negUB = pFirstOperand.closestNegativeToZero();
                    BitVectorInterval asPositive = pFirstOperand.hasLowerBound() ? (pFirstOperand.getLowerBound().equals(info.getMinValue()) ? BitVectorInterval.of(info, negUB.negate(), info.getMaxValue()) : BitVectorInterval.of(info, negUB.negate(), pFirstOperand.getLowerBound().negate())) : BitVectorInterval.singleton(info, negUB.negate()).extendToMaxValue();
                    result = this.applyPositiveUnknown(asPositive, pSecondOperand).negate(pAllowSignedWrapAround, pOverflowEventHandler);
                }
                if (pFirstOperand.containsPositive()) {
                    BigInteger posLB = pFirstOperand.closestPositiveToZero();
                    BitVectorInterval positivePart = pFirstOperand.hasUpperBound() ? BitVectorInterval.of(info, posLB, pFirstOperand.getUpperBound()) : BitVectorInterval.singleton(info, posLB).extendToMaxValue();
                    BitVectorInterval posResult = this.applyPositiveUnknown(positivePart, pSecondOperand);
                    BitVectorInterval bitVectorInterval = result = result == null ? posResult : BitVectorInterval.span(result, posResult);
                }
                assert (result != null);
                return result;
            }

            private BitVectorInterval applyPositiveUnknown(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                if (pSecondOperand.isSingleton()) {
                    Operator<BitVectorInterval, BigInteger, BitVectorInterval> operator = ISIOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler);
                    return operator.apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                BitVectorInterval result = null;
                if (pSecondOperand.containsNegative()) {
                    BigInteger negUB = pSecondOperand.closestNegativeToZero();
                    BitVectorInterval asPositive = pSecondOperand.hasLowerBound() ? (pSecondOperand.getLowerBound().equals(info.getMinValue()) ? BitVectorInterval.of(info, negUB.negate(), info.getMaxValue()) : BitVectorInterval.of(info, negUB.negate(), pSecondOperand.getLowerBound().negate())) : BitVectorInterval.singleton(info, negUB.negate()).extendToMaxValue();
                    result = this.applyPositivePositive(pFirstOperand, asPositive);
                }
                if (pSecondOperand.containsPositive()) {
                    BigInteger posLB = pSecondOperand.closestPositiveToZero();
                    BitVectorInterval positivePart = pSecondOperand.hasUpperBound() ? BitVectorInterval.of(info, posLB, pSecondOperand.getUpperBound()) : BitVectorInterval.singleton(info, posLB).extendToMaxValue();
                    BitVectorInterval posResult = this.applyPositivePositive(pFirstOperand, positivePart);
                    BitVectorInterval bitVectorInterval = result = result == null ? posResult : BitVectorInterval.span(result, posResult);
                }
                assert (result != null);
                return result;
            }

            private BitVectorInterval applyPositivePositive(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                BigInteger resultUpperBound;
                if (pSecondOperand.isSingleton()) {
                    Operator<BitVectorInterval, BigInteger, BitVectorInterval> operator = ISIOperatorFactory.INSTANCE.getModulo(pAllowSignedWrapAround, pOverflowEventHandler);
                    return operator.apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pSecondOperand.containsNegative() ? 1 : 0) != 0);
                Preconditions.checkArgument((!pSecondOperand.containsZero() ? 1 : 0) != 0);
                if (pFirstOperand.hasUpperBound() && pSecondOperand.getLowerBound().compareTo(pFirstOperand.getUpperBound()) > 0) {
                    return pFirstOperand;
                }
                BitVectorInfo info = pFirstOperand.getTypeInfo();
                if (pFirstOperand.hasUpperBound()) {
                    resultUpperBound = pSecondOperand.hasUpperBound() ? pFirstOperand.getUpperBound().min(pSecondOperand.getUpperBound().subtract(BigInteger.ONE)) : pFirstOperand.getUpperBound();
                } else if (pSecondOperand.hasUpperBound()) {
                    resultUpperBound = pSecondOperand.getUpperBound().subtract(BigInteger.ONE);
                } else {
                    return BitVectorInterval.singleton(info, BigInteger.ZERO).extendToMaxValue();
                }
                return BitVectorInterval.of(info, BigInteger.ZERO, resultUpperBound);
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getMultiply(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                IIIOperatorFactory.checkBitVectorCompatibility(pFirstOperand, pSecondOperand);
                if (pSecondOperand.isSingleton()) {
                    return ISIOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, pSecondOperand.getLowerBound());
                }
                if (pFirstOperand.isSingleton()) {
                    return ISIOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler).apply(pSecondOperand, pFirstOperand.getLowerBound());
                }
                BigInteger pLowerBound = pSecondOperand.getLowerBound();
                BigInteger pUpperBound = pSecondOperand.getUpperBound();
                BigInteger lbLb = pFirstOperand.getLowerBound().multiply(pLowerBound);
                BigInteger lbUb = pFirstOperand.getLowerBound().multiply(pUpperBound);
                BigInteger ubLb = pFirstOperand.getUpperBound().multiply(pLowerBound);
                BigInteger ubUb = pFirstOperand.getUpperBound().multiply(pUpperBound);
                BigInteger lowerBound = lbLb.min(lbUb).min(ubLb).min(ubUb);
                BigInteger upperBound = lbLb.max(lbUb).max(ubLb).max(ubUb);
                BitVectorInterval result = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getShiftLeft(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                IIIOperatorFactory.checkBitVectorCompatibility(pFirstOperand, pSecondOperand);
                if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                BitVectorInterval result = null;
                if (pSecondOperand.containsZero()) {
                    result = pFirstOperand;
                }
                if (pSecondOperand.containsNegative()) {
                    return pFirstOperand.getTypeInfo().getRange();
                }
                if (pSecondOperand.containsPositive()) {
                    BitVectorInterval posPart = pSecondOperand.intersectWith(BitVectorInterval.singleton(pFirstOperand.getTypeInfo(), BigInteger.ONE).extendToMaxValue());
                    BitVectorInterval posPartResult = ISIOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getLowerBound());
                    posPartResult = BitVectorInterval.span(posPartResult, ISIOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getUpperBound()));
                    result = result == null ? posPartResult : BitVectorInterval.span(result, posPartResult);
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> getShiftRight(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
                IIIOperatorFactory.checkBitVectorCompatibility(pFirstOperand, pSecondOperand);
                if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                BitVectorInterval result = null;
                if (pSecondOperand.containsZero()) {
                    result = pFirstOperand;
                }
                if (pSecondOperand.containsNegative()) {
                    return pFirstOperand.getTypeInfo().getRange();
                }
                if (pSecondOperand.containsPositive()) {
                    BitVectorInterval posPart = pSecondOperand.intersectWith(BitVectorInterval.singleton(pFirstOperand.getTypeInfo(), BigInteger.ONE).extendToMaxValue());
                    BitVectorInterval posPartResult = ISIOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getLowerBound());
                    posPartResult = BitVectorInterval.span(posPartResult, ISIOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply(pFirstOperand, posPart.getUpperBound()));
                    result = result == null ? posPartResult : BitVectorInterval.span(result, posPartResult);
                }
                return result;
            }
        };
    }

    private static void checkBitVectorCompatibility(BitVectorInterval pFirstOperand, BitVectorInterval pSecondOperand) {
        Preconditions.checkArgument((boolean)pFirstOperand.getTypeInfo().equals(pSecondOperand.getTypeInfo()), (Object)"Both operands must have the same bit length and signedness.");
    }
}

