/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.IIIOperatorFactory;

public class IIIOperatorTest {
    private static final BitVectorInfo INT = BitVectorInfo.from(32, true);
    private static final Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> ADD = IIIOperatorFactory.INSTANCE.getAdd(true, OverflowEventHandler.EMPTY);
    private static final Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> MULTIPLY = IIIOperatorFactory.INSTANCE.getMultiply(true, OverflowEventHandler.EMPTY);
    private static final Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> DIVIDE = IIIOperatorFactory.INSTANCE.getDivide(true, OverflowEventHandler.EMPTY);
    private static final Operator<BitVectorInterval, BitVectorInterval, BitVectorInterval> MODULO = IIIOperatorFactory.INSTANCE.getModulo(true, OverflowEventHandler.EMPTY);

    @Test
    public void testAdd() {
        BitVectorInterval zero = BitVectorInterval.singleton(INT, BigInteger.ZERO);
        BitVectorInterval one = BitVectorInterval.singleton(INT, BigInteger.ONE);
        Truth.assertThat((Object)ADD.apply(zero, one)).isEqualTo((Object)one);
    }

    @Test
    public void testModulo() {
        BigInteger scalarFour = BigInteger.valueOf(4L);
        BigInteger scalarFive = BigInteger.valueOf(5L);
        BitVectorInterval five = BitVectorInterval.singleton(INT, scalarFive);
        BitVectorInterval negFourToFour = BitVectorInterval.of(INT, scalarFour.negate(), scalarFour);
        BitVectorInterval zeroToFour = BitVectorInterval.of(INT, BigInteger.ZERO, scalarFour);
        BitVectorInterval zeroToMax = BitVectorInterval.singleton(INT, BigInteger.ZERO).extendToMaxValue();
        BitVectorInterval minToZero = BitVectorInterval.singleton(INT, BigInteger.ZERO).extendToMinValue();
        BitVectorInterval tenToEleven = BitVectorInterval.of(INT, BigInteger.valueOf(10L), BigInteger.valueOf(11L));
        BitVectorInterval twoToThree = BitVectorInterval.of(INT, BigInteger.valueOf(2L), BigInteger.valueOf(3L));
        BitVectorInterval zeroToTwo = BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.valueOf(2L));
        BitVectorInterval eightToTen = BitVectorInterval.of(INT, BigInteger.valueOf(8L), BigInteger.TEN);
        Truth.assertThat((Object)MODULO.apply(INT.getRange(), five)).isEqualTo((Object)negFourToFour);
        Truth.assertThat((Object)MODULO.apply(zeroToMax, five)).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)MODULO.apply(zeroToMax, five.negate(true, OverflowEventHandler.EMPTY))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)MODULO.apply(tenToEleven, BitVectorInterval.singleton(INT, scalarFour))).isEqualTo((Object)twoToThree);
        Truth.assertThat((Object)MODULO.apply(eightToTen, BitVectorInterval.singleton(INT, scalarFour))).isEqualTo((Object)zeroToTwo);
        Truth.assertThat((Object)MODULO.apply(tenToEleven, BitVectorInterval.singleton(INT, scalarFour).negate(true, OverflowEventHandler.EMPTY))).isEqualTo((Object)twoToThree);
        Truth.assertThat((Object)MODULO.apply(eightToTen, BitVectorInterval.singleton(INT, scalarFour).negate(true, OverflowEventHandler.EMPTY))).isEqualTo((Object)zeroToTwo);
        Truth.assertThat((Object)MODULO.apply(tenToEleven.negate(true, OverflowEventHandler.EMPTY), BitVectorInterval.singleton(INT, scalarFour))).isEqualTo((Object)twoToThree.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(eightToTen.negate(true, OverflowEventHandler.EMPTY), BitVectorInterval.singleton(INT, scalarFour))).isEqualTo((Object)zeroToTwo.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(tenToEleven.negate(true, OverflowEventHandler.EMPTY), BitVectorInterval.singleton(INT, scalarFour).negate(true, OverflowEventHandler.EMPTY))).isEqualTo((Object)twoToThree.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(eightToTen.negate(true, OverflowEventHandler.EMPTY), BitVectorInterval.singleton(INT, scalarFour).negate(true, OverflowEventHandler.EMPTY))).isEqualTo((Object)zeroToTwo.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(zeroToMax, BitVectorInterval.of(INT, BigInteger.ZERO, scalarFive))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)MODULO.apply(zeroToMax, BitVectorInterval.of(INT, scalarFour.negate(), scalarFive))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)MODULO.apply(zeroToMax, BitVectorInterval.of(INT, scalarFive.negate(), scalarFour))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)MODULO.apply(minToZero, BitVectorInterval.of(INT, BigInteger.ZERO, scalarFive))).isEqualTo((Object)zeroToFour.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(minToZero, BitVectorInterval.of(INT, scalarFour.negate(), scalarFive))).isEqualTo((Object)zeroToFour.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(minToZero, BitVectorInterval.of(INT, scalarFive.negate(), scalarFour))).isEqualTo((Object)zeroToFour.negate(true, OverflowEventHandler.EMPTY));
        Truth.assertThat((Object)MODULO.apply(INT.getRange(), BitVectorInterval.of(INT, scalarFive.negate(), scalarFour))).isEqualTo((Object)BitVectorInterval.of(INT, scalarFour.negate(), scalarFour));
        BitVectorInterval fiftyNine = BitVectorInterval.of(INT, BigInteger.valueOf(59L), BigInteger.valueOf(59L));
        BitVectorInterval zeroTo255 = BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.valueOf(255L));
        Truth.assertThat((Object)MODULO.apply(fiftyNine, zeroTo255)).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(0L), BigInteger.valueOf(59L)));
    }

    @Test
    public void testMultiply() {
        BigInteger hundred = BigInteger.valueOf(100L);
        BitVectorInterval negTenToZero = BitVectorInterval.of(INT, BigInteger.TEN.negate(), BigInteger.ZERO);
        BitVectorInterval zeroToTen = BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.TEN);
        BitVectorInterval negHundredToHundred = BitVectorInterval.of(INT, hundred.negate(), hundred);
        BitVectorInterval negHundredToZero = BitVectorInterval.of(INT, hundred.negate(), BigInteger.ZERO);
        BitVectorInterval negTenToTen = BitVectorInterval.of(INT, BigInteger.TEN.negate(), BigInteger.TEN);
        BitVectorInterval zero = BitVectorInterval.singleton(INT, BigInteger.ZERO);
        BitVectorInterval zeroToOne = BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.ONE);
        BitVectorInterval minToFive = BitVectorInterval.singleton(INT, BigInteger.valueOf(5L)).extendToMinValue();
        BitVectorInterval minToNegFive = BitVectorInterval.singleton(INT, BigInteger.valueOf(-5L)).extendToMinValue();
        BitVectorInterval twentyToTwentyFive = BitVectorInterval.of(INT, BigInteger.valueOf(20L), BigInteger.valueOf(25L));
        BitVectorInterval twoToFour = BitVectorInterval.of(INT, BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        BitVectorInterval fortyToHundred = BitVectorInterval.of(INT, BigInteger.valueOf(40L), BigInteger.valueOf(100L));
        Truth.assertThat((Object)MULTIPLY.apply(negTenToZero, zeroToTen)).isEqualTo((Object)negHundredToZero);
        Truth.assertThat((Object)MULTIPLY.apply(negTenToZero, negTenToTen)).isEqualTo((Object)negHundredToHundred);
        Truth.assertThat((Object)MULTIPLY.apply(INT.getRange(), zero)).isEqualTo((Object)zero);
        Truth.assertThat((Object)MULTIPLY.apply(INT.getRange(), zeroToOne)).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)MULTIPLY.apply(minToFive, minToFive)).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)MULTIPLY.apply(minToNegFive, minToNegFive)).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)MULTIPLY.apply(twentyToTwentyFive, twoToFour)).isEqualTo((Object)fortyToHundred);
    }

    @Test
    public void testDivide() {
        BitVectorInterval negFourToNegTwo = BitVectorInterval.of(INT, BigInteger.valueOf(-4L), BigInteger.valueOf(-2L));
        BitVectorInterval negFourToNegOne = BitVectorInterval.of(INT, BigInteger.valueOf(-4L), BigInteger.valueOf(-1L));
        BitVectorInterval negTwoToNegOne = BitVectorInterval.of(INT, BigInteger.valueOf(-2L), BigInteger.valueOf(-1L));
        BitVectorInterval oneToFour = BitVectorInterval.of(INT, BigInteger.valueOf(1L), BigInteger.valueOf(4L));
        BitVectorInterval oneToTwo = BitVectorInterval.of(INT, BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        BitVectorInterval twoToFour = BitVectorInterval.of(INT, BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        BitVectorInterval negTwentyToTwenty = BitVectorInterval.of(INT, BigInteger.valueOf(-20L), BigInteger.valueOf(20L));
        BitVectorInterval negTwoToTwo = BitVectorInterval.of(INT, BigInteger.valueOf(-2L), BigInteger.valueOf(2L));
        BitVectorInterval minToTen = BitVectorInterval.singleton(INT, BigInteger.valueOf(10L)).extendToMinValue();
        BitVectorInterval minToFive = BitVectorInterval.singleton(INT, BigInteger.valueOf(5L)).extendToMinValue();
        BitVectorInterval minToNegFive = BitVectorInterval.singleton(INT, BigInteger.valueOf(-5L)).extendToMinValue();
        BitVectorInterval fiveToMax = BitVectorInterval.singleton(INT, BigInteger.valueOf(5L)).extendToMaxValue();
        BitVectorInterval negTwentyToTen = BitVectorInterval.of(INT, BigInteger.valueOf(-20L), BigInteger.valueOf(10L));
        BitVectorInterval negTwoToMax = BitVectorInterval.singleton(INT, BigInteger.valueOf(-2L)).extendToMaxValue();
        BitVectorInterval zeroToMax = BitVectorInterval.singleton(INT, BigInteger.ZERO).extendToMaxValue();
        BitVectorInterval minToZero = BitVectorInterval.singleton(INT, BigInteger.ZERO).extendToMinValue();
        BitVectorInterval zeroToTwo = BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.valueOf(2L));
        Truth.assertThat((Object)DIVIDE.apply(minToZero, minToFive)).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)DIVIDE.apply(negFourToNegTwo, negTwoToNegOne)).isEqualTo((Object)oneToFour);
        Truth.assertThat((Object)DIVIDE.apply(negFourToNegTwo, oneToTwo)).isEqualTo((Object)negFourToNegOne);
        Truth.assertThat((Object)DIVIDE.apply(twoToFour, negTwoToNegOne)).isEqualTo((Object)negFourToNegOne);
        Truth.assertThat((Object)DIVIDE.apply(twoToFour, oneToTwo)).isEqualTo((Object)oneToFour);
        Truth.assertThat((Object)DIVIDE.apply(negTwentyToTwenty, negTwoToTwo)).isEqualTo((Object)negTwentyToTwenty);
        Truth.assertThat((Object)DIVIDE.apply(minToTen, negTwoToTwo)).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)DIVIDE.apply(minToTen, twoToFour)).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(-1073741824L), BigInteger.valueOf(5L)));
        Truth.assertThat((Object)DIVIDE.apply(minToNegFive, fiveToMax)).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(-429496729L), BigInteger.ZERO));
        Truth.assertThat((Object)DIVIDE.apply(negTwentyToTen, negTwoToMax)).isEqualTo((Object)negTwentyToTwenty);
        Truth.assertThat((Object)DIVIDE.apply(INT.getRange(), INT.getRange())).isEqualTo((Object)INT.getRange());
        Truth.assertThat((Object)DIVIDE.apply(INT.getRange(), BitVectorInterval.singleton(INT, BigInteger.ZERO))).isNull();
        Truth.assertThat((Object)DIVIDE.apply(INT.getRange(), BitVectorInterval.singleton(INT, BigInteger.valueOf(5L)))).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(-429496729L), BigInteger.valueOf(0x19999999L)));
        Truth.assertThat((Object)DIVIDE.apply(INT.getRange(), BitVectorInterval.singleton(INT, BigInteger.valueOf(-5L)))).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(-429496729L), BigInteger.valueOf(0x19999999L)));
        Truth.assertThat((Object)DIVIDE.apply(zeroToMax, BitVectorInterval.singleton(INT, BigInteger.valueOf(5L)))).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.ZERO, BigInteger.valueOf(0x19999999L)));
        Truth.assertThat((Object)DIVIDE.apply(zeroToMax, BitVectorInterval.singleton(INT, BigInteger.valueOf(-5L)))).isEqualTo((Object)BitVectorInterval.of(INT, BigInteger.valueOf(-429496729L), BigInteger.ZERO));
        Truth.assertThat((Object)DIVIDE.apply(negTwentyToTwenty, zeroToMax)).isEqualTo((Object)negTwentyToTwenty);
        Truth.assertThat((Object)DIVIDE.apply(twoToFour, zeroToTwo)).isEqualTo((Object)oneToFour);
    }
}

