/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundBitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector.ISIOperatorFactory;

public enum ISCOperatorFactory {
    INSTANCE;


    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getAdd(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> CompoundBitVectorInterval.of(ISIOperatorFactory.INSTANCE.getAdd(pAllowSignedWrapAround, pOverflowEventHandler).apply((BitVectorInterval)pFirstOperand, (BigInteger)pSecondOperand));
    }

    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getDivide(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> CompoundBitVectorInterval.of(ISIOperatorFactory.INSTANCE.getDivide(pAllowSignedWrapAround, pOverflowEventHandler).apply((BitVectorInterval)pFirstOperand, (BigInteger)pSecondOperand));
    }

    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getModulo(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval>(){

            @Override
            public CompoundBitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pValue) {
                if (pValue.signum() == 0) {
                    return CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                }
                if (pValue.signum() < 0) {
                    return this.apply(pFirstOperand, pValue.negate());
                }
                if (pFirstOperand.isSingleton()) {
                    return CompoundBitVectorInterval.singleton(pFirstOperand.getTypeInfo(), pFirstOperand.getLowerBound().remainder(pValue));
                }
                BigInteger largestPossibleValue = pValue.subtract(BigInteger.ONE);
                CompoundBitVectorInterval result = CompoundBitVectorInterval.bottom(pFirstOperand.getTypeInfo());
                if (pFirstOperand.containsZero()) {
                    result = result.unionWith(BitVectorInterval.singleton(pFirstOperand.getTypeInfo(), BigInteger.ZERO));
                }
                if (pFirstOperand.containsNegative()) {
                    BitVectorInterval negPart;
                    BitVectorInterval negatedNegPart;
                    CompoundBitVectorInterval negRange = CompoundBitVectorInterval.cast(pFirstOperand.getTypeInfo(), largestPossibleValue.negate(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler);
                    if (pFirstOperand.hasLowerBound() && !(negatedNegPart = (negPart = pFirstOperand.getNegativePart()).negate(pAllowSignedWrapAround, pOverflowEventHandler)).containsNegative()) {
                        negRange = this.apply(negatedNegPart, pValue).negate(pAllowSignedWrapAround, pOverflowEventHandler);
                    }
                    result = result.unionWith(negRange);
                }
                if (pFirstOperand.containsPositive()) {
                    BitVectorInterval posPart;
                    BigInteger posPartLength;
                    CompoundBitVectorInterval posRange = CompoundBitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, largestPossibleValue, pAllowSignedWrapAround, pOverflowEventHandler);
                    if (pFirstOperand.hasUpperBound() && (posPartLength = (posPart = pFirstOperand.getPositivePart()).size()).compareTo(pValue) < 0) {
                        BigInteger quotient = posPart.getUpperBound().divide(pValue);
                        BigInteger modBorder = quotient.multiply(pValue);
                        BigInteger nextModBorder = modBorder.add(pValue);
                        if (modBorder.compareTo(posPart.getLowerBound()) <= 0 && nextModBorder.compareTo(posPart.getUpperBound()) >= 0) {
                            BigInteger bound1 = posPart.getLowerBound().remainder(pValue);
                            BigInteger bound2 = posPart.getUpperBound().remainder(pValue);
                            posRange = CompoundBitVectorInterval.cast(pFirstOperand.getTypeInfo(), bound1.min(bound2), bound1.max(bound2), pAllowSignedWrapAround, pOverflowEventHandler);
                        } else if (modBorder.compareTo(posPart.getLowerBound()) > 0 && modBorder.compareTo(posPart.getUpperBound()) < 0) {
                            BitVectorInterval posPart1 = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), posPart.getLowerBound(), modBorder.subtract(BigInteger.ONE), pAllowSignedWrapAround, pOverflowEventHandler);
                            BitVectorInterval posPart2 = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), modBorder, posPart.getUpperBound(), pAllowSignedWrapAround, pOverflowEventHandler);
                            posRange = this.apply(posPart1, pValue).unionWith(this.apply(posPart2, pValue));
                        }
                    }
                    result = result.unionWith(posRange);
                }
                return result;
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getMultiply(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> CompoundBitVectorInterval.of(ISIOperatorFactory.INSTANCE.getMultiply(pAllowSignedWrapAround, pOverflowEventHandler).apply((BitVectorInterval)pFirstOperand, (BigInteger)pSecondOperand));
    }

    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getShiftLeft(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> CompoundBitVectorInterval.of(ISIOperatorFactory.INSTANCE.getShiftLeft(pAllowSignedWrapAround, pOverflowEventHandler).apply((BitVectorInterval)pFirstOperand, (BigInteger)pSecondOperand));
    }

    public Operator<BitVectorInterval, BigInteger, CompoundBitVectorInterval> getShiftRight(boolean pAllowSignedWrapAround, OverflowEventHandler pOverflowEventHandler) {
        return (pFirstOperand, pSecondOperand) -> CompoundBitVectorInterval.of(ISIOperatorFactory.INSTANCE.getShiftRight(pAllowSignedWrapAround, pOverflowEventHandler).apply((BitVectorInterval)pFirstOperand, (BigInteger)pSecondOperand));
    }
}

