/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.bitvector;

import java.math.BigInteger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInfo;
import org.sosy_lab.cpachecker.cpa.invariants.BitVectorInterval;
import org.sosy_lab.cpachecker.cpa.invariants.OverflowEventHandler;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;

enum ISIOperatorFactory {
    INSTANCE;


    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getAdd(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pFirstOperand.isTop() || pSecondOperand.equals(BigInteger.ZERO)) {
                    return pFirstOperand;
                }
                BigInteger lowerBound = pFirstOperand.getLowerBound().add(pSecondOperand);
                BigInteger upperBound = pFirstOperand.getUpperBound().add(pSecondOperand);
                return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getMultiply(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pSecondOperand.equals(BigInteger.ZERO)) {
                    return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler);
                }
                if (pSecondOperand.equals(BigInteger.ONE) || pFirstOperand.isTop()) {
                    return pFirstOperand;
                }
                if (pSecondOperand.signum() < 0) {
                    return this.apply(pFirstOperand.negate(pAllowSignedWrapAround, pOverflowEventHandler), pSecondOperand.negate());
                }
                BigInteger lowerBound = pFirstOperand.getLowerBound().multiply(pSecondOperand);
                BigInteger upperBound = pFirstOperand.getUpperBound().multiply(pSecondOperand);
                return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getDivide(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public @Nullable BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pSecondOperand.equals(BigInteger.ZERO)) {
                    return null;
                }
                if (pSecondOperand.equals(BigInteger.ONE) || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                if (pSecondOperand.compareTo(BigInteger.ZERO) < 0) {
                    return this.apply(pFirstOperand.negate(pAllowSignedWrapAround, pOverflowEventHandler), pSecondOperand.negate());
                }
                BigInteger lowerBound = pFirstOperand.getLowerBound().divide(pSecondOperand);
                BigInteger upperBound = pFirstOperand.getUpperBound().divide(pSecondOperand);
                return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getModulo(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pSecondOperand.equals(BigInteger.ZERO)) {
                    return null;
                }
                BitVectorInfo typeInfo = pFirstOperand.getTypeInfo();
                if (pSecondOperand.signum() < 0) {
                    if (pSecondOperand.equals(pFirstOperand.getTypeInfo().getMinValue())) {
                        if (pFirstOperand.contains(pSecondOperand)) {
                            return BitVectorInterval.span(pFirstOperand, BitVectorInterval.singleton(typeInfo, BigInteger.ZERO));
                        }
                        return pFirstOperand;
                    }
                    return this.apply(pFirstOperand, pSecondOperand.negate());
                }
                if (pSecondOperand.equals(BigInteger.ONE)) {
                    return BitVectorInterval.singleton(typeInfo, BigInteger.ZERO);
                }
                if (pFirstOperand.isSingleton()) {
                    return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), pFirstOperand.getLowerBound().remainder(pSecondOperand), pAllowSignedWrapAround, pOverflowEventHandler);
                }
                if (pFirstOperand.contains(typeInfo.getMinValue())) {
                    BigInteger minValue = typeInfo.getMinValue();
                    BigInteger minValueRemainder = minValue.remainder(pSecondOperand);
                    BitVectorInterval rest = BitVectorInterval.singleton(typeInfo, minValue.add(BigInteger.ONE)).extendToMaxValue().intersectWith(pFirstOperand);
                    return BitVectorInterval.span(BitVectorInterval.singleton(typeInfo, minValueRemainder), this.apply(rest, pSecondOperand));
                }
                BigInteger largestPossibleValue = pSecondOperand.subtract(BigInteger.ONE);
                BitVectorInterval moduloRange = null;
                if (pFirstOperand.containsNegative()) {
                    moduloRange = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), largestPossibleValue.negate(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler);
                    BitVectorInterval negPart = pFirstOperand.containsZero() ? BitVectorInterval.cast(pFirstOperand.getTypeInfo(), pFirstOperand.getLowerBound(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler) : pFirstOperand;
                    moduloRange = this.apply(negPart.negate(pAllowSignedWrapAround, pOverflowEventHandler), pSecondOperand).negate(pAllowSignedWrapAround, pOverflowEventHandler);
                }
                if (pFirstOperand.containsPositive()) {
                    BigInteger quotient;
                    BigInteger modBorder;
                    BitVectorInterval posRange = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, largestPossibleValue, pAllowSignedWrapAround, pOverflowEventHandler);
                    BitVectorInterval posPart = pFirstOperand.containsZero() ? BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, pFirstOperand.getUpperBound(), pAllowSignedWrapAround, pOverflowEventHandler) : pFirstOperand;
                    BigInteger posPartLength = posPart.size();
                    if (posPartLength.compareTo(pSecondOperand) < 0 && (modBorder = (quotient = posPart.getUpperBound().divide(pSecondOperand)).multiply(pSecondOperand)).compareTo(posPart.getLowerBound()) <= 0 && modBorder.add(largestPossibleValue).compareTo(posPart.getUpperBound()) >= 0) {
                        BigInteger bound1 = posPart.getLowerBound().remainder(pSecondOperand);
                        BigInteger bound2 = posPart.getUpperBound().remainder(pSecondOperand);
                        posRange = BitVectorInterval.cast(pFirstOperand.getTypeInfo(), bound1.min(bound2), bound1.max(bound2), pAllowSignedWrapAround, pOverflowEventHandler);
                    }
                    assert (moduloRange != null || posRange != null);
                    if (moduloRange == null) {
                        moduloRange = posRange;
                    } else if (posRange != null) {
                        moduloRange = BitVectorInterval.span(moduloRange, posRange);
                    }
                }
                return moduloRange;
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getShiftLeft(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pFirstOperand.isTop() || pSecondOperand.signum() == 0 || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                if (pSecondOperand.signum() < 0) {
                    return pFirstOperand.getTypeInfo().getRange();
                }
                if (pSecondOperand.compareTo(BigInteger.valueOf(pFirstOperand.getTypeInfo().getSize())) <= 0) {
                    BigInteger lowerBound = pFirstOperand.getLowerBound().shiftLeft(pSecondOperand.intValue());
                    BigInteger upperBound = pFirstOperand.getUpperBound().shiftLeft(pSecondOperand.intValue());
                    return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
                }
                return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }

    public Operator<BitVectorInterval, BigInteger, BitVectorInterval> getShiftRight(final boolean pAllowSignedWrapAround, final OverflowEventHandler pOverflowEventHandler) {
        return new Operator<BitVectorInterval, BigInteger, BitVectorInterval>(){

            @Override
            public BitVectorInterval apply(BitVectorInterval pFirstOperand, BigInteger pSecondOperand) {
                if (pFirstOperand.isTop() || pSecondOperand.signum() == 0 || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                    return pFirstOperand;
                }
                if (pSecondOperand.signum() < 0) {
                    return pFirstOperand.getTypeInfo().getRange();
                }
                if (pSecondOperand.compareTo(BigInteger.valueOf(pFirstOperand.getTypeInfo().getSize())) <= 0) {
                    BigInteger lowerBound = pFirstOperand.getLowerBound().shiftRight(pSecondOperand.intValue());
                    BigInteger upperBound = pFirstOperand.getUpperBound().shiftRight(pSecondOperand.intValue());
                    return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), lowerBound, upperBound, pAllowSignedWrapAround, pOverflowEventHandler);
                }
                return BitVectorInterval.cast(pFirstOperand.getTypeInfo(), BigInteger.ZERO, pAllowSignedWrapAround, pOverflowEventHandler);
            }
        };
    }
}

