/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical;

import org.sosy_lab.cpachecker.cpa.invariants.CompoundMathematicalInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.IICOperator;

public enum ICCOperator implements Operator<SimpleInterval, CompoundMathematicalInterval, CompoundMathematicalInterval>
{
    ADD{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            return pSecondOperand.add(pFirstOperand);
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundMathematicalInterval current = IICOperator.DIVIDE.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    MODULO{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundMathematicalInterval current = IICOperator.MODULO.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            return pSecondOperand.multiply(pFirstOperand);
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundMathematicalInterval current = IICOperator.SHIFT_LEFT.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, CompoundMathematicalInterval pSecondOperand) {
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            for (SimpleInterval interval : pSecondOperand.getIntervals()) {
                CompoundMathematicalInterval current = IICOperator.SHIFT_RIGHT.apply(pFirstOperand, interval);
                if (current == null || !(result = result.unionWith(current)).isTop()) continue;
                return result;
            }
            return result;
        }
    };


    @Override
    public abstract CompoundMathematicalInterval apply(SimpleInterval var1, CompoundMathematicalInterval var2);
}

