/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.invariants.CompoundMathematicalInterval;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.Operator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.IIIOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ISCOperator;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.ISIOperator;

public enum IICOperator implements Operator<SimpleInterval, SimpleInterval, CompoundMathematicalInterval>
{
    ADD{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundMathematicalInterval.of(IIIOperator.ADD.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    DIVIDE{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundMathematicalInterval.of(IIIOperator.DIVIDE.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    MODULO{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (!pSecondOperand.hasLowerBound() || !pSecondOperand.hasUpperBound()) {
                return CompoundMathematicalInterval.of(pFirstOperand);
            }
            if (pSecondOperand.isSingleton()) {
                return CompoundMathematicalInterval.of(ISIOperator.MODULO.apply(pFirstOperand, pSecondOperand.getLowerBound()));
            }
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            if (pFirstOperand.containsNegative()) {
                BigInteger negUB = pFirstOperand.closestNegativeToZero();
                SimpleInterval asPositive = pFirstOperand.hasLowerBound() ? SimpleInterval.of(negUB.negate(), pFirstOperand.getLowerBound().negate()) : SimpleInterval.singleton(negUB.negate()).extendToPositiveInfinity();
                result = result.unionWith(this.applyPositiveUnknown(asPositive, pSecondOperand).negate());
            }
            if (pFirstOperand.containsPositive()) {
                BigInteger posLB = pFirstOperand.closestPositiveToZero();
                SimpleInterval positivePart = pFirstOperand.hasUpperBound() ? SimpleInterval.of(posLB, pFirstOperand.getUpperBound()) : SimpleInterval.singleton(posLB).extendToPositiveInfinity();
                result = result.unionWith(this.applyPositiveUnknown(positivePart, pSecondOperand));
            }
            return result;
        }

        private CompoundMathematicalInterval applyPositiveUnknown(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pSecondOperand.isSingleton()) {
                return CompoundMathematicalInterval.of(ISIOperator.MODULO.apply(pFirstOperand, pSecondOperand.getLowerBound()));
            }
            Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            if (pSecondOperand.containsNegative()) {
                BigInteger negUB = pSecondOperand.closestNegativeToZero();
                SimpleInterval asPositive = pSecondOperand.hasLowerBound() ? SimpleInterval.of(negUB.negate(), pSecondOperand.getLowerBound().negate()) : SimpleInterval.singleton(negUB.negate()).extendToPositiveInfinity();
                result = result.unionWith(this.applyPositivePositive(pFirstOperand, asPositive));
            }
            if (pSecondOperand.containsPositive()) {
                BigInteger posLB = pSecondOperand.closestPositiveToZero();
                SimpleInterval positivePart = pSecondOperand.hasUpperBound() ? SimpleInterval.of(posLB, pSecondOperand.getUpperBound()) : SimpleInterval.singleton(posLB).extendToPositiveInfinity();
                result = result.unionWith(this.applyPositivePositive(pFirstOperand, positivePart));
            }
            return result;
        }

        private CompoundMathematicalInterval applyPositivePositive(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            BigInteger resultUpperBound;
            if (pSecondOperand.isSingleton()) {
                return CompoundMathematicalInterval.of(ISIOperator.MODULO.apply(pFirstOperand, pSecondOperand.getLowerBound()));
            }
            Preconditions.checkArgument((!pFirstOperand.containsNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!pFirstOperand.containsZero() ? 1 : 0) != 0);
            Preconditions.checkArgument((!pSecondOperand.containsNegative() ? 1 : 0) != 0);
            Preconditions.checkArgument((!pSecondOperand.containsZero() ? 1 : 0) != 0);
            if (pFirstOperand.hasUpperBound() && pSecondOperand.getLowerBound().compareTo(pFirstOperand.getUpperBound()) > 0) {
                return CompoundMathematicalInterval.of(pFirstOperand);
            }
            if (pFirstOperand.hasUpperBound()) {
                resultUpperBound = pSecondOperand.hasUpperBound() ? pFirstOperand.getUpperBound().min(pSecondOperand.getUpperBound()) : pFirstOperand.getUpperBound();
            } else if (pSecondOperand.hasUpperBound()) {
                resultUpperBound = pSecondOperand.getUpperBound();
            } else {
                return CompoundMathematicalInterval.of(SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity());
            }
            return CompoundMathematicalInterval.of(SimpleInterval.of(BigInteger.ZERO, resultUpperBound));
        }
    }
    ,
    MULTIPLY{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            return CompoundMathematicalInterval.of(IIIOperator.MULTIPLY.apply(pFirstOperand, pSecondOperand));
        }
    }
    ,
    SHIFT_LEFT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return CompoundMathematicalInterval.of(pFirstOperand);
            }
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            if (pSecondOperand.containsZero()) {
                result = result.unionWith(pFirstOperand);
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                result = result.unionWith(SHIFT_RIGHT.apply(pFirstOperand, negPart.negate()));
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                CompoundMathematicalInterval posPartResult = ISCOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getLowerBound());
                if (posPart.hasUpperBound()) {
                    posPartResult = CompoundMathematicalInterval.span(posPartResult, ISCOperator.SHIFT_LEFT.apply(pFirstOperand, posPart.getUpperBound()));
                } else {
                    if (pFirstOperand.containsPositive()) {
                        posPartResult = posPartResult.extendToMaxValue();
                    }
                    if (pFirstOperand.containsNegative()) {
                        posPartResult = posPartResult.extendToMinValue();
                    }
                }
                result = result.unionWith(posPartResult);
            }
            return result;
        }
    }
    ,
    SHIFT_RIGHT{

        @Override
        public CompoundMathematicalInterval apply(SimpleInterval pFirstOperand, SimpleInterval pSecondOperand) {
            if (pFirstOperand.isTop() || pSecondOperand.isSingleton() && pSecondOperand.containsZero() || pFirstOperand.isSingleton() && pFirstOperand.containsZero()) {
                return CompoundMathematicalInterval.of(pFirstOperand);
            }
            CompoundMathematicalInterval result = CompoundMathematicalInterval.bottom();
            if (pSecondOperand.containsZero()) {
                result = result.unionWith(pFirstOperand);
            }
            if (pSecondOperand.containsNegative()) {
                SimpleInterval negPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE.negate()).extendToNegativeInfinity());
                result = result.unionWith(SHIFT_LEFT.apply(pFirstOperand, negPart.negate()));
            }
            if (pSecondOperand.containsPositive()) {
                SimpleInterval posPart = pSecondOperand.intersectWith(SimpleInterval.singleton(BigInteger.ONE).extendToPositiveInfinity());
                CompoundMathematicalInterval posPartResult = ISCOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getLowerBound());
                posPartResult = posPart.hasUpperBound() ? CompoundMathematicalInterval.span(posPartResult, ISCOperator.SHIFT_RIGHT.apply(pFirstOperand, posPart.getUpperBound())) : CompoundMathematicalInterval.span(posPartResult, CompoundMathematicalInterval.singleton(BigInteger.ZERO));
                result = result.unionWith(posPartResult);
            }
            return result;
        }
    };


    @Override
    public abstract CompoundMathematicalInterval apply(SimpleInterval var1, SimpleInterval var2);
}

