/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical;

import com.google.common.truth.Truth;
import java.math.BigInteger;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.invariants.SimpleInterval;
import org.sosy_lab.cpachecker.cpa.invariants.operators.mathematical.IIIOperator;

public class IIIOperatorTest {
    @Test
    public void testAdd() {
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval one = SimpleInterval.singleton(BigInteger.ONE);
        Truth.assertThat((Object)IIIOperator.ADD.apply(zero, one)).isEqualTo((Object)one);
    }

    @Test
    public void testModulo() {
        BigInteger scalarFour = BigInteger.valueOf(4L);
        BigInteger scalarFive = BigInteger.valueOf(5L);
        SimpleInterval five = SimpleInterval.singleton(scalarFive);
        SimpleInterval negFourToFour = SimpleInterval.of(scalarFour.negate(), scalarFour);
        SimpleInterval zeroToFour = SimpleInterval.of(BigInteger.ZERO, scalarFour);
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        SimpleInterval tenToEleven = SimpleInterval.of(BigInteger.valueOf(10L), BigInteger.valueOf(11L));
        SimpleInterval twoToThree = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(3L));
        SimpleInterval zeroToTwo = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(2L));
        SimpleInterval eightToTen = SimpleInterval.of(BigInteger.valueOf(8L), BigInteger.TEN);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(SimpleInterval.infinite(), five)).isEqualTo((Object)negFourToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf, five)).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf, five.negate())).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(tenToEleven, SimpleInterval.singleton(scalarFour))).isEqualTo((Object)twoToThree);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(eightToTen, SimpleInterval.singleton(scalarFour))).isEqualTo((Object)zeroToTwo);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(tenToEleven, SimpleInterval.singleton(scalarFour).negate())).isEqualTo((Object)twoToThree);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(eightToTen, SimpleInterval.singleton(scalarFour).negate())).isEqualTo((Object)zeroToTwo);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(tenToEleven.negate(), SimpleInterval.singleton(scalarFour))).isEqualTo((Object)twoToThree.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(eightToTen.negate(), SimpleInterval.singleton(scalarFour))).isEqualTo((Object)zeroToTwo.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(tenToEleven.negate(), SimpleInterval.singleton(scalarFour).negate())).isEqualTo((Object)twoToThree.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(eightToTen.negate(), SimpleInterval.singleton(scalarFour).negate())).isEqualTo((Object)zeroToTwo.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(BigInteger.ZERO, scalarFive))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(scalarFour.negate(), scalarFive))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf, SimpleInterval.of(scalarFive.negate(), scalarFour))).isEqualTo((Object)zeroToFour);
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(BigInteger.ZERO, scalarFive))).isEqualTo((Object)zeroToFour.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(scalarFour.negate(), scalarFive))).isEqualTo((Object)zeroToFour.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(zeroToInf.negate(), SimpleInterval.of(scalarFive.negate(), scalarFour))).isEqualTo((Object)zeroToFour.negate());
        Truth.assertThat((Object)IIIOperator.MODULO.apply(SimpleInterval.infinite(), SimpleInterval.of(scalarFive.negate(), scalarFour))).isEqualTo((Object)SimpleInterval.of(scalarFour.negate(), scalarFour));
        SimpleInterval fiftyNine = SimpleInterval.of(BigInteger.valueOf(59L), BigInteger.valueOf(59L));
        SimpleInterval zeroTo255 = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(255L));
        Truth.assertThat((Object)IIIOperator.MODULO.apply(fiftyNine, zeroTo255)).isEqualTo((Object)SimpleInterval.of(BigInteger.valueOf(0L), BigInteger.valueOf(59L)));
    }

    @Test
    public void testMultiply() {
        BigInteger hundred = BigInteger.valueOf(100L);
        SimpleInterval negTenToZero = SimpleInterval.of(BigInteger.TEN.negate(), BigInteger.ZERO);
        SimpleInterval zeroToTen = SimpleInterval.of(BigInteger.ZERO, BigInteger.TEN);
        SimpleInterval negHundredToHundred = SimpleInterval.of(hundred.negate(), hundred);
        SimpleInterval negHundredToZero = SimpleInterval.of(hundred.negate(), BigInteger.ZERO);
        SimpleInterval negTenToTen = SimpleInterval.of(BigInteger.TEN.negate(), BigInteger.TEN);
        SimpleInterval zero = SimpleInterval.singleton(BigInteger.ZERO);
        SimpleInterval zeroToOne = SimpleInterval.of(BigInteger.ZERO, BigInteger.ONE);
        SimpleInterval negInfToFive = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToNegativeInfinity();
        SimpleInterval negInfToNegFive = SimpleInterval.singleton(BigInteger.valueOf(-5L)).extendToNegativeInfinity();
        SimpleInterval twentyFiveToInf = SimpleInterval.singleton(BigInteger.valueOf(25L)).extendToPositiveInfinity();
        SimpleInterval twentyToTwentyFive = SimpleInterval.of(BigInteger.valueOf(20L), BigInteger.valueOf(25L));
        SimpleInterval twoToFour = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        SimpleInterval fortyToHundred = SimpleInterval.of(BigInteger.valueOf(40L), BigInteger.valueOf(100L));
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(negTenToZero, zeroToTen)).isEqualTo((Object)negHundredToZero);
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(negTenToZero, negTenToTen)).isEqualTo((Object)negHundredToHundred);
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(SimpleInterval.infinite(), zero)).isEqualTo((Object)zero);
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(SimpleInterval.infinite(), zeroToOne)).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(negInfToFive, negInfToFive)).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(negInfToNegFive, negInfToNegFive)).isEqualTo((Object)twentyFiveToInf);
        Truth.assertThat((Object)IIIOperator.MULTIPLY.apply(twentyToTwentyFive, twoToFour)).isEqualTo((Object)fortyToHundred);
    }

    @Test
    public void testDivide() {
        SimpleInterval negFourToNegTwo = SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-2L));
        SimpleInterval negFourToNegOne = SimpleInterval.of(BigInteger.valueOf(-4L), BigInteger.valueOf(-1L));
        SimpleInterval negTwoToNegOne = SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(-1L));
        SimpleInterval oneToFour = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(4L));
        SimpleInterval oneToTwo = SimpleInterval.of(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        SimpleInterval twoToFour = SimpleInterval.of(BigInteger.valueOf(2L), BigInteger.valueOf(4L));
        SimpleInterval negTwentyToTwenty = SimpleInterval.of(BigInteger.valueOf(-20L), BigInteger.valueOf(20L));
        SimpleInterval negTwoToTwo = SimpleInterval.of(BigInteger.valueOf(-2L), BigInteger.valueOf(2L));
        SimpleInterval negInfToTen = SimpleInterval.singleton(BigInteger.valueOf(10L)).extendToNegativeInfinity();
        SimpleInterval negInfToFive = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToNegativeInfinity();
        SimpleInterval negInfToNegFive = SimpleInterval.singleton(BigInteger.valueOf(-5L)).extendToNegativeInfinity();
        SimpleInterval fiveToInf = SimpleInterval.singleton(BigInteger.valueOf(5L)).extendToPositiveInfinity();
        SimpleInterval negTwentyToTen = SimpleInterval.of(BigInteger.valueOf(-20L), BigInteger.valueOf(10L));
        SimpleInterval negTwoToInf = SimpleInterval.singleton(BigInteger.valueOf(-2L)).extendToPositiveInfinity();
        SimpleInterval zeroToInf = SimpleInterval.singleton(BigInteger.ZERO).extendToPositiveInfinity();
        SimpleInterval negInfToZero = zeroToInf.negate();
        SimpleInterval zeroToTwo = SimpleInterval.of(BigInteger.ZERO, BigInteger.valueOf(2L));
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negInfToZero, negInfToFive)).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negFourToNegTwo, negTwoToNegOne)).isEqualTo((Object)oneToFour);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negFourToNegTwo, oneToTwo)).isEqualTo((Object)negFourToNegOne);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(twoToFour, negTwoToNegOne)).isEqualTo((Object)negFourToNegOne);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(twoToFour, oneToTwo)).isEqualTo((Object)oneToFour);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negTwentyToTwenty, negTwoToTwo)).isEqualTo((Object)negTwentyToTwenty);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negInfToTen, negTwoToTwo)).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negInfToTen, twoToFour)).isEqualTo((Object)negInfToFive);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negInfToNegFive, fiveToInf)).isEqualTo((Object)negInfToZero);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negTwentyToTen, negTwoToInf)).isEqualTo((Object)negTwentyToTen);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.infinite())).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.ZERO))).isNull();
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.valueOf(5L)))).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(SimpleInterval.infinite(), SimpleInterval.singleton(BigInteger.valueOf(-5L)))).isEqualTo((Object)SimpleInterval.infinite());
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(zeroToInf, SimpleInterval.singleton(BigInteger.valueOf(5L)))).isEqualTo((Object)zeroToInf);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(zeroToInf, SimpleInterval.singleton(BigInteger.valueOf(-5L)))).isEqualTo((Object)negInfToZero);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(negTwentyToTwenty, zeroToInf)).isEqualTo((Object)negTwentyToTwenty);
        Truth.assertThat((Object)IIIOperator.DIVIDE.apply(twoToFour, zeroToTwo)).isEqualTo((Object)oneToFour);
    }
}

